/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.gui.ImageDataSource;
import com.actelion.research.gui.PopupItemProvider;
import com.actelion.research.gui.clipboard.ImageClipboardHandler;
import com.actelion.research.gui.swing.SwingCursorHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.ImageObserver;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JImagePanel
extends JPanel
implements ActionListener,
ImageObserver,
KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final long serialVersionUID = 538051842L;
    public static final Color BACKGROUND_COLOR = UIManager.getColor("Panel.background");
    public static final String cDefaultImageExtension = ".jpg";
    public static final String cThumbNailExtension = "_s";
    private static final int IMAGE_ERROR = -1;
    private static final int IMAGE_NO_IMAGE = 0;
    private static final int IMAGE_PENDING = 1;
    private static final int IMAGE_LOADING = 2;
    private static final int IMAGE_AVAILABLE = 3;
    private static final int MIN_SELECTION_PIXELS = 8;
    private static final float MAX_ZOOM_FACTOR = 8.0f;
    private String mImagePath;
    private String mFileName;
    private Image mImage;
    private Image mLowResImage;
    private byte[] mImageData;
    private boolean mImageIsThumbNail;
    private boolean mUseThumbNail;
    private boolean mAltIsDown;
    private boolean mMouseIsDown;
    private boolean mMouseIsInside;
    private int mImageStatus;
    private int mImageCenterOffsetX;
    private int mImageCenterOffsetY;
    private int mCurrentCursor;
    private int mImageUpdateCount;
    private float mZoomFactor;
    private Point mMouseLocation;
    private Rectangle mSelectionRect;
    private Rectangle mImageRect;
    private ImageDataSource mImageDataSource;
    private PopupItemProvider mPopupItemProvider;

    public JImagePanel() {
        this("", false);
    }

    public JImagePanel(String string) {
        this(string, false);
    }

    public JImagePanel(String string, boolean bl) {
        this.setFocusable(true);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.mImagePath = string == null ? "" : string;
        this.mUseThumbNail = bl;
        this.mImageRect = new Rectangle();
        this.resetZoomState();
        this.mCurrentCursor = 11;
    }

    public void setHighResolutionImageSource(ImageDataSource imageDataSource) {
        this.mImageDataSource = imageDataSource;
    }

    public void setPopupItemProvider(PopupItemProvider popupItemProvider) {
        this.mPopupItemProvider = popupItemProvider;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        graphics.setColor(BACKGROUND_COLOR);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.mImageStatus == 1) {
            if (this.mImageData != null || this.mFileName != null) {
                this.createAndPrepareImage();
            } else {
                this.mImage = null;
                this.mImageStatus = 0;
            }
        }
        if (this.mImage != null) {
            if (this.mImageStatus == 2) {
                if (this.mLowResImage != null) {
                    this.drawImage(graphics, this.mLowResImage);
                }
                String string = this.mUseThumbNail && !this.mImageIsThumbNail ? "higher resolution loading..." : "image loading...";
                graphics.setColor(Color.blue);
                graphics.drawString(string, 4, dimension.height - 4);
            } else if (this.mImageStatus == -1) {
                graphics.setColor(Color.red);
                graphics.drawString("image loading error.", 4, dimension.height - 4);
            } else if (this.mImageStatus == 3) {
                this.drawImage(graphics, this.mImage);
            }
        }
        if (this.mSelectionRect != null) {
            graphics.setColor(this.mSelectionRect.width >= 8 && this.mSelectionRect.height >= 8 ? Color.GREEN : Color.RED);
            graphics.drawRect(this.mSelectionRect.x - 1, this.mSelectionRect.y - 1, this.mSelectionRect.width + 2, this.mSelectionRect.height + 2);
            graphics.drawRect(this.mSelectionRect.x - 2, this.mSelectionRect.y - 2, this.mSelectionRect.width + 4, this.mSelectionRect.height + 4);
        }
    }

    private void drawImage(Graphics graphics, Image image) {
        if (image.getWidth(this) > 0 && image.getHeight(this) > 0) {
            if (this.mZoomFactor == 1.0f) {
                this.mImageRect.x = this.mImageCenterOffsetX + (this.getWidth() - image.getWidth(this)) / 2;
                this.mImageRect.y = this.mImageCenterOffsetY + (this.getHeight() - image.getHeight(this)) / 2;
                this.mImageRect.width = image.getWidth(this);
                this.mImageRect.height = image.getHeight(this);
                graphics.drawImage(image, this.mImageRect.x, this.mImageRect.y, this);
            } else {
                this.mImageRect.width = (int)((float)image.getWidth(this) * this.mZoomFactor);
                this.mImageRect.height = (int)((float)image.getHeight(this) * this.mZoomFactor);
                this.mImageRect.x = this.mImageCenterOffsetX + (this.getWidth() - this.mImageRect.width) / 2;
                this.mImageRect.y = this.mImageCenterOffsetY + (this.getHeight() - this.mImageRect.height) / 2;
                graphics.drawImage(image, this.mImageRect.x, this.mImageRect.y, this.mImageRect.width, this.mImageRect.height, this);
            }
        }
    }

    @Override
    public boolean imageUpdate(Image image, final int n, int n2, int n3, int n4, int n5) {
        if ((0xE0 & n) != 0) {
            final int n6 = ++this.mImageUpdateCount;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (JImagePanel.this.mImage != null && n6 == JImagePanel.this.mImageUpdateCount) {
                        JImagePanel.this.mImageStatus = (0x20 & n) == 0 ? -1 : 3;
                        if (JImagePanel.this.mImageStatus == 3) {
                            JImagePanel.this.setInitialFullImageZoomState();
                        }
                        JImagePanel.this.repaint();
                    }
                }
            });
            return false;
        }
        return true;
    }

    public void setImageData(byte[] byArray) {
        this.mFileName = null;
        if (byArray == this.mImageData) {
            return;
        }
        this.mImageData = byArray;
        this.mImageStatus = 1;
        this.mImageIsThumbNail = this.mUseThumbNail;
        this.mSelectionRect = null;
        this.mLowResImage = null;
        this.resetZoomState();
        this.repaint();
    }

    public void setFileName(String string) {
        this.mImageData = null;
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (this.mFileName == null && string == null) {
            return;
        }
        if (this.mFileName != null && string != null && this.mFileName.equals(string)) {
            return;
        }
        this.mFileName = string;
        this.mImageStatus = 1;
        this.mImageIsThumbNail = this.mUseThumbNail;
        this.mSelectionRect = null;
        this.mLowResImage = null;
        this.resetZoomState();
        this.repaint();
    }

    private void createAndPrepareImage() {
        if (this.mImageData != null) {
            this.mImage = Toolkit.getDefaultToolkit().createImage(this.mImageData);
        } else if (this.mFileName != null) {
            String string = JImagePanel.buildImagePath(this.mImagePath, this.mFileName, this.mUseThumbNail);
            this.mImage = Toolkit.getDefaultToolkit().createImage(string);
        }
        this.mImageStatus = Toolkit.getDefaultToolkit().prepareImage(this.mImage, -1, -1, this) ? 3 : 2;
        if (this.mImageStatus == 3) {
            this.setInitialFullImageZoomState();
        }
    }

    public static String buildImagePath(String string, String string2, boolean bl) {
        String string3;
        String string4 = cDefaultImageExtension;
        int n = string2.lastIndexOf(46);
        if (n != -1 && n >= string2.length() - 5 && n <= string2.length() - 4 && ((string3 = string2.substring(n + 1).toLowerCase()).equals("jpeg") || string3.equals("jpg") || string3.equals("png") || string3.equals("gif") || string3.equals("svg"))) {
            string4 = string2.substring(n);
            string2 = string2.substring(0, n);
        }
        string3 = bl ? cThumbNailExtension : "";
        return string + string2 + string3 + string4;
    }

    private void loadFullImage() {
        this.mImageIsThumbNail = false;
        this.mLowResImage = this.mImage;
        this.mImageStatus = 2;
        this.repaint();
        if (this.mImageData != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JImagePanel.access$402(JImagePanel.this, JImagePanel.this.mImageDataSource.getImageData());
                    JImagePanel.this.createAndPrepareImage();
                }
            });
        }
    }

    public void setImagePath(String string) {
        this.mImagePath = string == null ? "" : string;
        this.mFileName = null;
        this.mImageData = null;
        this.mImageStatus = 0;
        this.repaint();
    }

    public String getImagePath() {
        return this.mImagePath;
    }

    public void setUseThumbNail(boolean bl) {
        this.mUseThumbNail = bl;
    }

    public boolean usesThumbNail() {
        return this.mUseThumbNail;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 18) {
            this.mAltIsDown = true;
            this.updateCursor();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 18) {
            this.mAltIsDown = false;
            this.updateCursor();
        }
        if ((keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0 && keyEvent.getKeyCode() == 67) {
            this.copyVisible();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.handlePopupTrigger(mouseEvent)) {
            return;
        }
        this.mMouseIsDown = true;
        this.mSelectionRect = null;
        if ((mouseEvent.getModifiersEx() & 0x400) != 0 && this.mImageStatus == 3) {
            this.mMouseLocation = mouseEvent.getPoint();
            if (this.mAltIsDown) {
                this.mSelectionRect = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 0, 0);
            }
        }
        this.updateCursor();
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.handlePopupTrigger(mouseEvent)) {
            return;
        }
        this.mMouseIsDown = false;
        this.updateCursor();
        if (this.mSelectionRect != null) {
            Rectangle rectangle = this.mSelectionRect.intersection(this.mImageRect);
            if (rectangle.width >= 8 && rectangle.height >= 8) {
                float f;
                if (this.mImageIsThumbNail) {
                    this.loadFullImage();
                }
                if ((double)(f = Math.min(8.0f / this.mZoomFactor, Math.min((float)this.getWidth() / (float)rectangle.width, (float)this.getHeight() / (float)rectangle.height))) > 1.000001) {
                    this.mImageCenterOffsetX = (int)(f * (float)(this.mImageRect.x - rectangle.x + (this.mImageRect.width - rectangle.width) / 2));
                    this.mImageCenterOffsetY = (int)(f * (float)(this.mImageRect.y - rectangle.y + (this.mImageRect.height - rectangle.height) / 2));
                    this.mZoomFactor *= f;
                }
            }
            this.mSelectionRect = null;
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
        this.mMouseIsInside = true;
        this.updateCursor();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mMouseIsInside = false;
    }

    @Override
    public synchronized void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        if (this.mSelectionRect != null) {
            this.mSelectionRect.x = Math.min(mouseEvent.getX(), this.mMouseLocation.x);
            this.mSelectionRect.y = Math.min(mouseEvent.getY(), this.mMouseLocation.y);
            this.mSelectionRect.width = Math.abs(this.mMouseLocation.x - mouseEvent.getX());
            this.mSelectionRect.height = Math.abs(this.mMouseLocation.y - mouseEvent.getY());
            this.repaint();
        } else if (this.mImageStatus == 3) {
            int n = mouseEvent.getX() - this.mMouseLocation.x;
            int n2 = mouseEvent.getY() - this.mMouseLocation.y;
            this.mImageCenterOffsetX += n;
            this.mImageCenterOffsetY += n2;
            this.mMouseLocation.x += n;
            this.mMouseLocation.y += n2;
            this.validateOffsets();
            this.repaint();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.mImageStatus == 3) {
            this.zoom(mouseWheelEvent.getX(), mouseWheelEvent.getY(), mouseWheelEvent.getWheelRotation());
            if (this.mImageIsThumbNail) {
                this.loadFullImage();
            }
        }
    }

    private void zoom(int n, int n2, int n3) {
        float f = (float)Math.exp((double)(-n3) / 20.0);
        float f2 = Math.min((float)this.getWidth() / (float)this.mImage.getWidth(this), (float)this.getHeight() / (float)this.mImage.getHeight(this));
        float f3 = Math.min(f2, Math.min(this.mZoomFactor, 1.0f));
        float f4 = Math.max(f3, Math.min(8.0f, f * this.mZoomFactor));
        if (this.mZoomFactor != f4) {
            int n4 = (int)((float)this.mImage.getWidth(this) * this.mZoomFactor);
            int n5 = (int)((float)this.mImage.getHeight(this) * this.mZoomFactor);
            float f5 = Math.max(0.0f, Math.min(1.0f, ((float)(n - this.mImageCenterOffsetX) + (float)(n4 - this.getWidth()) / 2.0f) / (float)n4));
            float f6 = Math.max(0.0f, Math.min(1.0f, ((float)(n2 - this.mImageCenterOffsetY) + (float)(n5 - this.getHeight()) / 2.0f) / (float)n5));
            this.mZoomFactor = f4;
            this.mImageCenterOffsetX = (int)((float)this.mImageCenterOffsetX + (0.5f - f5) * (float)((int)((float)this.mImage.getWidth(this) * this.mZoomFactor) - n4));
            this.mImageCenterOffsetY = (int)((float)this.mImageCenterOffsetY + (0.5f - f6) * (float)((int)((float)this.mImage.getHeight(this) * this.mZoomFactor) - n5));
            this.validateOffsets();
            this.repaint();
        }
    }

    private void validateOffsets() {
        int n = (int)((float)this.mImage.getWidth(this) * this.mZoomFactor);
        int n2 = (int)((float)this.mImage.getHeight(this) * this.mZoomFactor);
        int n3 = (n - this.getWidth()) / 2;
        int n4 = (n2 - this.getHeight()) / 2;
        int n5 = this.mImageCenterOffsetX - n3;
        int n6 = -this.mImageCenterOffsetX - n3;
        int n7 = this.mImageCenterOffsetY - n4;
        int n8 = -this.mImageCenterOffsetY - n4;
        if (n3 < 0) {
            if (n5 < 0) {
                this.mImageCenterOffsetX -= n5;
            } else if (n6 < 0) {
                this.mImageCenterOffsetX += n6;
            }
        } else if (n5 > 0) {
            this.mImageCenterOffsetX -= n5;
        } else if (n6 > 0) {
            this.mImageCenterOffsetX += n6;
        }
        if (n4 < 0) {
            if (n7 < 0) {
                this.mImageCenterOffsetY -= n7;
            } else if (n8 < 0) {
                this.mImageCenterOffsetY += n8;
            }
        } else if (n7 > 0) {
            this.mImageCenterOffsetY -= n7;
        } else if (n8 > 0) {
            this.mImageCenterOffsetY += n8;
        }
    }

    private void resetZoomState() {
        this.mZoomFactor = 1.0f;
        this.mImageCenterOffsetX = 0;
        this.mImageCenterOffsetY = 0;
    }

    private void setInitialFullImageZoomState() {
        if (this.mLowResImage != null) {
            this.mZoomFactor *= (float)this.mLowResImage.getWidth(null) / (float)this.mImage.getWidth(null);
            this.mLowResImage = null;
        } else {
            Dimension dimension = this.getSize();
            if (dimension.width != 0 && dimension.height != 0) {
                this.mZoomFactor = Math.min(1.0f, Math.min((float)dimension.width / (float)this.mImage.getWidth(null), (float)dimension.height / (float)this.mImage.getHeight(null)));
            }
            this.mImageCenterOffsetX = 0;
            this.mImageCenterOffsetY = 0;
        }
    }

    private boolean handlePopupTrigger(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            if (this.mImageStatus == 3) {
                JMenuItem[] jMenuItemArray;
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem("Copy Full Image");
                jMenuItem.addActionListener(this);
                jPopupMenu.add(jMenuItem);
                JMenuItem jMenuItem2 = new JMenuItem("Copy Visible");
                jMenuItem2.addActionListener(this);
                jPopupMenu.add(jMenuItem2);
                if (this.mPopupItemProvider != null && (jMenuItemArray = this.mPopupItemProvider.getPopupItems()) != null) {
                    jPopupMenu.addSeparator();
                    for (JMenuItem jMenuItem3 : jMenuItemArray) {
                        jPopupMenu.add(jMenuItem3);
                    }
                }
                jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Copy Full Image")) {
            this.copyImage();
            return;
        }
        if (actionEvent.getActionCommand().equals("Copy Visible")) {
            this.copyVisible();
            return;
        }
    }

    private void copyImage() {
        if (this.mImageStatus == 3) {
            ImageClipboardHandler.copyImage(this.mImage);
        }
    }

    private void copyVisible() {
        Rectangle rectangle;
        if (this.mImageStatus == 3 && !(rectangle = this.mImageRect.intersection(new Rectangle(0, 0, this.getWidth(), this.getHeight()))).isEmpty()) {
            int n = (int)((float)rectangle.width / this.mZoomFactor);
            int n2 = (int)((float)rectangle.height / this.mZoomFactor);
            Image image = this.createImage(n, n2);
            int n3 = (int)((float)(this.mImageRect.x - rectangle.x) / this.mZoomFactor);
            int n4 = (int)((float)(this.mImageRect.y - rectangle.y) / this.mZoomFactor);
            image.getGraphics().drawImage(this.mImage, n3, n4, this);
            ImageClipboardHandler.copyImage(image);
        }
    }

    private void updateCursor() {
        if (this.mMouseIsInside) {
            int n = 11;
            if (this.mImageStatus == 3) {
                if (this.mAltIsDown) {
                    n = 7;
                } else {
                    int n2 = n = this.mMouseIsDown ? 4 : 2;
                }
            }
            if (this.mCurrentCursor != n) {
                this.mCurrentCursor = n;
                this.setCursor(SwingCursorHelper.getCursor(n));
            }
        }
    }

    static /* synthetic */ byte[] access$402(JImagePanel jImagePanel, byte[] byArray) {
        jImagePanel.mImageData = byArray;
        return byArray;
    }
}

