/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.chem.AbstractDrawingObject;
import com.actelion.research.chem.Depictor2D;
import com.actelion.research.chem.DepictorTransformation;
import com.actelion.research.chem.DrawingObjectList;
import com.actelion.research.chem.ExtendedDepictor;
import com.actelion.research.chem.MarkushStructure;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.NamedSubstituents;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.TextDrawingObject;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.chem.io.RDFileParser;
import com.actelion.research.chem.io.RXNFileParser;
import com.actelion.research.chem.name.StructureNameResolver;
import com.actelion.research.chem.reaction.IReactionMapper;
import com.actelion.research.chem.reaction.MCSReactionMapper;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionArrow;
import com.actelion.research.gui.FileHelper;
import com.actelion.research.gui.JAtomLabelDialog;
import com.actelion.research.gui.JAtomQueryFeatureDialog;
import com.actelion.research.gui.JBondQueryFeatureDialog;
import com.actelion.research.gui.JTextDrawingObjectDialog;
import com.actelion.research.gui.LookAndFeelHelper;
import com.actelion.research.gui.SwingCanvas;
import com.actelion.research.gui.clipboard.IClipboardHandler;
import com.actelion.research.gui.dnd.MoleculeDropAdapter;
import com.actelion.research.gui.editor.EditorEvent;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericPolygon;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.gui.generic.GenericShape;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.hidpi.ScaledEditorKit;
import com.actelion.research.gui.swing.SwingCursorHelper;
import com.actelion.research.gui.swing.SwingDrawContext;
import com.actelion.research.gui.swing.SwingUIHelper;
import com.actelion.research.util.ColorHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLEditorKit;

@Deprecated
public class JDrawArea
extends SwingCanvas
implements ActionListener,
KeyListener,
MouseListener,
MouseMotionListener {
    static final long serialVersionUID = 537268249L;
    public static final int MODE_MULTIPLE_FRAGMENTS = 1;
    public static final int MODE_MARKUSH_STRUCTURE = 2;
    public static final int MODE_REACTION = 4;
    public static final int MODE_DRAWING_OBJECTS = 8;
    private static final int MAX_CONNATOMS = 8;
    private static final int MIN_BOND_LENGTH_SQUARE = 100;
    private static final int KEY_IS_ATOM_LABEL = 1;
    private static final int KEY_IS_SUBSTITUENT = 2;
    private static final int KEY_IS_VALID_START = 3;
    private static final int KEY_IS_INVALID = 4;
    private static final String ITEM_COPY_STRUCTURE = "Copy Structure";
    private static final String ITEM_COPY_REACTION = "Copy Reaction";
    private static final String ITEM_PASTE_STRUCTURE = "Paste Structure";
    private static final String ITEM_PASTE_REACTION = "Paste Reaction";
    private static final String ITEM_PASTE_WITH_NAME = "Paste Structure or Name";
    private static final String ITEM_LOAD_REACTION = "Open Reaction File...";
    private static final String ITEM_ADD_AUTO_MAPPING = "Auto-Map Reaction";
    private static final String ITEM_REMOVE_MAPPING = "Remove Manual Atom Mapping";
    private static final String ITEM_FLIP_HORIZONTALLY = "Flip Horizontally";
    private static final String ITEM_FLIP_VERTICALLY = "Flip Vertically";
    private static final float FRAGMENT_MAX_CLICK_DISTANCE = 24.0f;
    private static final float FRAGMENT_GROUPING_DISTANCE = 1.4f;
    private static final float FRAGMENT_CLEANUP_DISTANCE = 1.5f;
    private static final float DEFAULT_ARROW_LENGTH = 0.08f;
    protected static final int UPDATE_NONE = 0;
    protected static final int UPDATE_REDRAW = 1;
    protected static final int UPDATE_CHECK_VIEW = 2;
    protected static final int UPDATE_CHECK_COORDS = 3;
    protected static final int UPDATE_SCALE_COORDS = 4;
    protected static final int UPDATE_SCALE_COORDS_USE_FRAGMENTS = 5;
    protected static final int UPDATE_INVENT_COORDS = 6;
    private static final Color DEFAULT_SELECTION_BACKGROUND = new Color(128, 164, 192);
    private static final int ALLOWED_DROP_ACTIONS = 3;
    private static final int cRequestNone = 0;
    private static final int cRequestNewBond = 1;
    private static final int cRequestNewChain = 2;
    private static final int cRequestMoveSingle = 3;
    private static final int cRequestMoveSelected = 4;
    private static final int cRequestLassoSelect = 5;
    private static final int cRequestSelectRect = 6;
    private static final int cRequestZoomAndRotate = 7;
    private static final int cRequestMapAtoms = 8;
    private static final int cRequestCopySelected = 9;
    private static final int cRequestMoveObject = 10;
    private static final int cRequestCopyObject = 11;
    private static IReactionMapper sMapper;
    private Dimension mSize;
    private int mMode;
    private int mChainAtoms;
    private int mCurrentTool;
    private int mOtherAtom;
    private int mOtherMass;
    private int mOtherValence;
    private int mOtherRadical;
    private int mCurrentHiliteAtom;
    private int mCurrentHiliteBond;
    private int mPendingRequest;
    private int mCurrentCursor;
    private int mReactantCount;
    private int mUpdateMode;
    private int mDisplayMode;
    private int mAtom1;
    private int mAtom2;
    private int[] mChainAtom;
    private int[] mFragmentNo;
    private int[] mHiliteBondSet;
    private double mX1;
    private double mY1;
    private double mX2;
    private double mY2;
    private double[] mX;
    private double[] mY;
    private double[] mChainAtomX;
    private double[] mChainAtomY;
    private boolean mShiftIsDown;
    private boolean mAltIsDown;
    private boolean mControlIsDown;
    private boolean mMouseIsDown;
    private boolean mIsAddingToSelection;
    private boolean mAtomColorSupported;
    private boolean mAllowQueryFeatures;
    private boolean[] mIsSelectedAtom;
    private boolean[] mIsSelectedObject;
    private String mOtherLabel;
    private String[] mAtomText;
    private ExtendedDepictor mDepictor;
    private StereoMolecule mMol;
    private Molecule mUndoMol;
    private StereoMolecule[] mFragment;
    private DrawingObjectList mDrawingObjectList;
    private DrawingObjectList mUndoDrawingObjectList;
    private AbstractDrawingObject mCurrentHiliteObject;
    private GenericPolygon mLassoRegion;
    private ArrayList<GenericEventListener<EditorEvent>> mListeners;
    private IClipboardHandler mClipboardHandler;
    private JDialog mHelpDialog;
    private StringBuilder mAtomKeyStrokeBuffer;

    public JDrawArea(StereoMolecule stereoMolecule, int n) {
        this.mMol = stereoMolecule;
        this.mMode = n;
        this.setFocusable(true);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.mListeners = new ArrayList();
        this.mCurrentTool = 5;
        this.mCurrentHiliteAtom = -1;
        this.mCurrentHiliteBond = -1;
        this.mCurrentHiliteObject = null;
        this.mAtom1 = -1;
        this.mOtherAtom = 6;
        this.mOtherMass = 0;
        this.mOtherValence = -1;
        this.mOtherRadical = 0;
        this.mOtherLabel = null;
        this.mAllowQueryFeatures = true;
        this.mPendingRequest = 0;
        this.mCurrentCursor = 11;
        this.mAtomKeyStrokeBuffer = new StringBuilder();
        if ((this.mMode & 6) != 0) {
            this.mMode |= 1;
        }
        if ((this.mMode & 0xC) != 0) {
            this.mDrawingObjectList = new DrawingObjectList();
        }
        this.mUpdateMode = 4;
        this.initializeDragAndDrop(3);
    }

    public void setClipboardHandler(IClipboardHandler iClipboardHandler) {
        this.mClipboardHandler = iClipboardHandler;
    }

    private void update(int n) {
        this.mUpdateMode = Math.max(this.mUpdateMode, n);
        this.repaint();
    }

    public static void setReactionMapper(IReactionMapper iReactionMapper) {
        sMapper = iReactionMapper;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        Object object;
        super.paintComponent(graphics);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Dimension dimension = this.getSize();
        if (this.mSize == null || this.mSize.width != dimension.width || this.mSize.height != dimension.height) {
            this.mSize = dimension;
            if (this.mUpdateMode < 3) {
                this.mUpdateMode = 3;
            }
        }
        Color color = UIManager.getColor("TextArea.background");
        Color color2 = UIManager.getColor("TextArea.foreground");
        graphics.setColor(color);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if ((this.mMode & 4) != 0 && this.mDrawingObjectList.size() == 0) {
            float f = 0.5f * (float)dimension.width;
            float f2 = 0.5f * (float)dimension.height;
            float f3 = 0.04f * (float)dimension.width;
            object = new ReactionArrow();
            ((ReactionArrow)object).setCoordinates(f - f3, f2, f + f3, f2);
            ((AbstractDrawingObject)object).setDeletable(false);
            this.mDrawingObjectList.add(object);
        }
        SwingDrawContext swingDrawContext = new SwingDrawContext((Graphics2D)graphics);
        boolean bl = false;
        if (this.mUpdateMode != 0) {
            if ((this.mMode & 1) != 0 && this.mUpdateMode != 5) {
                this.analyzeFragmentMembership();
            }
            this.mDepictor = (this.mMode & 4) != 0 ? new ExtendedDepictor(new Reaction(this.mFragment, this.mReactantCount), this.mDrawingObjectList, false) : ((this.mMode & 2) != 0 ? new ExtendedDepictor(this.mFragment, this.mReactantCount, this.mDrawingObjectList) : ((this.mMode & 1) != 0 ? new ExtendedDepictor(this.mFragment, this.mDrawingObjectList) : new ExtendedDepictor(this.mMol, this.mDrawingObjectList)));
            this.mDepictor.setForegroundColor(color2, color);
            this.mDepictor.setFragmentNoColor((this.mMode & 1) == 0 ? 0 : (LookAndFeelHelper.isDarkLookAndFeel() ? ColorHelper.brighter(color.getRGB(), 0.85f) : ColorHelper.darker(color.getRGB(), 0.85f)));
            this.mDepictor.setDisplayMode(this.mDisplayMode | 8 | (this.mCurrentTool == 19 ? 80 : 0));
            if ((this.mMode & 7) == 0) {
                this.mDepictor.getMoleculeDepictor(0).setAtomText(this.mAtomText);
            }
            switch (this.mUpdateMode) {
                case 4: 
                case 5: 
                case 6: {
                    this.cleanupCoordinates(swingDrawContext, (Graphics2D)graphics);
                    break;
                }
                case 3: {
                    DepictorTransformation depictorTransformation = this.mDepictor.updateCoords(swingDrawContext, new GenericRectangle(0.0, 0.0, dimension.width, dimension.height), 0);
                    if (depictorTransformation == null || (this.mMode & 1) == 0) break;
                    depictorTransformation.applyTo(this.mMol);
                    break;
                }
                case 2: {
                    object = this.mDepictor.validateView(swingDrawContext, new GenericRectangle(0.0, 0.0, dimension.width, dimension.height), 0);
                    bl = object != null && !((DepictorTransformation)object).isVoidTransformation();
                }
            }
            this.mUpdateMode = 0;
        }
        if (this.mDepictor != null) {
            this.mDepictor.paintFragmentNumbers(swingDrawContext);
        }
        if (!bl) {
            this.drawHiliting(swingDrawContext, graphics);
        }
        if (this.mDepictor != null) {
            this.mDepictor.paintStructures(swingDrawContext);
            this.mDepictor.paintDrawingObjects(swingDrawContext);
        }
        if (this.mCurrentHiliteAtom != -1 && this.mAtomKeyStrokeBuffer.length() != 0) {
            int n2 = (int)this.mMol.getAtomX(this.mCurrentHiliteAtom);
            int n3 = (int)this.mMol.getAtomY(this.mCurrentHiliteAtom);
            String string = this.mAtomKeyStrokeBuffer.toString();
            n = this.getAtomKeyStrokeValidity(string);
            graphics.setColor(n == 1 ? color2 : (n == 2 ? Color.BLUE : (n == 3 ? Color.GRAY : Color.RED)));
            if (n == 4) {
                string = string + "<unknown>";
            }
            graphics.setFont(graphics.getFont().deriveFont(0, 24.0f));
            graphics.drawString(string, n2, n3);
        }
        graphics.setColor(color2);
        switch (this.mPendingRequest) {
            case 1: {
                int n4;
                int n5 = (int)this.mX1;
                int n6 = (int)this.mY1;
                if (this.mCurrentHiliteAtom == -1 || this.mCurrentHiliteAtom == this.mAtom1) {
                    n4 = (int)this.mX2;
                    n = (int)this.mY2;
                } else {
                    n4 = (int)this.mMol.getAtomX(this.mCurrentHiliteAtom);
                    n = (int)this.mMol.getAtomY(this.mCurrentHiliteAtom);
                }
                switch (this.mCurrentTool) {
                    case 5: {
                        graphics.drawLine(n5, n6, n4, n);
                        break;
                    }
                    case 6: {
                        int[] nArray = new int[3];
                        int[] nArray2 = new int[3];
                        int n7 = (n6 - n) / 9;
                        int n8 = (n4 - n5) / 9;
                        nArray[0] = n5;
                        nArray2[0] = n6;
                        nArray[1] = n4 + n7;
                        nArray2[1] = n + n8;
                        nArray[2] = n4 - n7;
                        nArray2[2] = n - n8;
                        graphics.fillPolygon(nArray, nArray2, 3);
                        break;
                    }
                    case 23: {
                        int n9 = n4 - n5;
                        int n10 = n - n6;
                        for (int i = 2; i < 17; i += 2) {
                            int n11 = n5 + i * n9 / 17 - i * n10 / 128;
                            int n12 = n6 + i * n10 / 17 + i * n9 / 128;
                            int n13 = n5 + i * n9 / 17 + i * n10 / 128;
                            int n14 = n6 + i * n10 / 17 - i * n9 / 128;
                            graphics.drawLine(n11, n12, n13, n14);
                        }
                        break;
                    }
                }
                break;
            }
            case 2: {
                if (this.mChainAtoms > 0) {
                    graphics.drawLine((int)this.mX1, (int)this.mY1, (int)this.mChainAtomX[0], (int)this.mChainAtomY[0]);
                }
                if (this.mChainAtoms <= 1) break;
                for (int i = 1; i < this.mChainAtoms; ++i) {
                    graphics.drawLine((int)this.mChainAtomX[i - 1], (int)this.mChainAtomY[i - 1], (int)this.mChainAtomX[i], (int)this.mChainAtomY[i]);
                }
                break;
            }
            case 5: {
                graphics.setColor(JDrawArea.lassoColor());
                Polygon polygon = new Polygon();
                for (int i = 0; i < this.mLassoRegion.getSize(); ++i) {
                    polygon.addPoint(Math.round((float)this.mLassoRegion.getX(i)), Math.round((float)this.mLassoRegion.getY(i)));
                }
                graphics.drawPolygon(polygon);
                graphics.setColor(color2);
                break;
            }
            case 6: {
                int n15 = this.mX1 < this.mX2 ? (int)this.mX1 : (int)this.mX2;
                int n16 = this.mY1 < this.mY2 ? (int)this.mY1 : (int)this.mY2;
                int n17 = (int)Math.abs(this.mX2 - this.mX1);
                int n18 = (int)Math.abs(this.mY2 - this.mY1);
                graphics.setColor(JDrawArea.lassoColor());
                graphics.drawRect(n15, n16, n17, n18);
                graphics.setColor(color2);
                break;
            }
            case 8: {
                int n19;
                int n20 = (int)this.mX1;
                int n21 = (int)this.mY1;
                if (this.mCurrentHiliteAtom == -1 || this.mCurrentHiliteAtom == this.mAtom1) {
                    n19 = (int)this.mX2;
                    n = (int)this.mY2;
                } else {
                    n19 = (int)this.mMol.getAtomX(this.mCurrentHiliteAtom);
                    n = (int)this.mMol.getAtomY(this.mCurrentHiliteAtom);
                }
                graphics.setColor(JDrawArea.mapToolColor());
                graphics.drawLine(n20, n21, n19, n);
                graphics.setColor(color2);
            }
        }
        if (this.mWarningMessage != null) {
            int n22 = HiDPIHelper.scale(12.0f);
            graphics.setFont(this.getFont().deriveFont(1, n22));
            Color color3 = graphics.getColor();
            graphics.setColor(Color.RED);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(this.mWarningMessage, graphics);
            graphics.drawString(this.mWarningMessage, (int)((double)dimension.width - rectangle2D.getWidth()) / 2, fontMetrics.getHeight());
            graphics.setColor(color3);
        }
    }

    public static Color lassoColor() {
        Color color = JDrawArea.selectionColor();
        return ColorHelper.createColor(color, LookAndFeelHelper.isDarkLookAndFeel() ? 0.65f : 0.35f);
    }

    public static Color selectionColor() {
        Color color = UIManager.getColor("TextArea.selectionBackground");
        return color != null ? color : DEFAULT_SELECTION_BACKGROUND;
    }

    public static Color mapToolColor() {
        Color color = UIManager.getColor("TextArea.background");
        return ColorHelper.getContrastColor(new Color(128, 0, 0), color);
    }

    public static Color chainHiliteColor() {
        Color color = UIManager.getColor("TextArea.background");
        Color color2 = JDrawArea.selectionColor();
        return ColorHelper.intermediateColor(color2, color, 0.5f);
    }

    private void drawHiliting(SwingDrawContext swingDrawContext, Graphics graphics) {
        int n;
        if (this.mHiliteBondSet != null) {
            graphics.setColor(JDrawArea.chainHiliteColor());
            for (n = 0; n < this.mHiliteBondSet.length; ++n) {
                this.hiliteBond(graphics, this.mHiliteBondSet[n]);
            }
        }
        if (this.mCurrentHiliteAtom != -1) {
            graphics.setColor(JDrawArea.selectionColor());
            this.hiliteAtom(graphics, this.mCurrentHiliteAtom);
            if (this.mCurrentTool == 19 && (n = this.mMol.getAtomMapNo(this.mCurrentHiliteAtom)) != 0) {
                for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                    if (i == this.mCurrentHiliteAtom || this.mMol.getAtomMapNo(i) != n) continue;
                    this.hiliteAtom(graphics, i);
                }
            }
        }
        if (this.mCurrentHiliteBond != -1) {
            graphics.setColor(JDrawArea.selectionColor());
            this.hiliteBond(graphics, this.mCurrentHiliteBond);
        }
        if (this.mCurrentHiliteObject != null) {
            this.mCurrentHiliteObject.hilite(swingDrawContext);
        }
    }

    private void hiliteAtom(Graphics graphics, int n) {
        int n2 = (int)((double)0.32f * this.mMol.getAverageBondLength());
        int n3 = (int)this.mMol.getAtomX(n);
        int n4 = (int)this.mMol.getAtomY(n);
        graphics.fillOval(n3 - n2, n4 - n2, 2 * n2, 2 * n2);
    }

    private void hiliteBond(Graphics graphics, int n) {
        int n2 = (int)((double)0.32f * this.mMol.getAverageBondLength());
        int n3 = (int)this.mMol.getAtomX(this.mMol.getBondAtom(0, n));
        int n4 = (int)this.mMol.getAtomY(this.mMol.getBondAtom(0, n));
        int n5 = (int)this.mMol.getAtomX(this.mMol.getBondAtom(1, n));
        int n6 = (int)this.mMol.getAtomY(this.mMol.getBondAtom(1, n));
        Stroke stroke = ((Graphics2D)graphics).getStroke();
        ((Graphics2D)graphics).setStroke(new BasicStroke(n2, 1, 1));
        ((Graphics2D)graphics).drawLine(n3, n4, n5, n6);
        ((Graphics2D)graphics).setStroke(stroke);
    }

    public void addDrawAreaListener(GenericEventListener<EditorEvent> genericEventListener) {
        this.mListeners.add(genericEventListener);
    }

    protected void buttonPressed(int n) {
        switch (n) {
            case 0: {
                this.clearAll();
                return;
            }
            case 1: {
                this.storeState();
                this.fireMoleculeChanged();
                this.update(6);
                return;
            }
            case 17: {
                this.restoreState();
                this.fireMoleculeChanged();
                this.update(2);
                return;
            }
        }
    }

    public void clearAll() {
        if (this.mDrawingObjectList != null) {
            this.mDrawingObjectList.clear();
            this.update(1);
        }
        this.storeState();
        boolean bl = this.mMol.isFragment();
        this.mMol.clear();
        this.mMol.setFragment(bl);
        if (this.mUndoMol.getAllAtoms() != 0) {
            this.fireMoleculeChanged();
        }
        this.update(1);
    }

    public void toolChanged(int n) {
        if (this.mCurrentTool != n) {
            this.setOtherAtom(-1, 0, -1, 0, null);
            if (this.mCurrentTool == 19 || n == 19) {
                this.update(1);
            }
            this.mCurrentTool = n;
        }
    }

    private void setOtherAtom(int n, int n2, int n3, int n4, String string) {
        this.mOtherAtom = n;
        this.mOtherMass = n2;
        this.mOtherValence = n3;
        this.mOtherRadical = n4;
        this.mOtherLabel = string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ITEM_COPY_STRUCTURE) || string.equals(ITEM_COPY_REACTION)) {
            this.copy();
        } else if (string.equals(ITEM_PASTE_REACTION)) {
            this.pasteReaction();
        } else if (string.startsWith(ITEM_PASTE_STRUCTURE)) {
            this.pasteMolecule();
        } else if (actionEvent.getActionCommand().equals(ITEM_LOAD_REACTION)) {
            this.openReactionAsync();
        } else if (actionEvent.getActionCommand().equals(ITEM_ADD_AUTO_MAPPING)) {
            this.autoMapReaction();
            this.fireMoleculeChanged();
            this.mUpdateMode = Math.max(this.mUpdateMode, 1);
            this.repaint();
        } else if (actionEvent.getActionCommand().equals(ITEM_REMOVE_MAPPING)) {
            this.removeManualMapping();
        } else if (actionEvent.getActionCommand().equals(ITEM_FLIP_HORIZONTALLY)) {
            this.flip(true);
        } else if (actionEvent.getActionCommand().equals(ITEM_FLIP_VERTICALLY)) {
            this.flip(false);
        } else if (string.startsWith("atomColor")) {
            int n = string.indexOf(58);
            int n2 = Integer.parseInt(string.substring(9, n));
            int n3 = Integer.parseInt(string.substring(n + 1));
            if (this.mMol.isSelectedAtom(n2)) {
                for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                    if (!this.mMol.isSelectedAtom(i)) continue;
                    this.mMol.setAtomColor(i, n3);
                }
            } else {
                this.mMol.setAtomColor(n2, n3);
            }
        }
    }

    private void removeManualMapping() {
        boolean bl = false;
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            if (this.mMol.getAtomMapNo(i) == 0 || this.mMol.isAutoMappedAtom(i)) continue;
            if (!bl) {
                this.storeState();
                bl = true;
            }
            this.mMol.setAtomMapNo(i, 0, false);
        }
        if (bl) {
            this.autoMapReaction();
            this.fireMoleculeChanged();
            this.mUpdateMode = Math.max(this.mUpdateMode, 1);
            this.repaint();
        }
    }

    private boolean analyseCopy(boolean bl) {
        boolean bl2 = (this.mMode & 4) != 0;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        ReactionArrow reactionArrow = null;
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            if (!this.mMol.isSelectedAtom(i)) continue;
            if (!bl3) {
                bl3 = true;
                if (!bl2) break;
                reactionArrow = (ReactionArrow)this.mDrawingObjectList.get(0);
                bl5 = reactionArrow.isOnProductSide(this.mMol.getAtomX(i), this.mMol.getAtomY(i));
                continue;
            }
            if (bl5 == reactionArrow.isOnProductSide(this.mMol.getAtomX(i), this.mMol.getAtomY(i))) continue;
            bl4 = true;
            break;
        }
        if (!bl) {
            return bl2 && (bl4 || !bl3);
        }
        if (bl2) {
            if (bl4) {
                this.copyReaction(true);
                return true;
            }
            if (bl3) {
                this.copyMolecule(true);
                return false;
            }
            this.copyReaction(false);
            return true;
        }
        this.copyMolecule(bl3);
        return false;
    }

    private void copy() {
        this.analyseCopy(true);
    }

    private boolean copyReaction(boolean bl) {
        Reaction reaction;
        Reaction reaction2 = reaction = bl ? this.getSelectedReaction() : this.getReaction();
        if (reaction != null && this.mClipboardHandler != null) {
            return this.mClipboardHandler.copyReaction(reaction);
        }
        return false;
    }

    private Reaction getSelectedReaction() {
        Reaction reaction = new Reaction();
        for (int i = 0; i < this.mFragment.length; ++i) {
            StereoMolecule stereoMolecule = this.getSelectedCopy(this.mFragment[i]);
            if (stereoMolecule == null) continue;
            if (i < this.mReactantCount) {
                reaction.addReactant(stereoMolecule);
                continue;
            }
            reaction.addProduct(stereoMolecule);
        }
        return reaction;
    }

    private StereoMolecule getSelectedCopy(StereoMolecule stereoMolecule) {
        int n;
        int n2 = 0;
        for (n = 0; n < stereoMolecule.getAllAtoms(); ++n) {
            if (!stereoMolecule.isSelectedAtom(n)) continue;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        n = 0;
        for (int i = 0; i < stereoMolecule.getAllBonds(); ++i) {
            if (!stereoMolecule.isSelectedBond(i)) continue;
            ++n;
        }
        boolean[] blArray = new boolean[stereoMolecule.getAllAtoms()];
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            blArray[i] = stereoMolecule.isSelectedAtom(i);
        }
        StereoMolecule stereoMolecule2 = new StereoMolecule(n2, n);
        stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray, false, null);
        return stereoMolecule2;
    }

    private boolean copyMolecule(boolean bl) {
        if (this.mMol.getAllAtoms() != 0 && this.mClipboardHandler != null) {
            return this.mClipboardHandler.copyMolecule(bl ? this.getSelectedCopy(this.mMol) : this.mMol);
        }
        return false;
    }

    private void paste() {
        if ((this.mMode & 4) != 0 && this.pasteReaction()) {
            return;
        }
        this.pasteMolecule();
    }

    private boolean pasteReaction() {
        boolean bl = false;
        if (this.mClipboardHandler != null) {
            Reaction reaction = this.mClipboardHandler.pasteReaction();
            if (reaction != null) {
                for (int i = 0; i < reaction.getMolecules(); ++i) {
                    reaction.getMolecule(i).setFragment(this.mMol.isFragment());
                }
                this.storeState();
                this.setReaction(reaction);
                bl = true;
            } else {
                this.showWarningMessage("No reaction on clipboard!");
            }
        }
        return bl;
    }

    private boolean pasteMolecule() {
        boolean bl = false;
        if (this.mClipboardHandler != null) {
            StereoMolecule stereoMolecule = this.mClipboardHandler.pasteMolecule();
            if (stereoMolecule != null && stereoMolecule.getAllAtoms() != 0) {
                if (stereoMolecule.getAllBonds() != 0) {
                    new Depictor2D(stereoMolecule).updateCoords((Graphics2D)this.getGraphics(), new GenericRectangle(0.0, 0.0, this.getWidth(), this.getHeight()), 65536 + (int)this.mMol.getAverageBondLength());
                }
                this.storeState();
                if (this.mMol.getAllAtoms() == 0) {
                    boolean bl2 = this.mMol.isFragment();
                    stereoMolecule.copyMolecule(this.mMol);
                    this.mMol.setFragment(bl2);
                    this.moleculeChanged(true);
                } else {
                    int n = this.mMol.getAllAtoms();
                    this.mMol.addMolecule(stereoMolecule);
                    for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                        this.mMol.setAtomSelection(i, i >= n);
                    }
                    this.moleculeChanged(true);
                }
                bl = true;
            } else {
                this.showWarningMessage("No molecule on clipboard!");
            }
        }
        return bl;
    }

    private void openReactionAsync() {
        FileHelper.getFileAsync(this, "Please select a reaction file", 197632, file -> {
            if (file != null) {
                try {
                    Reaction reaction = null;
                    if (FileHelper.getFileType(file.getName()) == 1024) {
                        reaction = new RXNFileParser().getReaction((File)file);
                    } else {
                        RDFileParser rDFileParser = new RDFileParser((File)file);
                        if (rDFileParser.isReactionNext()) {
                            reaction = rDFileParser.getNextReaction();
                        }
                    }
                    if (reaction != null) {
                        for (int i = 0; i < reaction.getMolecules(); ++i) {
                            reaction.getMolecule(i).setFragment(this.mMol.isFragment());
                        }
                        this.storeState();
                        this.setReaction(reaction);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mCurrentHiliteAtom != -1 && this.mAtomKeyStrokeBuffer.length() != 0) {
            this.expandAtomKeyStrokes(this.mAtomKeyStrokeBuffer.toString());
        }
        this.mAtomKeyStrokeBuffer.setLength(0);
        if (this.handlePopupTrigger(mouseEvent)) {
            return;
        }
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            if (mouseEvent.getClickCount() == 2) {
                return;
            }
            this.mMouseIsDown = true;
            this.updateCursor();
            this.mousePressedButton1(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.handlePopupTrigger(mouseEvent)) {
            return;
        }
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            if (mouseEvent.getClickCount() == 2) {
                this.handleDoubleClick(mouseEvent);
                return;
            }
            this.mMouseIsDown = false;
            this.updateCursor();
            this.mouseReleasedButton1(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
        this.updateCursor();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mMouseIsDown = true;
        this.mX2 = mouseEvent.getX();
        this.mY2 = mouseEvent.getY();
        boolean bl = this.trackHiliting(this.mX2, this.mY2, true);
        switch (this.mPendingRequest) {
            case 2: {
                int n;
                double d;
                double d2;
                if (this.mChainAtoms > 0) {
                    d2 = this.mChainAtomX[this.mChainAtoms - 1];
                    d = this.mChainAtomY[this.mChainAtoms - 1];
                } else {
                    d2 = 0.0;
                    d = 0.0;
                }
                double d3 = this.mMol.getAverageBondLength();
                double d4 = (int)d3;
                double d5 = (int)(0.866 * d3);
                double d6 = (int)(0.5 * d3);
                double d7 = this.mX2 - this.mX1;
                double d8 = this.mY2 - this.mY1;
                if (Math.abs(d8) > Math.abs(d7)) {
                    this.mChainAtoms = (int)(2.0 * Math.abs(d8) / (d4 + d6));
                    if (Math.abs(d8) % (d4 + d6) > d4) {
                        ++this.mChainAtoms;
                    }
                    this.mChainAtomX = new double[this.mChainAtoms];
                    this.mChainAtomY = new double[this.mChainAtoms];
                    if (this.mX2 < this.mX1) {
                        d5 = -d5;
                    }
                    if (this.mY2 < this.mY1) {
                        d4 = -d4;
                        d6 = -d6;
                    }
                    for (n = 0; n < this.mChainAtoms; ++n) {
                        this.mChainAtomX[n] = this.mX1 + (double)((n + 1) / 2) * d5;
                        this.mChainAtomY[n] = this.mY1 + (double)((n + 1) / 2) * (d4 + d6);
                        if ((n & 1) != 0) continue;
                        int n2 = n;
                        this.mChainAtomY[n2] = this.mChainAtomY[n2] + d4;
                    }
                } else {
                    this.mChainAtoms = (int)(Math.abs(d7) / d5);
                    this.mChainAtomX = new double[this.mChainAtoms];
                    this.mChainAtomY = new double[this.mChainAtoms];
                    if (this.mX2 < this.mX1) {
                        d5 = -d5;
                    }
                    if (this.mY2 < this.mY1) {
                        d6 = -d6;
                    }
                    for (n = 0; n < this.mChainAtoms; ++n) {
                        this.mChainAtomX[n] = this.mX1 + (double)(n + 1) * d5;
                        this.mChainAtomY[n] = this.mY1;
                        if ((n & 1) != 0) continue;
                        int n3 = n;
                        this.mChainAtomY[n3] = this.mChainAtomY[n3] + d6;
                    }
                }
                if (this.mChainAtoms > 0) {
                    this.mChainAtom = new int[this.mChainAtoms];
                    for (n = 0; n < this.mChainAtoms; ++n) {
                        this.mChainAtom[n] = this.mMol.findAtom(this.mChainAtomX[n], this.mChainAtomY[n]);
                        if (this.mChainAtom[n] == -1) continue;
                        this.mChainAtomX[n] = this.mMol.getAtomX(this.mChainAtom[n]);
                        this.mChainAtomY[n] = this.mMol.getAtomY(this.mChainAtom[n]);
                    }
                    if (this.mChainAtomX[this.mChainAtoms - 1] == d2 && this.mChainAtomY[this.mChainAtoms - 1] == d) break;
                    bl = true;
                    break;
                }
                if (d2 == 0.0 && d == 0.0) break;
                bl = true;
                break;
            }
            case 1: {
                if ((this.mX2 - this.mX1) * (this.mX2 - this.mX1) + (this.mY2 - this.mY1) * (this.mY2 - this.mY1) < 100.0) {
                    this.suggestNewX2AndY2(this.mAtom1);
                }
                bl = true;
                break;
            }
            case 3: {
                this.mMol.setAtomX(this.mAtom1, this.mX[this.mAtom1] + this.mX2 - this.mX1);
                this.mMol.setAtomY(this.mAtom1, this.mY[this.mAtom1] + this.mY2 - this.mY1);
                if (this.mAtom2 != -1) {
                    this.mMol.setAtomX(this.mAtom2, this.mX[this.mAtom2] + this.mX2 - this.mX1);
                    this.mMol.setAtomY(this.mAtom2, this.mY[this.mAtom2] + this.mY2 - this.mY1);
                }
                this.update(2);
                break;
            }
            case 9: {
                this.duplicateSelected();
                this.mPendingRequest = 4;
            }
            case 4: {
                if (this.mDrawingObjectList != null) {
                    for (AbstractDrawingObject abstractDrawingObject : this.mDrawingObjectList) {
                        if (!abstractDrawingObject.isSelected()) continue;
                        abstractDrawingObject.translate(this.mX2, this.mY2);
                    }
                }
                for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                    if (!this.mMol.isSelectedAtom(i)) continue;
                    this.mMol.setAtomX(i, this.mX[i] + this.mX2 - this.mX1);
                    this.mMol.setAtomY(i, this.mY[i] + this.mY2 - this.mY1);
                }
                this.update(2);
                break;
            }
            case 11: {
                this.mDrawingObjectList.add(this.mCurrentHiliteObject.clone());
                this.mPendingRequest = 10;
            }
            case 10: {
                this.mCurrentHiliteObject.translate(this.mX2, this.mY2);
                this.update(2);
                break;
            }
            case 7: {
                boolean bl2;
                int n;
                boolean bl3 = false;
                for (n = 0; n < this.mMol.getAllAtoms() && !bl3; ++n) {
                    bl3 = this.mMol.isSelectedAtom(n);
                }
                n = 0;
                if (this.mDrawingObjectList != null) {
                    for (int i = 0; i < this.mDrawingObjectList.size() && n == 0; ++i) {
                        n = ((AbstractDrawingObject)this.mDrawingObjectList.get(i)).isSelected() ? 1 : 0;
                    }
                }
                double d = Math.abs(this.mY2 - this.mY1) < 20.0 ? 1.0 : Math.exp((this.mY2 - this.mY1) / 100.0);
                double d9 = Math.abs(this.mX2 - this.mX1) < 20.0 ? 0.0 : (this.mX2 - this.mX1) / 50.0;
                boolean bl4 = bl2 = bl3 || n != 0;
                if (!(this.mDrawingObjectList == null || bl2 && n == 0)) {
                    for (int i = 0; i < this.mDrawingObjectList.size(); ++i) {
                        if (bl2 && !((AbstractDrawingObject)this.mDrawingObjectList.get(i)).isSelected()) continue;
                        ((AbstractDrawingObject)this.mDrawingObjectList.get(i)).zoomAndRotate(d, d9);
                    }
                    this.update(2);
                }
                if (bl2 && !bl3) break;
                this.mMol.zoomAndRotate(d, d9, bl2);
                this.update(2);
                break;
            }
            case 5: 
            case 6: {
                int n;
                GenericShape genericShape = null;
                if (this.mPendingRequest == 5) {
                    if (Math.abs(this.mX2 - this.mLassoRegion.getX(this.mLassoRegion.getSize() - 1)) < 3.0 && Math.abs(this.mY2 - this.mLassoRegion.getY(this.mLassoRegion.getSize() - 1)) < 3.0) break;
                    this.mLassoRegion.removeLastPoint();
                    this.mLassoRegion.addPoint(this.mX2, this.mY2);
                    this.mLassoRegion.addPoint(this.mX1, this.mY1);
                    genericShape = this.mLassoRegion;
                } else {
                    genericShape = new GenericRectangle(Math.min(this.mX1, this.mX2), Math.min(this.mY1, this.mY2), Math.abs(this.mX2 - this.mX1), Math.abs(this.mY2 - this.mY1));
                }
                if (this.mDrawingObjectList != null) {
                    for (n = 0; n < this.mDrawingObjectList.size(); ++n) {
                        AbstractDrawingObject abstractDrawingObject = (AbstractDrawingObject)this.mDrawingObjectList.get(n);
                        boolean bl5 = abstractDrawingObject.isSurroundedBy(genericShape);
                        if (this.mIsAddingToSelection && this.mIsSelectedObject[n] || bl5 == abstractDrawingObject.isSelected()) continue;
                        abstractDrawingObject.setSelected(bl5);
                        this.mUpdateMode = Math.max(this.mUpdateMode, 1);
                    }
                }
                for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
                    boolean bl6 = genericShape.contains((int)this.mMol.getAtomX(n), (int)this.mMol.getAtomY(n));
                    if (this.mIsAddingToSelection && this.mIsSelectedAtom[n] || bl6 == this.mMol.isSelectedAtom(n)) continue;
                    this.mMol.setAtomSelection(n, bl6);
                    this.mUpdateMode = Math.max(this.mUpdateMode, 1);
                }
                bl = true;
                break;
            }
            case 8: {
                bl = true;
            }
        }
        if (bl) {
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        this.mMouseIsDown = false;
        int n2 = mouseEvent.getX();
        if (this.trackHiliting(n2, n = mouseEvent.getY(), false)) {
            this.repaint();
        }
        this.updateCursor();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            this.mShiftIsDown = true;
            this.updateCursor();
        }
        if (keyEvent.getKeyCode() == 18) {
            this.mAltIsDown = true;
            this.updateCursor();
        }
        if (keyEvent.getKeyCode() == 17) {
            this.mControlIsDown = true;
            this.updateCursor();
        }
        if (this.mControlIsDown && keyEvent.getKeyCode() == 90) {
            this.restoreState();
            this.fireMoleculeChanged();
            this.update(2);
        } else if (keyEvent.getKeyCode() == 127) {
            this.storeState();
            if (this.mCurrentTool == 19) {
                boolean bl = false;
                for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                    if (this.mMol.getAtomMapNo(i) == 0) continue;
                    this.mMol.setAtomMapNo(i, 0, false);
                    bl = true;
                }
                if (bl) {
                    this.fireMoleculeChanged();
                    this.update(1);
                }
            } else if (!this.deleteHilited() && this.mMol.deleteSelectedAtoms()) {
                this.fireMoleculeChanged();
                this.update(1);
            }
        } else {
            if (keyEvent.getKeyCode() == 156 || this.mCurrentHiliteAtom == -1 && keyEvent.getKeyChar() == '?') {
                this.showHelpDialog();
                return;
            }
            if (this.mCurrentHiliteBond != -1) {
                char c = keyEvent.getKeyChar();
                if (c == 'q' && this.mMol.isFragment()) {
                    this.showBondQFDialog(this.mCurrentHiliteBond);
                } else if (c == 'v') {
                    if (this.mMol.addRingToBond(this.mCurrentHiliteBond, 3, false, Molecule.getDefaultAverageBondLength())) {
                        this.fireMoleculeChanged();
                        this.update(3);
                    }
                } else if (c >= '4' && c <= '7') {
                    if (this.mMol.addRingToBond(this.mCurrentHiliteBond, c - 48, false, Molecule.getDefaultAverageBondLength())) {
                        this.fireMoleculeChanged();
                        this.update(3);
                    }
                } else if (c == 'a' || c == 'b') {
                    if (this.mMol.addRingToBond(this.mCurrentHiliteBond, 6, true, Molecule.getDefaultAverageBondLength())) {
                        this.fireMoleculeChanged();
                        this.update(3);
                    }
                } else {
                    boolean bl;
                    boolean bl2 = c == '0' ? this.changeHighlightedBond(32) : (c == '1' ? this.changeHighlightedBond(1) : (c == '2' ? this.changeHighlightedBond(2) : (c == '3' ? this.changeHighlightedBond(4) : (c == 'u' ? this.changeHighlightedBond(257) : (c == 'd' ? this.changeHighlightedBond(129) : (c == 'c' ? this.changeHighlightedBond(386) : (bl = c == 'm' ? this.changeHighlightedBond(32) : false)))))));
                    if (bl) {
                        this.fireMoleculeChanged();
                        this.update(1);
                    }
                }
            } else if (this.mCurrentHiliteAtom != -1) {
                boolean bl;
                char c = keyEvent.getKeyChar();
                boolean bl3 = bl = this.mAtomKeyStrokeBuffer.length() == 0;
                if (bl && (c == '+' || c == '-')) {
                    this.storeState();
                    if (this.mMol.changeAtomCharge(this.mCurrentHiliteAtom, c == '+')) {
                        this.fireMoleculeChanged();
                        this.update(3);
                    }
                } else if (bl && c == '.') {
                    this.storeState();
                    int n = this.mMol.getAtomRadical(this.mCurrentHiliteAtom) == 32 ? 0 : 32;
                    this.mMol.setAtomRadical(this.mCurrentHiliteAtom, n);
                    this.fireMoleculeChanged();
                    this.update(3);
                } else if (bl && c == ':') {
                    this.storeState();
                    int n = this.mMol.getAtomRadical(this.mCurrentHiliteAtom) == 48 ? 16 : (this.mMol.getAtomRadical(this.mCurrentHiliteAtom) == 16 ? 0 : 48);
                    this.mMol.setAtomRadical(this.mCurrentHiliteAtom, n);
                    this.fireMoleculeChanged();
                    this.update(3);
                } else if (bl && c == 'l') {
                    this.mAtomKeyStrokeBuffer.append("Cl");
                    this.update(1);
                } else if (bl && c == 'q' && this.mMol.isFragment()) {
                    this.showAtomQFDialog(this.mCurrentHiliteAtom);
                } else if (bl && c == '?') {
                    this.storeState();
                    if (this.mMol.changeAtom(this.mCurrentHiliteAtom, 0, 0, -1, 0)) {
                        this.fireMoleculeChanged();
                        this.update(3);
                    }
                } else if (bl && c > '0' && c <= '9') {
                    if (this.mMol.getFreeValence(this.mCurrentHiliteAtom) > 0) {
                        this.storeState();
                        int n = c - 47;
                        int n2 = this.mCurrentHiliteAtom;
                        int n3 = this.mMol.getAllAtoms() - this.mMol.getAtoms();
                        for (int i = 1; i < n; ++i) {
                            this.suggestNewX2AndY2(n2);
                            int n4 = this.mMol.addAtom(this.mX2, this.mY2);
                            if (n4 == -1) break;
                            this.mMol.addBond(n2, n4);
                            n2 = n4 - n3;
                            this.mMol.ensureHelperArrays(1);
                        }
                        this.fireMoleculeChanged();
                        this.update(3);
                    }
                } else if (!bl && keyEvent.getKeyCode() == 27) {
                    this.mAtomKeyStrokeBuffer.setLength(0);
                    this.update(1);
                } else if (!bl && keyEvent.getKeyCode() == 8) {
                    this.mAtomKeyStrokeBuffer.setLength(this.mAtomKeyStrokeBuffer.length() - 1);
                    this.update(1);
                } else if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-') {
                    this.mAtomKeyStrokeBuffer.append(c);
                    this.update(1);
                } else if (c == '\n' || c == '\r') {
                    this.expandAtomKeyStrokes(this.mAtomKeyStrokeBuffer.toString());
                }
            } else if (this.mCurrentHiliteAtom == -1 && this.mCurrentHiliteBond == -1 && (this.mMode & 7) == 0) {
                char c = keyEvent.getKeyChar();
                if (c == 'h') {
                    this.flip(true);
                }
                if (c == 'v') {
                    this.flip(false);
                }
            }
        }
    }

    private boolean changeHighlightedBond(int n) {
        this.storeState();
        return this.mMol.changeBond(this.mCurrentHiliteBond, n);
    }

    public void showHelpDialog() {
        if (this.mHelpDialog == null || !this.mHelpDialog.isVisible()) {
            JEditorPane jEditorPane = new JEditorPane();
            jEditorPane.setEditorKit(HiDPIHelper.getUIScaleFactor() == 1.0f ? new HTMLEditorKit() : new ScaledEditorKit());
            jEditorPane.setEditable(false);
            try {
                jEditorPane.setPage(this.getClass().getResource("/html/editor/editor.html"));
            }
            catch (Exception exception) {
                jEditorPane.setText(exception.toString());
            }
            Window window = SwingUIHelper.getWindow(this);
            this.mHelpDialog = new JDialog(window, "Idorsia Structure Editor Help", Dialog.ModalityType.MODELESS);
            this.mHelpDialog.setSize(HiDPIHelper.scale(520.0f), HiDPIHelper.scale(440.0f));
            this.mHelpDialog.getContentPane().add(new JScrollPane(jEditorPane, 22, 31));
            int n = window.getX() >= 8 + this.mHelpDialog.getWidth() ? window.getX() - 8 - this.mHelpDialog.getWidth() : window.getX() + 8 + window.getWidth();
            this.mHelpDialog.setLocation(n, window.getY());
            this.mHelpDialog.setVisible(true);
        } else {
            Window window = SwingUIHelper.getWindow(this);
            int n = this.mHelpDialog.getX() + this.mHelpDialog.getWidth() / 2 >= window.getX() + window.getWidth() / 2 ? window.getX() - 8 - this.mHelpDialog.getWidth() : window.getX() + 8 + window.getWidth();
            this.mHelpDialog.setLocation(n, window.getY());
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            this.mShiftIsDown = false;
            this.updateCursor();
        }
        if (keyEvent.getKeyCode() == 18) {
            this.mAltIsDown = false;
            this.updateCursor();
        }
        if (keyEvent.getKeyCode() == 17) {
            this.mControlIsDown = false;
            this.updateCursor();
        }
        if ((keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            if (keyEvent.getKeyCode() == 67) {
                this.copy();
            } else if (keyEvent.getKeyCode() == 86) {
                this.paste();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private boolean handlePopupTrigger(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Object object;
            JMenuItem jMenuItem;
            JMenuItem jMenuItem2;
            JPopupMenu jPopupMenu = null;
            if (this.mClipboardHandler != null) {
                jPopupMenu = new JPopupMenu();
                jMenuItem2 = new JMenuItem(this.analyseCopy(false) ? ITEM_COPY_REACTION : ITEM_COPY_STRUCTURE);
                jMenuItem2.addActionListener(this);
                if (this.mMol.getAllAtoms() == 0) {
                    jMenuItem2.setEnabled(false);
                }
                jPopupMenu.add(jMenuItem2);
                jMenuItem = null;
                if ((this.mMode & 4) != 0) {
                    jMenuItem = new JMenuItem(ITEM_PASTE_REACTION);
                    jMenuItem.addActionListener(this);
                    jPopupMenu.add(jMenuItem);
                }
                object = StructureNameResolver.getInstance() == null ? ITEM_PASTE_STRUCTURE : ITEM_PASTE_WITH_NAME;
                JMenuItem jMenuItem3 = new JMenuItem((String)object);
                jMenuItem3.addActionListener(this);
                jPopupMenu.add(jMenuItem3);
                JMenuItem jMenuItem4 = null;
                if ((this.mMode & 4) != 0) {
                    jMenuItem4 = new JMenuItem(ITEM_LOAD_REACTION);
                    jMenuItem4.addActionListener(this);
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(jMenuItem4);
                }
            }
            if ((this.mMode & 4) != 0 && this.mCurrentTool == 19) {
                if (jPopupMenu == null) {
                    jPopupMenu = new JPopupMenu();
                } else {
                    jPopupMenu.addSeparator();
                }
                jMenuItem2 = new JMenuItem(ITEM_ADD_AUTO_MAPPING);
                jMenuItem2.addActionListener(this);
                jPopupMenu.add(jMenuItem2);
                jMenuItem = new JMenuItem(ITEM_REMOVE_MAPPING);
                jMenuItem.addActionListener(this);
                jPopupMenu.add(jMenuItem);
            }
            if (this.mCurrentTool == 18) {
                if (jPopupMenu == null) {
                    jPopupMenu = new JPopupMenu();
                } else {
                    jPopupMenu.addSeparator();
                }
                jMenuItem2 = new JMenuItem(ITEM_FLIP_HORIZONTALLY);
                jMenuItem2.addActionListener(this);
                jPopupMenu.add(jMenuItem2);
                jMenuItem = new JMenuItem(ITEM_FLIP_VERTICALLY);
                jMenuItem.addActionListener(this);
                jPopupMenu.add(jMenuItem);
            }
            if (this.mAtomColorSupported && this.mCurrentHiliteAtom != -1) {
                int n = this.mMol.getAtomColor(this.mCurrentHiliteAtom);
                if (jPopupMenu == null) {
                    jPopupMenu = new JPopupMenu();
                } else {
                    jPopupMenu.addSeparator();
                }
                jMenuItem = new JMenu("Set Atom Color");
                this.addColorToMenu((JMenu)jMenuItem, Color.BLACK, 0, n == 0);
                this.addColorToMenu((JMenu)jMenuItem, new Color(-14655233), 64, n == 64);
                this.addColorToMenu((JMenu)jMenuItem, new Color(-6291456), 448, n == 448);
                this.addColorToMenu((JMenu)jMenuItem, new Color(-65536), 128, n == 128);
                this.addColorToMenu((JMenu)jMenuItem, new Color(-16744448), 384, n == 384);
                this.addColorToMenu((JMenu)jMenuItem, new Color(-16711936), 192, n == 192);
                this.addColorToMenu((JMenu)jMenuItem, new Color(-4194049), 256, n == 256);
                this.addColorToMenu((JMenu)jMenuItem, new Color(-24576), 320, n == 320);
                jPopupMenu.add(jMenuItem);
            }
            if (System.getProperty("development") != null) {
                if (jPopupMenu == null) {
                    jPopupMenu = new JPopupMenu();
                } else {
                    jPopupMenu.addSeparator();
                }
                JMenuItem jMenuItem5 = new JMenuItem("Show Atom & Bond Numbers");
                jMenuItem5.addActionListener(actionEvent -> this.setDisplayMode(6));
                jPopupMenu.add(jMenuItem5);
                jMenuItem = new JMenuItem("Show Symmetry");
                jMenuItem.addActionListener(actionEvent -> this.setDisplayMode(256));
                jPopupMenu.add(jMenuItem);
                object = new JMenuItem("Show Normal");
                ((AbstractButton)object).addActionListener(actionEvent -> this.setDisplayMode(this.mCurrentTool == 19 ? 16 : 0));
                jPopupMenu.add((JMenuItem)object);
            }
            if (jPopupMenu != null) {
                jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
            return true;
        }
        return false;
    }

    private void addColorToMenu(JMenu jMenu, Color color, int n, boolean bl) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("\t  ", bl);
        jRadioButtonMenuItem.setActionCommand("atomColor" + this.mCurrentHiliteAtom + ":" + n);
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setBackground(color);
        jMenu.add(jRadioButtonMenuItem);
    }

    private void handleDoubleClick(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.mMol.findAtom(n, n2);
        int n4 = this.mMol.findBond(n, n2);
        if (this.mCurrentTool == 2) {
            if (this.mMol.isFragment()) {
                if (n3 != -1) {
                    this.showAtomQFDialog(n3);
                } else if (n4 != -1) {
                    this.showBondQFDialog(n4);
                } else if (this.mCurrentHiliteObject != null) {
                    if (!this.mShiftIsDown) {
                        int n5;
                        for (n5 = 0; n5 < this.mMol.getAllAtoms(); ++n5) {
                            this.mMol.setAtomSelection(n5, false);
                        }
                        for (n5 = 0; n5 < this.mDrawingObjectList.size(); ++n5) {
                            ((AbstractDrawingObject)this.mDrawingObjectList.get(n5)).setSelected(false);
                        }
                    }
                    this.mCurrentHiliteObject.setSelected(true);
                    this.update(1);
                }
            } else {
                int n6 = -1;
                if (n3 != -1) {
                    n6 = n3;
                } else if (n4 != -1) {
                    n6 = this.mMol.getBondAtom(0, n4);
                }
                if (n6 != -1 || this.mCurrentHiliteObject != null) {
                    int n7;
                    if (!this.mShiftIsDown) {
                        for (n7 = 0; n7 < this.mMol.getAllAtoms(); ++n7) {
                            this.mMol.setAtomSelection(n7, false);
                        }
                        if (this.mDrawingObjectList != null) {
                            for (AbstractDrawingObject abstractDrawingObject : this.mDrawingObjectList) {
                                abstractDrawingObject.setSelected(false);
                            }
                        }
                    }
                    if (n6 != -1) {
                        if ((this.mMode & 1) != 0) {
                            n7 = this.mFragmentNo[n6];
                            for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                                if (this.mFragmentNo[i] != n7) continue;
                                this.mMol.setAtomSelection(i, true);
                            }
                        } else {
                            int[] nArray = this.mMol.getFragmentAtoms(n6);
                            for (int i = 0; i < nArray.length; ++i) {
                                this.mMol.setAtomSelection(nArray[i], true);
                            }
                        }
                    } else {
                        this.mCurrentHiliteObject.setSelected(true);
                    }
                    this.update(1);
                }
            }
        } else if (this.mCurrentTool == 18) {
            int n8 = -2;
            if ((this.mMode & 1) != 0) {
                n8 = this.findFragment(n, n2);
            }
            if (n8 != -1) {
                double d = 2.147483647E9;
                double d2 = -2.147483648E9;
                for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                    if (n8 != -2 && this.mFragmentNo[i] != n8) continue;
                    if (d > this.mMol.getAtomX(i)) {
                        d = this.mMol.getAtomX(i);
                    }
                    if (!(d2 < this.mMol.getAtomX(i))) continue;
                    d2 = this.mMol.getAtomX(i);
                }
                if (d2 > d) {
                    int n9;
                    double d3 = (d2 + d) / 2.0;
                    for (n9 = 0; n9 < this.mMol.getAllAtoms(); ++n9) {
                        if (n8 != -2 && this.mFragmentNo[n9] != n8) continue;
                        this.mMol.setAtomX(n9, 2.0 * d3 - this.mMol.getAtomX(n9));
                    }
                    block12: for (n9 = 0; n9 < this.mMol.getAllBonds(); ++n9) {
                        if (n8 != -2 && this.mFragmentNo[this.mMol.getBondAtom(0, n9)] != n8) continue;
                        switch (this.mMol.getBondType(n9)) {
                            case 257: {
                                this.mMol.setBondType(n9, 129);
                                continue block12;
                            }
                            case 129: {
                                this.mMol.setBondType(n9, 257);
                            }
                        }
                    }
                }
                this.fireMoleculeChanged();
                this.update(1);
            }
        } else if (this.mCurrentTool == 33) {
            JOptionPane.showMessageDialog(SwingUIHelper.getWindow(this), "Please hold 'Ctrl' while pressing the left mouse button\nto open the atom property dialog.");
        }
    }

    private void showAtomQFDialog(int n) {
        if (this.mAllowQueryFeatures) {
            Window window = SwingUIHelper.getWindow(this);
            this.storeState();
            boolean bl = (this.mMode & 4) != 0;
            new JAtomQueryFeatureDialog(window, this.mMol, n, bl);
            this.fireMoleculeChanged();
            this.update(1);
        }
    }

    private void showBondQFDialog(int n) {
        if (this.mAllowQueryFeatures) {
            Window window = SwingUIHelper.getWindow(this);
            this.storeState();
            new JBondQueryFeatureDialog(window, this.mMol, n);
            this.fireMoleculeChanged();
            this.update(1);
        }
    }

    private void mousePressedButton1(MouseEvent mouseEvent) {
        this.mX1 = mouseEvent.getX();
        this.mY1 = mouseEvent.getY();
        switch (this.mCurrentTool) {
            case 18: {
                double d = this.mX1;
                double d2 = this.mY1;
                this.mAtom1 = this.mMol.findAtom(this.mX1, this.mY1);
                if (this.mAtom1 != -1) {
                    this.mX1 = this.mMol.getAtomX(this.mAtom1);
                    this.mY1 = this.mMol.getAtomY(this.mAtom1);
                }
                this.mMol.zoomAndRotateInit(d, d2);
                if (this.mDrawingObjectList != null) {
                    for (AbstractDrawingObject abstractDrawingObject : this.mDrawingObjectList) {
                        abstractDrawingObject.zoomAndRotateInit(d, d2);
                    }
                }
                this.storeState();
                this.mPendingRequest = 7;
                break;
            }
            case 2: {
                int n;
                this.mPendingRequest = 0;
                this.mAtom1 = this.mMol.findAtom(this.mX1, this.mY1);
                if (this.mAtom1 != -1) {
                    this.mAtom2 = -1;
                    this.mX1 = this.mMol.getAtomX(this.mAtom1);
                    this.mY1 = this.mMol.getAtomY(this.mAtom1);
                    this.mPendingRequest = this.mMol.isSelectedAtom(this.mAtom1) ? (this.mShiftIsDown ? 9 : 4) : 3;
                }
                if (this.mPendingRequest == 0 && (n = this.mMol.findBond(this.mX1, this.mY1)) != -1) {
                    this.mAtom1 = this.mMol.getBondAtom(0, n);
                    this.mAtom2 = this.mMol.getBondAtom(1, n);
                    this.mPendingRequest = this.mMol.isSelectedBond(n) ? (this.mShiftIsDown ? 9 : 4) : 3;
                }
                if (this.mPendingRequest == 0 && this.mCurrentHiliteObject != null) {
                    if (this.mCurrentHiliteObject.isSelected()) {
                        this.mPendingRequest = this.mShiftIsDown ? 9 : 4;
                    } else {
                        int n2 = this.mPendingRequest = this.mShiftIsDown && !(this.mCurrentHiliteObject instanceof ReactionArrow) ? 11 : 10;
                    }
                }
                if (this.mPendingRequest != 0) {
                    this.mX = new double[this.mMol.getAllAtoms()];
                    this.mY = new double[this.mMol.getAllAtoms()];
                    for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
                        this.mX[n] = this.mMol.getAtomX(n);
                        this.mY[n] = this.mMol.getAtomY(n);
                    }
                    if (this.mDrawingObjectList != null) {
                        for (AbstractDrawingObject abstractDrawingObject : this.mDrawingObjectList) {
                            abstractDrawingObject.translateInit(this.mX1, this.mY1);
                        }
                    }
                    this.storeState();
                    break;
                }
                this.mIsSelectedAtom = new boolean[this.mMol.getAllAtoms()];
                if (this.mDrawingObjectList != null) {
                    this.mIsSelectedObject = new boolean[this.mDrawingObjectList.size()];
                }
                this.mIsAddingToSelection = mouseEvent.isShiftDown();
                for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
                    this.mIsSelectedAtom[n] = this.mMol.isSelectedAtom(n);
                }
                if (this.mDrawingObjectList != null) {
                    for (n = 0; n < this.mDrawingObjectList.size(); ++n) {
                        this.mIsSelectedObject[n] = ((AbstractDrawingObject)this.mDrawingObjectList.get(n)).isSelected();
                    }
                }
                if (mouseEvent.isAltDown()) {
                    this.mPendingRequest = 6;
                    break;
                }
                this.mLassoRegion = new GenericPolygon();
                this.mLassoRegion.addPoint(this.mX1, this.mY1);
                this.mLassoRegion.addPoint(this.mX1, this.mY1);
                this.mPendingRequest = 5;
                break;
            }
            case 4: {
                this.storeState();
                this.deleteAt(this.mX1, this.mY1);
                break;
            }
            case 3: {
                int n = this.mMol.findAtom(this.mX1, this.mY1);
                if (n == -1) break;
                this.storeState();
                this.mMol.setAtomConfigurationUnknown(n, !this.mMol.isAtomConfigurationUnknown(n));
                this.fireMoleculeChanged();
                this.update(1);
                break;
            }
            case 101: 
            case 102: 
            case 103: {
                if (this.mCurrentHiliteBond == -1 || !this.qualifiesForESR(this.mCurrentHiliteBond)) break;
                this.storeState();
                this.setESRInfo(this.mCurrentHiliteBond, this.mCurrentTool == 101 ? 0 : (this.mCurrentTool == 103 ? 1 : 2));
                this.fireMoleculeChanged();
                this.update(1);
                break;
            }
            case 5: 
            case 6: 
            case 23: {
                this.mAtom1 = this.mMol.findAtom(this.mX1, this.mY1);
                if (this.mAtom1 == -1) {
                    int n = this.mMol.findBond(this.mX1, this.mY1);
                    if (n != -1) {
                        this.storeState();
                        int n3 = 511;
                        if (this.mCurrentTool == 6) {
                            n3 = 257;
                        } else if (this.mCurrentTool == 23) {
                            n3 = 129;
                        }
                        if (!this.mMol.changeBond(n, n3)) break;
                        this.fireMoleculeChanged();
                        this.update(1);
                        break;
                    }
                } else {
                    if (this.mMol.getAllConnAtomsPlusMetalBonds(this.mAtom1) == 8) {
                        return;
                    }
                    this.mX1 = this.mMol.getAtomX(this.mAtom1);
                    this.mY1 = this.mMol.getAtomY(this.mAtom1);
                }
                this.mPendingRequest = 1;
                this.suggestNewX2AndY2(this.mAtom1);
                this.repaint();
                break;
            }
            case 22: {
                this.mAtom1 = this.mMol.findAtom(this.mX1, this.mY1);
                if (this.mAtom1 != -1) {
                    if (this.mMol.getAllConnAtomsPlusMetalBonds(this.mAtom1) == 8) {
                        return;
                    }
                    this.mX1 = this.mMol.getAtomX(this.mAtom1);
                    this.mY1 = this.mMol.getAtomY(this.mAtom1);
                }
                this.mPendingRequest = 2;
                this.mChainAtoms = 0;
                break;
            }
            case 7: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 3, false, Molecule.getDefaultAverageBondLength())) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 24: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 4, false, Molecule.getDefaultAverageBondLength())) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 8: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 5, false, Molecule.getDefaultAverageBondLength())) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 25: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 6, false, Molecule.getDefaultAverageBondLength())) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 9: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 7, false, Molecule.getDefaultAverageBondLength())) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 26: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 6, true, Molecule.getDefaultAverageBondLength())) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 10: {
                this.storeState();
                if (!this.mMol.changeAtomCharge(this.mX1, this.mY1, true)) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 27: {
                this.storeState();
                if (!this.mMol.changeAtomCharge(this.mX1, this.mY1, false)) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 16: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 1, 0, -1, 0, null)) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 11: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 6, 0, -1, 0, null)) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 12: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 7, 0, -1, 0, null)) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 13: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 8, 0, -1, 0, null)) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 28: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 14, 0, -1, 0, null)) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 29: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 15, 0, -1, 0, null)) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 30: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 16, 0, -1, 0, null)) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 14: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 9, 0, -1, 0, null)) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 31: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 17, 0, -1, 0, null)) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 15: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 35, 0, -1, 0, null)) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 32: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 53, 0, -1, 0, null)) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 33: {
                if (this.mOtherAtom == -1 || mouseEvent.isControlDown()) {
                    final int n = this.mMol.findAtom(this.mX1, this.mY1);
                    if (n == -1) break;
                    this.storeState();
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            JDrawArea.this.mOtherAtom = JDrawArea.this.mMol.getAtomicNo(n);
                            JDrawArea.this.mOtherMass = JDrawArea.this.mMol.getAtomMass(n);
                            JDrawArea.this.mOtherValence = JDrawArea.this.mMol.getAtomAbnormalValence(n);
                            JDrawArea.this.mOtherRadical = JDrawArea.this.mMol.getAtomRadical(n);
                            JDrawArea.this.mOtherLabel = JDrawArea.this.mMol.getAtomCustomLabel(n);
                            JDrawArea.this.fireMoleculeChanged();
                            JDrawArea.this.update(1);
                        }
                    };
                    if (SwingUIHelper.isAsynchronous()) {
                        new JAtomLabelDialog(SwingUIHelper.getWindow(this), this.mMol, n, runnable, runnable);
                        return;
                    }
                    new JAtomLabelDialog(SwingUIHelper.getWindow(this), this.mMol, n);
                    runnable.run();
                    break;
                }
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, this.mOtherAtom, this.mOtherMass, this.mOtherValence, this.mOtherRadical, this.mOtherLabel)) break;
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 19: {
                this.mAtom1 = this.mMol.findAtom(this.mX1, this.mY1);
                if (this.mAtom1 == -1 || this.mAtom1 >= this.mMol.getAtoms()) break;
                this.mX1 = this.mMol.getAtomX(this.mAtom1);
                this.mY1 = this.mMol.getAtomY(this.mAtom1);
                this.mPendingRequest = 8;
                break;
            }
            case 21: {
                TextDrawingObject textDrawingObject = null;
                if (this.mCurrentHiliteObject == null) {
                    textDrawingObject = new TextDrawingObject();
                    textDrawingObject.setCoordinates(this.mX1, this.mY1);
                    this.mDrawingObjectList.add(textDrawingObject);
                } else if (this.mCurrentHiliteObject instanceof TextDrawingObject) {
                    textDrawingObject = (TextDrawingObject)this.mCurrentHiliteObject;
                }
                this.editTextObject(textDrawingObject);
                this.storeState();
                this.update(3);
            }
        }
    }

    private void mouseReleasedButton1(MouseEvent mouseEvent) {
        int n = this.mPendingRequest;
        this.mPendingRequest = 0;
        switch (n) {
            case 1: {
                int n2 = this.mMol.findAtom(this.mX2, this.mY2);
                if (n2 != -1 && this.mMol.getAllConnAtomsPlusMetalBonds(n2) == 8) {
                    return;
                }
                this.storeState();
                if (this.mAtom1 == -1) {
                    this.mAtom1 = this.mMol.addAtom(this.mX1, this.mY1);
                }
                if (n2 == -1) {
                    n2 = this.mMol.addAtom(this.mX2, this.mY2);
                }
                if (this.mAtom1 != -1 && n2 != -1) {
                    int n3;
                    int n4 = n3 = this.mMol.isMetalAtom(this.mAtom1) || this.mMol.isMetalAtom(n2) ? 32 : 1;
                    if (this.mCurrentTool == 6) {
                        n3 = 257;
                    }
                    if (this.mCurrentTool == 23) {
                        n3 = 129;
                    }
                    this.mMol.addOrChangeBond(this.mAtom1, n2, n3);
                }
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 2: {
                this.storeState();
                if (this.mChainAtoms > 0) {
                    if (this.mAtom1 == -1) {
                        this.mAtom1 = this.mMol.addAtom(this.mX1, this.mY1);
                    }
                    if (this.mChainAtom[0] == -1) {
                        this.mChainAtom[0] = this.mMol.addAtom(this.mChainAtomX[0], this.mChainAtomY[0]);
                    }
                    if (this.mChainAtom[0] != -1) {
                        this.mMol.addBond(this.mAtom1, this.mChainAtom[0]);
                    }
                }
                if (this.mChainAtoms > 1) {
                    for (int i = 1; i < this.mChainAtoms; ++i) {
                        if (this.mChainAtom[i] == -1) {
                            this.mChainAtom[i] = this.mMol.addAtom(this.mChainAtomX[i], this.mChainAtomY[i]);
                        }
                        if (this.mChainAtom[i] == -1) continue;
                        this.mMol.addBond(this.mChainAtom[i - 1], this.mChainAtom[i]);
                    }
                }
                this.fireMoleculeChanged();
                this.update(3);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                this.fireMoleculeChanged();
            }
            case 10: {
                this.update(3);
                break;
            }
            case 5: 
            case 6: {
                boolean bl = false;
                for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                    if (this.mIsSelectedAtom[i] == this.mMol.isSelectedAtom(i)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.fireEvent(new EditorEvent(this, 2, true));
                }
                this.repaint();
                break;
            }
            case 8: {
                boolean bl = false;
                int n5 = this.mCurrentHiliteAtom;
                int n6 = this.mMol.getAtomMapNo(this.mAtom1);
                if (n5 == -1) {
                    this.storeState();
                    if (n6 != 0) {
                        bl = true;
                        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                            if (this.mMol.getAtomMapNo(i) != n6) continue;
                            this.mMol.setAtomMapNo(i, 0, false);
                        }
                        this.autoMapReaction();
                    }
                } else {
                    this.storeState();
                    bl = true;
                    if (this.mAtom1 == n5) {
                        int n7 = this.mMol.getAtomMapNo(this.mAtom1);
                        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                            if (this.mMol.getAtomMapNo(i) != n7) continue;
                            this.mMol.setAtomMapNo(i, 0, false);
                        }
                    } else {
                        int n8;
                        int n9 = this.mMol.getAtomMapNo(n5);
                        for (n8 = 0; n8 < this.mMol.getAtoms(); ++n8) {
                            if (this.mMol.getAtomMapNo(n8) != n6 && this.mMol.getAtomMapNo(n8) != n9) continue;
                            this.mMol.setAtomMapNo(n8, 0, false);
                        }
                        n8 = 1;
                        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                            if (this.mMol.getAtomMapNo(i) != n8) continue;
                            ++n8;
                            i = -1;
                        }
                        this.mMol.setAtomMapNo(this.mAtom1, n8, false);
                        this.mMol.setAtomMapNo(n5, n8, false);
                    }
                    this.autoMapReaction();
                }
                if (bl) {
                    this.fireMoleculeChanged();
                    this.mUpdateMode = Math.max(this.mUpdateMode, 1);
                }
                this.repaint();
            }
        }
    }

    private void autoMapReaction() {
        int n;
        int n2;
        int n3;
        if (sMapper == null) {
            sMapper = new MCSReactionMapper();
        }
        SSSearcher sSSearcher = new SSSearcher(){

            @Override
            public boolean areAtomsSimilar(int n, int n2) {
                if (this.mMolecule.getAtomicNo(n) == this.mFragment.getAtomicNo(n2)) {
                    if (this.mMolecule.getAtomMass(n) != this.mFragment.getAtomMass(n2)) {
                        return false;
                    }
                    if (this.mMolecule.isAromaticAtom(n) || this.mFragment.isAromaticAtom(n2)) {
                        return true;
                    }
                }
                return super.areAtomsSimilar(n, n2);
            }

            @Override
            public boolean areBondsSimilar(int n, int n2) {
                if (this.mMolecule.isAromaticBond(n) || this.mMolecule.isDelocalizedBond(n) || this.mFragment.isAromaticBond(n2) || this.mFragment.isDelocalizedBond(n2)) {
                    return true;
                }
                return super.areBondsSimilar(n, n2);
            }
        };
        Reaction reaction = this.getReaction();
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        int n4 = 1;
        int[] nArray = new int[this.mFragment.length];
        for (n3 = 0; n3 < this.mMol.getAllAtoms(); ++n3) {
            n2 = this.mFragmentNo[n3];
            this.mFragment[n2].setAtomMapNo(nArray[n2], 0, false);
            if (this.mMol.getAtomMapNo(n3) != 0 && !this.mMol.isAutoMappedAtom(n3)) {
                n = this.mMol.getAtomMapNo(n3);
                Integer n5 = (Integer)treeMap.get(-n);
                if (n5 == null) {
                    n5 = new Integer(n4++);
                    treeMap.put(-n, n5);
                }
                this.mFragment[n2].setAtomMass(nArray[n2], 512 + n5);
            }
            int n6 = n2;
            nArray[n6] = nArray[n6] + 1;
        }
        if ((reaction = sMapper.mapReaction(reaction, sSSearcher)) != null) {
            nArray = new int[this.mFragment.length];
            for (n3 = 0; n3 < this.mMol.getAllAtoms(); ++n3) {
                int n7;
                n2 = this.mFragmentNo[n3];
                int n8 = n = this.mFragment[n2].getAtomMass(nArray[n2]) > 512 ? 1 : 0;
                if (n != 0) {
                    n7 = this.mFragment[n2].getAtomMass(nArray[n2]) - 512;
                    this.mFragment[n2].setAtomMass(nArray[n2], this.mMol.getAtomMass(n3));
                    this.mMol.setAtomMapNo(n3, n7, false);
                    this.mFragment[n2].setAtomMapNo(nArray[n2], n7, false);
                } else {
                    n7 = this.mFragment[n2].getAtomMapNo(nArray[n2]);
                    Integer n9 = 0;
                    if (n7 != 0 && (n9 = (Integer)treeMap.get(n7)) == null) {
                        n9 = new Integer(n4++);
                        treeMap.put(n7, n9);
                    }
                    this.mMol.setAtomMapNo(n3, n9, true);
                    this.mFragment[n2].setAtomMapNo(nArray[n2], n9, true);
                }
                int n10 = n2;
                nArray[n10] = nArray[n10] + 1;
            }
        } else {
            nArray = new int[this.mFragment.length];
            for (n3 = 0; n3 < this.mMol.getAllAtoms(); ++n3) {
                n2 = this.mFragmentNo[n3];
                this.mFragment[n2].setAtomMass(nArray[n2], this.mMol.getAtomMass(n3));
                this.mFragment[n2].setAtomMapNo(nArray[n2], this.mMol.getAtomMapNo(n3), this.mMol.isAutoMappedAtom(n3));
                int n11 = n2;
                nArray[n11] = nArray[n11] + 1;
            }
        }
    }

    private boolean qualifiesForESR(int n) {
        return this.mMol.isStereoBond(n) && (this.getESRAtom(n) != -1 || this.getESRBond(n) != -1);
    }

    private int getESRAtom(int n) {
        int n2 = this.mMol.getBondAtom(0, n);
        if (this.mMol.getAtomParity(n2) != 0) {
            return this.mMol.isAtomParityPseudo(n2) || this.mMol.getAtomParity(n2) != 1 && this.mMol.getAtomParity(n2) != 2 ? -1 : n2;
        }
        if (this.mMol.getAtomPi(n2) == 1) {
            for (int i = 0; i < this.mMol.getConnAtoms(n2); ++i) {
                int n3;
                if (this.mMol.getConnBondOrder(n2, i) != 2 || this.mMol.getAtomPi(n3 = this.mMol.getConnAtom(n2, i)) != 2 || this.mMol.getAtomParity(n3) != 1 && this.mMol.getAtomParity(n3) != 2) continue;
                return n3;
            }
        }
        return -1;
    }

    private int getESRBond(int n) {
        int n2 = this.mMol.findBINAPChiralityBond(this.mMol.getBondAtom(0, n));
        if (n2 != -1 && this.mMol.getBondParity(n2) != 1 && this.mMol.getBondParity(n2) != 2) {
            n2 = -1;
        }
        return n2;
    }

    private void setESRInfo(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = -1;
        int n8 = this.getESRAtom(n);
        int n9 = n6 = n8 == -1 ? this.getESRBond(n) : -1;
        if (n2 != 0) {
            n5 = -1;
            for (n4 = 0; n4 < this.mMol.getAtoms(); ++n4) {
                if (n4 == n8 || this.mMol.getAtomESRType(n4) != n2 || this.mMol.isSelectedBond(n) && this.mMol.isSelectedAtom(n4) || n5 >= (n3 = this.mMol.getAtomESRGroup(n4))) continue;
                n5 = n3;
            }
            for (n4 = 0; n4 < this.mMol.getBonds(); ++n4) {
                if (n4 == n6 || this.mMol.getBondESRType(n4) != n2 || this.mMol.isSelectedBond(n) && this.mMol.isSelectedBond(n4) || n5 >= (n3 = this.mMol.getBondESRGroup(n4))) continue;
                n5 = n3;
            }
            if ((n8 == -1 ? this.mMol.getBondESRType(n6) : this.mMol.getAtomESRType(n8)) != n2) {
                n7 = Math.min(n5 + 1, 31);
            } else {
                int n10 = n7 = n8 == -1 ? this.mMol.getBondESRGroup(n6) : this.mMol.getAtomESRGroup(n8);
                if (this.mMol.isSelectedBond(n)) {
                    n4 = 1;
                    for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
                        if (n3 == n8 || !this.mMol.isSelectedAtom(n3) || this.mMol.getAtomESRType(n3) != n2 || this.mMol.getAtomESRGroup(n3) == n7) continue;
                        n4 = 0;
                        break;
                    }
                    for (n3 = 0; n3 < this.mMol.getBonds(); ++n3) {
                        if (n3 == n6 || !this.mMol.isSelectedBond(n3) || this.mMol.getBondESRType(n3) != n2 || this.mMol.getBondESRGroup(n3) == n7) continue;
                        n4 = 0;
                        break;
                    }
                    if (n4 != 0) {
                        if (n7 <= n5) {
                            if (++n7 == 32) {
                                n7 = 0;
                            }
                        } else {
                            n7 = 0;
                        }
                    }
                } else if (n7 <= n5) {
                    if (++n7 == 32) {
                        n7 = 0;
                    }
                } else {
                    n7 = 0;
                }
            }
        }
        if (this.mMol.isSelectedBond(n)) {
            for (n5 = 0; n5 < this.mMol.getBonds(); ++n5) {
                if (!this.mMol.isSelectedBond(n5) || !this.mMol.isStereoBond(n5)) continue;
                n4 = this.getESRAtom(n5);
                n3 = this.getESRBond(n5);
                if (n4 != -1) {
                    this.mMol.setAtomESR(n4, n2, n7);
                    continue;
                }
                if (n3 == -1) continue;
                this.mMol.setBondESR(n3, n2, n7);
            }
        } else if (n8 != -1) {
            this.mMol.setAtomESR(n8, n2, n7);
        } else if (n6 != -1) {
            this.mMol.setBondESR(n6, n2, n7);
        }
    }

    private int findFragment(double d, double d2) {
        int n = -1;
        double d3 = Double.MAX_VALUE;
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            double d4;
            double d5 = this.mX1 - this.mMol.getAtomX(i);
            double d6 = Math.sqrt(d5 * d5 + (d4 = this.mY1 - this.mMol.getAtomY(i)) * d4);
            if (!(d6 < 24.0) || !(d3 > d6)) continue;
            d3 = d6;
            n = this.mFragmentNo[i];
        }
        return n;
    }

    private void suggestNewX2AndY2(int n) {
        double d = 2.0943951023931953;
        if (n != -1) {
            int n2;
            double[] dArray = new double[9];
            for (n2 = 0; n2 < this.mMol.getAllConnAtomsPlusMetalBonds(n); ++n2) {
                dArray[n2] = this.mMol.getBondAngle(n, this.mMol.getConnAtom(n, n2));
            }
            if (this.mMol.getAllConnAtomsPlusMetalBonds(n) == 1) {
                d = dArray[0] < -2.6179938779914944 ? 1.0471975511965976 : (dArray[0] < -1.5707963267948966 ? 2.0943951023931953 : (dArray[0] < -0.5235987755982988 ? 1.0471975511965976 : (dArray[0] < 0.0 ? 2.0943951023931953 : (dArray[0] < 0.5235987755982988 ? -2.0943951023931953 : (dArray[0] < 1.5707963267948966 ? -1.0471975511965976 : (dArray[0] < 2.6179938779914944 ? -2.0943951023931953 : -1.0471975511965976))))));
            } else {
                for (n2 = this.mMol.getAllConnAtomsPlusMetalBonds(n) - 1; n2 > 0; --n2) {
                    for (int i = 0; i < n2; ++i) {
                        if (!(dArray[i] > dArray[i + 1])) continue;
                        double d2 = dArray[i];
                        dArray[i] = dArray[i + 1];
                        dArray[i + 1] = d2;
                    }
                }
                dArray[this.mMol.getAllConnAtomsPlusMetalBonds((int)n)] = dArray[0] + Math.PI * 2;
                n2 = 0;
                double d3 = 0.0;
                for (int i = 0; i < this.mMol.getAllConnAtomsPlusMetalBonds(n); ++i) {
                    double d4 = dArray[i + 1] - dArray[i];
                    if (!(d3 < d4)) continue;
                    d3 = d4;
                    n2 = i;
                }
                d = (dArray[n2] + dArray[n2 + 1]) / 2.0;
            }
        }
        double d5 = this.mMol.getAverageBondLength();
        this.mX2 = (n == -1 ? this.mX1 : this.mMol.getAtomX(n)) + d5 * (double)((float)Math.sin(d));
        this.mY2 = (n == -1 ? this.mY1 : this.mMol.getAtomY(n)) + d5 * (double)((float)Math.cos(d));
    }

    private boolean areAtomsMappingCompatible(int n, int n2) {
        if (this.mMol.isFragment()) {
            int n3;
            int n4;
            int[] nArray;
            if ((this.mMol.getAtomQueryFeatures(n) & 0x20000000L) != 0L || (this.mMol.getAtomQueryFeatures(n) & 0x20000000L) != 0L) {
                return false;
            }
            int[] nArray2 = this.mMol.getAtomList(n);
            if (nArray2 == null ^ (nArray = this.mMol.getAtomList(n2)) == null) {
                return false;
            }
            if (nArray2 != null) {
                if (nArray2.length != nArray.length) {
                    return false;
                }
                for (n4 = 0; n4 < nArray2.length; ++n4) {
                    if (nArray2[n4] == nArray[n4]) continue;
                    return false;
                }
            }
            n4 = (this.mMol.getAtomQueryFeatures(n) & 1L) != 0L ? 1 : 0;
            int n5 = n3 = (this.mMol.getAtomQueryFeatures(n2) & 1L) != 0L ? 1 : 0;
            if (n4 != n3) {
                return false;
            }
        }
        return this.mMol.getAtomicNo(n) == this.mMol.getAtomicNo(n2);
    }

    private boolean trackHiliting(double d, double d2, boolean bl) {
        boolean bl2;
        int n = this.mMol.findAtom(d, d2);
        int n2 = -1;
        if (bl && this.mPendingRequest == 8 && n != -1 && (!this.areAtomsMappingCompatible(this.mAtom1, n) || this.mMol.getAtomMapNo(this.mAtom1) != 0 && this.mMol.getAtomMapNo(this.mAtom1) == this.mMol.getAtomMapNo(n) && !this.mMol.isAutoMappedAtom(this.mAtom1) || this.shareSameReactionSide(this.mAtom1, n))) {
            n = -1;
        }
        if (n != -1) {
            if (this.mCurrentTool == 101 || this.mCurrentTool == 103 || this.mCurrentTool == 102) {
                n2 = this.mMol.getStereoBond(n);
                n = -1;
            } else if (this.mCurrentTool == 19 && n >= this.mMol.getAtoms()) {
                n = -1;
            }
        }
        if (n2 == -1 && n == -1 && this.mCurrentTool != 22 && this.mCurrentTool != 19 && this.mCurrentTool != 3 && this.mCurrentTool != 10 && this.mCurrentTool != 27 && this.mCurrentTool != 16 && this.mCurrentTool != 11 && this.mCurrentTool != 12 && this.mCurrentTool != 13 && this.mCurrentTool != 28 && this.mCurrentTool != 29 && this.mCurrentTool != 30 && this.mCurrentTool != 14 && this.mCurrentTool != 31 && this.mCurrentTool != 15 && this.mCurrentTool != 32 && this.mCurrentTool != 33) {
            n2 = this.mMol.findBond(d, d2);
        }
        if (!(n2 == -1 || this.mCurrentTool != 101 && this.mCurrentTool != 103 && this.mCurrentTool != 102 || this.qualifiesForESR(n2))) {
            n2 = -1;
        }
        AbstractDrawingObject abstractDrawingObject = this.mCurrentHiliteObject;
        if (!bl && this.mDrawingObjectList != null) {
            abstractDrawingObject = null;
            if (n == -1 && n2 == -1 && (this.mCurrentTool == 2 || this.mCurrentTool == 4 || this.mCurrentTool == 21)) {
                for (AbstractDrawingObject abstractDrawingObject2 : this.mDrawingObjectList) {
                    if (this.mCurrentTool != 2 && (this.mCurrentTool != 4 || abstractDrawingObject2 instanceof ReactionArrow) && (this.mCurrentTool != 21 || !(abstractDrawingObject2 instanceof TextDrawingObject)) || !abstractDrawingObject2.checkHiliting(d, d2)) continue;
                    abstractDrawingObject = abstractDrawingObject2;
                    if (this.mCurrentHiliteObject == null || this.mCurrentHiliteObject == abstractDrawingObject2) break;
                    this.mCurrentHiliteObject.clearHiliting();
                    break;
                }
            }
        }
        boolean bl3 = bl2 = this.mCurrentHiliteAtom != n || this.mCurrentHiliteBond != n2 || this.mCurrentHiliteObject != abstractDrawingObject || abstractDrawingObject != null;
        if (this.mCurrentHiliteAtom != n) {
            if (this.mCurrentHiliteAtom != -1 && this.mAtomKeyStrokeBuffer.length() != 0) {
                this.expandAtomKeyStrokes(this.mAtomKeyStrokeBuffer.toString());
            }
            this.mCurrentHiliteAtom = n;
            this.mAtomKeyStrokeBuffer.setLength(0);
            this.fireEvent(new EditorEvent(this, 4, true));
        }
        if (this.mCurrentHiliteBond != n2) {
            this.mCurrentHiliteBond = n2;
            this.fireEvent(new EditorEvent(this, 8, true));
        }
        this.mCurrentHiliteObject = abstractDrawingObject;
        return bl2;
    }

    private int getAtomKeyStrokeValidity(String string) {
        if (Molecule.getAtomicNoFromLabel(string) != 0) {
            return 1;
        }
        if (NamedSubstituents.getSubstituentIDCode(string) != null) {
            return 2;
        }
        if (this.isValidAtomKeyStrokeStart(string)) {
            return 3;
        }
        return 4;
    }

    private boolean isValidAtomKeyStroke(String string) {
        return Molecule.getAtomicNoFromLabel(string) != 0 || NamedSubstituents.getSubstituentIDCode(string) != null;
    }

    private boolean isValidAtomKeyStrokeStart(String string) {
        if (string.length() < 3) {
            for (int i = 1; i < Molecule.cAtomLabel.length; ++i) {
                if (!Molecule.cAtomLabel[i].startsWith(string)) continue;
                return true;
            }
        }
        return NamedSubstituents.isValidSubstituentNameStart(string);
    }

    private void expandAtomKeyStrokes(String string) {
        StereoMolecule stereoMolecule;
        this.mAtomKeyStrokeBuffer.setLength(0);
        int n = Molecule.getAtomicNoFromLabel(string);
        if (n != 0) {
            this.storeState();
            if (this.mMol.changeAtom(this.mCurrentHiliteAtom, n, 0, -1, 0)) {
                this.fireMoleculeChanged();
                this.update(3);
                return;
            }
        }
        if ((stereoMolecule = NamedSubstituents.getSubstituent(string)) != null) {
            this.storeState();
            StereoMolecule stereoMolecule2 = new StereoMolecule();
            stereoMolecule2.addFragment(this.mMol, this.mCurrentHiliteAtom, null);
            double d = stereoMolecule2.getAverageBondLength();
            int n2 = stereoMolecule2.getAllAtoms();
            for (int i = 0; i < stereoMolecule2.getAllAtoms(); ++i) {
                stereoMolecule2.setAtomMarker(i, true);
            }
            stereoMolecule2.addSubstituent(stereoMolecule, 0);
            new CoordinateInventor(4).invent(stereoMolecule2);
            double d2 = this.mMol.getAtomX(this.mCurrentHiliteAtom) - d * stereoMolecule2.getAtomX(0);
            double d3 = this.mMol.getAtomY(this.mCurrentHiliteAtom) - d * stereoMolecule2.getAtomY(0);
            int n3 = this.mMol.getAllAtoms();
            this.mMol.addSubstituent(stereoMolecule, this.mCurrentHiliteAtom);
            int n4 = this.mMol.getAllAtoms() - n3;
            for (int i = 0; i < n4; ++i) {
                this.mMol.setAtomX(n3 + i, d * stereoMolecule2.getAtomX(n2 + i) + d2);
                this.mMol.setAtomY(n3 + i, d * stereoMolecule2.getAtomY(n2 + i) + d3);
            }
            this.mMol.setStereoBondsFromParity();
            this.fireMoleculeChanged();
            this.update(3);
        }
    }

    private AbstractDrawingObject findDrawingObject(double d, double d2, String string, boolean bl) {
        if (this.mDrawingObjectList != null) {
            for (AbstractDrawingObject abstractDrawingObject : this.mDrawingObjectList) {
                if (string != null && (!string.equals(abstractDrawingObject.getTypeString()) || bl) && !abstractDrawingObject.isDeletable() || !abstractDrawingObject.contains(d, d2)) continue;
                return abstractDrawingObject;
            }
        }
        return null;
    }

    private void editTextObject(TextDrawingObject textDrawingObject) {
        new JTextDrawingObjectDialog(SwingUIHelper.getWindow(this), textDrawingObject);
        boolean bl = false;
        for (int i = 0; i < textDrawingObject.getText().length(); ++i) {
            if (Character.isWhitespace(textDrawingObject.getText().charAt(i))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.mDrawingObjectList.remove(textDrawingObject);
        }
        this.repaint();
    }

    private boolean shareSameReactionSide(int n, int n2) {
        ReactionArrow reactionArrow = (ReactionArrow)this.mDrawingObjectList.get(0);
        return !(reactionArrow.isOnProductSide(this.mMol.getAtomX(n), this.mMol.getAtomY(n)) ^ reactionArrow.isOnProductSide(this.mMol.getAtomX(n2), this.mMol.getAtomY(n2)));
    }

    protected void restoreState() {
        if (this.mUndoMol == null) {
            return;
        }
        this.mUndoMol.copyMolecule(this.mMol);
        this.mDrawingObjectList = this.mUndoDrawingObjectList == null ? null : new DrawingObjectList(this.mUndoDrawingObjectList);
    }

    public void storeState() {
        if (this.mUndoMol == null) {
            this.mUndoMol = new Molecule();
        }
        this.mMol.copyMolecule(this.mUndoMol);
        this.mUndoDrawingObjectList = this.mDrawingObjectList == null ? null : new DrawingObjectList(this.mDrawingObjectList);
    }

    private boolean deleteHilited() {
        if (this.mCurrentHiliteAtom != -1) {
            this.mMol.deleteAtom(this.mCurrentHiliteAtom);
            this.mCurrentHiliteAtom = -1;
            this.fireMoleculeChanged();
            this.update(1);
            return true;
        }
        if (this.mCurrentHiliteBond != -1) {
            this.mMol.deleteBondAndSurrounding(this.mCurrentHiliteBond);
            this.mCurrentHiliteBond = -1;
            this.fireMoleculeChanged();
            this.update(1);
            return true;
        }
        if (this.mCurrentHiliteObject != null && this.mCurrentHiliteObject.isDeletable()) {
            this.mDrawingObjectList.remove(this.mCurrentHiliteObject);
            this.mCurrentHiliteObject = null;
            this.update(1);
            return true;
        }
        return false;
    }

    private boolean deleteAt(double d, double d2) {
        if (this.mMol.deleteAtomOrBond(d, d2)) {
            this.fireMoleculeChanged();
            this.update(1);
            return true;
        }
        AbstractDrawingObject abstractDrawingObject = this.findDrawingObject(d, d2, null, true);
        if (abstractDrawingObject != null) {
            this.mDrawingObjectList.remove(abstractDrawingObject);
            this.mCurrentHiliteObject = null;
            this.update(1);
            return true;
        }
        return false;
    }

    private void duplicateSelected() {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.mMol.getAllAtoms(); ++n2) {
            if (!this.mMol.isSelectedAtom(n2)) continue;
            ++n3;
        }
        n2 = this.mMol.getAllAtoms();
        int n4 = this.mMol.getAllBonds();
        this.mX = Arrays.copyOf(this.mX, this.mX.length + n3);
        this.mY = Arrays.copyOf(this.mY, this.mY.length + n3);
        int[] nArray = new int[this.mMol.getAllAtoms()];
        int n5 = this.mMol.renumberESRGroups(1);
        int n6 = this.mMol.renumberESRGroups(2);
        for (n = 0; n < n2; ++n) {
            if (!this.mMol.isSelectedAtom(n)) continue;
            int n7 = this.mMol.getAllAtoms();
            this.mX[n7] = this.mX[n];
            this.mY[n7] = this.mY[n];
            nArray[n] = n7;
            this.mMol.copyAtom(this.mMol, n, n5, n6);
        }
        for (n = 0; n < n4; ++n) {
            if (!this.mMol.isSelectedBond(n)) continue;
            this.mMol.copyBond(this.mMol, n, n5, n6, nArray, false);
        }
        for (n = 0; n < n2; ++n) {
            this.mMol.setAtomSelection(n, false);
        }
        for (n = n2; n < this.mMol.getAllAtoms(); ++n) {
            this.mMol.setAtomMapNo(n, 0, false);
        }
        if (this.mDrawingObjectList != null) {
            for (n = this.mDrawingObjectList.size() - 1; n >= 0; --n) {
                AbstractDrawingObject abstractDrawingObject = (AbstractDrawingObject)this.mDrawingObjectList.get(n);
                if (!abstractDrawingObject.isSelected() || abstractDrawingObject instanceof ReactionArrow) continue;
                this.mDrawingObjectList.add(abstractDrawingObject.clone());
            }
        }
    }

    private void fireMoleculeChanged() {
        this.fireEvent(new EditorEvent(this, 1, true));
    }

    private void fireEvent(EditorEvent editorEvent) {
        for (GenericEventListener<EditorEvent> genericEventListener : this.mListeners) {
            genericEventListener.eventHappened(editorEvent);
        }
    }

    public void moleculeChanged() {
        this.moleculeChanged(false);
    }

    public void moleculeChanged(boolean bl) {
        this.fireEvent(new EditorEvent(this, 1, bl));
        this.update(4);
    }

    public StereoMolecule getMolecule() {
        return this.mMol;
    }

    public void setMolecule(StereoMolecule stereoMolecule) {
        if (this.mMol == stereoMolecule) {
            return;
        }
        this.mMol = stereoMolecule;
        this.storeState();
        this.moleculeChanged(false);
    }

    public StereoMolecule[] getFragments() {
        return this.mFragment;
    }

    public void setFragments(StereoMolecule[] stereoMoleculeArray) {
        int n;
        this.mMol.clear();
        this.mFragment = stereoMoleculeArray;
        for (n = 0; n < stereoMoleculeArray.length; ++n) {
            this.mMol.addMolecule(this.mFragment[n]);
        }
        this.storeState();
        this.mFragmentNo = new int[this.mMol.getAllAtoms()];
        n = 0;
        for (int i = 0; i < this.mFragment.length; ++i) {
            for (int j = 0; j < this.mFragment[i].getAllAtoms(); ++j) {
                this.mFragmentNo[n++] = i;
            }
        }
        this.fireEvent(new EditorEvent(this, 1, false));
        this.mMode = 1;
        this.update(5);
    }

    public Reaction getReaction() {
        if ((this.mMode & 4) == 0 || this.mFragment == null) {
            return null;
        }
        Reaction reaction = new Reaction();
        for (int i = 0; i < this.mFragment.length; ++i) {
            if (i < this.mReactantCount) {
                reaction.addReactant(this.mFragment[i]);
                continue;
            }
            reaction.addProduct(this.mFragment[i]);
        }
        return reaction;
    }

    public Reaction getReactionAndDrawings() {
        Reaction reaction = this.getReaction();
        if (reaction != null) {
            reaction.setDrawingObjects(this.getDrawingObjects());
        }
        return reaction;
    }

    public void setReaction(Reaction reaction) {
        int n;
        this.mMol.clear();
        this.mFragment = new StereoMolecule[reaction.getMolecules()];
        this.mReactantCount = reaction.getReactants();
        for (n = 0; n < reaction.getMolecules(); ++n) {
            this.mFragment[n] = reaction.getMolecule(n);
            this.mMol.addMolecule(this.mFragment[n]);
        }
        this.mMol.setFragment(reaction.isFragment());
        this.storeState();
        this.mFragmentNo = new int[this.mMol.getAllAtoms()];
        n = 0;
        for (int i = 0; i < this.mFragment.length; ++i) {
            for (int j = 0; j < this.mFragment[i].getAllAtoms(); ++j) {
                this.mFragmentNo[n++] = i;
            }
        }
        this.fireEvent(new EditorEvent(this, 1, false));
        this.mMode = 5;
        this.update(5);
    }

    public MarkushStructure getMarkushStructure() {
        if ((this.mMode & 2) == 0) {
            return null;
        }
        MarkushStructure markushStructure = new MarkushStructure();
        for (int i = 0; i < this.mFragment.length; ++i) {
            if (i < this.mReactantCount) {
                markushStructure.addCore(this.mFragment[i]);
                continue;
            }
            markushStructure.addRGroup(this.mFragment[i]);
        }
        return markushStructure;
    }

    public void setMarkushStructure(MarkushStructure markushStructure) {
        int n;
        this.mMol.clear();
        this.mFragment = new StereoMolecule[markushStructure.getCoreCount() + markushStructure.getRGroupCount()];
        this.mReactantCount = markushStructure.getCoreCount();
        boolean bl = false;
        for (n = 0; n < markushStructure.getCoreCount() + markushStructure.getRGroupCount(); ++n) {
            this.mFragment[n] = n < markushStructure.getCoreCount() ? markushStructure.getCoreStructure(n) : markushStructure.getRGroup(n - markushStructure.getCoreCount());
            bl |= this.mFragment[n].isFragment();
            this.mMol.addMolecule(this.mFragment[n]);
        }
        this.mMol.setFragment(bl);
        this.storeState();
        this.mFragmentNo = new int[this.mMol.getAllAtoms()];
        n = 0;
        for (int i = 0; i < this.mFragment.length; ++i) {
            for (int j = 0; j < this.mFragment[i].getAllAtoms(); ++j) {
                this.mFragmentNo[n++] = i;
            }
        }
        this.fireEvent(new EditorEvent(this, 1, false));
        this.mMode = 3;
        this.update(5);
    }

    public int getDisplayMode() {
        return this.mDisplayMode;
    }

    public void setDisplayMode(int n) {
        this.mDisplayMode = n;
        this.update(1);
    }

    public void setAllowQueryFeatures(boolean bl) {
        if (this.mAllowQueryFeatures != bl) {
            this.mAllowQueryFeatures = bl;
            if (!bl) {
                this.mMol.removeQueryFeatures();
            }
        }
    }

    public void setAtomText(String[] stringArray) {
        this.mAtomText = stringArray;
    }

    public DrawingObjectList getDrawingObjects() {
        return this.mDrawingObjectList;
    }

    public void setDrawingObjects(DrawingObjectList drawingObjectList) {
        this.mDrawingObjectList = drawingObjectList;
        this.storeState();
        this.update(4);
    }

    public int getMode() {
        return this.mMode;
    }

    public int getHiliteAtom() {
        return this.mCurrentHiliteAtom;
    }

    public int getHiliteBond() {
        return this.mCurrentHiliteBond;
    }

    public void setHiliteBondSet(int[] nArray) {
        this.mHiliteBondSet = nArray;
        this.update(1);
    }

    public void setReactionMode(boolean bl) {
        if (bl) {
            StereoMolecule[] stereoMoleculeArray = this.getFragments();
            if (stereoMoleculeArray == null) {
                this.setReaction(new Reaction(new StereoMolecule[]{new StereoMolecule(this.getMolecule())}, 1));
            } else {
                this.mMode = 5;
                Reaction reaction = this.getReaction();
                this.setReaction(reaction);
            }
        } else {
            this.mMode &= 0xFFFFFFFB;
        }
    }

    protected void setUpdateMode(int n) {
        this.mUpdateMode = n;
    }

    public boolean isAtomColorSupported() {
        return this.mAtomColorSupported;
    }

    public void setAtomColorSupported(boolean bl) {
        this.mAtomColorSupported = bl;
    }

    private void cleanupCoordinates(SwingDrawContext swingDrawContext, Graphics2D graphics2D) {
        int n;
        int n2 = 0;
        for (n = 0; n < this.mMol.getAllAtoms(); n += 1) {
            if (!this.mMol.isSelectedAtom(n)) continue;
            ++n2;
        }
        int n3 = n = n2 != 0 && n2 != this.mMol.getAllAtoms() ? 1 : 0;
        if ((this.mMode & 1) != 0) {
            this.cleanupMultiFragmentCoordinates(graphics2D, n != 0);
        } else {
            this.cleanupMoleculeCoordinates(swingDrawContext, n != 0);
        }
    }

    private void cleanupMoleculeCoordinates(SwingDrawContext swingDrawContext, boolean bl) {
        if (this.mUpdateMode == 6) {
            if (bl) {
                for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                    this.mMol.setAtomMarker(i, !this.mMol.isSelectedAtom(i));
                }
            }
            new CoordinateInventor(bl ? 4 : 0).invent(this.mMol);
            if (bl) {
                this.mMol.removeAtomMarkers();
            }
        }
        this.mDepictor.updateCoords(swingDrawContext, new GenericRectangle(0.0, 0.0, this.getWidth(), this.getHeight()), this.maxUpdateMode());
    }

    private void cleanupMultiFragmentCoordinates(Graphics2D graphics2D, boolean bl) {
        int n;
        Object[] objectArray;
        if (bl && this.mUpdateMode == 6) {
            objectArray = new int[this.mFragment.length];
            for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
                int n2 = this.mFragmentNo[n];
                this.mFragment[n2].setAtomMarker((int)objectArray[n2], !this.mMol.isSelectedAtom(n));
                int n3 = n2;
                objectArray[n3] = objectArray[n3] + true;
            }
        }
        objectArray = new GenericRectangle[this.mFragment.length];
        for (n = 0; n < this.mFragment.length; ++n) {
            if (this.mUpdateMode == 6) {
                new CoordinateInventor(bl ? 4 : 0).invent(this.mFragment[n]);
                this.mFragment[n].setStereoBondsFromParity();
            }
            Depictor2D depictor2D = new Depictor2D(this.mFragment[n]);
            depictor2D.updateCoords(graphics2D, null, 65536);
            objectArray[n] = depictor2D.getBoundingRect();
        }
        double d = 36.0;
        double d2 = this.mMol.getAverageBondLength();
        double d3 = (this.mMode & 4) == 0 ? 0.0 : (this.mUpdateMode == 5 ? (double)(0.08f * (float)this.getWidth()) : (double)(((ReactionArrow)this.mDrawingObjectList.get(0)).getLength() * 24.0f) / d2);
        double d4 = 0.5 * d;
        for (int i = 0; i <= this.mFragment.length; ++i) {
            if ((this.mMode & 4) != 0 && i == this.mReactantCount) {
                ((ReactionArrow)this.mDrawingObjectList.get(0)).setCoordinates(d4 - d / 2.0, this.getHeight() / 2, d4 - d / 2.0 + d3, this.getHeight() / 2);
                d4 += d3;
            }
            if (i == this.mFragment.length) break;
            double d5 = d4 - objectArray[i].x;
            double d6 = 0.5 * ((double)this.getHeight() - objectArray[i].height) - objectArray[i].y;
            this.mFragment[i].translateCoords(d5, d6);
            d4 += d + objectArray[i].width;
        }
        this.mDepictor.updateCoords(new SwingDrawContext(graphics2D), new GenericRectangle(0.0, 0.0, this.getWidth(), this.getHeight()), this.maxUpdateMode());
        int[] nArray = new int[this.mFragment.length];
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            int n4 = this.mFragmentNo[i];
            this.mMol.setAtomX(i, this.mFragment[n4].getAtomX(nArray[n4]));
            this.mMol.setAtomY(i, this.mFragment[n4].getAtomY(nArray[n4]));
            int n5 = n4;
            nArray[n5] = nArray[n5] + 1;
        }
        this.mMol.setStereoBondsFromParity();
    }

    private void analyzeFragmentMembership() {
        this.mMol.ensureHelperArrays(15);
        int[] nArray = new int[this.mMol.getAllAtoms()];
        int n = this.mMol.getFragmentNumbers(nArray, false, true);
        n = this.joinCloseFragments(nArray, n);
        this.sortFragmentsByPosition(nArray, n);
        this.mFragmentNo = nArray;
        this.mFragment = this.mMol.getFragments(nArray, n);
    }

    private int joinCloseFragments(int[] nArray, int n) {
        int n2;
        int n3;
        int n4;
        if (n < 2) {
            return n;
        }
        boolean[][] blArrayArray = new boolean[n][];
        for (int i = 1; i < n; ++i) {
            blArrayArray[i] = new boolean[i];
        }
        double d = this.mMol.getAverageBondLength();
        for (int i = 1; i < this.mMol.getAllAtoms(); ++i) {
            for (n4 = 0; n4 < i; ++n4) {
                int n5;
                double d2;
                double d3 = this.mMol.getAtomX(n4) - this.mMol.getAtomX(i);
                double d4 = Math.sqrt(d3 * d3 + (d2 = this.mMol.getAtomY(n4) - this.mMol.getAtomY(i)) * d2);
                if (!(d4 < (double)1.4f * d) || (n3 = nArray[i]) == (n5 = nArray[n4])) continue;
                if (n3 > n5) {
                    blArrayArray[n3][n5] = true;
                    continue;
                }
                blArrayArray[n5][n3] = true;
            }
        }
        int[] nArray2 = new int[n];
        for (n4 = 0; n4 < n; ++n4) {
            nArray2[n4] = n4;
        }
        n4 = 0;
        for (n2 = 1; n2 < n; ++n2) {
            for (int i = 0; i < n2; ++i) {
                int n6;
                int n7;
                if (!blArrayArray[n2][i] || (n7 = nArray2[n2]) == (n6 = nArray2[i])) continue;
                ++n4;
                int n8 = Math.min(n7, n6);
                int n9 = Math.max(n7, n6);
                for (n3 = 0; n3 < n; ++n3) {
                    if (nArray2[n3] == n9) {
                        nArray2[n3] = n8;
                        continue;
                    }
                    if (nArray2[n3] <= n9) continue;
                    int n10 = n3;
                    nArray2[n10] = nArray2[n10] - 1;
                }
            }
        }
        for (n2 = 0; n2 < this.mMol.getAllAtoms(); ++n2) {
            nArray[n2] = nArray2[nArray[n2]];
        }
        return n - n4;
    }

    private void sortFragmentsByPosition(int[] nArray, int n) {
        int n2;
        Point[] pointArray;
        int[][] nArray2 = new int[n][(this.mMode & 6) != 0 ? 2 : 1];
        for (int i = 0; i < n; ++i) {
            nArray2[i][0] = i;
        }
        Point[] pointArray2 = this.calculateFragmentCenterOfGravity(nArray, n);
        if ((this.mMode & 4) != 0) {
            this.mReactantCount = 0;
            pointArray = (this.mMode & 4) != 0 ? (ReactionArrow)this.mDrawingObjectList.get(0) : null;
            for (int i = 0; i < n; ++i) {
                int n3 = nArray2[i][1] = pointArray.isOnProductSide(pointArray2[i].x, pointArray2[i].y) ? 1 : 0;
                if (nArray2[i][1] != 0) continue;
                ++this.mReactantCount;
            }
        } else if ((this.mMode & 2) != 0) {
            this.mReactantCount = n;
            for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                if (this.mMol.getAtomicNo(i) != 0 || nArray2[nArray[i]][1] != 0) continue;
                nArray2[nArray[i]][1] = 1;
                --this.mReactantCount;
            }
        }
        pointArray = pointArray2;
        Arrays.sort(nArray2, new Comparator<int[]>(){

            @Override
            public int compare(int[] nArray, int[] nArray2) {
                if ((JDrawArea.this.mMode & 6) != 0 && nArray[1] != nArray2[1]) {
                    return nArray[1] == 0 ? -1 : 1;
                }
                return pointArray[nArray[0]].x + pointArray[nArray[0]].y < pointArray[nArray2[0]].x + pointArray[nArray2[0]].y ? -1 : 1;
            }
        });
        int[] nArray3 = new int[n];
        Point[] pointArray3 = new Point[n];
        for (n2 = 0; n2 < n; ++n2) {
            int n4 = nArray2[n2][0];
            nArray3[n4] = n2;
            pointArray3[n2] = pointArray2[n4];
        }
        pointArray2 = pointArray3;
        for (n2 = 0; n2 < this.mMol.getAllAtoms(); ++n2) {
            nArray[n2] = nArray3[nArray[n2]];
        }
    }

    private Point[] calculateFragmentCenterOfGravity(int[] nArray, int n) {
        int n2;
        Point[] pointArray = new Point[n];
        int[] nArray2 = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            pointArray[n2] = new Point(0, 0);
        }
        for (n2 = 0; n2 < this.mMol.getAllAtoms(); ++n2) {
            pointArray[nArray[n2]].x = (int)((double)pointArray[nArray[n2]].x + this.mMol.getAtomX(n2));
            pointArray[nArray[n2]].y = (int)((double)pointArray[nArray[n2]].y + this.mMol.getAtomY(n2));
            int n3 = nArray[n2];
            nArray2[n3] = nArray2[n3] + 1;
        }
        for (n2 = 0; n2 < n; ++n2) {
            pointArray[n2].x /= nArray2[n2];
            pointArray[n2].y /= nArray2[n2];
        }
        return pointArray;
    }

    private void updateCursor() {
        int n = -1;
        switch (this.mCurrentTool) {
            case 18: {
                n = 9;
                break;
            }
            case 2: {
                if (this.mCurrentHiliteAtom != -1 && this.mMol.isSelectedAtom(this.mCurrentHiliteAtom) || this.mCurrentHiliteBond != -1 && this.mMol.isSelectedBond(this.mCurrentHiliteBond)) {
                    n = this.mMouseIsDown ? 4 : (this.mShiftIsDown ? 3 : 2);
                    break;
                }
                if (this.mCurrentHiliteAtom != -1 || this.mCurrentHiliteBond != -1) {
                    n = 11;
                    break;
                }
                if (this.mCurrentHiliteObject != null) {
                    n = this.mMouseIsDown ? 4 : (this.mShiftIsDown && !(this.mCurrentHiliteObject instanceof ReactionArrow) ? 3 : 2);
                    break;
                }
                n = this.mShiftIsDown ? (this.mAltIsDown ? 8 : 6) : (this.mAltIsDown ? 7 : 5);
                break;
            }
            case 4: {
                n = 1;
                break;
            }
            case 22: {
                n = 0;
                break;
            }
            case 21: {
                n = 12;
                break;
            }
            default: {
                n = 11;
            }
        }
        if (this.mCurrentCursor != n) {
            this.mCurrentCursor = n;
            this.setCursor(SwingCursorHelper.getCursor(n));
        }
    }

    private void initializeDragAndDrop(int n) {
        if (n != 0) {
            MoleculeDropAdapter moleculeDropAdapter = new MoleculeDropAdapter(){

                @Override
                public void onDropMolecule(StereoMolecule stereoMolecule, Point point) {
                    if (stereoMolecule != null && stereoMolecule.getAllAtoms() != 0) {
                        for (int i = 0; i < JDrawArea.this.mMol.getAllAtoms(); ++i) {
                            JDrawArea.this.mMol.setAtomSelection(i, false);
                        }
                        double d = JDrawArea.this.mMol.getAverageBondLength();
                        double d2 = stereoMolecule.getAverageBondLength();
                        stereoMolecule.scaleCoords(d / d2);
                        Point point2 = new Point();
                        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
                            stereoMolecule.setAtomSelection(i, true);
                            point2.x = (int)((double)point2.x + stereoMolecule.getAtomX(i));
                            point2.y = (int)((double)point2.y + stereoMolecule.getAtomY(i));
                        }
                        point2.x /= stereoMolecule.getAllAtoms();
                        point2.y /= stereoMolecule.getAllAtoms();
                        stereoMolecule.translateCoords(point.x - point2.x, point.y - point2.y);
                        stereoMolecule.removeAtomColors();
                        stereoMolecule.removeBondHiliting();
                        JDrawArea.this.mMol.addMolecule(stereoMolecule);
                        JDrawArea.this.fireMoleculeChanged();
                        JDrawArea.this.update(3);
                    }
                }
            };
            new DropTarget(this, n, moleculeDropAdapter, true, new OurFlavorMap());
        }
    }

    private int maxUpdateMode() {
        return 65536 + HiDPIHelper.scale(24.0f);
    }

    private Point2D calculateCenterOfGravity(boolean bl) {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            if (bl && !this.mMol.isSelectedAtom(i)) continue;
            d += this.mMol.getAtomX(i);
            d2 += this.mMol.getAtomY(i);
            ++n;
        }
        return n > 1 ? new Point2D.Double(d / (double)n, d2 / (double)n) : null;
    }

    private void flip(boolean bl) {
        Point2D point2D;
        boolean bl2 = false;
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            if (!this.mMol.isSelectedAtom(i)) continue;
            bl2 = true;
            break;
        }
        if ((point2D = this.calculateCenterOfGravity(bl2)) != null) {
            int n;
            this.storeState();
            for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
                if (bl2 && !this.mMol.isSelectedAtom(n)) continue;
                if (bl) {
                    this.mMol.setAtomX(n, 2.0 * point2D.getX() - this.mMol.getAtomX(n));
                    continue;
                }
                this.mMol.setAtomY(n, 2.0 * point2D.getY() - this.mMol.getAtomY(n));
            }
            for (n = 0; n < this.mMol.getAllBonds(); ++n) {
                if (bl2 && !this.mMol.isSelectedBond(n)) continue;
                if (this.mMol.getBondType(n) == 257) {
                    this.mMol.setBondType(n, 129);
                    continue;
                }
                if (this.mMol.getBondType(n) != 129) continue;
                this.mMol.setBondType(n, 257);
            }
            this.update(1);
        }
    }

    static class OurFlavorMap
    implements FlavorMap {
        OurFlavorMap() {
        }

        @Override
        public Map<DataFlavor, String> getNativesForFlavors(DataFlavor[] dataFlavorArray) {
            FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
            return flavorMap.getNativesForFlavors(dataFlavorArray);
        }

        @Override
        public Map<String, DataFlavor> getFlavorsForNatives(String[] stringArray) {
            FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
            return flavorMap.getFlavorsForNatives(stringArray);
        }
    }
}

