/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction.mapping;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionEncoder;
import com.actelion.research.chem.reaction.mapping.ChemicalRuleBond;
import com.actelion.research.util.SortedList;
import java.util.Arrays;

public class ChemicalRule {
    private String mName;
    private String mIDCode;
    private float mPanalty;
    private StereoMolecule mReactant;
    private StereoMolecule mProduct;
    private ChemicalRuleBond[] mRuleBonds;
    private int[] mInvertedTHParity;
    private int[] mReactantAtomSymmetryConstraint;

    public ChemicalRule(String string, String string2, float f) {
        this.mName = string;
        this.mIDCode = string2;
        this.mPanalty = f;
    }

    public void initialize() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Reaction reaction = ReactionEncoder.decode(this.mIDCode, false);
        this.mReactant = reaction.getReactant(0);
        this.mProduct = reaction.getProduct(0);
        this.mReactant.ensureHelperArrays(1);
        this.mProduct.ensureHelperArrays(63);
        SortedList<ChemicalRuleBond> sortedList = new SortedList<ChemicalRuleBond>();
        int[] nArray = new int[this.mReactant.getAtoms() + 1];
        nArray[0] = -1;
        for (int i = 0; i < this.mReactant.getAtoms(); ++i) {
            nArray[this.mReactant.getAtomMapNo((int)i)] = i;
        }
        this.calculateReactantAtomSymmetryConstraints(nArray);
        boolean[] blArray = new boolean[this.mReactant.getBonds()];
        for (n5 = 0; n5 < this.mProduct.getBonds(); ++n5) {
            int n6;
            n4 = this.mProduct.getAtomMapNo(this.mProduct.getBondAtom(0, n5));
            n3 = this.mProduct.getAtomMapNo(this.mProduct.getBondAtom(1, n5));
            if (n4 == 0 || n3 == 0) continue;
            n2 = nArray[n4];
            n = nArray[n3];
            int n7 = this.mProduct.getBondTypeSimple(n5);
            int n8 = this.mReactant.getBond(n2, n);
            if (n8 == -1) {
                sortedList.add(new ChemicalRuleBond(n2, n, n4, n3, n7));
                continue;
            }
            if ((this.mReactant.getBondQueryFeatures(n8) & 0x1F) == 0 && (n6 = this.mReactant.getBondTypeSimple(n8)) != n7) {
                sortedList.add(new ChemicalRuleBond(n2, n, n4, n3, n7));
            }
            blArray[n8] = true;
        }
        for (n5 = 0; n5 < this.mReactant.getBonds(); ++n5) {
            if (blArray[n5]) continue;
            n4 = this.mReactant.getBondAtom(0, n5);
            n3 = this.mReactant.getBondAtom(1, n5);
            n2 = this.mReactant.getAtomMapNo(n4);
            n = this.mReactant.getAtomMapNo(n3);
            if (n2 == 0 || n == 0) continue;
            sortedList.add(new ChemicalRuleBond(n4, n3, n2, n, -1));
        }
        this.mRuleBonds = sortedList.toArray(new ChemicalRuleBond[0]);
        this.mInvertedTHParity = new int[0];
        for (n5 = 0; n5 < this.mProduct.getAtoms(); ++n5) {
            n4 = this.mProduct.getAtomParity(n5);
            if (n4 != 1 && n4 != 2 || (n3 = nArray[this.mProduct.getAtomMapNo(n5)]) == -1) continue;
            n2 = this.mReactant.getAtomParity(n3);
            if (this.isTHParityInversion(n5, nArray) != (n2 == n4)) continue;
            this.addInvertedParityAtom(n3);
        }
    }

    private boolean isTHParityInversion(int n, int[] nArray) {
        boolean bl = false;
        if (this.mReactant.getAtomPi(n) == 0) {
            for (int i = 1; i < this.mReactant.getConnAtoms(n); ++i) {
                for (int j = 0; j < i; ++j) {
                    int n2;
                    int n3 = this.mReactant.getConnAtom(n, i);
                    int n4 = this.mReactant.getConnAtom(n, j);
                    int n5 = this.mReactant.getAtomMapNo(n3);
                    if (!(nArray[n5] > nArray[n2 = this.mReactant.getAtomMapNo(n4)] ^ n3 > n4)) continue;
                    bl = !bl;
                }
            }
        }
        return bl;
    }

    private void addInvertedParityAtom(int n) {
        this.mInvertedTHParity = Arrays.copyOf(this.mInvertedTHParity, this.mInvertedTHParity.length + 1);
        this.mInvertedTHParity[this.mInvertedTHParity.length - 1] = n;
    }

    public void apply(StereoMolecule stereoMolecule, int[] nArray) {
        int n;
        int n2;
        stereoMolecule.ensureHelperArrays(1);
        for (ChemicalRuleBond chemicalRuleBond : this.mRuleBonds) {
            n2 = nArray[chemicalRuleBond.atom1];
            n = nArray[chemicalRuleBond.atom2];
            int n3 = stereoMolecule.getBond(n2, n);
            if (n3 == -1) {
                stereoMolecule.addBond(n2, n, chemicalRuleBond.newBondType);
                continue;
            }
            if (chemicalRuleBond.newBondType == -1) {
                stereoMolecule.markBondForDeletion(n3);
                continue;
            }
            if (chemicalRuleBond.newBondType == -2) continue;
            stereoMolecule.setBondType(n3, chemicalRuleBond.newBondType);
        }
        stereoMolecule.deleteMarkedAtomsAndBonds();
        if (this.mInvertedTHParity.length != 0) {
            stereoMolecule.ensureHelperArrays(1);
            for (int n4 : this.mInvertedTHParity) {
                n = stereoMolecule.getAtomParity(n2 = nArray[n4]);
                stereoMolecule.setAtomParity(n2, n == 1 ? 2 : 1, false);
                stereoMolecule.setStereoBondFromAtomParity(n2);
            }
        }
    }

    public StereoMolecule getReactant() {
        return this.mReactant;
    }

    public StereoMolecule getProduct() {
        return this.mProduct;
    }

    public String getName() {
        return this.mName;
    }

    public float getPanalty() {
        return this.mPanalty;
    }

    private void calculateReactantAtomSymmetryConstraints(int[] nArray) {
        this.mReactantAtomSymmetryConstraint = new int[this.mReactant.getAtoms()];
        for (int i = 0; i < this.mProduct.getAtoms(); ++i) {
            this.mReactantAtomSymmetryConstraint[nArray[this.mProduct.getAtomMapNo((int)i)]] = this.mProduct.getSymmetryRank(i);
        }
        int[] nArray2 = new int[this.mReactant.getAllAtoms()];
        int n = this.mReactant.getFragmentNumbers(nArray2, false, false);
        if (n > 1) {
            int[] nArray3 = new int[n];
            for (int i = 0; i < this.mReactant.getAtoms(); ++i) {
                int n2 = i;
                int n3 = nArray2[i];
                int n4 = nArray3[n3];
                nArray3[n3] = n4 + 1;
                this.mReactantAtomSymmetryConstraint[n2] = this.mReactantAtomSymmetryConstraint[n2] | n4 << 5;
            }
        }
    }

    public int[] getReactantAtomSymmetryConstraints() {
        return this.mReactantAtomSymmetryConstraint;
    }
}

