/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionEncoder;
import java.util.ArrayList;
import java.util.Arrays;

public class SRSearcher {
    private StereoMolecule mQueryReactantBuffer;
    private StereoMolecule mQueryProductBuffer;
    private StereoMolecule mReactantBuffer;
    private StereoMolecule mProductBuffer;
    private StereoMolecule mQueryReactant;
    private StereoMolecule mQueryProduct;
    private StereoMolecule mReactant;
    private StereoMolecule mProduct;
    private SSSearcher mReactantSearcher = new SSSearcher(){

        @Override
        public boolean areAtomsSimilar(int n, int n2) {
            return super.areAtomsSimilar(n, n2) && SRSearcher.this.productAtomMatches(n, n2);
        }

        @Override
        public boolean areBondsSimilar(int n, int n2) {
            return super.areBondsSimilar(n, n2) && SRSearcher.this.productBondMatches(n, n2);
        }
    };
    private SSSearcher mProductSearcher = new SSSearcher(){

        @Override
        public boolean areAtomsSimilar(int n, int n2) {
            return (SRSearcher.this.mProductMatch == null || SRSearcher.this.mProductMatch[n2] == -1 || SRSearcher.this.mProductMatch[n2] == n) && super.areAtomsSimilar(n, n2);
        }
    };
    private boolean mQueryIsPreprocessed;
    private boolean mReactionIsPreprocessed;
    private int mQueryMaxMapNo;
    private int mMaxMapNo;
    private byte[] mQueryCode;
    private byte[] mQueryCoords;
    private byte[] mQueryMapping;
    private byte[] mReactionCode;
    private byte[] mReactionCoords;
    private byte[] mReactionMapping;
    private long[] mQueryReactantFFP;
    private long[] mQueryProductFFP;
    private long[] mReactantFFP;
    private long[] mProductFFP;
    private int[] mQueryReactantToProductAtom;
    private int[] mQueryReactantToProductBond;
    private int[] mReactantToProductAtom;
    private int[] mReactantToProductBond;
    private int[] mProductMatch;
    private int[] mQueryNeighborDelta;
    private int[] mNeighborDelta;

    public void setQuery(byte[] byArray, byte[] byArray2, byte[] byArray3, long[] lArray, long[] lArray2) {
        this.mQueryCode = byArray;
        this.mQueryMapping = byArray2;
        this.mQueryCoords = byArray3;
        this.mQueryIsPreprocessed = false;
        this.mQueryReactant = null;
        this.mQueryReactantFFP = lArray;
        this.mQueryProduct = null;
        this.mQueryProductFFP = lArray2;
    }

    public void setReaction(byte[] byArray, byte[] byArray2, byte[] byArray3, long[] lArray, long[] lArray2) {
        this.mReactionCode = byArray;
        this.mReactionMapping = byArray2;
        this.mReactionCoords = byArray3;
        this.mReactionIsPreprocessed = false;
        this.mReactant = null;
        this.mReactantFFP = lArray;
        this.mProduct = null;
        this.mProductFFP = lArray2;
    }

    public void setQuery(Reaction reaction, long[] lArray, long[] lArray2) {
        this.mQueryCode = null;
        this.mQueryReactantFFP = lArray;
        this.mQueryProductFFP = lArray2;
        this.mQueryIsPreprocessed = false;
        if (reaction == null || reaction.getReactants() == 0 || reaction.getProducts() == 0) {
            this.mQueryReactant = null;
            this.mQueryProduct = null;
            return;
        }
        this.splitQuery(reaction);
    }

    public void setReaction(Reaction reaction, long[] lArray, long[] lArray2) {
        this.mReactionCode = null;
        this.mReactantFFP = lArray;
        this.mProductFFP = lArray2;
        this.mReactionIsPreprocessed = false;
        if (reaction == null || reaction.getReactants() == 0 || reaction.getProducts() == 0) {
            this.mReactant = null;
            this.mProduct = null;
            return;
        }
        this.splitReaction(reaction);
    }

    public void setQuery(Reaction reaction) {
        this.mQueryCode = null;
        this.mQueryReactantFFP = null;
        this.mQueryProductFFP = null;
        this.mQueryIsPreprocessed = false;
        if (reaction == null || reaction.getReactants() == 0 || reaction.getProducts() == 0) {
            this.mQueryReactant = null;
            this.mQueryProduct = null;
            return;
        }
        this.splitQuery(reaction);
    }

    public void setReaction(Reaction reaction) {
        this.mReactionCode = null;
        this.mReactantFFP = null;
        this.mProductFFP = null;
        this.mReactionIsPreprocessed = false;
        if (reaction == null || reaction.getReactants() == 0 || reaction.getProducts() == 0) {
            this.mReactant = null;
            this.mProduct = null;
            return;
        }
        this.splitReaction(reaction);
    }

    public void stop() {
        this.mReactantSearcher.stop();
        this.mProductSearcher.stop();
    }

    private void preprocessQuery() {
        if (!this.mQueryIsPreprocessed) {
            this.mQueryMaxMapNo = this.getHighestMapNo(this.mQueryReactant, this.mQueryProduct);
            this.mReactantSearcher.setFragment(this.mQueryReactant);
            this.mProductSearcher.setFragment(this.mQueryProduct);
            if (this.mQueryReactant != null && this.mQueryProduct != null) {
                this.mQueryReactantToProductAtom = this.createReactantToProductAtomMap(this.mQueryReactant, this.mQueryProduct, this.mQueryMaxMapNo);
                this.mQueryReactantToProductBond = this.createReactantToProductBondMap(this.mQueryReactant, this.mQueryProduct, this.mQueryReactantToProductAtom);
                this.mQueryNeighborDelta = this.createMappedAtomNeighborDeltas(this.mQueryReactant, this.mQueryProduct, this.mQueryReactantToProductAtom);
            }
            this.mQueryIsPreprocessed = true;
        }
    }

    private void preprocessReaction() {
        if (!this.mReactionIsPreprocessed) {
            this.mMaxMapNo = this.getHighestMapNo(this.mReactant, this.mProduct);
            this.mReactantSearcher.setMolecule(this.mReactant);
            this.mProductSearcher.setMolecule(this.mProduct);
            if (this.mReactant != null && this.mProduct != null) {
                this.mReactantToProductAtom = this.createReactantToProductAtomMap(this.mReactant, this.mProduct, this.mMaxMapNo);
                this.mReactantToProductBond = this.createReactantToProductBondMap(this.mReactant, this.mProduct, this.mReactantToProductAtom);
                this.mNeighborDelta = this.createMappedAtomNeighborDeltas(this.mReactant, this.mProduct, this.mReactantToProductAtom);
            }
            this.mReactionIsPreprocessed = true;
        }
    }

    private int getHighestMapNo(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
        int n;
        int n2 = 0;
        for (n = 0; n < stereoMolecule.getAllAtoms(); ++n) {
            n2 = Math.max(n2, stereoMolecule.getAtomMapNo(n));
        }
        for (n = 0; n < stereoMolecule2.getAllAtoms(); ++n) {
            n2 = Math.max(n2, stereoMolecule2.getAtomMapNo(n));
        }
        return n2;
    }

    public boolean isQueryInReaction() {
        return this.isQueryInReaction(8);
    }

    public boolean isQueryInReaction(int n) {
        int n2;
        if (this.mQueryReactantFFP != null && this.mQueryProductFFP != null && this.mReactantFFP != null && this.mProductFFP != null) {
            for (n2 = 0; n2 < this.mReactantFFP.length; ++n2) {
                if ((this.mQueryReactantFFP[n2] & (this.mReactantFFP[n2] ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
                return false;
            }
            for (n2 = 0; n2 < this.mProductFFP.length; ++n2) {
                if ((this.mQueryProductFFP[n2] & (this.mProductFFP[n2] ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
                return false;
            }
        }
        if (this.mQueryReactant == null && this.mQueryProduct == null) {
            this.splitQuery(ReactionEncoder.decode(this.mQueryCode, this.mQueryMapping, this.mQueryCoords, null, null, false));
        }
        if (this.mReactant == null && this.mProduct == null) {
            this.splitReaction(ReactionEncoder.decode(this.mReactionCode, this.mReactionMapping, this.mReactionCoords, null, null, false));
        }
        if (this.mQueryReactant == null || this.mQueryProduct == null || this.mReactant == null || this.mProduct == null) {
            return false;
        }
        this.preprocessQuery();
        this.preprocessReaction();
        this.mProductMatch = null;
        this.mProductSearcher.setupAtomAndBondFeatures(n);
        n2 = this.mReactantSearcher.findFragmentInMolecule(5, n);
        if (n2 == 0) {
            return false;
        }
        this.mProductMatch = new int[this.mQueryProduct.getAllAtoms()];
        ArrayList<int[]> arrayList = this.mReactantSearcher.getMatchList();
        for (int[] nArray : arrayList) {
            Arrays.fill(this.mProductMatch, -1);
            for (int i = 0; i < nArray.length; ++i) {
                if (this.mQueryReactantToProductAtom[i] == -1) continue;
                this.mProductMatch[this.mQueryReactantToProductAtom[i]] = this.mReactantToProductAtom[nArray[i]];
            }
            if (!this.mProductSearcher.isFragmentInMolecule()) continue;
            return true;
        }
        return false;
    }

    private void splitQuery(Reaction reaction) {
        int n;
        if (reaction == null) {
            this.mQueryReactant = null;
            this.mQueryProduct = null;
            return;
        }
        if (reaction.getReactants() == 1) {
            this.mQueryReactant = reaction.getReactant(0);
        } else if (reaction.getReactants() > 1) {
            if (this.mQueryReactantBuffer == null) {
                this.mQueryReactantBuffer = new StereoMolecule();
            }
            this.mQueryReactant = this.mQueryReactantBuffer;
            reaction.getReactant(0).copyMolecule(this.mQueryReactant);
            for (n = 1; n < reaction.getReactants(); ++n) {
                this.mQueryReactant.addMolecule(reaction.getReactant(n));
            }
        }
        if (reaction.getProducts() == 1) {
            this.mQueryProduct = reaction.getProduct(0);
        } else {
            if (this.mQueryProductBuffer == null) {
                this.mQueryProductBuffer = new StereoMolecule();
            }
            this.mQueryProduct = this.mQueryProductBuffer;
            reaction.getProduct(0).copyMolecule(this.mQueryProduct);
            for (n = 1; n < reaction.getProducts(); ++n) {
                this.mQueryProduct.addMolecule(reaction.getProduct(n));
            }
        }
        this.mQueryReactant.setFragment(true);
        this.mQueryProduct.setFragment(true);
    }

    private void splitReaction(Reaction reaction) {
        int n;
        if (reaction == null) {
            this.mReactant = null;
            this.mProduct = null;
            return;
        }
        if (reaction.getReactants() == 1) {
            this.mReactant = reaction.getReactant(0);
        } else if (reaction.getReactants() > 1) {
            if (this.mReactantBuffer == null) {
                this.mReactantBuffer = new StereoMolecule();
            }
            this.mReactant = this.mReactantBuffer;
            reaction.getReactant(0).copyMolecule(this.mReactant);
            for (n = 1; n < reaction.getReactants(); ++n) {
                this.mReactant.addMolecule(reaction.getReactant(n));
            }
        }
        if (reaction.getProducts() == 1) {
            this.mProduct = reaction.getProduct(0);
        } else {
            if (this.mProductBuffer == null) {
                this.mProductBuffer = new StereoMolecule();
            }
            this.mProduct = this.mProductBuffer;
            reaction.getProduct(0).copyMolecule(this.mProduct);
            for (n = 1; n < reaction.getProducts(); ++n) {
                this.mProduct.addMolecule(reaction.getProduct(n));
            }
        }
    }

    private int[] createReactantToProductAtomMap(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, int n) {
        int[] nArray = new int[n + 1];
        for (int i = 0; i < stereoMolecule2.getAllAtoms(); ++i) {
            nArray[stereoMolecule2.getAtomMapNo((int)i)] = i;
        }
        int[] nArray2 = new int[stereoMolecule.getAllAtoms()];
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            int n2 = stereoMolecule.getAtomMapNo(i);
            nArray2[i] = n2 != 0 ? nArray[n2] : -1;
        }
        return nArray2;
    }

    private int[] createReactantToProductBondMap(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, int[] nArray) {
        int[] nArray2 = new int[stereoMolecule.getAllBonds()];
        stereoMolecule2.ensureHelperArrays(1);
        for (int i = 0; i < stereoMolecule.getAllBonds(); ++i) {
            int n = nArray[stereoMolecule.getBondAtom(0, i)];
            int n2 = nArray[stereoMolecule.getBondAtom(1, i)];
            nArray2[i] = n != -1 && n2 != -1 ? stereoMolecule2.getBond(n, n2) : -1;
        }
        return nArray2;
    }

    private int[] createMappedAtomNeighborDeltas(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -1) continue;
            nArray2[i] = this.getNonExcludedNeighbours(stereoMolecule2, nArray[i]) - this.getNonExcludedNeighbours(stereoMolecule, i);
        }
        return nArray2;
    }

    private int getNonExcludedNeighbours(StereoMolecule stereoMolecule, int n) {
        int n2 = 0;
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            if ((stereoMolecule.getAtomQueryFeatures(stereoMolecule.getConnAtom(n, i)) & 0x20000000L) != 0L) continue;
            ++n2;
        }
        return n2;
    }

    private boolean productAtomMatches(int n, int n2) {
        if (this.mQueryReactant.getAtomMapNo(n2) != 0 && this.mReactant.getAtomMapNo(n) == 0) {
            return false;
        }
        if (this.mNeighborDelta[n] != this.mQueryNeighborDelta[n2]) {
            return false;
        }
        int n3 = this.mReactantToProductAtom[n];
        int n4 = this.mQueryReactantToProductAtom[n2];
        if (n3 == -1 || n4 == -1) {
            return true;
        }
        return this.mProductSearcher.areAtomsSimilar(n3, n4);
    }

    private boolean productBondMatches(int n, int n2) {
        int n3 = this.mReactantToProductBond[n];
        int n4 = this.mQueryReactantToProductBond[n2];
        if (n3 == -1 && n4 != -1) {
            return false;
        }
        if (n3 == -1 || n4 == -1) {
            return true;
        }
        return this.mProductSearcher.areBondsSimilar(n3, n4);
    }
}

