/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.AbstractDrawingObject;
import com.actelion.research.chem.DepictorTransformation;
import com.actelion.research.chem.Molecule;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.gui.generic.GenericPolygon;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.util.ColorHelper;

public class ReactionArrow
extends AbstractDrawingObject {
    public static final String TYPE_STRING = "arrow";
    private static final int PART_NONE = 0;
    private static final int PART_ARROW_START = 1;
    private static final int PART_ARROW_END = 2;
    private static final int PART_ARROW = 3;
    int mHiliteStatus;

    public ReactionArrow() {
        this.mPoint = new GenericPoint[2];
        this.mPoint[0] = new GenericPoint();
        this.mPoint[1] = new GenericPoint();
        this.mHiliteStatus = 0;
    }

    public ReactionArrow(String string) {
        this();
        int n;
        int n2 = 0;
        while (n2 != -1 && (n = string.indexOf("=\"", n2)) != -1) {
            String string2;
            String string3 = string.substring(n2 + 1, n);
            n2 = string.indexOf("\"", n + 2);
            String string4 = string2 = n2 == -1 ? string.substring(n + 1) : string.substring(n + 1, n2);
            if (string3.equals("x1")) {
                try {
                    this.mPoint[0].x = Float.parseFloat(string2);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (string3.equals("y1")) {
                try {
                    this.mPoint[0].y = Float.parseFloat(string2);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (string3.equals("x2")) {
                try {
                    this.mPoint[1].x = Float.parseFloat(string2);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!string3.equals("y2")) continue;
            try {
                this.mPoint[1].y = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public String getTypeString() {
        return TYPE_STRING;
    }

    @Override
    public String getDescriptorDetail() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" x1=\"" + this.mPoint[0].x + "\"");
        stringBuilder.append(" y1=\"" + this.mPoint[0].y + "\"");
        stringBuilder.append(" x2=\"" + this.mPoint[1].x + "\"");
        stringBuilder.append(" y2=\"" + this.mPoint[1].y + "\"");
        return stringBuilder.toString();
    }

    @Override
    public AbstractDrawingObject clone() {
        ReactionArrow reactionArrow = new ReactionArrow();
        reactionArrow.mPoint[0].x = this.mPoint[0].x;
        reactionArrow.mPoint[0].y = this.mPoint[0].y;
        reactionArrow.mPoint[1].x = this.mPoint[1].x;
        reactionArrow.mPoint[1].y = this.mPoint[1].y;
        reactionArrow.mIsSelected = this.mIsSelected;
        return reactionArrow;
    }

    public float getLength() {
        int n = (int)(this.mPoint[1].x - this.mPoint[0].x);
        int n2 = (int)(this.mPoint[1].y - this.mPoint[0].y);
        return (float)Math.sqrt(n * n + n2 * n2);
    }

    public void setCoordinates(double d, double d2, double d3, double d4) {
        this.mPoint[0].x = d;
        this.mPoint[0].y = d2;
        this.mPoint[1].x = d3;
        this.mPoint[1].y = d4;
    }

    @Override
    public void translate(double d, double d2) {
        switch (this.mHiliteStatus) {
            case 1: {
                this.mPoint[0].x = this.mTransformationValue1[0] + d - this.mTransformationReferenceX;
                this.mPoint[0].y = this.mTransformationValue2[0] + d2 - this.mTransformationReferenceY;
                break;
            }
            case 2: {
                this.mPoint[1].x = this.mTransformationValue1[1] + d - this.mTransformationReferenceX;
                this.mPoint[1].y = this.mTransformationValue2[1] + d2 - this.mTransformationReferenceY;
                break;
            }
            default: {
                super.translate(d, d2);
            }
        }
    }

    @Override
    public void draw(GenericDrawContext genericDrawContext, DepictorTransformation depictorTransformation) {
        genericDrawContext.setRGB(this.mIsSelected ? ColorHelper.getContrastColor(0xFF0000, genericDrawContext.getBackgroundRGB()) : genericDrawContext.getForegroundRGB());
        double d = depictorTransformation == null ? this.mPoint[0].x : depictorTransformation.transformX(this.mPoint[0].x);
        double d2 = depictorTransformation == null ? this.mPoint[0].y : depictorTransformation.transformY(this.mPoint[0].y);
        double d3 = depictorTransformation == null ? this.mPoint[1].x : depictorTransformation.transformX(this.mPoint[1].x);
        double d4 = depictorTransformation == null ? this.mPoint[1].y : depictorTransformation.transformY(this.mPoint[1].y);
        double d5 = d3 - d;
        double d6 = d4 - d2;
        genericDrawContext.setLineWidth(Math.max(1.0f, 0.02f * (float)Math.sqrt(d5 * d5 + d6 * d6)));
        genericDrawContext.drawLine(d, d2, d3, d4);
        GenericPolygon genericPolygon = new GenericPolygon(4);
        genericPolygon.addPoint(d3 + d5 / 40.0, d4 + d6 / 40.0);
        genericPolygon.addPoint(d3 - d5 / 5.0 + d6 / 10.0, d4 - d6 / 5.0 - d5 / 10.0);
        genericPolygon.addPoint(d3 - d5 / 20.0, d4 - d6 / 20.0);
        genericPolygon.addPoint(d3 - d5 / 5.0 - d6 / 10.0, d4 - d6 / 5.0 + d5 / 10.0);
        genericDrawContext.fillPolygon(genericPolygon);
    }

    @Override
    public void hilite(GenericDrawContext genericDrawContext) {
        genericDrawContext.setRGB(genericDrawContext.getSelectionBackgroundRGB());
        switch (this.mHiliteStatus) {
            case 1: {
                genericDrawContext.fillCircle(this.mPoint[0].x - 8.0, this.mPoint[0].y - 8.0, 16.0);
                break;
            }
            case 2: {
                genericDrawContext.fillCircle(this.mPoint[1].x - 8.0, this.mPoint[1].y - 8.0, 16.0);
                break;
            }
            case 3: {
                double d = this.getLength();
                double d2 = Math.max(d / 8.0, 3.0);
                double d3 = Molecule.getAngle(this.mPoint[0].x, this.mPoint[0].y, this.mPoint[1].x, this.mPoint[1].y);
                double d4 = d2 * Math.cos(d3);
                double d5 = -d2 * Math.sin(d3);
                GenericPolygon genericPolygon = new GenericPolygon(4);
                genericPolygon.addPoint(this.mPoint[0].x + d4, this.mPoint[0].y + d5);
                genericPolygon.addPoint(this.mPoint[1].x + d4, this.mPoint[1].y + d5);
                genericPolygon.addPoint(this.mPoint[1].x - d4, this.mPoint[1].y - d5);
                genericPolygon.addPoint(this.mPoint[0].x - d4, this.mPoint[0].y - d5);
                genericDrawContext.fillPolygon(genericPolygon);
            }
        }
    }

    @Override
    public boolean contains(double d, double d2) {
        return this.findPart(d, d2) != 0;
    }

    @Override
    public boolean checkHiliting(double d, double d2) {
        this.mHiliteStatus = this.findPart(d, d2);
        return this.mHiliteStatus != 0;
    }

    @Override
    public void clearHiliting() {
        this.mHiliteStatus = 0;
    }

    private int findPart(double d, double d2) {
        double d3 = Math.sqrt((this.mPoint[0].x - d) * (this.mPoint[0].x - d) + (this.mPoint[0].y - d2) * (this.mPoint[0].y - d2));
        if (d3 < 8.0) {
            return 1;
        }
        double d4 = Math.sqrt((this.mPoint[1].x - d) * (this.mPoint[1].x - d) + (this.mPoint[1].y - d2) * (this.mPoint[1].y - d2));
        if (d4 < 8.0) {
            return 2;
        }
        double d5 = Math.sqrt((this.mPoint[1].x - this.mPoint[0].x) * (this.mPoint[1].x - this.mPoint[0].x) + (this.mPoint[1].y - this.mPoint[0].y) * (this.mPoint[1].y - this.mPoint[0].y));
        if (d3 + d4 < d5 + 5.0) {
            return 3;
        }
        return 0;
    }

    @Override
    public GenericRectangle getBoundingRect(GenericDrawContext genericDrawContext) {
        double d = this.getLength();
        double d2 = Math.max(d / 8.0, 3.0);
        double d3 = Molecule.getAngle(this.mPoint[0].x, this.mPoint[0].y, this.mPoint[1].x, this.mPoint[1].y);
        double d4 = Math.abs(d2 * Math.cos(d3));
        double d5 = Math.abs(d2 * Math.sin(d3));
        GenericRectangle genericRectangle = new GenericRectangle();
        if (this.mPoint[0].x < this.mPoint[1].x) {
            genericRectangle.x = this.mPoint[0].x - d4;
            genericRectangle.width = this.mPoint[1].x - this.mPoint[0].x + 2.0 * d4;
        } else {
            genericRectangle.x = this.mPoint[1].x - d4;
            genericRectangle.width = this.mPoint[0].x - this.mPoint[1].x + 2.0 * d4;
        }
        if (this.mPoint[0].y < this.mPoint[1].y) {
            genericRectangle.y = this.mPoint[0].y - d5;
            genericRectangle.height = this.mPoint[1].y - this.mPoint[0].y + 2.0 * d5;
        } else {
            genericRectangle.y = this.mPoint[1].y - d5;
            genericRectangle.height = this.mPoint[0].y - this.mPoint[1].y + 2.0 * d5;
        }
        return genericRectangle;
    }

    public boolean isOnProductSide(double d, double d2) {
        double d3 = this.mPoint[1].x - this.mPoint[0].x;
        double d4 = this.mPoint[1].y - this.mPoint[0].y;
        double d5 = (this.mPoint[0].x + this.mPoint[1].x) / 2.0;
        double d6 = (this.mPoint[0].y + this.mPoint[1].y) / 2.0;
        if (d3 == 0.0) {
            return d4 < 0.0 ^ d2 > d6;
        }
        if (d4 == 0.0) {
            return d3 < 0.0 ^ d > d5;
        }
        double d7 = -d3 / d4;
        double d8 = (this.mPoint[0].x + d7 * d7 * d - d7 * d2 + d7 * this.mPoint[0].y) / (1.0 + d7 * d7);
        return d3 < 0.0 ^ d8 > d5;
    }
}

