/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.DrawingObjectList;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericRectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class Reaction
implements Serializable {
    static final long serialVersionUID = 537316094L;
    private ArrayList<StereoMolecule> mReactant = new ArrayList();
    private ArrayList<StereoMolecule> mProduct = new ArrayList();
    private ArrayList<StereoMolecule> mCatalyst = new ArrayList();
    private DrawingObjectList mDrawingObjectList;
    private String mName;
    private int mMaxMapNo = -1;
    private boolean mIsFragment = false;

    public Reaction() {
    }

    public Reaction(String string) {
        this();
        this.mName = string;
    }

    public void clear() {
        this.mReactant.clear();
        this.mProduct.clear();
        this.mCatalyst.clear();
        this.mDrawingObjectList = null;
        this.mMaxMapNo = -1;
    }

    public void removeCatalysts() {
        this.mCatalyst.clear();
    }

    public void removeAtomMapping(boolean bl) {
        for (StereoMolecule stereoMolecule : this.mReactant) {
            stereoMolecule.removeAtomMapping(bl);
        }
        for (StereoMolecule stereoMolecule : this.mProduct) {
            stereoMolecule.removeAtomMapping(bl);
        }
    }

    public void removeDrawingObjects() {
        this.mDrawingObjectList = null;
    }

    public boolean isEmpty() {
        for (StereoMolecule stereoMolecule : this.mReactant) {
            if (stereoMolecule.getAllAtoms() == 0) continue;
            return false;
        }
        for (StereoMolecule stereoMolecule : this.mProduct) {
            if (stereoMolecule.getAllAtoms() == 0) continue;
            return false;
        }
        for (StereoMolecule stereoMolecule : this.mCatalyst) {
            if (stereoMolecule.getAllAtoms() == 0) continue;
            return false;
        }
        return true;
    }

    public void setFragment(boolean bl) {
        this.mIsFragment = bl;
        for (StereoMolecule stereoMolecule : this.mReactant) {
            stereoMolecule.setFragment(bl);
        }
        for (StereoMolecule stereoMolecule : this.mProduct) {
            stereoMolecule.setFragment(bl);
        }
    }

    public boolean isFragment() {
        return this.mIsFragment || this.determineFragment();
    }

    private boolean determineFragment() {
        for (StereoMolecule stereoMolecule : this.mReactant) {
            if (!stereoMolecule.isFragment()) continue;
            return true;
        }
        for (StereoMolecule stereoMolecule : this.mProduct) {
            if (!stereoMolecule.isFragment()) continue;
            return true;
        }
        return false;
    }

    public Reaction(Reaction reaction) {
        this();
        int n;
        int n2;
        int n3;
        int n4 = reaction == null ? 0 : (n3 = reaction.mReactant == null ? 0 : reaction.mReactant.size());
        int n5 = reaction == null ? 0 : (n2 = reaction.mProduct == null ? 0 : reaction.mProduct.size());
        int n6 = reaction == null ? 0 : (reaction.mCatalyst == null ? 0 : reaction.mCatalyst.size());
        for (n = 0; n < n3; ++n) {
            this.mReactant.add(new StereoMolecule(reaction.getReactant(n)));
        }
        for (n = 0; n < n2; ++n) {
            this.mProduct.add(new StereoMolecule(reaction.getProduct(n)));
        }
        for (n = 0; n < n6; ++n) {
            this.mCatalyst.add(new StereoMolecule(reaction.getCatalyst(n)));
        }
        this.mDrawingObjectList = new DrawingObjectList(reaction.getDrawingObjects());
        if (reaction.mName != null) {
            this.mName = reaction.mName;
        }
        this.mIsFragment = reaction.isFragment();
    }

    public Reaction(StereoMolecule[] stereoMoleculeArray, int n) {
        this();
        if (stereoMoleculeArray != null) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                this.mReactant.add(stereoMoleculeArray[n2]);
            }
            for (n2 = n; n2 < stereoMoleculeArray.length; ++n2) {
                this.mProduct.add(stereoMoleculeArray[n2]);
            }
        }
        this.mIsFragment = this.determineFragment();
    }

    public StereoMolecule getReactant(int n) {
        return this.mReactant.get(n);
    }

    public int getReactants() {
        return this.mReactant.size();
    }

    public StereoMolecule getProduct(int n) {
        return this.mProduct.get(n);
    }

    public int getProducts() {
        return this.mProduct.size();
    }

    public StereoMolecule getCatalyst(int n) {
        return this.mCatalyst.get(n);
    }

    public int getCatalysts() {
        return this.mCatalyst.size();
    }

    public int getMolecules() {
        return this.mReactant.size() + this.mProduct.size();
    }

    public StereoMolecule getMolecule(int n) {
        return n < this.mReactant.size() ? this.mReactant.get(n) : this.mProduct.get(n - this.mReactant.size());
    }

    public void addReactant(StereoMolecule stereoMolecule) {
        this.mReactant.add(stereoMolecule);
        this.mMaxMapNo = -1;
    }

    public void addReactant(StereoMolecule stereoMolecule, int n) {
        this.mReactant.add(n, stereoMolecule);
        this.mMaxMapNo = -1;
    }

    public void addProduct(StereoMolecule stereoMolecule) {
        this.mProduct.add(stereoMolecule);
        this.mMaxMapNo = -1;
    }

    public void addProduct(StereoMolecule stereoMolecule, int n) {
        this.mProduct.add(n, stereoMolecule);
        this.mMaxMapNo = -1;
    }

    public void addCatalyst(StereoMolecule stereoMolecule) {
        this.mCatalyst.add(stereoMolecule);
    }

    public void addCatalyst(StereoMolecule stereoMolecule, int n) {
        this.mCatalyst.add(n, stereoMolecule);
    }

    public String getName() {
        return this.mName == null ? "" : this.mName;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public DrawingObjectList getDrawingObjects() {
        return this.mDrawingObjectList;
    }

    public void setDrawingObjects(DrawingObjectList drawingObjectList) {
        this.mDrawingObjectList = drawingObjectList;
    }

    public double getAverageBondLength() {
        int n = 0;
        double d = 0.0;
        for (int i = 0; i < this.getMolecules(); ++i) {
            StereoMolecule stereoMolecule = this.getMolecule(i);
            if (stereoMolecule.getAllBonds() == 0) continue;
            n += stereoMolecule.getAllBonds();
            d += stereoMolecule.getAverageBondLength() * (double)stereoMolecule.getAllBonds();
        }
        return n == 0 ? Molecule.getDefaultAverageBondLength() : d / (double)n;
    }

    public boolean isReactionLayoutRequired() {
        if (this.getMolecules() <= 1) {
            return false;
        }
        double d = this.getAverageBondLength();
        GenericRectangle[] genericRectangleArray = new GenericRectangle[this.getMolecules()];
        for (int i = 0; i < this.getMolecules(); ++i) {
            genericRectangleArray[i] = this.getMolecule(i).getBounds(null);
            if (genericRectangleArray[i] == null) continue;
            for (int j = 0; j < i; ++j) {
                if (genericRectangleArray[j] == null) continue;
                if (genericRectangleArray[i].x + genericRectangleArray[i].width >= genericRectangleArray[j].x && genericRectangleArray[i].x <= genericRectangleArray[j].x + genericRectangleArray[j].width) {
                    return true;
                }
                if (!(genericRectangleArray[i].y + genericRectangleArray[i].height >= genericRectangleArray[j].y) || !(genericRectangleArray[i].y <= genericRectangleArray[j].y + genericRectangleArray[j].height)) continue;
                return true;
            }
            if (i == 0 || genericRectangleArray[i - 1] == null) continue;
            if (genericRectangleArray[i].x - genericRectangleArray[i - 1].x - genericRectangleArray[i].width > 5.0 * d) {
                return true;
            }
            if (!(genericRectangleArray[i].y - genericRectangleArray[i - 1].y - genericRectangleArray[i].height > 5.0 * d)) continue;
            return true;
        }
        return false;
    }

    public boolean isMapped() {
        int n;
        int n2;
        int n3 = this.getHighestMapNo();
        boolean[] blArray = new boolean[n3 + 1];
        int n4 = 0;
        for (StereoMolecule stereoMolecule : this.mReactant) {
            for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
                n = stereoMolecule.getAtomMapNo(n2);
                if (n == 0) continue;
                ++n4;
                if (stereoMolecule.isFragment() && (stereoMolecule.getAtomQueryFeatures(n2) & 0x20000000L) != 0L) {
                    return false;
                }
                if (blArray[n]) {
                    return false;
                }
                blArray[n] = true;
            }
        }
        if (n4 == 0) {
            return false;
        }
        for (StereoMolecule stereoMolecule : this.mProduct) {
            for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
                n = stereoMolecule.getAtomMapNo(n2);
                if (n == 0) continue;
                --n4;
                if (stereoMolecule.isFragment() && (stereoMolecule.getAtomQueryFeatures(n2) & 0x20000000L) != 0L) {
                    return false;
                }
                if (!blArray[n]) {
                    return false;
                }
                blArray[n] = false;
            }
        }
        return n4 == 0;
    }

    public boolean isPerfectlyMapped() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        for (StereoMolecule object2 : this.mReactant) {
            object2.ensureHelperArrays(1);
            if (object2.isFragment()) {
                for (n3 = 0; n3 < object2.getAtoms(); ++n3) {
                    if ((object2.getAtomQueryFeatures(n3) & 0x20000000L) == 0L) {
                        ++n4;
                        continue;
                    }
                    if (object2.getAtomMapNo(n3) == 0) continue;
                    return false;
                }
                continue;
            }
            n4 += object2.getAtoms();
        }
        for (StereoMolecule stereoMolecule : this.mProduct) {
            stereoMolecule.ensureHelperArrays(1);
            if (stereoMolecule.isFragment()) {
                for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
                    if ((stereoMolecule.getAtomQueryFeatures(n3) & 0x20000000L) == 0L) {
                        --n4;
                        continue;
                    }
                    if (stereoMolecule.getAtomMapNo(n3) == 0) continue;
                    return false;
                }
                continue;
            }
            n4 -= stereoMolecule.getAtoms();
        }
        if (n4 != 0) {
            return false;
        }
        int n5 = this.getHighestMapNo();
        boolean[] blArray = new boolean[n5 + 1];
        for (StereoMolecule stereoMolecule : this.mReactant) {
            for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
                if (stereoMolecule.isFragment() && (stereoMolecule.getAtomQueryFeatures(n2) & 0x20000000L) != 0L) continue;
                n = stereoMolecule.getAtomMapNo(n2);
                if (blArray[n]) {
                    return false;
                }
                blArray[n] = true;
            }
        }
        for (StereoMolecule stereoMolecule : this.mProduct) {
            stereoMolecule.ensureHelperArrays(1);
            for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
                if (stereoMolecule.isFragment() && (stereoMolecule.getAtomQueryFeatures(n2) & 0x20000000L) != 0L) continue;
                n = stereoMolecule.getAtomMapNo(n2);
                if (n >= n5 || !blArray[n]) {
                    return false;
                }
                blArray[n] = false;
            }
        }
        return true;
    }

    public int getHighestMapNo() {
        if (this.mMaxMapNo != -1) {
            return this.mMaxMapNo;
        }
        this.mMaxMapNo = 0;
        for (int i = 0; i < this.getMolecules(); ++i) {
            StereoMolecule stereoMolecule = this.getMolecule(i);
            for (int j = 0; j < stereoMolecule.getAllAtoms(); ++j) {
                if (this.mMaxMapNo >= stereoMolecule.getAtomMapNo(j)) continue;
                this.mMaxMapNo = stereoMolecule.getAtomMapNo(j);
            }
        }
        return this.mMaxMapNo;
    }

    public void validateMapping() throws Exception {
        int n;
        StereoMolecule stereoMolecule;
        int n2;
        int n3;
        StereoMolecule stereoMolecule2;
        int n4 = this.getHighestMapNo();
        boolean[] blArray = new boolean[n4 + 1];
        for (int i = 0; i < this.mReactant.size(); ++i) {
            stereoMolecule2 = this.mReactant.get(i);
            for (n3 = 0; n3 < stereoMolecule2.getAllAtoms(); ++n3) {
                n2 = stereoMolecule2.getAtomMapNo(n3);
                if (n2 == 0) continue;
                if (blArray[n2]) {
                    throw new Exception("Duplicate mapping no in reactants");
                }
                blArray[n2] = true;
            }
        }
        boolean[] blArray2 = new boolean[n4 + 1];
        for (n3 = 0; n3 < this.mProduct.size(); ++n3) {
            stereoMolecule = this.mProduct.get(n3);
            for (n2 = 0; n2 < stereoMolecule.getAllAtoms(); ++n2) {
                n = stereoMolecule.getAtomMapNo(n2);
                if (n == 0) continue;
                if (blArray2[n]) {
                    throw new Exception("Duplicate mapping no in products");
                }
                blArray2[n] = true;
            }
        }
        int[] nArray = new int[n4 + 1];
        n2 = 0;
        for (n = 1; n <= n4; ++n) {
            if (!blArray[n] || !blArray2[n]) continue;
            nArray[n] = ++n2;
        }
        if (n2 != n4) {
            int n5;
            for (n = 0; n < this.mReactant.size(); ++n) {
                stereoMolecule2 = this.mReactant.get(n);
                for (n5 = 0; n5 < stereoMolecule2.getAllAtoms(); ++n5) {
                    stereoMolecule2.setAtomMapNo(n5, nArray[stereoMolecule2.getAtomMapNo(n5)], stereoMolecule2.isAutoMappedAtom(n5));
                }
            }
            for (n = 0; n < this.mProduct.size(); ++n) {
                stereoMolecule = this.mProduct.get(n);
                for (n5 = 0; n5 < stereoMolecule.getAllAtoms(); ++n5) {
                    stereoMolecule.setAtomMapNo(n5, nArray[stereoMolecule.getAtomMapNo(n5)], stereoMolecule.isAutoMappedAtom(n5));
                }
            }
        }
    }

    public boolean[] getReactionCenterMapNos() {
        int n;
        if (this.getReactants() == 0 || this.getProducts() == 0) {
            return null;
        }
        int n2 = this.getHighestMapNo();
        if (n2 == 0) {
            return null;
        }
        int[][] nArrayArray = new int[this.getProducts()][];
        for (int i = 0; i < this.getProducts(); ++i) {
            StereoMolecule stereoMolecule = this.getProduct(i);
            stereoMolecule.ensureHelperArrays(15);
            nArrayArray[i] = new int[n2 + 1];
            Arrays.fill(nArrayArray[i], -1);
            int n3 = 0;
            while (n3 < stereoMolecule.getAllAtoms()) {
                n = stereoMolecule.getAtomMapNo(n3);
                if (n != 0 && nArrayArray[i][n] != -1) {
                    return null;
                }
                nArrayArray[i][n] = n3++;
            }
        }
        boolean[] blArray = new boolean[n2 + 1];
        for (int i = 0; i < this.getReactants(); ++i) {
            StereoMolecule stereoMolecule = this.getReactant(i);
            stereoMolecule.ensureHelperArrays(15);
            block3: for (n = 0; n < stereoMolecule.getAllAtoms(); ++n) {
                int n4 = stereoMolecule.getAtomMapNo(n);
                if (n4 == 0 || blArray[n4]) continue;
                for (int j = 0; j < this.getProducts(); ++j) {
                    int n5 = nArrayArray[j][n4];
                    if (n5 == -1) continue;
                    StereoMolecule stereoMolecule2 = this.getProduct(j);
                    if (stereoMolecule.getConnAtoms(n) != stereoMolecule2.getConnAtoms(n5)) {
                        blArray[n4] = true;
                        continue block3;
                    }
                    if (stereoMolecule.getAtomParity(n) != stereoMolecule2.getAtomParity(n5)) {
                        blArray[n4] = true;
                        continue block3;
                    }
                    for (int k = 0; k < stereoMolecule.getConnAtoms(n); ++k) {
                        int n6 = stereoMolecule.getAtomMapNo(stereoMolecule.getConnAtom(n, k));
                        if (n6 == 0) {
                            blArray[n4] = true;
                            continue;
                        }
                        int n7 = stereoMolecule.getConnBond(n, k);
                        boolean bl = false;
                        for (int i2 = 0; i2 < stereoMolecule2.getConnAtoms(n5); ++i2) {
                            int n8 = stereoMolecule2.getAtomMapNo(stereoMolecule2.getConnAtom(n5, i2));
                            if (n8 == 0) {
                                blArray[n4] = true;
                                break;
                            }
                            if (n8 != n6) continue;
                            bl = true;
                            int n9 = stereoMolecule2.getConnBond(n5, i2);
                            if (!(stereoMolecule.isDelocalizedBond(n7) ^ stereoMolecule2.isDelocalizedBond(n9)) && (stereoMolecule.isDelocalizedBond(n7) || stereoMolecule.getBondOrder(n7) == stereoMolecule2.getBondOrder(n9) && stereoMolecule.getBondParity(n7) == stereoMolecule2.getBondParity(n9))) break;
                            blArray[n4] = true;
                            blArray[n6] = true;
                            break;
                        }
                        if (bl) continue;
                        blArray[n4] = true;
                    }
                }
            }
        }
        return blArray;
    }

    public int getReactionCenterAtoms(int n, boolean[] blArray, boolean[] blArray2, int[] nArray) {
        int n2;
        StereoMolecule stereoMolecule = this.getMolecule(n);
        if (blArray2 == null) {
            blArray2 = new boolean[stereoMolecule.getAllAtoms()];
        }
        int n3 = 0;
        for (n2 = 0; n2 < stereoMolecule.getAllAtoms(); ++n2) {
            if (!blArray[stereoMolecule.getAtomMapNo(n2)]) continue;
            blArray2[n2] = true;
            if (nArray != null) {
                nArray[n3] = n2;
            }
            ++n3;
        }
        for (n2 = 0; n2 < stereoMolecule.getAllBonds(); ++n2) {
            int n4 = stereoMolecule.getBondAtom(0, n2);
            int n5 = stereoMolecule.getBondAtom(1, n2);
            if (!(stereoMolecule.getAtomMapNo(n4) == 0 ^ stereoMolecule.getAtomMapNo(n5) == 0)) continue;
            if (!blArray2[n4]) {
                blArray2[n4] = true;
                if (nArray != null) {
                    nArray[n3] = n4;
                }
                ++n3;
            }
            if (blArray2[n5]) continue;
            blArray2[n5] = true;
            if (nArray != null) {
                nArray[n3] = n5;
            }
            ++n3;
        }
        return n3;
    }

    public Reaction getMergedCopy() {
        int n;
        StereoMolecule stereoMolecule;
        Reaction reaction = new Reaction();
        if (this.mReactant.size() != 0) {
            stereoMolecule = new StereoMolecule(this.mReactant.get(0));
            for (n = 1; n < this.mReactant.size(); ++n) {
                stereoMolecule.addMolecule(this.mReactant.get(n));
            }
            reaction.addReactant(stereoMolecule);
        }
        if (this.mProduct.size() != 0) {
            stereoMolecule = new StereoMolecule(this.mProduct.get(0));
            for (n = 1; n < this.mProduct.size(); ++n) {
                stereoMolecule.addMolecule(this.mProduct.get(n));
            }
            reaction.addProduct(stereoMolecule);
        }
        return reaction;
    }
}

