/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.AutoMapper;
import com.actelion.research.chem.reaction.FragmentSpec;
import java.util.Arrays;

public class MoleculeAutoMapper
implements AutoMapper {
    private static final int MASK_ATOM_INDEX = 65535;
    private static final int MASK_ATOM_TYPE = -65536;
    private StereoMolecule mMol;
    private Canonizer mCanonizer;
    private int mCurrentMapNo;
    private int[] mCounterAtom;
    private boolean[] mMapNoInUse;
    private boolean[] mMatchHandled;

    public MoleculeAutoMapper(StereoMolecule stereoMolecule) {
        this.mMol = stereoMolecule;
    }

    @Override
    public void autoMap() {
        int n;
        int n2;
        int n3;
        this.mMol.ensureHelperArrays(7);
        this.mMapNoInUse = new boolean[this.mMol.getAtoms() + 1];
        this.mMatchHandled = new boolean[this.mMol.getAtoms() + 1];
        this.mCounterAtom = new int[this.mMol.getAtoms()];
        this.mCurrentMapNo = 0;
        for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
            n2 = this.mMol.getAtomMapNo(n3);
            if (n2 == 0) {
                this.mCounterAtom[n3] = -1;
                continue;
            }
            if (this.mMol.isAutoMappedAtom(n3)) {
                this.mMol.setAtomMapNo(n3, 0, false);
                this.mCounterAtom[n3] = -1;
                continue;
            }
            if (this.mMapNoInUse[n2]) continue;
            this.mMapNoInUse[n2] = true;
            for (n = n3 + 1; n < this.mMol.getAtoms(); ++n) {
                if (this.mMol.getAtomMapNo(n) != n2) continue;
                this.mCounterAtom[n3] = n;
                this.mCounterAtom[n] = n3;
                break;
            }
            if (this.mCounterAtom[n3] != -1) continue;
            this.mMol.setAtomMapNo(n3, 0, false);
            this.mCounterAtom[n3] = -1;
        }
        this.matchFragments();
        this.mCanonizer = new Canonizer(this.mMol, 1);
        do {
            n3 = 0;
            for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
                n = this.mMol.getAtomMapNo(n2);
                if (n == 0 || this.mMatchHandled[n] || !this.autoMapNeighbors(n2, this.mCounterAtom[n2])) continue;
                n3 = 1;
            }
        } while (n3 != 0);
        this.matchFragments();
    }

    private void matchFragments() {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
            this.mMol.setAtomMarker(n3, this.mMol.getAtomMapNo(n3) == 0 && (this.mMol.getAtomQueryFeatures(n3) & 0x20000000L) == 0L);
        }
        for (n3 = this.mMol.getAtoms(); n3 < this.mMol.getAllAtoms(); ++n3) {
            this.mMol.setAtomMarker(n3, false);
        }
        int[] nArray = new int[this.mMol.getAllAtoms()];
        int n4 = this.mMol.getFragmentNumbers(nArray, true, false);
        this.mMol.removeAtomMarkers();
        if (n4 == 0) {
            return;
        }
        StereoMolecule[] stereoMoleculeArray = this.mMol.getFragments(nArray, n4);
        FragmentSpec[] fragmentSpecArray = new FragmentSpec[n4];
        for (int i = 0; i < n4; ++i) {
            stereoMoleculeArray[i].ensureHelperArrays(7);
            fragmentSpecArray[i] = new FragmentSpec();
            fragmentSpecArray[i].atomMap = new int[stereoMoleculeArray[i].getAtoms()];
            fragmentSpecArray[i].rank = new int[stereoMoleculeArray[i].getAtoms()];
        }
        int[] nArray2 = new int[n4];
        for (n2 = 0; n2 < this.mMol.getAtoms(); ++n2) {
            int n5;
            if (this.mMol.getAtomMapNo(n2) != 0 || (this.mMol.getAtomQueryFeatures(n2) & 0x20000000L) != 0L) continue;
            int n6 = n5 = nArray[n2];
            nArray2[n6] = nArray2[n6] + 1;
            String string = this.encodeMappedNeighbors(n2);
            if (string != null) {
                stereoMoleculeArray[n5].setAtomCustomLabel(n, string);
                int n7 = this.getHighestMappedNeighbor(n2);
                if (fragmentSpecArray[n5].highestMappedNeighbor < n7) {
                    fragmentSpecArray[n5].highestMappedNeighbor = n7;
                }
            }
            fragmentSpecArray[n5].atomMap[n] = n2;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            Canonizer canonizer = new Canonizer(stereoMoleculeArray[n2], 8);
            fragmentSpecArray[n2].code = canonizer.getIDCode();
            for (n = 0; n < stereoMoleculeArray[n2].getAtoms(); ++n) {
                fragmentSpecArray[n2].rank[n] = canonizer.getFinalRank()[n];
            }
        }
        block6: for (n2 = 0; n2 < n4 - 1; ++n2) {
            if (fragmentSpecArray[n2].isMapped) continue;
            for (int i = n2 + 1; i < n4; ++i) {
                if (fragmentSpecArray[i].isMapped || !fragmentSpecArray[n2].code.equals(fragmentSpecArray[i].code) || fragmentSpecArray[n2].highestMappedNeighbor == fragmentSpecArray[i].highestMappedNeighbor) continue;
                this.mapFragments(fragmentSpecArray[n2], fragmentSpecArray[i]);
                continue block6;
            }
        }
    }

    private String encodeMappedNeighbors(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < this.mMol.getConnAtoms(n); ++n4) {
            if (this.mMol.getAtomMapNo(this.mMol.getConnAtom(n, n4)) == 0) continue;
            ++n5;
        }
        if (n5 == 0) {
            return null;
        }
        if (n5 == 1) {
            for (n4 = 0; n4 < this.mMol.getConnAtoms(n); ++n4) {
                n3 = this.mMol.getAtomMapNo(this.mMol.getConnAtom(n, n4));
                if (n3 == 0) continue;
                return this.encodeBond(this.mMol.getConnBond(n, n4)) + n3;
            }
        }
        Object[] objectArray = new String[n5];
        n5 = 0;
        for (n3 = 0; n3 < this.mMol.getConnAtoms(n); ++n3) {
            n2 = this.mMol.getAtomMapNo(this.mMol.getConnAtom(n, n3));
            if (n2 == 0) continue;
            objectArray[n5++] = this.encodeBond(this.mMol.getConnBond(n, n3)) + n2;
        }
        Arrays.sort(objectArray);
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < n5; ++n2) {
            stringBuilder.append((String)objectArray[n2]);
        }
        return stringBuilder.toString();
    }

    private String encodeBond(int n) {
        if (this.mMol.isDelocalizedBond(n)) {
            return ".";
        }
        int n2 = this.mMol.getBondOrder(n);
        return n2 == 1 ? "-" : (n2 == 2 ? "=" : "#");
    }

    private int getHighestMappedNeighbor(int n) {
        int n2 = -1;
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            int n3 = this.mMol.getConnAtom(n, i);
            if (this.mMol.getAtomMapNo(n3) == 0 || n2 >= n3) continue;
            n2 = n3;
        }
        return n2;
    }

    private void mapFragments(FragmentSpec fragmentSpec, FragmentSpec fragmentSpec2) {
        block0: for (int i = 0; i < fragmentSpec.rank.length; ++i) {
            for (int j = 0; j < fragmentSpec2.rank.length; ++j) {
                if (fragmentSpec.rank[i] != fragmentSpec2.rank[j]) continue;
                this.mapAtoms(fragmentSpec.atomMap[i], fragmentSpec2.atomMap[j]);
                this.mMatchHandled[this.mCurrentMapNo] = true;
                continue block0;
            }
        }
        fragmentSpec.isMapped = true;
        fragmentSpec2.isMapped = true;
    }

    private boolean autoMapNeighbors(int n, int n2) {
        int n3 = Math.abs(this.mMol.getAtomMapNo(n));
        int[] nArray = this.getUnmappedNeighbors(n);
        if (nArray == null) {
            this.mMatchHandled[n3] = true;
            return false;
        }
        int[] nArray2 = this.getUnmappedNeighbors(n2);
        if (nArray2 == null) {
            this.mMatchHandled[n3] = true;
            return false;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n4 < nArray.length && n5 < nArray2.length) {
            if ((nArray[n4] & 0xFFFF0000) == (nArray2[n5] & 0xFFFF0000)) {
                int n7 = this.countSimilarNeighbors(nArray, n4);
                int n8 = this.countSimilarNeighbors(nArray2, n5);
                n6 += this.tryMapNeighbors(n, nArray, n4, n7, n2, nArray2, n5, n8);
                n4 += n7;
                n5 += n8;
                continue;
            }
            if (n5 < nArray2.length) {
                while (n4 < nArray.length && (nArray[n4] & 0xFFFF0000) < (nArray2[n5] & 0xFFFF0000)) {
                    ++n4;
                }
            }
            if (n4 >= nArray.length) continue;
            while (n5 < nArray2.length && (nArray2[n5] & 0xFFFF0000) < (nArray[n4] & 0xFFFF0000)) {
                ++n5;
            }
        }
        if (nArray.length == n6 || nArray2.length == n6) {
            this.mMatchHandled[n3] = true;
        }
        return n6 != 0;
    }

    private int countSimilarNeighbors(int[] nArray, int n) {
        int n2 = 1;
        while (n + n2 < nArray.length && (nArray[n + n2] & 0xFFFF0000) == (nArray[n] & 0xFFFF0000)) {
            ++n2;
        }
        return n2;
    }

    private int tryMapNeighbors(int n, int[] nArray, int n2, int n3, int n4, int[] nArray2, int n5, int n6) {
        if (n3 == 1 && n6 == 1) {
            this.mapAtoms(nArray[n2] & 0xFFFF, nArray2[n5] & 0xFFFF);
            return 1;
        }
        boolean bl = this.areNeighborsEqual(nArray, n2, n3);
        boolean bl2 = this.areNeighborsEqual(nArray2, n5, n6);
        if (bl && n3 >= n6 || bl2 && n6 >= n3) {
            int n7 = Math.min(n3, n6);
            for (int i = 0; i < n7; ++i) {
                this.mapAtoms(nArray[n2 + i] & 0xFFFF, nArray2[n5 + i] & 0xFFFF);
            }
            return n7;
        }
        for (int i = 0; i < n3; ++i) {
            int n8 = nArray[n2 + i] & 0xFFFF;
            if (this.mMol.getConnAtoms(n8) != 1) continue;
            for (int j = 0; j < n6; ++j) {
                int n9 = nArray2[n5 + j] & 0xFFFF;
                if (this.mMol.getConnAtoms(n9) != 1 || this.mMol.getBondOrder(this.mMol.getBond(n, n8)) != this.mMol.getBondOrder(this.mMol.getBond(n4, n9))) continue;
                this.mapAtoms(n8, n9);
                return 1;
            }
        }
        return 0;
    }

    private boolean areNeighborsEqual(int[] nArray, int n, int n2) {
        int n3 = this.mCanonizer.getSymmetryRank(nArray[n] & 0xFFFF);
        for (int i = 1; i < n2; ++i) {
            if (n3 == this.mCanonizer.getSymmetryRank(nArray[n + i] & 0xFFFF)) continue;
            return false;
        }
        return true;
    }

    private int[] getUnmappedNeighbors(int n) {
        int n2;
        int n3 = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            n2 = this.mMol.getConnAtom(n, i);
            if (this.mMol.getAtomMapNo(n2) != 0 || (this.mMol.getAtomQueryFeatures(n2) & 0x20000000L) != 0L) continue;
            ++n3;
        }
        if (n3 == 0) {
            return null;
        }
        int[] nArray = new int[n3];
        n3 = 0;
        for (n2 = 0; n2 < this.mMol.getConnAtoms(n); ++n2) {
            int n4 = this.mMol.getConnAtom(n, n2);
            if (this.mMol.getAtomMapNo(n4) != 0 || (this.mMol.getAtomQueryFeatures(n4) & 0x20000000L) != 0L) continue;
            nArray[n3++] = (this.mMol.getAtomicNo(n4) << 24) + (this.mMol.getAtomMass(n4) << 16) + n4;
        }
        Arrays.sort(nArray);
        return nArray;
    }

    private void mapAtoms(int n, int n2) {
        int n3 = this.getNextFreeMapNo();
        this.mMol.setAtomMapNo(n, n3, true);
        this.mMol.setAtomMapNo(n2, n3, true);
        this.mCounterAtom[n] = n2;
        this.mCounterAtom[n2] = n;
    }

    private int getNextFreeMapNo() {
        do {
            ++this.mCurrentMapNo;
        } while (this.mCurrentMapNo < this.mMapNoInUse.length && this.mMapNoInUse[this.mCurrentMapNo]);
        return this.mCurrentMapNo < this.mMapNoInUse.length ? this.mCurrentMapNo : -1;
    }
}

