/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.properties.complexity;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.mcs.ContainerListWithIntVec;
import com.actelion.research.chem.mcs.ListWithIntVec;
import com.actelion.research.util.SizeOf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class UniqueFragmentEstimator {
    private static final int SIZE_SUBSET_SOLUTIONS = 10000;
    private static final int NUM_BONDS_ESTIMATION_STARTS = 16;
    private static final int MAX_NUM_BONDS = 256;
    private static int CAPACITY_FRAGMENTS = 1000000;
    private List<ContainerSolutions> liSolutions;
    private ExtendedMolecule mol;
    private int nBondsMolecule;
    private int sizeIntVec;
    private int maximumNumberBondsInFrag;
    private ListWithIntVec livNeighbours;
    private ContainerListWithIntVec containerListWithIntVec;
    private boolean fragmentsGenerated;
    private int maxCapacityFragments;
    private boolean capacityLimitBreakes;
    int numBondsEstimationStarts;
    int sizeSubsetSolutions;

    public UniqueFragmentEstimator() {
        this(CAPACITY_FRAGMENTS);
    }

    public UniqueFragmentEstimator(int n) {
        this.maxCapacityFragments = n;
        int n2 = UniqueFragmentEstimator.getSizeArrayLIV();
        this.containerListWithIntVec = new ContainerListWithIntVec(n2, n);
        System.out.println("ExhaustiveFragmentGeneratorBonds Used mem " + SizeOf.usedMemoryMB() + "[MB].");
        this.sizeSubsetSolutions = 10000;
        this.numBondsEstimationStarts = 16;
    }

    public void set(ExtendedMolecule extendedMolecule, int n) {
        this.initHashSet(n + 1);
        this.mol = extendedMolecule;
        this.nBondsMolecule = extendedMolecule.getBonds();
        if (this.nBondsMolecule > 256) {
            throw new RuntimeException("Maximum number of atoms exceeded.");
        }
        this.sizeIntVec = (this.nBondsMolecule + 32 - 1) / 32;
        this.maximumNumberBondsInFrag = n;
        this.livNeighbours = new ListWithIntVec(this.sizeIntVec, -1);
        this.fragmentsGenerated = false;
        this.containerListWithIntVec.reset();
        this.capacityLimitBreakes = false;
    }

    private void initHashSet(int n) {
        int n2;
        if (this.liSolutions == null) {
            this.liSolutions = new ArrayList<ContainerSolutions>();
        }
        int n3 = this.liSolutions.size();
        for (n2 = 0; n2 < this.liSolutions.size(); ++n2) {
            this.liSolutions.get(n2).clear();
        }
        for (n2 = n3; n2 < n + 1; ++n2) {
            int n4 = 1000;
            if (n2 > 15) {
                n4 = 1000000;
            } else if (n2 > 10) {
                n4 = 100000;
            } else if (n2 > 5) {
                n4 = 10000;
            }
            this.liSolutions.add(new ContainerSolutions(n4, n2));
        }
    }

    public void generateFragments() {
        this.createInitSolutions();
        for (int i = 1; i < this.maximumNumberBondsInFrag + 1; ++i) {
            this.getAllPossibleNeigbourCombinations(i);
        }
        this.fragmentsGenerated = true;
        System.out.println("ExhaustiveFragmentGeneratorBonds generateFragments() getTotalSizeResultList() " + this.getTotalSizeResultList() + ".");
    }

    private void createInitSolutions() {
        ContainerSolutions containerSolutions = this.liSolutions.get(1);
        for (int i = 0; i < this.maximumNumberBondsInFrag + 1; ++i) {
            ListWithIntVec listWithIntVec = this.containerListWithIntVec.get();
            listWithIntVec.addBit(i);
            listWithIntVec.calculateHash();
            containerSolutions.add(listWithIntVec);
        }
    }

    public List<ListWithIntVec> get(int n) {
        if (!this.fragmentsGenerated) {
            throw new RuntimeException("Fragments have to be generated first. Call generateFragments().");
        }
        return this.liSolutions.get(n).getSolutions();
    }

    private void getAllPossibleNeigbourCombinations(int n) {
        ContainerSolutions containerSolutions = this.liSolutions.get(n);
        List<ListWithIntVec> list = containerSolutions.getSolutions();
        List<ListWithIntVec> list2 = null;
        if (n >= this.numBondsEstimationStarts) {
            Collections.shuffle(list);
            list2 = list.subList(0, this.sizeSubsetSolutions);
        } else {
            list2 = list;
        }
        ContainerSolutions containerSolutions2 = this.liSolutions.get(n + 1);
        if (this.maximumNumberBondsInFrag == 1) {
            return;
        }
        for (ListWithIntVec listWithIntVec : list2) {
            ListWithIntVec listWithIntVec2 = this.getAllReachableNeighbourBonds(this.mol, listWithIntVec);
            for (int i = 0; i < listWithIntVec2.size(); ++i) {
                ListWithIntVec listWithIntVec3 = this.containerListWithIntVec.getWithCopy(listWithIntVec);
                if (!listWithIntVec3.addBit(listWithIntVec2.get(i))) continue;
                listWithIntVec3.calculateHash();
                if (containerSolutions2.add(listWithIntVec3)) continue;
                this.containerListWithIntVec.back(listWithIntVec3);
            }
        }
    }

    private int getTotalSizeResultList() {
        int n = 0;
        for (ContainerSolutions containerSolutions : this.liSolutions) {
            n += containerSolutions.size();
        }
        return n;
    }

    private void shrinkResultList() {
        for (int i = 0; i < this.liSolutions.size() - 1; ++i) {
            int n = this.liSolutions.get(i + 1).size();
            if (n <= 0) continue;
            this.liSolutions.get(i).clear();
        }
    }

    private void clearResultList() {
        for (int i = 0; i < this.liSolutions.size(); ++i) {
            this.liSolutions.get(i).clear();
        }
    }

    private final ListWithIntVec getAllReachableNeighbourBonds(ExtendedMolecule extendedMolecule, ListWithIntVec listWithIntVec) {
        this.livNeighbours.reset();
        for (int i = 0; i < listWithIntVec.size(); ++i) {
            int n;
            int n2;
            int n3;
            int n4 = listWithIntVec.get(i);
            int n5 = extendedMolecule.getBondAtom(0, n4);
            int n6 = extendedMolecule.getBondAtom(1, n4);
            int n7 = extendedMolecule.getAllConnAtoms(n5);
            for (n3 = 0; n3 < n7; ++n3) {
                n2 = extendedMolecule.getConnAtom(n5, n3);
                n = extendedMolecule.getBond(n5, n2);
                if (listWithIntVec.isBitSet(n)) continue;
                this.livNeighbours.addBit(n);
            }
            n3 = extendedMolecule.getAllConnAtoms(n6);
            for (n2 = 0; n2 < n3; ++n2) {
                n = extendedMolecule.getConnAtom(n6, n2);
                int n8 = extendedMolecule.getBond(n6, n);
                if (listWithIntVec.isBitSet(n8)) continue;
                this.livNeighbours.addBit(n8);
            }
        }
        return this.livNeighbours;
    }

    public boolean isCapacityLimitBreakes() {
        return this.capacityLimitBreakes;
    }

    public static int getSizeArrayLIV() {
        int n = 8;
        return n;
    }

    private static class ContainerSolutions {
        private int bonds;
        private HashSet<ListWithIntVec> hsSolution;

        public ContainerSolutions(int n, int n2) {
            this.hsSolution = new HashSet(n);
            this.bonds = n2;
        }

        public List<ListWithIntVec> getSolutions() {
            return new ArrayList<ListWithIntVec>(this.hsSolution);
        }

        public boolean add(ListWithIntVec listWithIntVec) {
            return this.hsSolution.add(listWithIntVec);
        }

        public void clear() {
            this.hsSolution.clear();
        }

        public int size() {
            return this.hsSolution.size();
        }

        public int getBonds() {
            return this.bonds;
        }
    }
}

