/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.properties.complexity;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.properties.complexity.ExhaustiveFragmentsStatistics;
import com.actelion.research.chem.properties.complexity.ObjectiveExhaustiveStatistics;
import com.actelion.research.chem.properties.complexity.ResultFragmentsStatistic;
import com.actelion.research.chem.properties.complexity.SummaryFragments;

public class MolecularComplexityCalculator {
    public static final int TOTAL_CAPACITY = (int)(10.0 * Math.pow(10.0, 6.0));
    private ExhaustiveFragmentsStatistics exhaustiveFragmentsStatistics = new ExhaustiveFragmentsStatistics(128, TOTAL_CAPACITY);

    public MolecularComplexityCalculator() {
        this.exhaustiveFragmentsStatistics.setCollectFragmentIdCodes(false);
    }

    public double calculate(StereoMolecule stereoMolecule) {
        int n = ObjectiveExhaustiveStatistics.getNeededNumberOfBondsInFragment(stereoMolecule);
        if (n > 128) {
            return Double.NaN;
        }
        ResultFragmentsStatistic resultFragmentsStatistic = this.exhaustiveFragmentsStatistics.create(stereoMolecule, n);
        SummaryFragments summaryFragments = new SummaryFragments(resultFragmentsStatistic);
        return summaryFragments.getComplexityScore();
    }

    public void finalize() throws Throwable {
        this.exhaustiveFragmentsStatistics.finalize();
        super.finalize();
    }
}

