/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.prediction;

import com.actelion.research.chem.StereoMolecule;

public class MolecularShapeCalculator {
    public static float assessShape(StereoMolecule stereoMolecule) {
        stereoMolecule.ensureHelperArrays(7);
        if (stereoMolecule.getAtoms() == 0) {
            return -1.0f;
        }
        if (stereoMolecule.getBonds() == 0) {
            return 0.0f;
        }
        int n = 0;
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (stereoMolecule.getConnAtoms(i) != 1 && !stereoMolecule.isRingAtom(i)) continue;
            n = Math.max(n, MolecularShapeCalculator.findHighestAtomDistance(stereoMolecule, i));
        }
        return (float)(n + 1) / (float)stereoMolecule.getAtoms();
    }

    private static int findHighestAtomDistance(StereoMolecule stereoMolecule, int n) {
        int[] nArray = new int[stereoMolecule.getAtoms()];
        int[] nArray2 = new int[stereoMolecule.getAtoms()];
        nArray2[0] = n;
        nArray[n] = 1;
        int n2 = 0;
        for (int i = 0; i <= n2; ++i) {
            int n3 = nArray2[i];
            for (int j = 0; j < stereoMolecule.getConnAtoms(n3); ++j) {
                int n4 = stereoMolecule.getConnAtom(n3, j);
                if (nArray[n4] != 0) continue;
                nArray2[++n2] = n4;
                nArray[n4] = nArray[n3] + 1;
            }
        }
        return nArray[nArray2[n2]] - 1;
    }
}

