/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.prediction;

import com.actelion.research.chem.descriptor.DescriptorHandlerLongFFP512;
import com.actelion.research.chem.prediction.IncrementTableRecordWithIndex;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class IncrementTableWithIndex {
    private static final String cHeader = "<index version 1.2.1>";
    ArrayList<IncrementTableRecordWithIndex> mRecords;

    protected IncrementTableWithIndex() {
        this.mRecords = new ArrayList();
    }

    protected IncrementTableWithIndex(String string) throws Exception {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(string)));
        String string3 = bufferedReader.readLine();
        if (!string3.equals(cHeader)) {
            throw new Exception("index version mismatch");
        }
        DescriptorHandlerLongFFP512 descriptorHandlerLongFFP512 = new DescriptorHandlerLongFFP512();
        this.mRecords = new ArrayList();
        while ((string2 = bufferedReader.readLine()) != null) {
            int n = string2.indexOf(9);
            if (n == -1) {
                throw new Exception("line without TAB");
            }
            int n2 = string2.indexOf(9, n + 1);
            if (n2 == -1) {
                throw new Exception("line without second TAB");
            }
            long[] lArray = descriptorHandlerLongFFP512.decode(string2.substring(0, n));
            String string4 = string2.substring(n + 1, n2);
            double d = Double.valueOf(string2.substring(n2 + 1));
            this.mRecords.add(new IncrementTableRecordWithIndex(string4, lArray, d));
        }
        bufferedReader.close();
    }

    protected void addElement(String string, long[] lArray, double d) {
        this.mRecords.add(new IncrementTableRecordWithIndex(string, lArray, d));
    }

    protected int getSize() {
        return this.mRecords.size();
    }

    protected String getFragment(int n) {
        return this.mRecords.get((int)n).mIDCode;
    }

    protected long[] getIndex(int n) {
        return this.mRecords.get((int)n).mIndex;
    }

    protected double getIncrement(int n) {
        return this.mRecords.get((int)n).mIncrement;
    }
}

