/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.prediction;

import com.actelion.research.calc.ThreadMaster;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.SSSearcherWithIndex;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.prediction.IncrementTableWithIndex;

public class DruglikenessPredictorWithIndex {
    public static final double cDruglikenessUnknown = -999.0;
    private static IncrementTableWithIndex sIncrementTable;
    private static boolean sInitialized;
    private static StereoMolecule[] sFragmentList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruglikenessPredictorWithIndex() {
        Class<DruglikenessPredictorWithIndex> clazz = DruglikenessPredictorWithIndex.class;
        synchronized (DruglikenessPredictorWithIndex.class) {
            if (!sInitialized) {
                try {
                    sIncrementTable = new IncrementTableWithIndex("/resources/druglikeness.txt");
                    sFragmentList = new StereoMolecule[sIncrementTable.getSize()];
                    for (int i = 0; i < sIncrementTable.getSize(); ++i) {
                        DruglikenessPredictorWithIndex.sFragmentList[i] = new IDCodeParser(false).getCompactMolecule(sIncrementTable.getFragment(i));
                    }
                    sInitialized = true;
                }
                catch (Exception exception) {
                    System.out.println("Unable to initialize DruglikenessPredictor");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public double assessDruglikeness(StereoMolecule stereoMolecule, long[] lArray, ThreadMaster threadMaster) {
        if (!sInitialized) {
            return -999.0;
        }
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        SSSearcherWithIndex sSSearcherWithIndex = new SSSearcherWithIndex(1);
        sSSearcherWithIndex.setMolecule(stereoMolecule, lArray);
        for (int i = 0; i < sIncrementTable.getSize(); ++i) {
            if (threadMaster != null && threadMaster.threadMustDie()) {
                return -999.0;
            }
            sSSearcherWithIndex.setFragment(sFragmentList[i], sIncrementTable.getIndex(i));
            if (!sSSearcherWithIndex.isFragmentInMolecule()) continue;
            double d3 = sIncrementTable.getIncrement(i);
            if (d3 < -1.0) {
                d += d3;
                continue;
            }
            d2 += d3;
            ++n;
        }
        if (n == 0) {
            return -1.0;
        }
        double d4 = d + d2 / Math.sqrt(n);
        return d4 += 0.0625 * (double)(n - 40);
    }

    static {
        sInitialized = false;
    }
}

