/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.potentialenergy;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.potentialenergy.PotentialEnergyTerm;

public class AngleConstraint
implements PotentialEnergyTerm {
    private static double FORCE_CONSTANT = 50.0;
    private Conformer conf;
    private int[] angleAtoms;
    private double targetValue;

    public AngleConstraint(Conformer conformer, int[] nArray, double d) {
        this.conf = conformer;
        this.angleAtoms = nArray;
        this.targetValue = Math.PI * 2 * d / 360.0;
    }

    @Override
    public double getFGValue(double[] dArray) {
        int n = this.angleAtoms[0];
        int n2 = this.angleAtoms[1];
        int n3 = this.angleAtoms[2];
        Coordinates coordinates = this.conf.getCoordinates(n);
        Coordinates coordinates2 = this.conf.getCoordinates(n2);
        Coordinates coordinates3 = this.conf.getCoordinates(n3);
        Coordinates coordinates4 = coordinates.subC(coordinates2).unit();
        Coordinates coordinates5 = coordinates3.subC(coordinates2).unit();
        double d = coordinates2.distance(coordinates);
        double d2 = coordinates3.distance(coordinates2);
        double d3 = coordinates4.cosAngle(coordinates5);
        double d4 = 1.0 - d3 * d3;
        double d5 = 1.0E-8;
        if (d4 > 0.0) {
            d5 = Math.sqrt(d4);
        }
        double d6 = Math.acos(d3) - this.targetValue;
        double d7 = FORCE_CONSTANT * d6;
        double[] dArray2 = new double[]{1.0 / d * (coordinates5.x - d3 * coordinates4.x), 1.0 / d * (coordinates5.y - d3 * coordinates4.y), 1.0 / d * (coordinates5.z - d3 * coordinates4.z), 1.0 / d2 * (coordinates4.x - d3 * coordinates5.x), 1.0 / d2 * (coordinates4.y - d3 * coordinates5.y), 1.0 / d2 * (coordinates4.z - d3 * coordinates5.z)};
        int n4 = 3 * n;
        dArray[n4] = dArray[n4] + d7 * dArray2[0] / -d5;
        int n5 = 3 * n + 1;
        dArray[n5] = dArray[n5] + d7 * dArray2[1] / -d5;
        int n6 = 3 * n + 2;
        dArray[n6] = dArray[n6] + d7 * dArray2[2] / -d5;
        int n7 = 3 * n2;
        dArray[n7] = dArray[n7] + d7 * (-dArray2[0] - dArray2[3]) / -d5;
        int n8 = 3 * n2 + 1;
        dArray[n8] = dArray[n8] + d7 * (-dArray2[1] - dArray2[4]) / -d5;
        int n9 = 3 * n2 + 2;
        dArray[n9] = dArray[n9] + d7 * (-dArray2[2] - dArray2[5]) / -d5;
        int n10 = 3 * n3;
        dArray[n10] = dArray[n10] + d7 * dArray2[3] / -d5;
        int n11 = 3 * n3 + 1;
        dArray[n11] = dArray[n11] + d7 * dArray2[4] / -d5;
        int n12 = 3 * n3 + 2;
        dArray[n12] = dArray[n12] + d7 * dArray2[5] / -d5;
        return 0.5 * FORCE_CONSTANT * d6 * d6;
    }
}

