/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesaflex;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.alignment3d.PheSAAlignmentOptimizer;
import com.actelion.research.chem.alignment3d.transformation.TransformationSequence;
import com.actelion.research.chem.conf.BondRotationHelper;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.forcefield.mmff.ForceFieldMMFF94;
import com.actelion.research.chem.forcefield.mmff.MMFFPositionConstraint;
import com.actelion.research.chem.optimization.MCHelper;
import com.actelion.research.chem.optimization.OptimizerLBFGS;
import com.actelion.research.chem.phesa.MolecularVolume;
import com.actelion.research.chem.phesa.PheSAAlignment;
import com.actelion.research.chem.phesaflex.EvaluableFlexibleOverlap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class FlexibleShapeAlignment {
    private static final int MC_STEPS = 50;
    public static final double ENERGY_CUTOFF = 10.0;
    private StereoMolecule refMol;
    private StereoMolecule fitMol;
    private MolecularVolume refVol;
    private MolecularVolume fitVol;
    private Map<String, Object> ffOptions;
    private PheSAAlignmentOptimizer.PheSASetting settings;

    public PheSAAlignmentOptimizer.PheSASetting getSettings() {
        return this.settings;
    }

    public void setSettings(PheSAAlignmentOptimizer.PheSASetting pheSASetting) {
        this.settings = pheSASetting;
    }

    public FlexibleShapeAlignment(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
        this(stereoMolecule, stereoMolecule2, new MolecularVolume(stereoMolecule), new MolecularVolume(stereoMolecule2));
    }

    public FlexibleShapeAlignment(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, MolecularVolume molecularVolume, MolecularVolume molecularVolume2) {
        this.refMol = stereoMolecule;
        this.fitMol = stereoMolecule2;
        this.refVol = molecularVolume;
        this.fitVol = molecularVolume2;
        this.ffOptions = new HashMap<String, Object>();
        this.ffOptions.put("dielectric constant", 4.0);
        this.settings = new PheSAAlignmentOptimizer.PheSASetting();
    }

    public double[] align() {
        double[] dArray = new double[3];
        PheSAAlignment pheSAAlignment = new PheSAAlignment(this.refVol, this.fitVol);
        double d = this.calcMin(this.fitMol);
        if (Double.isNaN(d)) {
            System.err.print("no force field parameters for this structure");
            return dArray;
        }
        this.restrainedRelaxation(this.fitMol, d);
        boolean[] blArray = new boolean[this.fitMol.getAllAtoms()];
        for (int i = 0; i < this.fitMol.getAllAtoms(); ++i) {
            blArray[i] = this.fitMol.getAtomicNo(i) == 1;
        }
        Conformer conformer = new Conformer(this.fitMol);
        BondRotationHelper bondRotationHelper = new BondRotationHelper(conformer.getMolecule(), true);
        EvaluableFlexibleOverlap evaluableFlexibleOverlap = new EvaluableFlexibleOverlap(pheSAAlignment, this.refMol, conformer, bondRotationHelper, this.settings, blArray, this.ffOptions);
        evaluableFlexibleOverlap.setState(evaluableFlexibleOverlap.getState());
        evaluableFlexibleOverlap.setE0(d);
        OptimizerLBFGS optimizerLBFGS = new OptimizerLBFGS(200, 0.001);
        double d2 = optimizerLBFGS.optimize(evaluableFlexibleOverlap)[0];
        Random random = new Random(12345L);
        MCHelper mCHelper = new MCHelper(bondRotationHelper, null, random);
        boolean bl = bondRotationHelper.getRotatableBonds().length != 0;
        double[] dArray2 = evaluableFlexibleOverlap.getState();
        double d3 = d2;
        if (bl) {
            for (int i = 0; i < 50; ++i) {
                double[] dArray3 = Arrays.stream(dArray2).toArray();
                mCHelper.torsionPerturbation(conformer, dArray2);
                evaluableFlexibleOverlap.setState(dArray2);
                evaluableFlexibleOverlap.setE0(d);
                optimizerLBFGS = new OptimizerLBFGS(200, 0.001);
                optimizerLBFGS.optimize(evaluableFlexibleOverlap);
                double d4 = this.getSimilarity(evaluableFlexibleOverlap, pheSAAlignment);
                if (!mCHelper.accept(d3, d4)) {
                    dArray2 = dArray3;
                    evaluableFlexibleOverlap.setState(dArray2);
                    continue;
                }
                evaluableFlexibleOverlap.getState(dArray2);
                d3 = d4;
            }
        }
        Conformer conformer2 = evaluableFlexibleOverlap.getFitConf();
        for (int i = 0; i < conformer2.getMolecule().getAllAtoms(); ++i) {
            this.fitMol.setAtomX(i, conformer2.getX(i));
            this.fitMol.setAtomY(i, conformer2.getY(i));
            this.fitMol.setAtomZ(i, conformer2.getZ(i));
        }
        dArray = this.getResult();
        return dArray;
    }

    private double getSimilarity(EvaluableFlexibleOverlap evaluableFlexibleOverlap, PheSAAlignment pheSAAlignment) {
        boolean bl = true;
        if (this.settings.getSimMode() == PheSAAlignmentOptimizer.SimilarityMode.TANIMOTO) {
            bl = false;
        }
        double d = this.settings.getPpWeight();
        double d2 = this.settings.getSimMode() == PheSAAlignmentOptimizer.SimilarityMode.TVERSKY ? 0.95 : 0.050000000000000044;
        double d3 = evaluableFlexibleOverlap.getFGValueShapeSelf(new double[3 * this.fitMol.getAllAtoms()], pheSAAlignment.getMolGauss(), false);
        double d4 = evaluableFlexibleOverlap.getFGValueShapeSelf(new double[3 * this.refMol.getAllAtoms()], pheSAAlignment.getRefMolGauss(), true);
        double d5 = evaluableFlexibleOverlap.getFGValueShape(new double[3 * this.fitMol.getAllAtoms()]);
        double d6 = 0.0;
        d6 = bl ? d5 / (d2 * d3 + (1.0 - d2) * d4) : d5 / (d4 + d3 - d5);
        if (!bl && d6 > 1.0) {
            d6 = 1.0;
        }
        double d7 = (double)pheSAAlignment.getRefMolGauss().getPPGaussians().size() / pheSAAlignment.getRefMolGauss().getPPGaussians().stream().mapToDouble(pPGaussian -> pPGaussian.getWeight()).sum();
        double d8 = evaluableFlexibleOverlap.getFGValueSelfPP(pheSAAlignment.getMolGauss(), false);
        double d9 = evaluableFlexibleOverlap.getFGValueSelfPP(pheSAAlignment.getRefMolGauss(), true);
        double d10 = evaluableFlexibleOverlap.getFGValuePP();
        double d11 = 0.0;
        d11 = pheSAAlignment.getRefMolGauss().getPPGaussians().size() == 0 && pheSAAlignment.getMolGauss().getPPGaussians().size() == 0 ? 1.0 : (bl ? d10 / (d2 * d8 + (1.0 - d2) * d9) : d10 / (d9 + d8 - d10));
        d11 *= d7;
        if (!bl && d6 > 1.0) {
            d6 = 1.0;
        }
        if (!bl && d11 > 1.0) {
            d11 = 1.0;
        }
        double d12 = (double)(1.0f - (float)d) * d6 + (double)((float)d) * d11;
        return d12;
    }

    private double[] getResult() {
        TransformationSequence transformationSequence = new TransformationSequence();
        PheSAAlignment pheSAAlignment = new PheSAAlignment(this.fitMol, this.refMol, this.settings.getPpWeight());
        double[] dArray = pheSAAlignment.findAlignment(new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}}, transformationSequence, false, this.settings.getSimMode());
        return new double[]{dArray[0], dArray[1], dArray[2], dArray[3]};
    }

    public double calcMin(StereoMolecule stereoMolecule) {
        ForceFieldMMFF94.initialize("MMFF94s+");
        ForceFieldMMFF94 forceFieldMMFF94 = new ForceFieldMMFF94(new StereoMolecule(stereoMolecule), "MMFF94s+", this.ffOptions);
        forceFieldMMFF94.minimise();
        double d = forceFieldMMFF94.getTotalEnergy();
        return d;
    }

    public void restrainedRelaxation(StereoMolecule stereoMolecule, double d) {
        ForceFieldMMFF94.initialize("MMFF94s+");
        double d2 = 0.2;
        boolean bl = true;
        int n = 10;
        for (int i = 0; bl && i < n; ++i) {
            ForceFieldMMFF94 forceFieldMMFF94 = new ForceFieldMMFF94(stereoMolecule, "MMFF94s+", this.ffOptions);
            MMFFPositionConstraint mMFFPositionConstraint = new MMFFPositionConstraint(stereoMolecule, 50.0, d2);
            forceFieldMMFF94.addEnergyTerm(mMFFPositionConstraint);
            forceFieldMMFF94.minimise();
            double d3 = forceFieldMMFF94.getTotalEnergy();
            bl = d3 > d && d3 - d > 10.0;
            d2 += 0.2;
        }
    }
}

