/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.PeriodicTable;
import com.actelion.research.chem.alignment3d.transformation.Transformation;
import com.actelion.research.chem.phesa.QuickMathCalculator;

public abstract class Gaussian3D {
    public static final double DIST_CUTOFF = 10.0;
    protected int atomId;
    protected int atomicNo;
    protected Coordinates center;
    protected double coeff;
    protected double alpha;
    protected double volume;
    protected double weight;

    public Gaussian3D(int n, int n2, Coordinates coordinates, double d) {
        this.weight = d;
        this.atomId = n;
        this.atomicNo = n2;
        this.center = coordinates;
        this.coeff = this.calculateHeight();
        this.alpha = this.calculateWidth();
        this.volume = this.calculateVolume();
    }

    public Gaussian3D(Gaussian3D gaussian3D) {
        this.atomId = gaussian3D.atomId;
        this.atomicNo = gaussian3D.atomicNo;
        this.coeff = gaussian3D.coeff;
        this.center = new Coordinates(gaussian3D.center);
        this.alpha = gaussian3D.alpha;
        this.volume = gaussian3D.volume;
        this.weight = gaussian3D.weight;
    }

    public Gaussian3D() {
    }

    public abstract double calculateHeight();

    public abstract double calculateWidth();

    public double calculateVolume() {
        double d = PeriodicTable.getElement(this.atomicNo).getVDWRadius();
        double d2 = 4.1887902047863905 * d * d * d;
        return d2;
    }

    public double getHeight() {
        return this.coeff;
    }

    public void setHeight(double d) {
        this.coeff = d;
    }

    public double getWidth() {
        return this.alpha;
    }

    public double getVolume() {
        return this.volume;
    }

    public Coordinates getCenter() {
        return this.center;
    }

    public void setCenter(Coordinates coordinates) {
        this.center = coordinates;
    }

    public int getAtomicNo() {
        return this.atomicNo;
    }

    public void setAtomicNo(int n) {
        this.atomicNo = n;
        this.coeff = this.calculateHeight();
        this.alpha = this.calculateWidth();
        this.volume = this.calculateVolume();
    }

    public int getAtomId() {
        return this.atomId;
    }

    public void setAtomId(int n) {
        this.atomId = n;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double d) {
        this.weight = d;
    }

    public void transform(Transformation transformation) {
        transformation.apply(this.center);
    }

    public final double getVolumeOverlap(Gaussian3D gaussian3D, Coordinates coordinates, double d) {
        double d2 = this.getWidth() + gaussian3D.getWidth();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = this.getCenter().x - coordinates.x;
        double d6 = this.getCenter().y - coordinates.y;
        double d7 = this.getCenter().z - coordinates.z;
        double d8 = d5 * d5 + d6 * d6 + d7 * d7;
        if (d8 < d) {
            double d9 = -(this.getWidth() * gaussian3D.getWidth() * d8) / d2;
            d4 = this.getHeight() * gaussian3D.getHeight() * QuickMathCalculator.getInstance().quickExp(d9);
            double d10 = QuickMathCalculator.getInstance().getPrefactor(this.getAtomicNo(), gaussian3D.getAtomicNo());
            d3 = this.weight * d10 * d4;
        }
        return d3;
    }

    public final double getVolumeOverlap(Gaussian3D gaussian3D) {
        return this.getVolumeOverlap(gaussian3D, 10.0);
    }

    public final double getVolumeOverlap(Gaussian3D gaussian3D, double d) {
        return this.getVolumeOverlap(gaussian3D, gaussian3D.getCenter(), d);
    }

    public void updateCoordinates(Coordinates[] coordinatesArray) {
        this.center = new Coordinates(coordinatesArray[this.atomId]);
    }

    public void updateAtomIndeces(int[] nArray) {
        this.atomId = nArray[this.atomId];
    }

    public abstract String encode();
}

