/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.PeriodicTable;
import com.actelion.research.chem.phesa.Gaussian3D;
import com.actelion.research.util.EncoderFloatingPointNumbers;

public class AtomicGaussian
extends Gaussian3D {
    public AtomicGaussian(int n, int n2, Coordinates coordinates) {
        super(n, n2, coordinates, 1.0);
    }

    public AtomicGaussian(AtomicGaussian atomicGaussian) {
        super(atomicGaussian);
    }

    private AtomicGaussian(String string) {
        this.decode(string);
    }

    public static AtomicGaussian fromString(String string) {
        return new AtomicGaussian(string);
    }

    @Override
    public String encode() {
        double[] dArray = new double[]{this.center.x, this.center.y, this.center.z};
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Integer.toString(this.atomicNo));
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this.atomId));
        stringBuilder.append(" ");
        stringBuilder.append(EncoderFloatingPointNumbers.encode(new double[]{this.weight}, 13));
        stringBuilder.append(" ");
        stringBuilder.append(EncoderFloatingPointNumbers.encode(dArray, 13));
        return stringBuilder.toString();
    }

    public void decode(String string) {
        String[] stringArray = string.split(" ");
        this.atomicNo = Integer.decode(stringArray[0]);
        this.atomId = Integer.decode(stringArray[1]);
        double[] dArray = EncoderFloatingPointNumbers.decode(stringArray[2]);
        double[] dArray2 = EncoderFloatingPointNumbers.decode(stringArray[3]);
        this.alpha = this.calculateWidth();
        this.volume = this.calculateVolume();
        this.coeff = this.calculateHeight();
        this.center = new Coordinates(dArray2[0], dArray2[1], dArray2[2]);
        this.weight = dArray[0];
    }

    @Override
    public double calculateHeight() {
        return 2.82842712475;
    }

    @Override
    public double calculateWidth() {
        double d = PeriodicTable.getElement(this.atomicNo).getVDWRadius();
        return 2.41798793102 / (d * d);
    }
}

