/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.moreparsers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;

public class ParserUtils {
    private ParserUtils() {
    }

    public static byte[] getResourceBytes(Class<?> clazz, String string) throws FileNotFoundException, IOException {
        return ParserUtils.getLimitedStreamBytes(clazz.getResourceAsStream(string), -1L, null, true, true);
    }

    public static byte[] getLimitedStreamBytes(InputStream inputStream, long l, OutputStream outputStream, boolean bl, boolean bl2) throws IOException {
        boolean bl3 = outputStream != null;
        int n = l > 0L && l < 1024L ? (int)l : 1024;
        byte[] byArray = new byte[n];
        byte[] byArray2 = outputStream == null ? new byte[l < 0L ? 4096 : (int)l] : null;
        int n2 = 0;
        int n3 = 0;
        if (l < 0L) {
            l = Integer.MAX_VALUE;
        }
        while ((long)n3 < l && (n2 = inputStream.read(byArray, 0, n)) > 0) {
            n3 += n2;
            if (bl3) {
                outputStream.write(byArray, 0, n2);
                continue;
            }
            if (n3 > byArray2.length) {
                byArray2 = Arrays.copyOf(byArray2, n3 * 2);
            }
            System.arraycopy(byArray, 0, byArray2, n3 - n2, n2);
            if (l == Integer.MAX_VALUE || n3 + n <= byArray2.length) continue;
            n = byArray2.length - n3;
        }
        if (bl) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bl3) {
            if (bl2) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
        if (n3 == byArray2.length) {
            return byArray2;
        }
        byArray = new byte[n3];
        System.arraycopy(byArray2, 0, byArray, 0, n3);
        return byArray;
    }

    public static String getURLContentsAsString(String string) {
        byte[] byArray = ParserUtils.getURLContentsAsBytes(string);
        return byArray == null ? null : new String(byArray);
    }

    public static byte[] getURLContentsAsBytes(String string) {
        try {
            string = ParserUtils.ensureURLPath(string);
            return ParserUtils.getLimitedStreamBytes(new URL(string).openStream(), -1L, null, true, true);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String ensureURLPath(String string) {
        return string.indexOf("://") < 0 ? "file://" + (string.startsWith("/") ? "" : "/") + string : string;
    }
}

