/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.moreparsers;

import com.actelion.research.chem.MolfileParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.inchi.InChIJNI;
import com.actelion.research.chem.moreparsers.ParserUtils;

public class InChIParser {
    private int mMode;
    private final String type;
    private static final String pubchemInChIKey = "https://pubchem.ncbi.nlm.nih.gov/rest/pug/compound/inchikey/XX/SDF?record_type=2d";
    private static final String pubchemInChI = "https://pubchem.ncbi.nlm.nih.gov/rest/pug/compound/inchi/SDF?record_type=2d&inchi=";

    public InChIParser() {
        this(0);
    }

    protected InChIParser(String string) {
        this.mMode = 0;
        this.type = string;
    }

    public InChIParser(int n) {
        this.mMode = n;
        this.type = "inchi";
    }

    protected InChIParser(int n, String string) {
        this.mMode = n;
        this.type = string;
    }

    public boolean parse(StereoMolecule stereoMolecule, String string) {
        String string2;
        switch (this.type) {
            default: {
                if (!string.startsWith("PubChem:")) {
                    return InChIJNI.inchiToMolecule(string, stereoMolecule);
                }
                string = string.substring(8);
                string = string.replaceAll("=", "%3D").replaceAll("/", "%2F").replaceAll("\\+", "%2B").replaceAll(",", "%2C").replaceAll("\\(", "%28").replaceAll("\\)", "%29");
                string2 = pubchemInChI + string;
                break;
            }
            case "inchikey": {
                string2 = pubchemInChIKey.replace("XX", string);
            }
        }
        String string3 = ParserUtils.getURLContentsAsString(string2);
        return string3 != null && new MolfileParser(this.mMode).parse(stereoMolecule, string3);
    }
}

