/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.moreparsers;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.chem.moreparsers.CDX2CDXML;
import com.actelion.research.chem.moreparsers.CDXMLParser;
import com.actelion.research.chem.moreparsers.ParserUtils;
import com.actelion.research.chem.moreparsers.XmlReader;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.BitSet;
import java.util.Map;

public class CDXParser
extends XmlReader
implements CDXMLParser.CDXReaderI {
    private static final int BOND_ORDER_NULL = 0;
    private static final int BOND_ORDER_STEREO_EITHER = -1;
    private CDXMLParser parser = new CDXMLParser(this);
    private StereoMolecule mol;

    public static StereoMolecule parseFile(String string) {
        StereoMolecule stereoMolecule = new StereoMolecule();
        byte[] byArray = ParserUtils.getURLContentsAsBytes(string);
        return new CDXParser().parse(stereoMolecule, byArray) ? stereoMolecule : null;
    }

    public boolean parse(StereoMolecule stereoMolecule, String string) {
        this.mol = stereoMolecule;
        this.reader = new BufferedReader(new StringReader(string));
        this.err = this.parseXML();
        if (this.err != null) {
            return false;
        }
        this.parser.finalizeParsing();
        this.createMolecule();
        return true;
    }

    public boolean parse(StereoMolecule stereoMolecule, byte[] byArray) {
        return this.get(stereoMolecule, byArray) != null;
    }

    private StereoMolecule get(StereoMolecule stereoMolecule, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            String string = byArray[0] == 86 ? CDX2CDXML.fromCDX(byArray) : new String(byArray, "utf-8");
            return new CDXParser().parse(stereoMolecule, string) && stereoMolecule.getAllAtoms() > 0 ? stereoMolecule : null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void processStartElement(String string, String string2) {
        this.parser.processStartElement(string, this.atts);
    }

    @Override
    void processEndElement(String string) {
        this.parser.processEndElement(string, this.chars.toString());
    }

    @Override
    public void setKeepChars(boolean bl) {
        super.setKeepChars(bl);
    }

    @Override
    public void handleCoordinates(Map<String, String> map) {
        this.parser.setAtom("p", map);
    }

    @Override
    public int getBondOrder(String string) {
        switch (string) {
            case "1": 
            case "single": {
                return 1;
            }
            case "2": 
            case "double": {
                return 2;
            }
            case "3": 
            case "triple": {
                return 4;
            }
            case "up": {
                return 257;
            }
            case "down": {
                return 129;
            }
            case "either": {
                return -1;
            }
            case "null": {
                return 0;
            }
            case "delocalized": {
                return 64;
            }
        }
        return 32;
    }

    private void createMolecule() {
        int n;
        Cloneable cloneable;
        BitSet bitSet = this.parser.bsAtoms;
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            cloneable = this.parser.getAtom(n2);
            cloneable.index = n = this.mol.addAtom(cloneable.x, cloneable.y);
            this.mol.setAtomCharge(n, cloneable.formalCharge);
            this.mol.setAtomicNo(n, cloneable.elementNumber);
            if (cloneable.isotope != null) {
                this.mol.setAtomMass(n, this.parser.parseInt(cloneable.isotope));
            }
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        bitSet = this.parser.bsBonds;
        n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            cloneable = this.parser.getBond(n2);
            n = this.mol.addBond(((CDXMLParser.CDBond)cloneable).atom1.index, ((CDXMLParser.CDBond)cloneable).atom2.index);
            this.mol.setBondType(n, ((CDXMLParser.CDBond)cloneable).order);
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        new CoordinateInventor(0).invent(this.mol);
    }

    @Override
    public void warn(String string) {
        System.err.println(string);
    }
}

