/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mmp;

import com.actelion.research.chem.AtomFunctionAnalyzer;
import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.MolecularFormula;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.MolecularFlexibilityCalculator;
import com.actelion.research.chem.prediction.CLogPPredictor;
import com.actelion.research.chem.prediction.PolarSurfaceAreaPredictor;
import com.actelion.research.util.DoubleFormat;
import java.util.TreeSet;

public class MMPPropertyCalculator {
    String propertyName;
    String shortDisplayedPropertyName;
    String longDisplayedPropertyName;
    int calculatedPropertyAttributeIndex;
    String value;

    private void CalculateCompound(String string, StereoMolecule stereoMolecule, int n) {
        this.propertyName = string;
        this.calculatedPropertyAttributeIndex = n;
        this.value = null;
        if (string.toLowerCase().equals("total_weight") || string.toLowerCase().equals("mw")) {
            this.shortDisplayedPropertyName = "MW";
            this.longDisplayedPropertyName = "Molecular Weight";
            double d = new MolecularFormula(stereoMolecule).getRelativeWeight();
            this.value = DoubleFormat.toString(d, 6, true);
        } else if (string.toLowerCase().equals("logp")) {
            this.shortDisplayedPropertyName = "LogP";
            this.longDisplayedPropertyName = "LogP";
            CLogPPredictor cLogPPredictor = new CLogPPredictor();
            float f = cLogPPredictor.assessCLogP(stereoMolecule);
            this.value = Float.toString(f);
        } else if (string.toLowerCase().equals("acceptors")) {
            this.shortDisplayedPropertyName = "Acceptors";
            this.longDisplayedPropertyName = "Acceptors";
            int n2 = 0;
            for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
                if (stereoMolecule.getAtomicNo(i) != 7 && stereoMolecule.getAtomicNo(i) != 8) continue;
                ++n2;
            }
            this.value = "" + n2;
        } else if (string.toLowerCase().equals("donors")) {
            this.shortDisplayedPropertyName = "Donors";
            this.longDisplayedPropertyName = "Donors";
            int n3 = 0;
            for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
                if (stereoMolecule.getAtomicNo(i) != 7 && stereoMolecule.getAtomicNo(i) != 8 || stereoMolecule.getAllHydrogens(i) <= 0) continue;
                ++n3;
            }
            this.value = "" + n3;
        } else if (string.toLowerCase().equals("psa")) {
            this.shortDisplayedPropertyName = "PSA";
            this.longDisplayedPropertyName = "Polar Surface Area";
            PolarSurfaceAreaPredictor polarSurfaceAreaPredictor = new PolarSurfaceAreaPredictor();
            float f = polarSurfaceAreaPredictor.assessPSA(stereoMolecule);
            this.value = Float.toString(f);
        } else if (string.toLowerCase().equals("shape")) {
            this.shortDisplayedPropertyName = "Shape";
            this.longDisplayedPropertyName = "Shape";
            this.value = DoubleFormat.toString(this.assessMolecularShape(stereoMolecule));
        } else if (string.toLowerCase().equals("flexibility")) {
            this.shortDisplayedPropertyName = "Flexibility";
            this.longDisplayedPropertyName = "Flexibility";
            MolecularFlexibilityCalculator molecularFlexibilityCalculator = new MolecularFlexibilityCalculator();
            float f = molecularFlexibilityCalculator.calculateMolecularFlexibility(stereoMolecule);
            this.value = Float.toString(f);
        } else if (string.toLowerCase().equals("complexity")) {
            this.shortDisplayedPropertyName = "Complexity";
            this.longDisplayedPropertyName = "Complexity";
            this.value = DoubleFormat.toString(this.assessMolecularComplexity(stereoMolecule));
        } else if (string.replace(" ", "_").toLowerCase().equals("heavy_atoms")) {
            this.shortDisplayedPropertyName = "Heavy atoms";
            this.longDisplayedPropertyName = "Heavy atoms";
            this.value = "" + stereoMolecule.getAtoms();
        } else if (string.replace(" ", "_").toLowerCase().equals("noncarbon_atoms") || string.toLowerCase().equals("non-carbon atoms")) {
            this.shortDisplayedPropertyName = "Non-carbon atoms";
            this.longDisplayedPropertyName = "Non-carbon atoms";
            int n4 = 0;
            stereoMolecule.ensureHelperArrays(1);
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                if (stereoMolecule.getAtomicNo(i) == 6) continue;
                ++n4;
            }
            this.value = "" + n4;
        } else if (string.replace(" ", "_").toLowerCase().equals("metal_atoms")) {
            this.shortDisplayedPropertyName = "Metal atoms";
            this.longDisplayedPropertyName = "Metal atoms";
            int n5 = 0;
            stereoMolecule.ensureHelperArrays(1);
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                if (!stereoMolecule.isMetalAtom(i)) continue;
                ++n5;
            }
            this.value = "" + n5;
        } else if (string.replace(" ", "_").toLowerCase().equals("negative_atoms")) {
            this.shortDisplayedPropertyName = "Negative atoms";
            this.longDisplayedPropertyName = "Negative atoms";
            int n6 = 0;
            stereoMolecule.ensureHelperArrays(1);
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                if (!stereoMolecule.isElectronegative(i)) continue;
                ++n6;
            }
            this.value = "" + n6;
        } else if (string.toLowerCase().equals("stereocenters")) {
            this.shortDisplayedPropertyName = "Stereocenters";
            this.longDisplayedPropertyName = "Stereocenters";
            this.value = "" + stereoMolecule.getStereoCenterCount();
        } else if (string.replace(" ", "_").toLowerCase().equals("rotatable_bonds") || string.toLowerCase().equals("rot. bonds")) {
            this.shortDisplayedPropertyName = "Rot. bonds";
            this.longDisplayedPropertyName = "Rotatable bonds";
            this.value = "" + stereoMolecule.getRotatableBondCount();
        } else if (string.toLowerCase().equals("rings")) {
            this.shortDisplayedPropertyName = "Rings";
            this.longDisplayedPropertyName = "Rings";
            stereoMolecule.ensureHelperArrays(7);
            this.value = "" + stereoMolecule.getRingSet().getSize();
        } else if (string.replace(" ", "_").toLowerCase().equals("aromatic_rings") || string.toLowerCase().equals("arom. rings")) {
            this.shortDisplayedPropertyName = "Arom. rings";
            this.longDisplayedPropertyName = "Aromatic rings";
            int n7 = 0;
            stereoMolecule.ensureHelperArrays(7);
            RingCollection ringCollection = stereoMolecule.getRingSet();
            for (int i = 0; i < ringCollection.getSize(); ++i) {
                if (!ringCollection.isAromatic(i)) continue;
                ++n7;
            }
            this.value = "" + n7;
        } else if (string.replace(" ", "_").toLowerCase().equals("sp3_atoms")) {
            this.shortDisplayedPropertyName = "SP3 atoms";
            this.longDisplayedPropertyName = "SP3 atoms";
            int n8 = 0;
            stereoMolecule.ensureHelperArrays(7);
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                if (!(stereoMolecule.getAtomicNo(i) == 6 && stereoMolecule.getAtomPi(i) == 0 || stereoMolecule.getAtomicNo(i) == 7 && !stereoMolecule.isFlatNitrogen(i) || stereoMolecule.getAtomicNo(i) == 8 && stereoMolecule.getAtomPi(i) == 0 && !stereoMolecule.isAromaticAtom(i) || stereoMolecule.getAtomicNo(i) == 15) && (stereoMolecule.getAtomicNo(i) != 16 || stereoMolecule.isAromaticAtom(i))) continue;
                ++n8;
            }
            this.value = "" + n8;
        } else if (string.replace(" ", "_").toLowerCase().equals("symmetric_atoms") || string.toLowerCase().equals("symm. atoms")) {
            this.shortDisplayedPropertyName = "Symm. atoms";
            this.longDisplayedPropertyName = "Symmetric atoms";
            stereoMolecule.ensureHelperArrays(63);
            int n9 = 0;
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                if (n9 >= stereoMolecule.getSymmetryRank(i)) continue;
                n9 = stereoMolecule.getSymmetryRank(i);
            }
            this.value = "" + (stereoMolecule.getAtoms() - n9);
        } else if (string.replace(" ", "_").toLowerCase().equals("all_amides")) {
            this.shortDisplayedPropertyName = "All amides";
            this.longDisplayedPropertyName = "All amides";
            int n10 = 0;
            stereoMolecule.ensureHelperArrays(1);
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                if (!AtomFunctionAnalyzer.isAmide(stereoMolecule, i)) continue;
                ++n10;
            }
            this.value = "" + n10;
        } else if (string.replace(" ", "_").toLowerCase().equals("all_amines")) {
            this.shortDisplayedPropertyName = "All amines";
            this.longDisplayedPropertyName = "All amines";
            int n11 = 0;
            stereoMolecule.ensureHelperArrays(7);
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                if (!AtomFunctionAnalyzer.isAmine(stereoMolecule, i)) continue;
                ++n11;
            }
            this.value = "" + n11;
        } else if (string.replace(" ", "_").toLowerCase().equals("alkyl_amines")) {
            this.shortDisplayedPropertyName = "Alkyl amines";
            this.longDisplayedPropertyName = "Alkyl amines";
            int n12 = 0;
            stereoMolecule.ensureHelperArrays(7);
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                if (!AtomFunctionAnalyzer.isAlkylAmine(stereoMolecule, i)) continue;
                ++n12;
            }
            this.value = "" + n12;
        } else if (string.replace(" ", "_").toLowerCase().equals("aryl_amines")) {
            this.shortDisplayedPropertyName = "Aryl amines";
            this.longDisplayedPropertyName = "Aryl amines";
            int n13 = 0;
            stereoMolecule.ensureHelperArrays(7);
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                if (!AtomFunctionAnalyzer.isArylAmine(stereoMolecule, i)) continue;
                ++n13;
            }
            this.value = "" + n13;
        } else if (string.replace(" ", "_").toLowerCase().equals("aromatic_nitrogens") || string.toLowerCase().equals("arom. nitrogens")) {
            this.shortDisplayedPropertyName = "Arom. nitrogens";
            this.longDisplayedPropertyName = "Aromatic nitrogens";
            int n14 = 0;
            stereoMolecule.ensureHelperArrays(7);
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                if (stereoMolecule.getAtomicNo(i) != 7 || !stereoMolecule.isAromaticAtom(i)) continue;
                ++n14;
            }
            this.value = "" + n14;
        } else if (string.replace(" ", "_").toLowerCase().equals("basic_nitrogens")) {
            this.shortDisplayedPropertyName = "Basic nitrogens";
            this.longDisplayedPropertyName = "Basic nitrogens";
            int n15 = 0;
            stereoMolecule.ensureHelperArrays(7);
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                if (!AtomFunctionAnalyzer.isBasicNitrogen(stereoMolecule, i)) continue;
                ++n15;
            }
            this.value = "" + n15;
        } else if (string.replace(" ", "_").toLowerCase().equals("acidic_nitrogens")) {
            this.shortDisplayedPropertyName = "Acidic nitrogens";
            this.longDisplayedPropertyName = "Acidic nitrogens";
            int n16 = 0;
            stereoMolecule.ensureHelperArrays(7);
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                if (!AtomFunctionAnalyzer.isAcidicOxygen(stereoMolecule, i)) continue;
                ++n16;
            }
            this.value = "" + n16;
        }
    }

    private double assessMolecularShape(StereoMolecule stereoMolecule) {
        stereoMolecule.ensureHelperArrays(7);
        if (stereoMolecule.getAtoms() == 0) {
            return -1.0;
        }
        if (stereoMolecule.getBonds() == 0) {
            return 0.0;
        }
        int n = 0;
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (stereoMolecule.getConnAtoms(i) != 1 && !stereoMolecule.isRingAtom(i)) continue;
            n = Math.max(n, this.findHighestAtomDistance(stereoMolecule, i));
        }
        return (double)(n + 1) / (double)stereoMolecule.getAtoms();
    }

    private double assessMolecularComplexity(StereoMolecule stereoMolecule) {
        int n;
        int n2;
        int n3;
        int n4 = Math.min(stereoMolecule.getBonds() / 2, 7);
        stereoMolecule.ensureHelperArrays(7);
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule.getAtoms(), stereoMolecule.getBonds());
        TreeSet<String> treeSet = new TreeSet<String>();
        int[] nArray = new int[stereoMolecule.getAllAtoms()];
        boolean[][] blArray = new boolean[stereoMolecule.getBonds()][stereoMolecule.getBonds()];
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            for (n3 = 1; n3 < stereoMolecule.getConnAtoms(i); ++n3) {
                for (int j = 0; j < n3; ++j) {
                    n2 = stereoMolecule.getConnBond(i, n3);
                    n = stereoMolecule.getConnBond(i, j);
                    blArray[n2][n] = true;
                    blArray[n][n2] = true;
                }
            }
        }
        boolean[] blArray2 = new boolean[stereoMolecule.getBonds()];
        n3 = n4 - 2;
        int[] nArray2 = new int[n3 + 1];
        block3: for (n2 = 0; n2 < stereoMolecule.getBonds(); ++n2) {
            blArray2[n2] = true;
            n = 0;
            nArray2[0] = n2;
            while (true) {
                boolean bl = false;
                block5: while (!bl && nArray2[n] < stereoMolecule.getBonds() - 1) {
                    int n5 = n;
                    nArray2[n5] = nArray2[n5] + 1;
                    if (blArray2[nArray2[n]]) continue;
                    for (int i = n2; i < stereoMolecule.getBonds(); ++i) {
                        if (!blArray2[i] || !blArray[i][nArray2[n]]) continue;
                        bl = true;
                        continue block5;
                    }
                }
                if (bl) {
                    blArray2[nArray2[n]] = true;
                    if (n == n3) {
                        stereoMolecule.copyMoleculeByBonds(stereoMolecule2, blArray2, true, nArray);
                        treeSet.add(new Canonizer(stereoMolecule2).getIDCode());
                        blArray2[nArray2[n]] = false;
                        continue;
                    }
                    nArray2[++n] = n2;
                    continue;
                }
                if (--n < 0) continue block3;
                blArray2[nArray2[n]] = false;
            }
        }
        return Math.log(treeSet.size()) / (double)n4;
    }

    private int findHighestAtomDistance(StereoMolecule stereoMolecule, int n) {
        int[] nArray = new int[stereoMolecule.getAtoms()];
        int[] nArray2 = new int[stereoMolecule.getAtoms()];
        nArray2[0] = n;
        nArray[n] = 1;
        int n2 = 0;
        for (int i = 0; i <= n2; ++i) {
            int n3 = nArray2[i];
            for (int j = 0; j < stereoMolecule.getConnAtoms(n3); ++j) {
                int n4 = stereoMolecule.getConnAtom(n3, j);
                if (nArray[n4] != 0) continue;
                nArray2[++n2] = n4;
                nArray[n4] = nArray[n3] + 1;
            }
        }
        return nArray[nArray2[n2]] - 1;
    }

    public String getCalculatedValue(String string, StereoMolecule stereoMolecule) {
        this.CalculateCompound(string, stereoMolecule, -1);
        return this.value;
    }

    public String getCalculatedValue(String string, StereoMolecule stereoMolecule, int n) {
        this.CalculateCompound(string, stereoMolecule, n);
        return this.value;
    }

    public String getShortDisplayedPropertyName() {
        return this.shortDisplayedPropertyName;
    }

    public String getLongDisplayedPropertyName() {
        return this.longDisplayedPropertyName;
    }

    public int getCalculatedPropertyAttributeIndex() {
        return this.calculatedPropertyAttributeIndex;
    }
}

