/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mcs;

import com.actelion.research.chem.mcs.MatchList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class MatchListContainer {
    private static final double fractionCapacity = 0.25;
    private MatchList[] arrMatchList;
    private HashSet<MatchList> hsMatchList;
    private LinkedList<Integer> liIndexAvailable;
    private LinkedList<Integer> liIndexUsed;
    private List<int[]> liMatches;

    public MatchListContainer(int n) {
        int n2 = (int)((double)n * 0.25);
        this.arrMatchList = new MatchList[n2];
        this.liIndexAvailable = new LinkedList();
        this.liIndexUsed = new LinkedList();
        int n3 = (n + 32 - 1) / 32;
        for (int i = 0; i < this.arrMatchList.length; ++i) {
            this.arrMatchList[i] = new MatchList(n3);
            this.liIndexAvailable.add(i);
        }
        this.hsMatchList = new HashSet();
        this.liMatches = new ArrayList<int[]>();
    }

    public void reset() {
        this.hsMatchList.clear();
        Iterator iterator = this.liIndexUsed.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.arrMatchList[n].reset();
            this.liIndexAvailable.add(n);
        }
        this.liIndexUsed.clear();
        this.liMatches = new ArrayList<int[]>();
    }

    public void add(int[] nArray) {
        this.liMatches.add(nArray);
    }

    public List<int[]> getMatchList() {
        return this.liMatches;
    }

    public boolean isMaxCapacityReached() {
        return this.liIndexAvailable.isEmpty();
    }
}

