/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mcs;

import com.actelion.research.calc.ArrayUtilsCalc;
import com.actelion.research.chem.ExtendedMoleculeFunctions;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.util.datamodel.IntVec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class MCSFast {
    public static final int PAR_CLEAVE_RINGS = 0;
    public static final int PAR_KEEP_RINGS = 1;
    public static final int PAR_KEEP_AROMATIC_RINGS = 2;
    private static final boolean DEBUG = false;
    private static final int CAPACITY = 1200;
    private StereoMolecule mol;
    private StereoMolecule frag;
    private HashSet<IntVec> hsIndexFragCandidates;
    private HashSet<IntVec> hsIndexFragGarbage;
    private HashSet<IntVec> hsIndexFragSolution;
    private SSSearcher sss;
    private ComparatorBitsSet comparatorBitsSet;
    private StereoMolecule molMCS;
    private boolean considerAromaticRings = false;
    private boolean considerRings = false;
    private List<IntVec> liMCSSolutions;
    private HashMap<Integer, List<int[]>> hmRingBnd_ListRingBnds;
    private HashMap<Integer, List<int[]>> hmAromaticRingBnd_ListRingBnds;
    private RingCollection ringCollection;

    public MCSFast() {
        this(0);
    }

    public MCSFast(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.considerRings = true;
                break;
            }
            case 2: {
                this.considerAromaticRings = true;
                break;
            }
        }
        this.hsIndexFragCandidates = new HashSet(1200);
        this.hsIndexFragGarbage = new HashSet(1200);
        this.hsIndexFragSolution = new HashSet(1200);
        this.liMCSSolutions = new ArrayList<IntVec>(1200);
        this.sss = new SSSearcher();
        this.comparatorBitsSet = new ComparatorBitsSet();
        this.hmRingBnd_ListRingBnds = new HashMap();
        this.hmAromaticRingBnd_ListRingBnds = new HashMap();
    }

    public void set(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
        this.mol = stereoMolecule;
        this.frag = stereoMolecule2;
        this.init();
    }

    private void init() {
        this.hsIndexFragCandidates.clear();
        this.hsIndexFragGarbage.clear();
        this.hsIndexFragSolution.clear();
        this.liMCSSolutions.clear();
        this.hmRingBnd_ListRingBnds.clear();
        this.hmAromaticRingBnd_ListRingBnds.clear();
        this.initCandidates();
    }

    private void initCandidates() {
        int n;
        this.ringCollection = this.frag.getRingSet();
        int n2 = this.ringCollection.getSize();
        for (n = 0; n < n2; ++n) {
            List<int[]> list;
            int n3;
            int[] nArray = this.ringCollection.getRingBonds(n);
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (!this.hmRingBnd_ListRingBnds.containsKey(nArray[n3])) {
                    this.hmRingBnd_ListRingBnds.put(nArray[n3], new ArrayList());
                }
                list = this.hmRingBnd_ListRingBnds.get(nArray[n3]);
                list.add(nArray);
            }
            if (!this.ringCollection.isAromatic(n)) continue;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (!this.hmAromaticRingBnd_ListRingBnds.containsKey(nArray[n3])) {
                    this.hmAromaticRingBnd_ListRingBnds.put(nArray[n3], new ArrayList());
                }
                list = this.hmAromaticRingBnd_ListRingBnds.get(nArray[n3]);
                list.add(nArray);
            }
        }
        n = (int)((double)this.frag.getBonds() / 32.0 + 0.96875);
        for (int i = 0; i < this.frag.getBonds(); ++i) {
            IntVec intVec = new IntVec(n);
            this.setBitAndAddRelatedRingBonds(i, intVec);
            this.hsIndexFragCandidates.add(intVec);
        }
    }

    private void setBitAndAddRelatedRingBonds(int n, IntVec intVec) {
        if (!this.considerAromaticRings && !this.considerRings) {
            intVec.setBit(n);
        } else if (this.considerRings) {
            intVec.setBit(n);
            if (this.hmRingBnd_ListRingBnds.containsKey(n)) {
                List<int[]> list = this.hmRingBnd_ListRingBnds.get(n);
                for (int i = 0; i < list.size(); ++i) {
                    int[] nArray = list.get(i);
                    for (int j = 0; j < nArray.length; ++j) {
                        intVec.setBit(nArray[j]);
                    }
                }
            }
        } else if (this.considerAromaticRings) {
            intVec.setBit(n);
            if (this.hmAromaticRingBnd_ListRingBnds.containsKey(n)) {
                List<int[]> list = this.hmAromaticRingBnd_ListRingBnds.get(n);
                for (int i = 0; i < list.size(); ++i) {
                    int[] nArray = list.get(i);
                    for (int j = 0; j < nArray.length; ++j) {
                        intVec.setBit(nArray[j]);
                    }
                }
            }
        }
        intVec.calculateHashCode();
    }

    private List<IntVec> getAllSolutionsForCommonSubstructures() {
        this.sss.setMolecule(this.mol);
        this.frag.setFragment(true);
        this.sss.setFragment(this.frag);
        try {
            if (this.sss.findFragmentInMolecule() > 0) {
                this.molMCS = this.frag;
                ArrayList<IntVec> arrayList = new ArrayList<IntVec>(this.hsIndexFragCandidates);
                IntVec intVec = (IntVec)arrayList.get(0);
                intVec.setBits(0, intVec.sizeBits());
                intVec.calculateHashCode();
                ArrayList<IntVec> arrayList2 = new ArrayList<IntVec>();
                arrayList2.add(intVec);
                return arrayList2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = 0;
        while (!this.hsIndexFragCandidates.isEmpty()) {
            ArrayList<IntVec> arrayList = new ArrayList<IntVec>(this.hsIndexFragCandidates);
            Collections.sort(arrayList, this.comparatorBitsSet);
            IntVec intVec = (IntVec)arrayList.get(arrayList.size() - 1);
            this.hsIndexFragCandidates.remove(intVec);
            StereoMolecule stereoMolecule = MCSFast.getSubFrag(this.frag, intVec);
            this.sss.setFragment(stereoMolecule);
            if (this.sss.findFragmentInMolecule() > 0) {
                this.hsIndexFragSolution.add(intVec);
                this.removeAllSubSolutions(intVec);
                if (intVec.getBitsSet() != this.frag.getBonds()) {
                    List<IntVec> list = this.getAllPlusOneAtomCombinations(intVec, this.frag);
                    for (IntVec intVec2 : list) {
                        if (this.hsIndexFragGarbage.contains(intVec2) || this.hsIndexFragSolution.contains(intVec2)) continue;
                        this.hsIndexFragCandidates.add(intVec2);
                    }
                }
                if (n >= this.hsIndexFragCandidates.size()) continue;
                n = this.hsIndexFragCandidates.size();
                continue;
            }
            this.hsIndexFragGarbage.add(intVec);
        }
        if (this.hsIndexFragSolution.size() == 0) {
            return null;
        }
        return MCSFast.getFinalSolutionSet(this.hsIndexFragSolution);
    }

    public List<StereoMolecule> getAllCommonSubstructures() {
        List<IntVec> list = this.getAllSolutionsForCommonSubstructures();
        if (list == null) {
            return null;
        }
        Collections.sort(list, this.comparatorBitsSet);
        IntVec intVec = list.get(list.size() - 1);
        this.molMCS = MCSFast.getSubFrag(this.frag, intVec);
        ArrayList<StereoMolecule> arrayList = new ArrayList<StereoMolecule>();
        for (IntVec intVec2 : list) {
            arrayList.add(MCSFast.getSubFrag(this.frag, intVec2));
        }
        return ExtendedMoleculeFunctions.removeSubStructures(arrayList);
    }

    public StereoMolecule getMCS() {
        List<IntVec> list = this.getAllSolutionsForCommonSubstructures();
        if (list == null) {
            return null;
        }
        Collections.sort(list, this.comparatorBitsSet);
        IntVec intVec = list.get(list.size() - 1);
        this.molMCS = MCSFast.getSubFrag(this.frag, intVec);
        return this.molMCS;
    }

    private static StereoMolecule getSubFrag(StereoMolecule stereoMolecule, IntVec intVec) {
        int n;
        int n2;
        int n3 = stereoMolecule.getBonds();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < n3; ++i) {
            if (!intVec.isBitSet(i)) continue;
            int n4 = stereoMolecule.getBondAtom(0, i);
            int n5 = stereoMolecule.getBondAtom(1, i);
            hashSet.add(n4);
            hashSet.add(n5);
        }
        StereoMolecule stereoMolecule2 = new StereoMolecule(hashSet.size(), n3);
        stereoMolecule2.setFragment(true);
        int[] nArray = new int[stereoMolecule.getAtoms()];
        ArrayUtilsCalc.set(nArray, -1);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            n = stereoMolecule2.addAtom(stereoMolecule.getAtomicNo(n2));
            stereoMolecule2.setAtomX(n, stereoMolecule.getAtomX(n2));
            stereoMolecule2.setAtomY(n, stereoMolecule.getAtomY(n2));
            stereoMolecule2.setAtomZ(n, stereoMolecule.getAtomZ(n2));
            nArray[n2] = n;
        }
        for (int i = 0; i < n3; ++i) {
            if (!intVec.isBitSet(i)) continue;
            n2 = stereoMolecule.getBondAtom(0, i);
            n = stereoMolecule.getBondAtom(1, i);
            int n6 = nArray[n2];
            int n7 = nArray[n];
            int n8 = stereoMolecule.getBondType(i);
            if (stereoMolecule.isDelocalizedBond(i)) {
                n8 = 64;
            }
            stereoMolecule2.addBond(n6, n7, n8);
        }
        stereoMolecule2.ensureHelperArrays(7);
        return stereoMolecule2;
    }

    private List<IntVec> getAllPlusOneAtomCombinations(IntVec intVec, StereoMolecule stereoMolecule) {
        int n;
        int n2;
        int n3;
        int n4 = stereoMolecule.getBonds();
        ArrayList<IntVec> arrayList = new ArrayList<IntVec>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (n3 = 0; n3 < n4; ++n3) {
            if (!intVec.isBitSet(n3)) continue;
            n2 = stereoMolecule.getBondAtom(0, n3);
            n = stereoMolecule.getBondAtom(1, n3);
            hashSet.add(n2);
            hashSet.add(n);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (intVec.isBitSet(n3)) continue;
            n2 = stereoMolecule.getBondAtom(0, n3);
            n = stereoMolecule.getBondAtom(1, n3);
            if (!hashSet.contains(n2) && !hashSet.contains(n)) continue;
            IntVec intVec2 = new IntVec(intVec.get());
            this.setBitAndAddRelatedRingBonds(n3, intVec2);
            arrayList.add(intVec2);
        }
        return arrayList;
    }

    private void removeAllSubSolutions(IntVec intVec) {
        ArrayList<IntVec> arrayList = new ArrayList<IntVec>(this.hsIndexFragCandidates);
        for (IntVec intVec2 : arrayList) {
            if (!MCSFast.isCandidateInSolution(intVec, intVec2)) continue;
            this.hsIndexFragCandidates.remove(intVec2);
        }
    }

    private static List<IntVec> getFinalSolutionSet(HashSet<IntVec> hashSet) {
        ArrayList<IntVec> arrayList = new ArrayList<IntVec>(hashSet);
        block0: for (int i = arrayList.size() - 1; i >= 0; --i) {
            IntVec intVec = (IntVec)arrayList.get(i);
            for (int j = 0; j < arrayList.size(); ++j) {
                IntVec intVec2 = (IntVec)arrayList.get(j);
                if (i == j || !MCSFast.isCandidateInSolution(intVec2, intVec)) continue;
                arrayList.remove(i);
                continue block0;
            }
        }
        return arrayList;
    }

    private static final boolean isCandidateInSolution(IntVec intVec, IntVec intVec2) {
        IntVec intVec3 = IntVec.OR(intVec, intVec2);
        return intVec3.equals(intVec);
    }

    public double getScore() {
        double d = 0.0;
        double d2 = this.frag.getBonds();
        double d3 = this.mol.getBonds();
        double d4 = this.molMCS.getBonds();
        d = d4 / Math.max(d2, d3);
        return d;
    }

    public boolean isConsiderAromaticRings() {
        return this.considerAromaticRings;
    }

    public boolean isConsiderRings() {
        return this.considerRings;
    }

    private static class ComparatorBitsSet
    implements Comparator<IntVec> {
        private ComparatorBitsSet() {
        }

        @Override
        public int compare(IntVec intVec, IntVec intVec2) {
            int n;
            int n2 = intVec.getBitsSet();
            if (n2 > (n = intVec2.getBitsSet())) {
                return 1;
            }
            if (n2 < n) {
                return -1;
            }
            return 0;
        }
    }
}

