/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mcs;

import com.actelion.research.util.datamodel.IntArray;
import com.actelion.research.util.datamodel.IntVec;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class ListWithIntVec {
    private IntVec iv;
    private IntArray arr;
    private int positionInContainer;

    public ListWithIntVec() {
    }

    public ListWithIntVec(int n) {
        this(n, -1);
    }

    public ListWithIntVec(int n, int n2) {
        this.iv = new IntVec(n);
        this.arr = new IntArray();
        this.positionInContainer = n2;
    }

    public ListWithIntVec(ListWithIntVec listWithIntVec) {
        this.iv = new IntVec(listWithIntVec.iv);
        this.arr = new IntArray(listWithIntVec.arr);
    }

    public void copyIntoThis(ListWithIntVec listWithIntVec) {
        this.iv.set(0);
        System.arraycopy(listWithIntVec.iv.get(), 0, this.iv.get(), 0, this.iv.get().length);
        this.arr.reset();
        for (int i = 0; i < listWithIntVec.arr.length(); ++i) {
            this.arr.add(listWithIntVec.arr.get(i));
        }
    }

    public boolean addBit(int n) {
        if (this.iv.isBitSet(n)) {
            return false;
        }
        this.iv.setBit(n);
        this.arr.add(n);
        return true;
    }

    public void addAllBits(ListWithIntVec listWithIntVec) {
        int n = listWithIntVec.size();
        for (int i = 0; i < n; ++i) {
            this.addBit(listWithIntVec.get(i));
        }
        this.calculateHash();
    }

    public boolean isOverlap(ListWithIntVec listWithIntVec) {
        boolean bl = false;
        int n = listWithIntVec.size();
        for (int i = 0; i < n; ++i) {
            if (!this.isBitSet(listWithIntVec.get(i))) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean equals(Object object) {
        IntVec intVec = ((ListWithIntVec)object).iv;
        return this.iv.equals(intVec);
    }

    public boolean isBitSet(int n) {
        return this.iv.isBitSet(n);
    }

    public int getBitsSet() {
        return this.iv.getBitsSet();
    }

    public int sizeBits() {
        return this.iv.sizeBits();
    }

    public void calculateHash() {
        this.iv.calculateHashCode();
    }

    public int hashCode() {
        return this.iv.hashCode();
    }

    public int get(int n) {
        return this.arr.get(n);
    }

    public int size() {
        return this.arr.length();
    }

    public int getLengthIntVec() {
        return this.iv.size();
    }

    public void reset() {
        this.iv.set(0);
        this.arr.reset();
    }

    public String toStringArray() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.arr.length(); ++i) {
            stringBuilder.append(this.arr.get(i));
            if (i >= this.arr.length() - 1) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.iv.sizeBits();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < n2; ++n) {
            if (!this.iv.isBitSet(n)) continue;
            arrayList.add(n);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            stringBuilder.append(arrayList.get(n));
            if (n >= arrayList.size() - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public int getPositionInContainer() {
        return this.positionInContainer;
    }

    public static ListWithIntVec read(InputStream inputStream) throws IOException {
        int n = IntArray.parseInteger(inputStream);
        IntVec intVec = IntVec.read(inputStream);
        IntArray intArray = IntArray.read(inputStream);
        ListWithIntVec listWithIntVec = new ListWithIntVec();
        listWithIntVec.positionInContainer = n;
        listWithIntVec.iv = intVec;
        listWithIntVec.arr = intArray;
        return listWithIntVec;
    }

    public String write2String() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.positionInContainer);
        stringBuilder.append(" ");
        stringBuilder.append(this.iv.write2String());
        stringBuilder.append(" ");
        stringBuilder.append(this.arr.write2String());
        return stringBuilder.toString();
    }
}

