/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mcs;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.properties.complexity.ContainerFragBondsSolutions;
import com.actelion.research.chem.properties.complexity.IBitArray;
import com.actelion.research.util.SizeOf;
import com.actelion.research.util.datamodel.IntArray;
import java.util.Date;
import java.util.List;

public class ExhaustiveFragmentGeneratorBonds {
    private static boolean ELUSIVE = false;
    public static final long LIMIT_NEIGHBOURS_SINCE_LAST_ADDED = 100000000L;
    private ContainerFragBondsSolutions containerDataFragDefByBonds;
    private ExtendedMolecule mol;
    private int nBondsMolecule;
    private int maximumNumberBondsInFrag;
    private IntArray arrIndexReachableNeighbours;
    private boolean fragmentsGenerated;
    private boolean capacityLimitBreakes;
    private long solutionAdded;
    private int totalMaximumCapacity;

    public ExhaustiveFragmentGeneratorBonds(int n, int n2) {
        ContainerFragBondsSolutions.ELUSIVE = ELUSIVE;
        this.totalMaximumCapacity = n2;
        this.containerDataFragDefByBonds = new ContainerFragBondsSolutions(n, n2);
        this.arrIndexReachableNeighbours = new IntArray();
        if (ELUSIVE) {
            System.out.println("ExhaustiveFragmentGeneratorBonds constructor finished, used mem " + SizeOf.usedMemoryMB() + "[MB].");
        }
    }

    public void set(ExtendedMolecule extendedMolecule, int n) {
        this.mol = extendedMolecule;
        this.nBondsMolecule = extendedMolecule.getBonds();
        if (this.nBondsMolecule > this.containerDataFragDefByBonds.getSizeBinaryArray()) {
            throw new RuntimeException("Maximum number of bonds exceeded.");
        }
        this.maximumNumberBondsInFrag = Math.min(n, this.containerDataFragDefByBonds.getMaximumCapacityBondsInFragment());
        this.fragmentsGenerated = false;
        this.capacityLimitBreakes = false;
        this.containerDataFragDefByBonds.setBondsMolecule(this.nBondsMolecule);
    }

    private void initDataContainerAllSingleBonds() {
        this.containerDataFragDefByBonds.reset();
        for (int i = 0; i < this.nBondsMolecule; ++i) {
            IBitArray iBitArray = this.containerDataFragDefByBonds.get();
            iBitArray.setBit(i);
            this.containerDataFragDefByBonds.addFacultative(iBitArray);
        }
    }

    private void initDataContainerOneSingleBond(int n) {
        this.containerDataFragDefByBonds.reset();
        IBitArray iBitArray = this.containerDataFragDefByBonds.get();
        iBitArray.setBit(n);
        this.containerDataFragDefByBonds.addFacultative(iBitArray);
    }

    public void generateFragmentsAllBonds() {
        this.initDataContainerAllSingleBonds();
        this.generateFragments();
    }

    public void generateFragmentsForSingleBond(int n) {
        this.initDataContainerOneSingleBond(n);
        this.generateFragments();
    }

    private void generateFragments() {
        int n = Math.min(this.nBondsMolecule, this.maximumNumberBondsInFrag);
        if (n == 1) {
            return;
        }
        long l = 0L;
        long l2 = 0L;
        if (ELUSIVE) {
            System.out.println("ExhaustiveFragmentGeneratorBonds generateFragments() start record capacity " + this.containerDataFragDefByBonds.getAvailable() + ".");
        }
        block0: for (int i = 1; i < n; ++i) {
            List<IBitArray> list = this.containerDataFragDefByBonds.getList(i);
            if (ELUSIVE) {
                System.out.println("ExhaustiveFragmentGeneratorBonds generateFragments() bonds  " + i + ". Parents " + list.size() + ".");
            }
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            for (IBitArray iBitArray : list) {
                IntArray intArray = this.getAllReachableNeighbourBonds(this.mol, iBitArray);
                for (int j = 0; j < intArray.length(); ++j) {
                    IBitArray iBitArray2 = this.containerDataFragDefByBonds.getWithCopy(iBitArray);
                    iBitArray2.setBit(intArray.get(j));
                    if (this.containerDataFragDefByBonds.addFacultative(iBitArray2)) {
                        ++l3;
                        l5 = 0L;
                        if (++l2 > (long)this.totalMaximumCapacity) {
                            if (ELUSIVE) {
                                System.out.println("ExhaustiveFragmentGeneratorBonds generateFragments() maximum capacity break.");
                                this.log(l4, l, l3, l2, l5);
                            }
                            this.containerDataFragDefByBonds.reset(iBitArray2.getBitsSet());
                            break block0;
                        }
                    }
                    ++l5;
                    if (++l4 % 50000000L != 0L || !ELUSIVE) continue;
                    this.log(l4, l, l3, l2, l5);
                }
                if (l5 <= 100000000L) continue;
                System.out.println("ExhaustiveFragmentGeneratorBonds generateFragments(). Break for fragments with " + i + " bonds. Generated  " + l5 + " neighbours since last add to hash map.");
                break;
            }
            l += l4;
            if (!ELUSIVE) continue;
            this.log(l4, l, l3, l2, l5);
        }
        this.fragmentsGenerated = true;
        if (ELUSIVE) {
            System.out.println("ExhaustiveFragmentGeneratorBonds generateFragments() getTotalSizeResultList() " + this.containerDataFragDefByBonds.getTotalSizeResults() + ".");
            System.out.println("ExhaustiveFragmentGeneratorBonds generateFragments() solutionAdded " + this.solutionAdded + ".");
        }
    }

    private void log(long l, long l2, long l3, long l4, long l5) {
        System.out.println("ExhaustiveFragmentGeneratorBonds generateFragments() " + new Date().toString() + ".");
        System.out.println("ExhaustiveFragmentGeneratorBonds generateFragments() neighbours generated " + l + ".");
        System.out.println("ExhaustiveFragmentGeneratorBonds generateFragments() neighbours generated total " + l2 + ".");
        System.out.println("ExhaustiveFragmentGeneratorBonds generateFragments() solutions added " + l3 + ".");
        System.out.println("ExhaustiveFragmentGeneratorBonds generateFragments() solutions added total " + l4 + ".");
        System.out.println("ExhaustiveFragmentGeneratorBonds generateFragments() available  " + this.containerDataFragDefByBonds.getAvailable() + ".");
        System.out.println("ExhaustiveFragmentGeneratorBonds generateFragments() capacity  " + this.containerDataFragDefByBonds.getCapacity() + ".");
        System.out.println("ExhaustiveFragmentGeneratorBonds generateFragments() neighboursSinceLastAdded  " + l5 + ".");
    }

    public List<IBitArray> getFragments(int n) {
        if (!this.fragmentsGenerated) {
            throw new RuntimeException("Fragments have to be generated first. Call generateFragments().");
        }
        return this.containerDataFragDefByBonds.getList(n);
    }

    private final IntArray getAllReachableNeighbourBonds(ExtendedMolecule extendedMolecule, IBitArray iBitArray) {
        this.arrIndexReachableNeighbours.reset();
        for (int i = 0; i < this.nBondsMolecule; ++i) {
            int n;
            int n2;
            int n3;
            if (!iBitArray.isBitSet(i)) continue;
            int n4 = i;
            int n5 = extendedMolecule.getBondAtom(0, n4);
            int n6 = extendedMolecule.getBondAtom(1, n4);
            int n7 = extendedMolecule.getAllConnAtoms(n5);
            for (n3 = 0; n3 < n7; ++n3) {
                n2 = extendedMolecule.getConnAtom(n5, n3);
                n = extendedMolecule.getBond(n5, n2);
                if (iBitArray.isBitSet(n)) continue;
                ++this.solutionAdded;
                this.arrIndexReachableNeighbours.add(n);
            }
            n3 = extendedMolecule.getAllConnAtoms(n6);
            for (n2 = 0; n2 < n3; ++n2) {
                n = extendedMolecule.getConnAtom(n6, n2);
                int n8 = extendedMolecule.getBond(n6, n);
                if (iBitArray.isBitSet(n8)) continue;
                ++this.solutionAdded;
                this.arrIndexReachableNeighbours.add(n8);
            }
        }
        return this.arrIndexReachableNeighbours;
    }

    public boolean isCapacityLimitBreakes() {
        return this.capacityLimitBreakes;
    }

    public int getSizeArrayLIV() {
        int n = (this.containerDataFragDefByBonds.getSizeBinaryArray() + 32 - 1) / 32;
        return n;
    }

    public int getMaximumCapacityBondsInFragment() {
        return this.containerDataFragDefByBonds.getMaximumCapacityBondsInFragment();
    }

    public int getMaximumNumberBondsInMolecule() {
        return this.containerDataFragDefByBonds.getMaximumNumberBondsInMolecule();
    }

    public static boolean isELUSIVE() {
        return ELUSIVE;
    }

    public static void setELUSIVE(boolean bl) {
        ContainerFragBondsSolutions.ELUSIVE = ELUSIVE = bl;
    }
}

