/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io.pdb.parser;

import com.actelion.research.chem.Molecule3D;
import com.actelion.research.chem.io.pdb.converter.AminoAcidsLabeledContainer;
import com.actelion.research.chem.io.pdb.converter.BondsCalculator;
import com.actelion.research.chem.io.pdb.parser.AtomRecord;
import java.util.HashMap;
import java.util.List;

public class Residue {
    public static double BOND_CUTOFF_SQ = 3.24;
    private List<AtomRecord> records;
    private boolean isTerminal;
    private Molecule3D mol;

    public Residue(List<AtomRecord> list) {
        this.records = list;
        this.isTerminal = this.isTerminal();
        this.mol = this.constructFragment();
    }

    public boolean isTerminal() {
        this.isTerminal = false;
        for (AtomRecord atomRecord : this.records) {
            if (!atomRecord.isTerminalC()) continue;
            this.isTerminal = true;
        }
        return this.isTerminal;
    }

    private Molecule3D constructFragment() {
        boolean bl = false;
        if (AminoAcidsLabeledContainer.INSTANCE.get(this.getResname()) != null) {
            bl = true;
        }
        Molecule3D molecule3D = bl ? this.constructFragmentFromIDCode(this.getResname()) : this.constructFragmentFromGeometry(this.getResname());
        molecule3D.ensureHelperArrays(1);
        return molecule3D;
    }

    private Molecule3D constructFragmentFromIDCode(String string) {
        HashMap<String, AtomRecord> hashMap = new HashMap<String, AtomRecord>();
        for (AtomRecord atomRecord : this.records) {
            String string2 = atomRecord.getAtomName();
            hashMap.put(string2, atomRecord);
        }
        Molecule3D molecule3D = AminoAcidsLabeledContainer.INSTANCE.get(string).createResidue(hashMap);
        if (molecule3D == null) {
            molecule3D = this.constructFragmentFromGeometry(string);
        }
        return molecule3D;
    }

    private Molecule3D constructFragmentFromGeometry(String string) {
        Molecule3D molecule3D = new Molecule3D();
        for (AtomRecord atomRecord : this.records) {
            int n = atomRecord.getAtomicNo();
            int n2 = molecule3D.addAtom(n);
            molecule3D.setAtomName(n2, atomRecord.getAtomName());
            molecule3D.setAtomAmino(n2, atomRecord.getResName());
            molecule3D.setAtomSequence(n2, atomRecord.getSerialId());
            molecule3D.setResSequence(n2, atomRecord.getResNum());
            molecule3D.setAtomAmino(n2, atomRecord.getResName());
            molecule3D.setAtomChainId(n2, atomRecord.getChainID());
            molecule3D.setAtomX(n2, atomRecord.getX());
            molecule3D.setAtomY(n2, atomRecord.getY());
            molecule3D.setAtomZ(n2, atomRecord.getZ());
        }
        molecule3D.ensureHelperArrays(31);
        try {
            BondsCalculator.createBonds(molecule3D, true, null);
            BondsCalculator.calculateBondOrders(molecule3D, true);
        }
        catch (Exception exception) {
            System.err.println();
        }
        return molecule3D;
    }

    public int getResnum() {
        return this.records.get(0).getResNum();
    }

    public Molecule3D getMolecule() {
        return this.mol;
    }

    public String getResname() {
        return this.records.get(0).getResName();
    }

    public String getChainID() {
        return this.records.get(0).getChainID();
    }

    public String getInsertionCode() {
        return this.records.get(0).getInsertionCode();
    }

    public boolean areBonded(Residue residue) {
        double d;
        double d2;
        double d3;
        double d4;
        AtomRecord atomRecord = null;
        AtomRecord atomRecord2 = null;
        boolean bl = false;
        for (AtomRecord atomRecord3 : this.records) {
            if (!atomRecord3.getAtomName().equals("C")) continue;
            atomRecord2 = atomRecord3;
            break;
        }
        for (AtomRecord atomRecord3 : residue.records) {
            if (!atomRecord3.getAtomName().equals("N")) continue;
            atomRecord = atomRecord3;
            break;
        }
        if (atomRecord2 != null && atomRecord != null && (d4 = (d3 = atomRecord2.getX() - atomRecord.getX()) * d3 + (d2 = atomRecord2.getY() - atomRecord.getY()) * d2 + (d = atomRecord2.getZ() - atomRecord.getZ()) * d) < BOND_CUTOFF_SQ) {
            bl = true;
        }
        return bl;
    }
}

