/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io.pdb.converter;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.io.pdb.converter.AminoAcidLabeled;
import com.actelion.research.util.IO;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;

public enum AminoAcidsLabeledContainer {
    INSTANCE;

    public static final int AMINO_ACIDS = 20;
    private HashMap<String, AminoAcidLabeled> hmAbbreviation_AminoAcidLabeled;

    private AminoAcidsLabeledContainer() {
        this.read();
    }

    private void read() {
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/resources/pdb/aminoAcidsLabeled.txt");
            List<String> list = IO.readLines2List(inputStream);
            inputStream.close();
            for (int i = list.size() - 1; i >= 0; --i) {
                if (!list.get(i).startsWith("#")) continue;
                list.remove(i);
            }
            IDCodeParser iDCodeParser = new IDCodeParser();
            this.hmAbbreviation_AminoAcidLabeled = new HashMap();
            for (String string : list) {
                String[] stringArray = string.split("\t");
                StereoMolecule stereoMolecule = iDCodeParser.getCompactMolecule(stringArray[0], stringArray[1]);
                String string2 = stringArray[3].toUpperCase();
                AminoAcidLabeled aminoAcidLabeled = new AminoAcidLabeled(stereoMolecule, stringArray[2], string2);
                this.hmAbbreviation_AminoAcidLabeled.put(string2, aminoAcidLabeled);
            }
        }
        catch (Exception exception) {
            System.err.println("no Amino-Acid File detected!");
        }
    }

    public AminoAcidLabeled get(String string) {
        return this.hmAbbreviation_AminoAcidLabeled.get(string);
    }
}

