/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.MolfileParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.UniqueStringList;
import com.actelion.research.chem.io.RXNFileParser;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.io.BOMSkipper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.TreeMap;

public class RDFileParser {
    private static final int DEFAULT_RECORDS_TO_INSPECT = 1024;
    public static final String cNewLineString = "\n";
    private BufferedReader mReader;
    private String[] mFieldName;
    private String[] mFieldData;
    private int mNoOfRecords = 0;
    private String mLine;
    private String mIRegNo;
    private String mERegNo;
    private TreeMap<String, String> mDataMap;

    public RDFileParser(String string) {
        try {
            this.mReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            BOMSkipper.skip(this.mReader);
            this.readHeader();
        }
        catch (IOException iOException) {
            this.mReader = null;
        }
    }

    public RDFileParser(File file) {
        try {
            this.mReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            BOMSkipper.skip(this.mReader);
            this.readHeader();
        }
        catch (IOException iOException) {
            this.mReader = null;
        }
    }

    public RDFileParser(Reader reader) {
        this.mReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        try {
            this.readHeader();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readHeader() throws IOException {
        if (!"$RDFILE 1".equals(this.mReader.readLine()) || this.mReader.readLine() == null || (this.mLine = this.mReader.readLine()) == null) {
            this.mReader.close();
            this.mReader = null;
            return;
        }
        this.mDataMap = new TreeMap();
    }

    public boolean hasNext() {
        return this.mReader != null;
    }

    public int getRowCount() {
        return this.mNoOfRecords;
    }

    public TreeMap<String, String> getFieldData() {
        return this.mDataMap;
    }

    public String getFieldData(String string) {
        return this.mDataMap.get(string);
    }

    public String getERegNo() {
        return this.mERegNo;
    }

    public String getIRegNo() {
        return this.mIRegNo;
    }

    public Reaction getNextReaction() {
        if (this.mReader == null) {
            return null;
        }
        this.mIRegNo = null;
        this.mERegNo = null;
        Reaction reaction = null;
        this.mDataMap.clear();
        String string = null;
        while (this.mLine != null) {
            block17: {
                if (this.mLine.startsWith("$REREG ")) {
                    this.mERegNo = this.mLine.substring(7).trim();
                } else if (this.mLine.startsWith("$RIREG ")) {
                    this.mIRegNo = this.mLine.substring(7).trim();
                } else {
                    if (this.mLine.startsWith("$RFMT")) {
                        reaction = new Reaction();
                        try {
                            if (!new RXNFileParser().parse(reaction, this.mReader)) {
                                this.mReader = null;
                                return null;
                            }
                            break block17;
                        }
                        catch (Exception exception) {
                            this.mReader = null;
                            return null;
                        }
                    }
                    if (this.mLine.startsWith("$DTYPE ")) {
                        string = this.mLine.substring(7).trim();
                    } else if (this.mLine.startsWith("$DATUM ") && string != null) {
                        String string2 = this.mLine.substring(7).trim();
                        if (string2.length() != 0) {
                            this.mDataMap.put(string, string2);
                        }
                        string = null;
                    }
                }
            }
            try {
                this.mLine = this.mReader.readLine();
                if (this.mLine == null) {
                    this.mReader.close();
                    this.mReader = null;
                }
            }
            catch (IOException iOException) {
                return null;
            }
            if (!this.isReactionNext()) continue;
        }
        ++this.mNoOfRecords;
        return reaction;
    }

    public boolean isMoleculeNext() {
        return this.mLine != null && (this.mLine.startsWith("$MFMT") || this.mLine.startsWith("$MEGEG") || this.mLine.startsWith("$MIREG"));
    }

    public boolean isReactionNext() {
        return this.mLine != null && (this.mLine.startsWith("$RFMT") || this.mLine.startsWith("$REGEG") || this.mLine.startsWith("$RIREG"));
    }

    public StereoMolecule getNextMolecule() {
        if (this.mReader == null) {
            return null;
        }
        this.mIRegNo = null;
        this.mERegNo = null;
        StereoMolecule stereoMolecule = null;
        this.mDataMap.clear();
        String string = null;
        while (this.mLine != null) {
            block17: {
                if (this.mLine.startsWith("$MEREG ")) {
                    this.mERegNo = this.mLine.substring(7).trim();
                } else if (this.mLine.startsWith("$MIREG ")) {
                    this.mIRegNo = this.mLine.substring(7).trim();
                } else {
                    if (this.mLine.startsWith("$MFMT")) {
                        this.mIRegNo = this.mLine.substring(7).trim();
                        stereoMolecule = new StereoMolecule();
                        try {
                            if (!new MolfileParser().parse(stereoMolecule, this.mReader)) {
                                this.mReader = null;
                                return null;
                            }
                            break block17;
                        }
                        catch (Exception exception) {
                            this.mReader = null;
                            return null;
                        }
                    }
                    if (this.mLine.startsWith("$DTYPE ")) {
                        string = this.mLine.substring(7).trim();
                    } else if (this.mLine.startsWith("$DATUM ") && string != null) {
                        String string2 = this.mLine.substring(7).trim();
                        if (string2.length() != 0) {
                            this.mDataMap.put(string, string2);
                        }
                        string = null;
                    }
                }
            }
            try {
                this.mLine = this.mReader.readLine();
                if (this.mLine == null) {
                    this.mReader.close();
                    this.mReader = null;
                }
            }
            catch (IOException iOException) {
                return null;
            }
            if (!this.isMoleculeNext()) continue;
        }
        ++this.mNoOfRecords;
        return stereoMolecule;
    }

    public String[] getFieldNames() {
        if (this.mFieldName == null) {
            this.extractAllFieldNames(1024);
        }
        return this.mFieldName;
    }

    private void extractAllFieldNames(int n) {
        UniqueStringList uniqueStringList = new UniqueStringList();
        for (int i = 0; i < n; ++i) {
            Serializable serializable;
            Serializable serializable2 = serializable = this.isReactionNext() ? this.getNextReaction() : this.getNextMolecule();
            if (serializable == null) break;
            for (String string : this.mDataMap.keySet()) {
                uniqueStringList.addString(string);
            }
        }
        this.mFieldName = uniqueStringList.toArray();
    }
}

