/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.AromaticityResolver;
import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.Molecule3D;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.io.AbstractParser;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class Mol2FileParser
extends AbstractParser {
    public static final int iNO_CHARGES = 0;
    public static final int iDEL_RE = 1;
    public static final int iGASTEIGER = 2;
    public static final int iGAST_HUCK = 3;
    public static final int iHUCKEL = 4;
    public static final int iPULLMAN = 5;
    public static final int iGAUSS80_CHARGES = 6;
    public static final int iAMPAC_CHARGES = 7;
    public static final int iMULLIKEN_CHARGES = 8;
    public static final int iDICT_CHARGES = 9;
    public static final int iMMFF94_CHARGES = 10;
    public static final int iUSER_CHARGES = 11;
    private static final NumberFormat NF_PARTIAL_CHARGES = new DecimalFormat(" 0.0000;-0.0000");
    private static final String sNO_CHARGES = "NO_CHARGES";
    private static final String sDEL_RE = "DEL_RE";
    private static final String sGASTEIGER = "GASTEIGER";
    private static final String sGAST_HUCK = "GAST_HUCK";
    private static final String sHUCKEL = "HUCKEL";
    private static final String sPULLMAN = "PULLMAN";
    private static final String sGAUSS80_CHARGES = "GAUSS80_CHARGES";
    private static final String sAMPAC_CHARGES = "AMPAC_CHARGES";
    private static final String sMULLIKEN_CHARGES = "MULLIKEN_CHARGES";
    private static final String sDICT_CHARGES = "DICT_CHARGES";
    private static final String sMMFF94_CHARGES = "MMFF94_CHARGES";
    private static final String sUSER_CHARGES = "USER_CHARGES";
    private static HashMap<Integer, String> hmIndex_CHARGETYPE;
    private boolean isLoadHydrogen = true;

    private void addMol(List<Molecule3D> list, Molecule3D molecule3D, Set<Integer> set, Set<Integer> set2) {
        if (molecule3D == null || molecule3D.getAllAtoms() == 0) {
            return;
        }
        StereoMolecule stereoMolecule = new StereoMolecule(molecule3D);
        int[] nArray = stereoMolecule.getHandleHydrogenBondMap();
        boolean bl = false;
        new AromaticityResolver(stereoMolecule).locateDelocalizedDoubleBonds(null, true, true);
        for (int i = 0; i < stereoMolecule.getBonds(); ++i) {
            molecule3D.setBondOrder(i, stereoMolecule.getBondOrder(nArray[i]));
        }
        this.assignCharges(molecule3D);
        molecule3D.setAllAtomFlag(2, true);
        list.add(molecule3D);
    }

    private void assignCharges(Molecule3D molecule3D) {
        for (int i = 0; i < molecule3D.getAtoms(); ++i) {
            if (molecule3D.getAtomicNo(i) == 7) {
                if (molecule3D.getOccupiedValence(i) == 4) {
                    molecule3D.setAtomCharge(i, 1);
                } else if (molecule3D.getOccupiedValence(i) == 2) {
                    molecule3D.setAtomCharge(i, -1);
                }
            }
            if (molecule3D.getAtomicNo(i) == 8) {
                if (molecule3D.getOccupiedValence(i) == 3) {
                    molecule3D.setAtomCharge(i, 1);
                } else if (molecule3D.getOccupiedValence(i) == 1) {
                    molecule3D.setAtomCharge(i, -1);
                }
            }
            if (molecule3D.getAtomicNo(i) != 16) continue;
            if (molecule3D.getOccupiedValence(i) == 3) {
                molecule3D.setAtomCharge(i, 1);
                continue;
            }
            if (molecule3D.getOccupiedValence(i) != 1) continue;
            molecule3D.setAtomCharge(i, -1);
        }
    }

    public static String getChargeType(int n) {
        if (hmIndex_CHARGETYPE == null) {
            hmIndex_CHARGETYPE = new HashMap();
            hmIndex_CHARGETYPE.put(0, sNO_CHARGES);
            hmIndex_CHARGETYPE.put(1, sDEL_RE);
            hmIndex_CHARGETYPE.put(2, sGASTEIGER);
            hmIndex_CHARGETYPE.put(3, sGAST_HUCK);
            hmIndex_CHARGETYPE.put(4, sHUCKEL);
            hmIndex_CHARGETYPE.put(5, sPULLMAN);
            hmIndex_CHARGETYPE.put(6, sGAUSS80_CHARGES);
            hmIndex_CHARGETYPE.put(7, sAMPAC_CHARGES);
            hmIndex_CHARGETYPE.put(8, sMULLIKEN_CHARGES);
            hmIndex_CHARGETYPE.put(9, sDICT_CHARGES);
            hmIndex_CHARGETYPE.put(10, sMMFF94_CHARGES);
            hmIndex_CHARGETYPE.put(11, sUSER_CHARGES);
        }
        return hmIndex_CHARGETYPE.get(n);
    }

    @Override
    public List<Molecule3D> loadGroup(String string, Reader reader, int n2, int n3) throws Exception {
        Object object;
        Object object2;
        String string2;
        ArrayList<Molecule3D> arrayList = new ArrayList<Molecule3D>();
        Molecule3D molecule3D = new Molecule3D();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        while ((string2 = lineNumberReader.readLine()) != null) {
            if (string2.startsWith("@<TRIPOS>")) {
                n5 = 0;
            }
            if (string2.startsWith("@<TRIPOS>MOLECULE")) {
                n4 = 0;
                continue;
            }
            if (string2.startsWith("@<TRIPOS>ATOM")) {
                n4 = 1;
                continue;
            }
            if (string2.startsWith("@<TRIPOS>BOND")) {
                n4 = 2;
                continue;
            }
            if (string2.startsWith("@<TRIPOS>")) {
                n4 = -1;
                continue;
            }
            ++n5;
            switch (n4) {
                case 0: {
                    if (n5 != 1 || n2 > ++n6 || n3 >= 0 && n3 < n6) break;
                    this.addMol(arrayList, molecule3D, hashSet, hashSet2);
                    molecule3D = new Molecule3D();
                    hashSet.clear();
                    hashSet2.clear();
                    object2 = string2.trim();
                    molecule3D.setName((String)object2);
                    break;
                }
                case 1: {
                    int n7;
                    try {
                        object2 = new StringTokenizer(string2, "\t ");
                        n7 = Integer.parseInt(((StringTokenizer)object2).nextToken().trim());
                        object = ((StringTokenizer)object2).nextToken().trim();
                        double d = Double.parseDouble(((StringTokenizer)object2).nextToken().trim());
                        double d2 = Double.parseDouble(((StringTokenizer)object2).nextToken().trim());
                        double d3 = Double.parseDouble(((StringTokenizer)object2).nextToken().trim());
                        String string3 = ((StringTokenizer)object2).hasMoreTokens() ? ((StringTokenizer)object2).nextToken().trim() : "";
                        String string4 = ((StringTokenizer)object2).hasMoreTokens() ? ((StringTokenizer)object2).nextToken().trim() : "";
                        String string5 = ((StringTokenizer)object2).hasMoreTokens() ? ((StringTokenizer)object2).nextToken().trim() : "";
                        String string6 = ((StringTokenizer)object2).hasMoreTokens() ? ((StringTokenizer)object2).nextToken().trim() : "";
                        String string7 = new StringTokenizer(string3, ".").nextToken();
                        boolean bl = string3.endsWith(".ar");
                        int n8 = Molecule.getAtomicNoFromLabel(string7);
                        if (n8 < 0) {
                            throw new Exception("Invalid Atomic Number for " + n7 + ": " + string7);
                        }
                        if (!this.isLoadHydrogen && n8 <= 1) break;
                        int n9 = molecule3D.addAtom(n8);
                        molecule3D.setAtomX(n9, d);
                        molecule3D.setAtomY(n9, -d2);
                        molecule3D.setAtomZ(n9, -d3);
                        molecule3D.setAtomName(n9, (String)object);
                        molecule3D.setAtomChainId(n9, string4);
                        molecule3D.setAtomAmino(n9, string5);
                        if (bl) {
                            hashSet.add(n9);
                        }
                        try {
                            molecule3D.setPartialCharge(n9, Double.parseDouble(string6));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        treeMap.put(n7, n9);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new Exception("Invalid number at line " + lineNumberReader.getLineNumber() + ": " + string2);
                    }
                }
                case 2: {
                    int n10;
                    object2 = new StringTokenizer(string2);
                    if (((StringTokenizer)object2).countTokens() < 3) break;
                    ((StringTokenizer)object2).nextToken();
                    int n7 = Integer.parseInt(((StringTokenizer)object2).nextToken());
                    int n11 = Integer.parseInt(((StringTokenizer)object2).nextToken());
                    String string8 = ((StringTokenizer)object2).nextToken();
                    Integer n12 = (Integer)treeMap.get(n7);
                    Integer n13 = (Integer)treeMap.get(n11);
                    if (n12 == null || n13 == null) break;
                    if (string8.equals("ar")) {
                        n10 = 64;
                    } else if (string8.equals("am")) {
                        n10 = 1;
                    } else {
                        if (string8.equals("un") || string8.equals("nc") || string8.equals("du")) break;
                        n10 = Integer.parseInt(string8);
                        if (n10 == 1) {
                            n10 = 1;
                        } else if (n10 == 2) {
                            n10 = 2;
                        } else if (n10 == 3) {
                            n10 = 4;
                        } else {
                            throw new RuntimeException("Unknown bond type " + n10 + ".");
                        }
                    }
                    int n14 = n12;
                    int n15 = n13;
                    int n16 = molecule3D.addBond(n14, n15, n10);
                    break;
                }
            }
        }
        ++n6;
        object2 = molecule3D.getHandleHydrogenBondMap();
        int[] nArray = molecule3D.getHandleHydrogenMap();
        object = new HashSet();
        HashSet hashSet3 = new HashSet();
        hashSet.stream().forEach(n -> object.add(nArray[n]));
        hashSet2.stream().forEach(arg_0 -> Mol2FileParser.lambda$loadGroup$1(hashSet3, (int[])object2, arg_0));
        if (n2 <= n6 && (n3 < 0 || n3 >= n6)) {
            molecule3D.ensureHelperArrays(7);
            this.addMol(arrayList, molecule3D, hashSet, hashSet2);
        }
        return arrayList;
    }

    @Override
    public void save(Molecule3D molecule3D, Writer writer) throws Exception {
        this.save(Collections.singletonList(molecule3D), writer);
    }

    @Override
    public void save(List<Molecule3D> list, Writer writer) throws Exception {
        this.save(list, 0, writer);
    }

    public void save(List<Molecule3D> list, int n, Writer writer) throws Exception {
        DecimalFormat decimalFormat = new DecimalFormat("0.0000");
        for (Molecule3D molecule3D : list) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            for (n2 = 0; n2 < molecule3D.getAllAtoms(); ++n2) {
                if (molecule3D.getAtomicNo(n2) <= 0) continue;
                ++n3;
            }
            for (n2 = 0; n2 < molecule3D.getAllBonds(); ++n2) {
                if (molecule3D.getAtomicNo(molecule3D.getBondAtom(0, n2)) <= 0 || molecule3D.getAtomicNo(molecule3D.getBondAtom(1, n2)) <= 0) continue;
                ++n4;
            }
            writer.write("@<TRIPOS>MOLECULE" + NEWLINE);
            writer.write(molecule3D.getName() + NEWLINE);
            Mol2FileParser.writeR(writer, "" + n3, 5);
            Mol2FileParser.writeR(writer, "" + n4, 6);
            writer.write(NEWLINE);
            writer.write("SMALL" + NEWLINE);
            writer.write(Mol2FileParser.getChargeType(n) + NEWLINE);
            writer.write("@<TRIPOS>ATOM" + NEWLINE);
            for (n2 = 0; n2 < molecule3D.getAllAtoms(); ++n2) {
                if (molecule3D.getAtomicNo(n2) <= 0) continue;
                Mol2FileParser.writeR(writer, "" + (n2 + 1), 7);
                writer.write(" ");
                String string = molecule3D.getAtomName(n2);
                if (string == null || string.length() == 0) {
                    string = "" + ExtendedMolecule.cAtomLabel[molecule3D.getAtomicNo(n2)];
                }
                Mol2FileParser.writeL(writer, string, 8);
                Mol2FileParser.writeR(writer, decimalFormat.format(molecule3D.getAtomX(n2)), 10);
                Mol2FileParser.writeR(writer, decimalFormat.format(molecule3D.getAtomY(n2)), 10);
                Mol2FileParser.writeR(writer, decimalFormat.format(molecule3D.getAtomZ(n2)), 10);
                writer.write(" ");
                Mol2FileParser.writeL(writer, ExtendedMolecule.cAtomLabel[molecule3D.getAtomicNo(n2)] + (molecule3D.isAromaticAtom(n2) ? ".ar" : ""), 8);
                Mol2FileParser.writeR(writer, molecule3D.getAtomChainId(n2) != null && molecule3D.getAtomChainId(n2).length() > 0 ? molecule3D.getAtomChainId(n2) : "1", 5);
                writer.write("  ");
                Mol2FileParser.writeL(writer, molecule3D.getAtomAmino(n2) != null && molecule3D.getAtomAmino(n2).length() > 0 ? molecule3D.getAtomAmino(n2) : "1", 11);
                writer.write(NF_PARTIAL_CHARGES.format(molecule3D.getPartialCharge(n2)));
                writer.write(NEWLINE);
            }
            writer.write("@<TRIPOS>BOND" + NEWLINE);
            for (n2 = 0; n2 < molecule3D.getAllBonds(); ++n2) {
                if (molecule3D.getAtomicNo(molecule3D.getBondAtom(0, n2)) <= 0 || molecule3D.getAtomicNo(molecule3D.getBondAtom(1, n2)) <= 0) continue;
                Mol2FileParser.writeR(writer, "" + (n2 + 1), 6);
                Mol2FileParser.writeR(writer, "" + (molecule3D.getBondAtom(0, n2) + 1), 5);
                Mol2FileParser.writeR(writer, "" + (molecule3D.getBondAtom(1, n2) + 1), 5);
                writer.write(" ");
                Mol2FileParser.writeL(writer, "" + molecule3D.getBondOrder(n2), 5);
                writer.write(NEWLINE);
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        List<Molecule3D> list = new Mol2FileParser().loadGroup("c:/mopac11971.mol2");
        System.out.println("models=" + list.size() + " atm=" + list.get(0).getAllAtoms() + " " + list.get(0).getAtoms());
    }

    private static /* synthetic */ void lambda$loadGroup$1(Set set, int[] nArray, Integer n) {
        set.add(nArray[n]);
    }
}

