/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.io.CompoundFileHelper;
import java.io.File;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.filechooser.FileFilter;

public class CompoundFileFilter
extends FileFilter {
    private TreeMap<String, CompoundFileFilter> mFilterMap = new TreeMap();
    private String mDescription = null;
    private String mFullDescription = null;
    private boolean mUseExtensionsInDescription = true;

    public CompoundFileFilter() {
    }

    public CompoundFileFilter(String string) {
        this(string, null);
    }

    public CompoundFileFilter(String string, String string2) {
        this();
        if (string != null) {
            this.addExtension(string);
        }
        if (string2 != null) {
            this.setDescription(string2);
        }
    }

    public CompoundFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public CompoundFileFilter(String[] stringArray, String string) {
        this();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addExtension(stringArray[i]);
        }
        if (string != null) {
            this.setDescription(string);
        }
    }

    @Override
    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null && this.mFilterMap.get(this.getExtension(file)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File file) {
        return CompoundFileHelper.getExtension(file);
    }

    public void addExtension(String string) {
        if (this.mFilterMap == null) {
            this.mFilterMap = new TreeMap();
        }
        this.mFilterMap.put(string.toLowerCase(), this);
        this.mFullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.mFullDescription == null) {
            if (this.mDescription == null || this.isExtensionListInDescription()) {
                this.mFullDescription = this.mDescription == null ? "(" : this.mDescription + " (";
                Iterator iterator = this.mFilterMap.keySet().stream().sorted().iterator();
                this.mFullDescription = this.mFullDescription + (String)iterator.next();
                while (iterator.hasNext()) {
                    this.mFullDescription = this.mFullDescription + ", " + (String)iterator.next();
                }
                this.mFullDescription = this.mFullDescription + ")";
            } else {
                this.mFullDescription = this.mDescription;
            }
        }
        return this.mFullDescription;
    }

    public void setDescription(String string) {
        this.mDescription = string;
        this.mFullDescription = null;
    }

    public void addDescription(String string) {
        this.mDescription = this.mDescription == null ? string : this.mDescription.concat(", " + string);
    }

    public void setExtensionListInDescription(boolean bl) {
        this.mUseExtensionsInDescription = bl;
        this.mFullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.mUseExtensionsInDescription;
    }
}

