/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff.table;

import com.actelion.research.chem.forcefield.mmff.Csv;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.Search;
import com.actelion.research.chem.forcefield.mmff.Searchable;
import com.actelion.research.chem.forcefield.mmff.Tables;
import com.actelion.research.chem.forcefield.mmff.type.Angle;
import com.actelion.research.chem.forcefield.mmff.type.Bond;

public final class Stbn
implements Searchable {
    private final Object[][] table;
    private final Tables t;

    public Stbn(Tables tables, String string) {
        this.table = Csv.readFile(string);
        this.t = tables;
    }

    @Override
    public int get(int n, int n2) {
        return ((Number)this.table[n][n2]).intValue();
    }

    @Override
    public int length() {
        return this.table.length;
    }

    public int index(MMFFMolecule mMFFMolecule, int n, int n2, int n3) {
        int n4 = mMFFMolecule.getAtomType(n);
        int n5 = mMFFMolecule.getAtomType(n2);
        int n6 = mMFFMolecule.getAtomType(n3);
        int n7 = Angle.getStbnType(this.t, mMFFMolecule, n, n2, n3);
        if (n4 > n6) {
            Integer n8 = n6;
            n6 = n4;
            n4 = Search.s(n8, n6);
        }
        return Search.binary(new int[]{2, 1, 3, 0}, new int[]{n5, n4, n6, n7}, (Searchable)this);
    }

    public double kba(MMFFMolecule mMFFMolecule, int n, int n2, int n3) {
        int n4;
        int n5 = mMFFMolecule.getAtomType(n);
        int n6 = mMFFMolecule.getAtomType(n3);
        int n7 = Bond.getType(this.t, mMFFMolecule, n, n2);
        int n8 = Bond.getType(this.t, mMFFMolecule, n2, n3);
        int n9 = this.index(mMFFMolecule, n, n2, n3);
        int n10 = n4 = n5 > n6 || n5 == n6 && n7 < n8 ? 1 : 0;
        if (n9 >= 0) {
            return ((Number)this.table[n9][4 + n4]).doubleValue();
        }
        return this.t.dfsb.kb(mMFFMolecule, n, n2, n3);
    }
}

