/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff.table;

import com.actelion.research.chem.forcefield.mmff.Csv;
import com.actelion.research.chem.forcefield.mmff.Search;
import com.actelion.research.chem.forcefield.mmff.Searchable;
import com.actelion.research.chem.forcefield.mmff.Tables;

public final class Atom
implements Searchable {
    private final int[][] table;

    public Atom(Tables tables, String string) {
        this.table = Csv.readIntsFile(string);
    }

    @Override
    public int get(int n, int n2) {
        return this.table[n][n2];
    }

    @Override
    public int length() {
        return this.table.length;
    }

    public int aspec(int n) {
        return this.table[this.index(n)][1];
    }

    public int crd(int n) {
        return this.table[this.index(n)][2];
    }

    public int val(int n) {
        return this.table[this.index(n)][3];
    }

    public int pilp(int n) {
        return this.table[this.index(n)][4];
    }

    public int mltb(int n) {
        return this.table[this.index(n)][5];
    }

    public boolean arom(int n) {
        return this.table[this.index(n)][6] > 0;
    }

    public boolean linear(int n) {
        int n2 = this.index(n);
        return n2 >= 0 ? this.table[n2][7] > 0 : false;
    }

    public boolean sbmb(int n) {
        return this.table[this.index(n)][8] > 0;
    }

    private int index(int n) {
        return Search.binary(0, n, (Searchable)this);
    }
}

