/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff;

import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.SortedPair;
import java.util.Hashtable;

public class Separation {
    public Hashtable<SortedPair, Relation> table = new Hashtable();

    public Separation(MMFFMolecule mMFFMolecule) {
        for (int i = 0; i < mMFFMolecule.getAllAtoms(); ++i) {
            this.table.put(new SortedPair(i, i), Relation.ONE_ONE);
            for (int j = 0; j < mMFFMolecule.getAllConnAtoms(i); ++j) {
                int n = mMFFMolecule.getConnAtom(i, j);
                SortedPair sortedPair = new SortedPair(i, n);
                this.table.put(sortedPair, Relation.ONE_TWO);
                for (int k = 0; k < mMFFMolecule.getAllConnAtoms(n); ++k) {
                    int n2 = mMFFMolecule.getConnAtom(n, k);
                    SortedPair sortedPair2 = new SortedPair(i, n2);
                    if (!this.table.containsKey(sortedPair2) || this.table.get(sortedPair2) == Relation.ONE_FOUR) {
                        this.table.put(sortedPair2, Relation.ONE_THREE);
                    }
                    for (int i2 = 0; i2 < mMFFMolecule.getAllConnAtoms(n2); ++i2) {
                        int n3 = mMFFMolecule.getConnAtom(n2, i2);
                        SortedPair sortedPair3 = new SortedPair(i, n3);
                        if (this.table.containsKey(sortedPair3)) continue;
                        this.table.put(sortedPair3, Relation.ONE_FOUR);
                    }
                }
            }
        }
    }

    public Relation get(SortedPair sortedPair) {
        return this.table.get(sortedPair) != null ? this.table.get(sortedPair) : Relation.ONE_X;
    }

    public Relation get(int n, int n2) {
        return this.get(new SortedPair(n, n2));
    }

    public static enum Relation {
        ONE_ONE,
        ONE_TWO,
        ONE_THREE,
        ONE_FOUR,
        ONE_X;

    }
}

