/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff;

import com.actelion.research.chem.forcefield.mmff.EnergyTerm;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.Separation;
import com.actelion.research.chem.forcefield.mmff.SortedPair;
import com.actelion.research.chem.forcefield.mmff.Tables;
import com.actelion.research.chem.forcefield.mmff.Vector3;
import com.actelion.research.chem.forcefield.mmff.type.Charge;
import java.util.ArrayList;
import java.util.List;

public class Electrostatic
implements EnergyTerm {
    public final MMFFMolecule mol;
    public final int a1;
    public final int a2;
    public final Separation.Relation rel;
    public final double charge_term;
    public final boolean distModel;

    public Electrostatic(MMFFMolecule mMFFMolecule, int n, int n2, Separation.Relation relation, double d, double d2, boolean bl, double d3) {
        this.mol = mMFFMolecule;
        this.a1 = n;
        this.a2 = n2;
        this.rel = relation;
        this.distModel = bl;
        this.charge_term = d * d2 / d3;
    }

    public Electrostatic(MMFFMolecule mMFFMolecule, int n, int n2, Separation.Relation relation, double d, double d2) {
        this(mMFFMolecule, n, n2, relation, d, d2, false, 1.0);
    }

    @Override
    public double getEnergy(double[] dArray) {
        double d = new Vector3(dArray, this.a1, this.a2).length();
        double d2 = d + 0.05;
        double d3 = 332.0716;
        if (this.distModel) {
            d2 *= d2;
        }
        return d3 * this.charge_term / d2 * (this.rel == Separation.Relation.ONE_FOUR ? 0.75 : 1.0);
    }

    @Override
    public void getGradient(double[] dArray, double[] dArray2) {
        double d = new Vector3(dArray, this.a1, this.a2).length();
        double d2 = d + 0.05;
        double d3 = -332.0716 * (this.distModel ? 2.0 : 1.0) * this.charge_term / (d2 *= this.distModel ? d2 * d2 : d2) * (this.rel == Separation.Relation.ONE_FOUR ? 0.75 : 1.0);
        for (int i = 0; i < 3; ++i) {
            double d4 = 0.02;
            if (d > 0.0) {
                d4 = d3 * (dArray[3 * this.a1 + i] - dArray[3 * this.a2 + i]) / d;
            }
            int n = 3 * this.a1 + i;
            dArray2[n] = dArray2[n] + d4;
            int n2 = 3 * this.a2 + i;
            dArray2[n2] = dArray2[n2] - d4;
        }
    }

    public static List<Electrostatic> findIn(Tables tables, MMFFMolecule mMFFMolecule, Separation separation, double d, boolean bl, double d2) {
        ArrayList<Electrostatic> arrayList = new ArrayList<Electrostatic>();
        double[] dArray = Charge.getCharges(tables, mMFFMolecule);
        for (int i = 0; i < mMFFMolecule.getAllAtoms(); ++i) {
            for (int j = 0; j < i + 1; ++j) {
                Separation.Relation relation = separation.get(new SortedPair(i, j));
                if (relation != Separation.Relation.ONE_FOUR && relation != Separation.Relation.ONE_X || !(Math.abs(dArray[i]) > 1.0E-5) || !(Math.abs(dArray[j]) > 1.0E-5)) continue;
                Vector3 vector3 = new Vector3(mMFFMolecule, i, j);
                if (!(vector3.length() < d)) continue;
                arrayList.add(new Electrostatic(mMFFMolecule, i, j, relation, dArray[i], dArray[j], bl, d2));
            }
        }
        return arrayList;
    }

    public static List<Electrostatic> findIn(Tables tables, MMFFMolecule mMFFMolecule, Separation separation) {
        return Electrostatic.findIn(tables, mMFFMolecule, separation, 100.0, false, 1.0);
    }
}

