/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.docking;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.SingularValueDecomposition;
import com.actelion.research.chem.AtomFunctionAnalyzer;
import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.AtomAssembler;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.phesa.PheSAAlignment;
import java.util.Random;

public class DockingUtils {
    private DockingUtils() {
    }

    public static Coordinates getCOM(Conformer conformer) {
        int n = 0;
        Coordinates coordinates = new Coordinates();
        for (int i = 0; i < conformer.getMolecule().getAtoms(); ++i) {
            Coordinates coordinates2 = conformer.getCoordinates(i);
            coordinates.add(coordinates2);
            ++n;
        }
        coordinates.scale(1.0 / (double)n);
        return coordinates;
    }

    public static Coordinates getCOM(StereoMolecule stereoMolecule) {
        int n = 0;
        Coordinates coordinates = new Coordinates();
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            Coordinates coordinates2 = stereoMolecule.getCoordinates(i);
            coordinates.add(coordinates2);
            ++n;
        }
        coordinates.scale(1.0 / (double)n);
        return coordinates;
    }

    public static Matrix createInitialOrientation(Conformer conformer) {
        Matrix matrix = DockingUtils.calculateMassCovarianceMatrix(conformer);
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(matrix.getArray(), null, null);
        Matrix matrix2 = new Matrix(singularValueDecomposition.getU());
        double d = matrix2.det();
        if (d < 0.0) {
            matrix2.set(0, 1, -matrix2.get(0, 1));
            matrix2.set(1, 1, -matrix2.get(1, 1));
            matrix2.set(2, 1, -matrix2.get(2, 1));
        }
        PheSAAlignment.rotateMol(conformer, matrix2.getArray());
        return matrix2;
    }

    public static Matrix calculateMassCovarianceMatrix(Conformer conformer) {
        Matrix matrix = new Matrix(3, 3);
        int n = 0;
        for (int i = 0; i < conformer.getMolecule().getAllAtoms(); ++i) {
            Coordinates coordinates = conformer.getCoordinates(i);
            ++n;
            double d = coordinates.x * coordinates.x;
            matrix.addToElement(0, 0, d);
            d = coordinates.x * coordinates.y;
            matrix.addToElement(0, 1, d);
            d = coordinates.x * coordinates.z;
            matrix.addToElement(0, 2, d);
            d = coordinates.y * coordinates.y;
            matrix.addToElement(1, 1, d);
            d = coordinates.y * coordinates.z;
            matrix.addToElement(1, 2, d);
            d = coordinates.z * coordinates.z;
            matrix.addToElement(2, 2, d);
        }
        matrix.set(0, 0, matrix.get(0, 0) / (double)n);
        matrix.set(0, 1, matrix.get(0, 1) / (double)n);
        matrix.set(0, 2, matrix.get(0, 2) / (double)n);
        matrix.set(1, 1, matrix.get(1, 1) / (double)n);
        matrix.set(1, 2, matrix.get(1, 2) / (double)n);
        matrix.set(2, 2, matrix.get(2, 2) / (double)n);
        matrix.set(1, 0, matrix.get(0, 1));
        matrix.set(2, 0, matrix.get(0, 2));
        matrix.set(2, 1, matrix.get(1, 2));
        return matrix;
    }

    public static Coordinates randomVectorInSphere(Random random) {
        double d = 1.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = true;
        while (bl) {
            d = -1.0 + 2.0 * random.nextDouble();
            if (!(d * d + (d2 = -1.0 + 2.0 * random.nextDouble()) * d2 + (d3 = -1.0 + 2.0 * random.nextDouble()) * d3 < 1.0)) continue;
            bl = false;
        }
        return new Coordinates(d, d2, d3);
    }

    public static void repairMolecule3D(StereoMolecule stereoMolecule) {
        new Canonizer(stereoMolecule);
        stereoMolecule.normalizeAmbiguousBonds();
        DockingUtils.repairQuaternaryNitrogen(stereoMolecule);
        DockingUtils.repairCarboxylate(stereoMolecule);
        DockingUtils.addImplicitHydrogens(stereoMolecule);
    }

    private static void repairQuaternaryNitrogen(StereoMolecule stereoMolecule) {
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (stereoMolecule.getAtomicNo(i) != 7 || stereoMolecule.getOccupiedValence(i) != 4 || stereoMolecule.getAtomCharge(i) != 0) continue;
            stereoMolecule.setAtomCharge(i, 1);
        }
        stereoMolecule.ensureHelperArrays(7);
    }

    public static void assignLikelyProtonationStates(StereoMolecule stereoMolecule) {
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (stereoMolecule.getAtomicNo(i) == 7 && AtomFunctionAnalyzer.isBasicNitrogen(stereoMolecule, i)) {
                stereoMolecule.setAtomCharge(i, 1);
            }
            if (stereoMolecule.getAtomicNo(i) != 8 || !AtomFunctionAnalyzer.isAcidicOxygen(stereoMolecule, i)) continue;
            stereoMolecule.setAtomCharge(i, -1);
        }
        DockingUtils.addImplicitHydrogens(stereoMolecule);
    }

    public static void addImplicitHydrogens(StereoMolecule stereoMolecule) {
        new AtomAssembler(stereoMolecule).addImplicitHydrogens();
        stereoMolecule.ensureHelperArrays(1);
    }

    private static void repairCarboxylate(StereoMolecule stereoMolecule) {
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (stereoMolecule.getAtomicNo(i) != 8 || stereoMolecule.getOccupiedValence(i) != 1 || stereoMolecule.getAtomCharge(i) != 0) continue;
            stereoMolecule.setAtomCharge(i, -1);
        }
        stereoMolecule.ensureHelperArrays(7);
    }
}

