/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.pharmacophoretree;

import com.actelion.research.chem.phesa.EncodeFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PharmacophoreNode {
    public static final int[] FUNCTIONALITY_WEIGHTS = new int[]{3, 3, 3, 3, 1, 1};
    public static final double CHEM_SIM_WEIGHT = 0.7;
    public static final int ZERO_NODE = 1;
    public static final int LINK_NODE = 6;
    private int[] functionalities;
    private List<Integer> atoms;
    private List<Double> weights;
    private List<Double> volumes;
    private double size;
    private double vol;
    private int role;
    private boolean isRing;
    private boolean isAromatic;

    public PharmacophoreNode(List<Integer> list, int[][] nArray, double[] dArray, int n3, boolean bl, boolean bl2) {
        this.functionalities = new int[FUNCTIONALITY_WEIGHTS.length];
        this.atoms = list;
        this.isRing = bl;
        this.isAromatic = bl2;
        this.weights = new ArrayList<Double>();
        this.volumes = new ArrayList<Double>();
        this.role = n3;
        if ((n3 & 1) == 0) {
            this.atoms.stream().forEach(n -> {
                this.weights.add(1.0);
                this.volumes.add(dArray[n]);
            });
            this.atoms.stream().forEach(n2 -> {
                int[] nArray2 = nArray[n2];
                IntStream.range(0, nArray2.length).forEach(n -> {
                    int n2 = n;
                    this.functionalities[n2] = this.functionalities[n2] + nArray2[n];
                });
            });
            this.calculate();
        }
    }

    public PharmacophoreNode(List<Integer> list, int[] nArray, List<Double> list2, List<Double> list3, int n) {
        this.atoms = list;
        this.functionalities = nArray;
        this.volumes = list2;
        this.weights = list3;
        this.role = n;
        this.calculate();
    }

    public PharmacophoreNode(List<Integer> list, int[][] nArray, double[] dArray, boolean bl, boolean bl2) {
        this(list, nArray, dArray, 0, bl, bl2);
    }

    public void updateWeights(Map<Integer, List<Integer>> map) {
        if ((this.role & 1) == 0) {
            IntStream.range(0, this.atoms.size()).forEach(n -> {
                int n2 = this.atoms.get(n);
                double d = 1.0 / (double)((List)map.get(n2)).size();
                this.weights.set(n, d);
            });
            this.calculate();
        }
    }

    public void calculate() {
        this.size = 0.0;
        this.vol = 0.0;
        for (double d : this.weights) {
            this.size += d;
        }
        this.vol = IntStream.range(0, this.volumes.size()).mapToDouble(n -> this.volumes.get(n) * this.weights.get(n)).sum();
    }

    private static double calcStericSim(double d, double d2) {
        double d3 = 0.0;
        d3 = d + d2 < 0.001 ? 1.0 : 2.0 * Math.min(d, d2) / (d + d2);
        return d3;
    }

    public static double calcFeatureSim(int[] nArray, int[] nArray2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            int n = FUNCTIONALITY_WEIGHTS[i];
            d2 += (double)(n * Math.min(nArray[i], nArray2[i]));
            d3 += (double)(n * (nArray[i] + nArray2[i]));
        }
        if (d3 != 0.0) {
            d = 2.0 * d2 / d3;
        }
        return d;
    }

    public static double getSimilarity(Collection<Integer> collection, Collection<Integer> collection2, List<PharmacophoreNode> list, List<PharmacophoreNode> list2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int[] nArray = new int[FUNCTIONALITY_WEIGHTS.length];
        for (int n : collection) {
            PharmacophoreNode pharmacophoreNode = list.get(n);
            d += pharmacophoreNode.size;
            d2 += pharmacophoreNode.vol;
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = i;
                nArray[n2] = nArray[n2] + pharmacophoreNode.functionalities[i];
            }
        }
        double d5 = 0.0;
        double d6 = 0.0;
        int[] nArray2 = new int[FUNCTIONALITY_WEIGHTS.length];
        Object object = collection2.iterator();
        while (object.hasNext()) {
            int n = object.next();
            PharmacophoreNode pharmacophoreNode = list2.get(n);
            d5 += pharmacophoreNode.size;
            d6 += pharmacophoreNode.vol;
            for (int i = 0; i < nArray2.length; ++i) {
                int n3 = i;
                nArray2[n3] = nArray2[n3] + pharmacophoreNode.functionalities[i];
            }
        }
        if (d / d5 > 2.0 || d / d5 < 0.5) {
            d3 = 0.0;
            d4 = 0.0;
        } else {
            d3 = 0.5 * PharmacophoreNode.calcStericSim(d, d5) + 0.5 * PharmacophoreNode.calcStericSim(d2, d6);
            d4 = PharmacophoreNode.calcFeatureSim(nArray, nArray2);
        }
        if (collection.size() == 1 && collection2.size() == 1) {
            object = list.get((Integer)collection.toArray()[0]);
            PharmacophoreNode pharmacophoreNode = list2.get((Integer)collection2.toArray()[0]);
            if (((PharmacophoreNode)object).isLinkNode() && pharmacophoreNode.isLinkNode()) {
                d3 = 1.0;
                d4 = 1.0;
            }
        }
        return 0.30000000000000004 * d3 + 0.7 * d4;
    }

    public static double getSimilarity(Collection<PharmacophoreNode> collection, Collection<PharmacophoreNode> collection2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int[] nArray = new int[FUNCTIONALITY_WEIGHTS.length];
        for (PharmacophoreNode pharmacophoreNode : collection) {
            d += pharmacophoreNode.size;
            d2 += pharmacophoreNode.vol;
            for (int i = 0; i < nArray.length; ++i) {
                int n = i;
                nArray[n] = nArray[n] + pharmacophoreNode.functionalities[i];
            }
        }
        double d5 = 0.0;
        double d6 = 0.0;
        int[] nArray2 = new int[FUNCTIONALITY_WEIGHTS.length];
        for (PharmacophoreNode pharmacophoreNode : collection2) {
            d5 += pharmacophoreNode.size;
            d6 += pharmacophoreNode.vol;
            for (int i = 0; i < nArray2.length; ++i) {
                int n = i;
                nArray2[n] = nArray2[n] + pharmacophoreNode.functionalities[i];
            }
        }
        if (d / d5 > 2.0 || d / d5 < 0.5) {
            d3 = 0.0;
            d4 = 0.0;
        } else {
            d3 = 0.5 * PharmacophoreNode.calcStericSim(d, d5) + 0.5 * PharmacophoreNode.calcStericSim(d2, d6);
            d4 = PharmacophoreNode.calcFeatureSim(nArray, nArray2);
        }
        if (collection.size() == 1 && collection2.size() == 1 && ((PharmacophoreNode)collection.toArray()[0]).isLinkNode() && ((PharmacophoreNode)collection2.toArray()[0]).isLinkNode()) {
            d3 = 1.0;
            d4 = 1.0;
        }
        return 0.30000000000000004 * d3 + 0.7 * d4;
    }

    public List<Integer> getAtoms() {
        return this.atoms;
    }

    public List<Double> getWeights() {
        return this.weights;
    }

    public int[] getFunctionalities() {
        return this.functionalities;
    }

    public List<Double> getVolumes() {
        return this.weights;
    }

    public double getSize() {
        return this.size;
    }

    public void setFunctionalities(int[] nArray) {
        this.functionalities = nArray;
    }

    public void setVolumes(List<Double> list) {
        this.volumes = list;
    }

    public void setWeights(List<Double> list) {
        this.weights = list;
    }

    public void setAtoms(List<Integer> list) {
        this.atoms = list;
    }

    public void setRole(int n) {
        this.role = n;
    }

    public boolean isLinkNode() {
        boolean bl = (this.role & 6) != 0;
        return bl;
    }

    public static String encode(PharmacophoreNode pharmacophoreNode) {
        String string = Base64.getEncoder().encodeToString(EncodeFunctions.intArrayToByteArray(pharmacophoreNode.functionalities));
        String string2 = Base64.getEncoder().encodeToString(EncodeFunctions.intArrayToByteArray(pharmacophoreNode.atoms.stream().mapToInt(n -> n).toArray()));
        String string3 = Base64.getEncoder().encodeToString(EncodeFunctions.doubleArrayToByteArray(pharmacophoreNode.volumes.stream().mapToDouble(d -> d).toArray()));
        String string4 = Base64.getEncoder().encodeToString(EncodeFunctions.doubleArrayToByteArray(pharmacophoreNode.weights.stream().mapToDouble(d -> d).toArray()));
        String string5 = Integer.toString(pharmacophoreNode.role);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(",");
        stringBuilder.append(string2);
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(",");
        stringBuilder.append(string4);
        stringBuilder.append(",");
        stringBuilder.append(string5);
        stringBuilder.append(",");
        return stringBuilder.toString();
    }

    public static PharmacophoreNode decode(String string) {
        String[] stringArray = string.split(",");
        int[] nArray = EncodeFunctions.byteArrayToIntArray(Base64.getDecoder().decode(stringArray[0]));
        List<Integer> list = Arrays.stream(EncodeFunctions.byteArrayToIntArray(Base64.getDecoder().decode(stringArray[1]))).boxed().collect(Collectors.toList());
        List<Double> list2 = Arrays.stream(EncodeFunctions.byteArrayToDoubleArray(Base64.getDecoder().decode(stringArray[2]))).boxed().collect(Collectors.toList());
        List<Double> list3 = Arrays.stream(EncodeFunctions.byteArrayToDoubleArray(Base64.getDecoder().decode(stringArray[3]))).boxed().collect(Collectors.toList());
        int n = Integer.parseInt(stringArray[4]);
        return new PharmacophoreNode(list, nArray, list2, list3, n);
    }

    public boolean isRing() {
        return this.isRing;
    }

    public void setRing(boolean bl) {
        this.isRing = bl;
    }

    public boolean isAromatic() {
        return this.isAromatic;
    }

    public void setAromatic(boolean bl) {
        this.isAromatic = bl;
    }
}

