/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.pharmacophoretree;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.chem.descriptor.pharmacophoretree.PharmacophoreNode;
import com.actelion.research.chem.descriptor.pharmacophoretree.PharmacophoreTree;
import com.actelion.research.chem.descriptor.pharmacophoretree.PharmacophoreTreeGenerator;
import com.actelion.research.chem.descriptor.pharmacophoretree.TreeMatcher;
import java.util.ArrayList;

public class DescriptorHandlerPTree
implements DescriptorHandler<PharmacophoreTree, StereoMolecule> {
    private static final int MAX_NODE_SIZE = 40;
    private static DescriptorHandlerPTree INSTANCE;
    public static final PharmacophoreTree FAILED_OBJECT;

    @Override
    public float getSimilarity(PharmacophoreTree pharmacophoreTree, PharmacophoreTree pharmacophoreTree2) {
        TreeMatcher treeMatcher = new TreeMatcher(pharmacophoreTree, pharmacophoreTree2);
        TreeMatcher.TreeMatching treeMatching = treeMatcher.matchSearch();
        return (float)treeMatching.getSim();
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_PTREE.version;
    }

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_PTREE;
    }

    @Override
    public String encode(PharmacophoreTree pharmacophoreTree) {
        StringBuilder stringBuilder = new StringBuilder();
        for (PharmacophoreNode object : pharmacophoreTree.getNodes()) {
            stringBuilder.append(PharmacophoreNode.encode(object));
            stringBuilder.append(";");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(":");
        for (int[] nArray : pharmacophoreTree.getEdges()) {
            stringBuilder.append(nArray[0]);
            stringBuilder.append(" ");
            stringBuilder.append(nArray[1]);
            stringBuilder.append(":");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private PharmacophoreTree getDecodedObject(String string) {
        String[] stringArray = string.split(":");
        String[] stringArray2 = stringArray[0].split(";");
        ArrayList<PharmacophoreNode> arrayList = new ArrayList<PharmacophoreNode>();
        ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
        for (String string2 : stringArray2) {
            arrayList.add(PharmacophoreNode.decode(string2));
        }
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i].split(" ");
            arrayList2.add(new int[]{Integer.valueOf(stringArray3[0]), Integer.valueOf(stringArray3[1])});
        }
        return new PharmacophoreTree(arrayList, arrayList2);
    }

    @Override
    public PharmacophoreTree decode(byte[] byArray) {
        return this.decode(new String(byArray));
    }

    @Override
    public PharmacophoreTree decode(String string) {
        try {
            return string == null || string.length() == 0 ? null : (string.equals("Calculation Failed") ? FAILED_OBJECT : this.getDecodedObject(string));
        }
        catch (RuntimeException runtimeException) {
            return FAILED_OBJECT;
        }
    }

    @Override
    public PharmacophoreTree createDescriptor(StereoMolecule stereoMolecule) {
        stereoMolecule.stripSmallFragments();
        PharmacophoreTree pharmacophoreTree = PharmacophoreTreeGenerator.generate(stereoMolecule);
        if (pharmacophoreTree.getNodes().size() > 40) {
            pharmacophoreTree = FAILED_OBJECT;
        }
        return pharmacophoreTree;
    }

    @Override
    public boolean calculationFailed(PharmacophoreTree pharmacophoreTree) {
        boolean bl = pharmacophoreTree.getNodes().size() == 0;
        return bl;
    }

    @Override
    public DescriptorHandler<PharmacophoreTree, StereoMolecule> getThreadSafeCopy() {
        return new DescriptorHandlerPTree();
    }

    public static DescriptorHandlerPTree getDefaultInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DescriptorHandlerPTree();
        }
        return INSTANCE;
    }

    static {
        FAILED_OBJECT = new PharmacophoreTree(new ArrayList<PharmacophoreNode>(), new ArrayList<int[]>());
    }
}

