/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.pharmacophoregraph;

import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.pharmacophoretree.FeatureCalculator;
import com.actelion.research.chem.descriptor.pharmacophoretree.PharmacophoreNode;
import com.actelion.research.chem.descriptor.pharmacophoretree.PharmacophoreTree;
import com.actelion.research.chem.descriptor.pharmacophoretree.PharmacophoreTreeGenerator;
import com.actelion.research.chem.descriptor.pharmacophoretree.TreeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openmolecules.chem.conf.gen.ConformerGenerator;

public class PharmGraphGenerator {
    private static final int MAX_RING_SIZE = 8;

    public StereoMolecule generateDescriptor(StereoMolecule stereoMolecule) {
        Object object;
        Object object2;
        int n;
        stereoMolecule.ensureHelperArrays(1);
        stereoMolecule.stripSmallFragments();
        stereoMolecule.ensureHelperArrays(1);
        ConformerGenerator.addHydrogenAtoms(stereoMolecule);
        ArrayList<PharmacophoreNode> arrayList = new ArrayList<PharmacophoreNode>();
        ArrayList<PharmacophoreTree.BiGramInt> arrayList2 = new ArrayList<PharmacophoreTree.BiGramInt>();
        HashMap<Integer, List<Integer>> hashMap = new HashMap<Integer, List<Integer>>();
        double[] dArray = PharmacophoreTreeGenerator.getAtomVolumes(stereoMolecule);
        ArrayList<PharmacophoreNode> arrayList3 = new ArrayList<PharmacophoreNode>();
        ArrayList<PharmacophoreTree.BiGramInt> arrayList4 = new ArrayList<PharmacophoreTree.BiGramInt>();
        ArrayList<Set<Integer>> arrayList5 = new ArrayList<Set<Integer>>();
        HashMap<Integer, Boolean> hashMap2 = new HashMap<Integer, Boolean>();
        FeatureCalculator featureCalculator = new FeatureCalculator(stereoMolecule);
        featureCalculator.calculate();
        int[][] nArray = featureCalculator.getAtomFunctionalities();
        PharmGraphGenerator.processRings(stereoMolecule, arrayList3, hashMap2, arrayList4, arrayList5, nArray, dArray);
        for (n = 0; n < arrayList3.size(); ++n) {
            object2 = (PharmacophoreNode)arrayList3.get(n);
            PharmacophoreTreeGenerator.addNode((PharmacophoreNode)object2, arrayList, hashMap);
        }
        for (n = 0; n < arrayList4.size(); ++n) {
            object2 = (PharmacophoreTree.BiGramInt)arrayList4.get(n);
            if (arrayList2.contains(object2)) continue;
            arrayList2.add((PharmacophoreTree.BiGramInt)object2);
        }
        ArrayList<PharmacophoreNode> arrayList6 = new ArrayList<PharmacophoreNode>();
        PharmGraphGenerator.processHeteroGroups(stereoMolecule, arrayList6, nArray, dArray);
        for (int i = 0; i < arrayList6.size(); ++i) {
            object = (PharmacophoreNode)arrayList6.get(i);
            PharmacophoreTreeGenerator.addNode((PharmacophoreNode)object, arrayList, hashMap);
        }
        PharmGraphGenerator.treeWalk(0, stereoMolecule, hashMap, arrayList, arrayList2, nArray, dArray);
        Map<Integer, Map<Integer, Integer>> map = TreeUtils.getAdjacencyListWithBondOrders(arrayList.size(), arrayList2);
        object = PharmGraphGenerator.createPharmMol(arrayList, map);
        return object;
    }

    private static StereoMolecule createPharmMol(List<PharmacophoreNode> list, Map<Integer, Map<Integer, Integer>> map) {
        StereoMolecule stereoMolecule = new StereoMolecule();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            int n = -1;
            n = !hashMap.keySet().contains(i) ? PharmGraphGenerator.addNodeToPharmGraph(stereoMolecule, list, i, hashMap) : (Integer)hashMap.get(i);
            Map<Integer, Integer> map2 = map.get(i);
            for (int n2 : map2.keySet()) {
                int n3 = -1;
                n3 = hashMap.keySet().contains(n2) ? (Integer)hashMap.get(n2) : PharmGraphGenerator.addNodeToPharmGraph(stereoMolecule, list, n2, hashMap);
                int n4 = map2.get(n2);
                stereoMolecule.ensureHelperArrays(1);
                if (stereoMolecule.getBond(n, n3) != -1) continue;
                if (n4 == 2) {
                    stereoMolecule.addBond(n, n3, 2);
                    continue;
                }
                if (n4 != 1) continue;
                stereoMolecule.addBond(n, n3, 1);
            }
        }
        return stereoMolecule;
    }

    private static int addNodeToPharmGraph(StereoMolecule stereoMolecule, List<PharmacophoreNode> list, int n, Map<Integer, Integer> map) {
        int n2 = -1;
        PharmacophoreNode pharmacophoreNode = list.get(n);
        int n3 = pharmacophoreNode.getFunctionalities()[0];
        int n4 = pharmacophoreNode.getFunctionalities()[1];
        int n5 = pharmacophoreNode.getFunctionalities()[2];
        int n6 = pharmacophoreNode.getFunctionalities()[3];
        int n7 = n3 + n4 + n5 + n6;
        if (!pharmacophoreNode.isRing() && n7 > 0) {
            n2 = stereoMolecule.addAtom(PharmAtomElements.HETEO_GROUP.id);
            map.put(n, n2);
            PharmGraphGenerator.addPolarInfo(stereoMolecule, n2, n3, n4, n5, n6);
        } else if (pharmacophoreNode.isAromatic()) {
            n2 = stereoMolecule.addAtom(PharmAtomElements.AROM_RING.id);
            map.put(n, n2);
            PharmGraphGenerator.addRingSizeInfo(stereoMolecule, n2, pharmacophoreNode.getAtoms().size());
            if (n7 > 0) {
                PharmGraphGenerator.addPolarInfo(stereoMolecule, n2, n3, n4, n5, n6);
            }
        } else if (pharmacophoreNode.isRing()) {
            n2 = stereoMolecule.addAtom(PharmAtomElements.RING.id);
            map.put(n, n2);
            PharmGraphGenerator.addRingSizeInfo(stereoMolecule, n2, pharmacophoreNode.getAtoms().size());
            if (n7 > 0) {
                PharmGraphGenerator.addPolarInfo(stereoMolecule, n2, n3, n4, n5, n6);
            }
        } else if (pharmacophoreNode.isLinkNode()) {
            int n8 = pharmacophoreNode.getFunctionalities()[0];
            switch (n8) {
                case 1: {
                    n2 = stereoMolecule.addAtom(PharmAtomElements.L1.id);
                    map.put(n, n2);
                    break;
                }
                case 2: {
                    n2 = stereoMolecule.addAtom(PharmAtomElements.L2.id);
                    map.put(n, n2);
                    break;
                }
                case 3: {
                    n2 = stereoMolecule.addAtom(PharmAtomElements.L3.id);
                    map.put(n, n2);
                    break;
                }
                case 4: {
                    n2 = stereoMolecule.addAtom(PharmAtomElements.L4.id);
                    map.put(n, n2);
                }
            }
        } else {
            n2 = stereoMolecule.addAtom(PharmAtomElements.LIPO.id);
            map.put(n, n2);
        }
        return n2;
    }

    private static void addRingSizeInfo(StereoMolecule stereoMolecule, int n, int n2) {
        stereoMolecule.ensureHelperArrays(1);
        switch (n2) {
            case 3: {
                int n3 = stereoMolecule.addAtom(PharmAtomElements.RING3.id);
                stereoMolecule.addBond(n, n3, 32);
                break;
            }
            case 4: {
                int n4 = stereoMolecule.addAtom(PharmAtomElements.RING4.id);
                stereoMolecule.addBond(n, n4, 32);
                break;
            }
            case 5: {
                int n5 = stereoMolecule.addAtom(PharmAtomElements.RING5.id);
                stereoMolecule.addBond(n, n5, 32);
                break;
            }
            case 6: {
                int n6 = stereoMolecule.addAtom(PharmAtomElements.RING6.id);
                stereoMolecule.addBond(n, n6, 32);
                break;
            }
            case 7: {
                int n7 = stereoMolecule.addAtom(PharmAtomElements.RING7.id);
                stereoMolecule.addBond(n, n7, 32);
                break;
            }
            case 8: {
                int n8 = stereoMolecule.addAtom(PharmAtomElements.RING8.id);
                stereoMolecule.addBond(n, n8, 32);
            }
        }
        stereoMolecule.ensureHelperArrays(1);
    }

    private static void addPolarInfo(StereoMolecule stereoMolecule, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        stereoMolecule.ensureHelperArrays(1);
        for (n7 = 0; n7 < n2; ++n7) {
            n6 = stereoMolecule.addAtom(PharmAtomElements.ACCEPTOR.id);
            stereoMolecule.addBond(n, n6, 32);
        }
        for (n7 = 0; n7 < n3; ++n7) {
            n6 = stereoMolecule.addAtom(PharmAtomElements.DONOR.id);
            stereoMolecule.addBond(n, n6, 32);
        }
        for (n7 = 0; n7 < n4; ++n7) {
            n6 = stereoMolecule.addAtom(PharmAtomElements.NEG_CHARGE.id);
            stereoMolecule.addBond(n, n6, 32);
        }
        for (n7 = 0; n7 < n5; ++n7) {
            n6 = stereoMolecule.addAtom(PharmAtomElements.POS_CHARGE.id);
            stereoMolecule.addBond(n, n6, 32);
        }
        stereoMolecule.ensureHelperArrays(1);
    }

    private static void processRings(StereoMolecule stereoMolecule, List<PharmacophoreNode> list, Map<Integer, Boolean> map, List<PharmacophoreTree.BiGramInt> list2, List<Set<Integer>> list3, int[][] nArray, double[] dArray) {
        int n2;
        RingCollection ringCollection = new RingCollection(stereoMolecule, 7, 8);
        for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
            List<Integer> list4 = PharmacophoreTreeGenerator.getSmallestRingsOfAtom(ringCollection, n2);
            for (Integer object2 : list4) {
                Set set = Arrays.stream(ringCollection.getRingAtoms(object2)).boxed().collect(Collectors.toSet());
                if (list3.contains(set)) continue;
                list3.add(set);
                boolean bl = ringCollection.isAromatic(object2);
                map.put(list3.indexOf(set), bl);
            }
        }
        for (n2 = 0; n2 < list3.size(); ++n2) {
            boolean bl = map.get(n2);
            Set<Integer> set = list3.get(n2);
            PharmacophoreNode pharmacophoreNode = new PharmacophoreNode(new ArrayList<Integer>(set), nArray, dArray, true, bl);
            list.add(pharmacophoreNode);
        }
        for (n2 = 0; n2 < list3.size(); ++n2) {
            Set<Integer> set = list3.get(n2);
            for (int i = n2 + 1; i < list3.size(); ++i) {
                Set<Integer> set2 = list3.get(i);
                long l = set.stream().filter(n -> object2.contains(n)).count();
                if (l <= 0L) continue;
                list2.add(new PharmacophoreTree.BiGramInt(new int[]{n2, i}, 2));
            }
        }
    }

    private static void processHeteroGroups(StereoMolecule stereoMolecule, List<PharmacophoreNode> list, int[][] nArray, double[] dArray) {
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (stereoMolecule.isRingAtom(i)) continue;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            hashSet.add(i);
            for (int j = 0; j < stereoMolecule.getConnAtoms(i); ++j) {
                int n = stereoMolecule.getConnAtom(i, j);
                if (stereoMolecule.getAtomicNo(n) != 7 && stereoMolecule.getAtomicNo(n) != 8 || stereoMolecule.getConnAtoms(n) != 1) continue;
                hashSet.add(n);
            }
            if (hashSet.size() <= 1) continue;
            PharmacophoreNode pharmacophoreNode = new PharmacophoreNode(new ArrayList<Integer>(hashSet), nArray, dArray, false, false);
            list.add(pharmacophoreNode);
        }
    }

    private static void treeWalk(int n, StereoMolecule stereoMolecule, Map<Integer, List<Integer>> map, List<PharmacophoreNode> list, List<PharmacophoreTree.BiGramInt> list2, int[][] nArray, double[] dArray) {
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        int[] nArray2 = new int[stereoMolecule.getAtoms()];
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.add(n);
        nArray2[n] = -1;
        blArray[n] = true;
        while (!linkedList.isEmpty()) {
            PharmacophoreTree.BiGramInt biGramInt;
            int n2;
            Iterator<Object> iterator;
            Object object;
            Object object2;
            int n3 = (Integer)linkedList.poll();
            blArray[n3] = true;
            if (map.get(n3) == null) {
                object2 = stereoMolecule.getAtomLabel(n3);
                if (PharmacophoreTreeGenerator.RGROUPS.contains(object2)) {
                    object = new PharmacophoreNode(Arrays.asList(n3), nArray, dArray, 7, false, false);
                    ((PharmacophoreNode)object).getFunctionalities()[0] = Integer.parseInt(((String)object2).split("R")[1]);
                } else {
                    object = new PharmacophoreNode(Arrays.asList(n3), nArray, dArray, false, false);
                }
                PharmacophoreTreeGenerator.addNode((PharmacophoreNode)object, list, map);
                int n4 = list.size() - 1;
                if (nArray2[n3] != -1) {
                    List<Integer> list3 = map.get(nArray2[n3]);
                    iterator = list3.iterator();
                    while (iterator.hasNext()) {
                        n2 = (Integer)iterator.next();
                        biGramInt = new PharmacophoreTree.BiGramInt(new int[]{n2, n4});
                        if (list2.contains(biGramInt)) continue;
                        list2.add(biGramInt);
                    }
                }
            } else {
                object2 = map.get(n3);
                if (nArray2[n3] != -1) {
                    object = map.get(nArray2[n3]);
                    Iterator iterator2 = object2.iterator();
                    while (iterator2.hasNext()) {
                        int n5 = (Integer)iterator2.next();
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            n2 = (Integer)iterator.next();
                            if (n2 == n5 || list2.contains(biGramInt = new PharmacophoreTree.BiGramInt(new int[]{n2, n5}))) continue;
                            list2.add(biGramInt);
                        }
                    }
                }
            }
            for (int i = 0; i < stereoMolecule.getConnAtoms(n3); ++i) {
                int n6 = stereoMolecule.getConnAtom(n3, i);
                if (blArray[n6]) continue;
                linkedList.add(n6);
                nArray2[n6] = n3;
            }
        }
    }

    private static enum PharmAtomElements {
        ACCEPTOR(85),
        DONOR(110),
        POS_CHARGE(78),
        NEG_CHARGE(41),
        AROM(47),
        LIPO(71),
        AROM_RING(79),
        RING(44),
        L1(92),
        L2(93),
        L3(94),
        L4(95),
        RING3(31),
        RING4(32),
        RING5(30),
        RING6(36),
        RING7(49),
        RING8(50),
        HETEO_GROUP(80);

        int id;

        private PharmAtomElements(int n2) {
            this.id = n2;
        }

        int getID() {
            return this.id;
        }
    }
}

