/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore.generator;

import com.actelion.research.chem.interactionstatistics.InteractionDistanceStatistics;
import java.util.HashMap;
import java.util.List;

public class AtomTypeMap {
    private static AtomTypeMap INSTANCE;
    private HashMap<Integer, Integer> hmAtomType_Index;
    private int[] arrAtomType;

    private AtomTypeMap() {
        this.init();
    }

    private void init() {
        InteractionDistanceStatistics interactionDistanceStatistics = InteractionDistanceStatistics.getInstance();
        List<Integer> list = interactionDistanceStatistics.getAtomTypes();
        this.hmAtomType_Index = new HashMap(list.size());
        this.arrAtomType = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            int n = list.get(i);
            this.hmAtomType_Index.put(n, i);
            this.arrAtomType[i] = n;
        }
    }

    public int getIndex(int n) {
        return this.hmAtomType_Index.get(n);
    }

    public int getAtomType(int n) {
        return this.arrAtomType[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AtomTypeMap getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<AtomTypeMap> clazz = AtomTypeMap.class;
        synchronized (AtomTypeMap.class) {
            INSTANCE = new AtomTypeMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static void main(String[] stringArray) {
        InteractionDistanceStatistics interactionDistanceStatistics = InteractionDistanceStatistics.getInstance();
        List<Integer> list = interactionDistanceStatistics.getAtomTypes();
        AtomTypeMap atomTypeMap = AtomTypeMap.getInstance();
        for (int i = 0; i < list.size(); ++i) {
            int n;
            int n2;
            int n3 = list.get(i);
            if (n3 == (n2 = atomTypeMap.getAtomType(n = atomTypeMap.getIndex(n3)))) continue;
            throw new RuntimeException("Error in algorithm!");
        }
        System.out.println("Done for " + list.size() + " atom types");
    }
}

