/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore;

import com.actelion.research.chem.descriptor.flexophore.DistHist;

public class SlidingWindowDistHist {
    private double[] arrFilter;
    private byte[] arrTmp;
    private int lenFilHalf;

    public SlidingWindowDistHist(double[] dArray) {
        this.arrFilter = dArray;
        if (dArray.length % 2 == 0) {
            throw new RuntimeException("Odd number of filter values needed!");
        }
        this.lenFilHalf = dArray.length / 2;
        int n = 64;
        int n2 = (n * n - n) / 2;
        this.arrTmp = new byte[80 * n2];
    }

    public void apply(DistHist distHist) {
        int n = distHist.getNumPPNodes();
        int n2 = 80;
        int n3 = n2 - this.lenFilHalf;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                int n4 = distHist.getIndexPosStartForDistHist(i, j);
                for (int k = this.lenFilHalf; k < n3; ++k) {
                    double d = 0.0;
                    for (int i2 = 0; i2 < this.arrFilter.length; ++i2) {
                        int n5 = k - this.lenFilHalf + i2 + n4;
                        d += (double)distHist.getValueAtAbsolutePosition(n5) * this.arrFilter[i2];
                    }
                    this.arrTmp[n4 + k] = (byte)(d + 0.5);
                }
            }
        }
        System.arraycopy(this.arrTmp, 0, distHist.arrDistHists, 0, distHist.arrDistHists.length);
    }
}

