/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore;

import com.actelion.research.chem.Molecule3D;
import com.actelion.research.chem.descriptor.flexophore.MolDistHist;
import com.actelion.research.chem.descriptor.flexophore.MolDistHistViz;
import com.actelion.research.chem.descriptor.flexophore.PPNodeViz;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;

public class MolDistHistVizHiddenPPPoints
extends MolDistHistViz
implements Serializable {
    private static final long serialVersionUID = 22102012L;
    public static final String TAG_FLEXOPHORE_ALL = "FlexophoreWithHidden";
    public static final String TAG_MOLDISTHISTVIZ_HIDDENPPPOINTS = "MolDistHistVizHiddenPPPoints";
    public static final String TAG_FLEXOPHORE_OBJECT = "MolDistHistVizHiddenPPPointsObject";
    public static final String TAG_FLEXOPHORE_OBJECTLIST = "ListMolDistHistVizHiddenPPPointsObject";
    private byte[] arrMapHiddenPPPoints;
    private HashSet<Byte> hsHiddenIndex;

    public MolDistHistVizHiddenPPPoints(MolDistHistVizHiddenPPPoints molDistHistVizHiddenPPPoints) {
        super(molDistHistVizHiddenPPPoints);
        this.init();
        this.hsHiddenIndex.addAll(molDistHistVizHiddenPPPoints.hsHiddenIndex);
        this.hidden2Map();
    }

    public MolDistHistVizHiddenPPPoints(MolDistHistViz molDistHistViz) {
        super(molDistHistViz);
        this.init();
    }

    public MolDistHistVizHiddenPPPoints(MolDistHist molDistHist) {
        super(molDistHist);
        this.init();
    }

    private void init() {
        this.hsHiddenIndex = new HashSet();
        int n = super.getNumPPNodes();
        this.arrMapHiddenPPPoints = new byte[n];
        this.hidden2Map();
    }

    private void hidden2Map() {
        byte by = super.getNumPPNodes();
        int n = 0;
        for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
            if (this.hsHiddenIndex.contains(by2)) continue;
            this.arrMapHiddenPPPoints[n++] = by2;
        }
    }

    @Override
    public void addInevitablePharmacophorePoint(int n) {
        if (this.isHiddenPharmacophorePointAbsolute((byte)n)) {
            this.removeHiddenPharmacophorePoint((byte)n);
        }
        super.addInevitablePharmacophorePoint(n);
    }

    @Override
    public void removeInevitablePharmacophorePoint(int n) {
        super.removeInevitablePharmacophorePoint(n);
    }

    public void addHiddenPharmacophorePoint(byte by) {
        this.hsHiddenIndex.add(by);
        this.hidden2Map();
    }

    public void removeHiddenPharmacophorePoint(byte by) {
        this.hsHiddenIndex.remove(by);
        this.hidden2Map();
    }

    public void resetHiddenPharmacophorePoints() {
        this.hsHiddenIndex.clear();
        this.hidden2Map();
    }

    public double getRelMaxDistInHistSkipHidden(int n, int n2) {
        return super.getRelMaxDistInHist(this.arrMapHiddenPPPoints[n], this.arrMapHiddenPPPoints[n2]);
    }

    public PPNodeViz getNodeSkipHidden(int n) {
        return super.getNode(this.arrMapHiddenPPPoints[n]);
    }

    public byte[] getDistHistSkipHidden(int n, int n2, byte[] byArray) {
        return super.getDistHist(this.arrMapHiddenPPPoints[n], this.arrMapHiddenPPPoints[n2], byArray);
    }

    public byte[] getDistHistSkipHidden(int n, int n2) {
        return super.getDistHist(this.arrMapHiddenPPPoints[n], this.arrMapHiddenPPPoints[n2]);
    }

    public boolean isInevitablePharmacophorePointSkipHidden(int n) {
        return super.isInevitablePharmacophorePoint(this.arrMapHiddenPPPoints[n]);
    }

    public int getNumInevitablePharmacophorePointsSkipHidden() {
        int n = 0;
        int n2 = this.getSizeSkipHidden();
        for (int i = 0; i < n2; ++i) {
            if (!this.isInevitablePharmacophorePointSkipHidden(i)) continue;
            ++n;
        }
        return n;
    }

    public int getSizeSkipHidden() {
        return super.getNumPPNodes() - this.hsHiddenIndex.size();
    }

    protected HashSet<Byte> getHashSetHiddenIndex() {
        return this.hsHiddenIndex;
    }

    public boolean isHiddenPharmacophorePointAbsolute(byte by) {
        return this.hsHiddenIndex.contains(by);
    }

    public boolean isInevitablePharmacophorePointAbsolute(int n) {
        return super.isInevitablePharmacophorePoint(n);
    }

    public MolDistHistViz getMolDistHistVizSkipHidden() {
        int n;
        Molecule3D molecule3D = MolDistHistVizHiddenPPPoints.finalizeMolecule(this.molecule3D);
        int n2 = this.getSizeSkipHidden();
        MolDistHistViz molDistHistViz = new MolDistHistViz(n2, molecule3D);
        int n3 = this.getNumPPNodes();
        for (n = 0; n < n3; ++n) {
            if (this.isHiddenPharmacophorePointAbsolute((byte)n)) continue;
            PPNodeViz pPNodeViz = new PPNodeViz(this.getNode(n));
            int n4 = molDistHistViz.addNode(pPNodeViz);
            if (!this.isInevitablePharmacophorePointAbsolute(n)) continue;
            molDistHistViz.addInevitablePharmacophorePoint(n4);
        }
        for (n = 0; n < n2; ++n) {
            for (int i = n + 1; i < n2; ++i) {
                byte[] byArray = this.getDistHistSkipHidden(n, i);
                molDistHistViz.setDistHist(n, i, byArray);
            }
        }
        molDistHistViz.realize();
        return molDistHistViz;
    }

    public String toStringHiddenAndInevitable() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.toStringInevitable());
        stringBuilder.append("\n");
        stringBuilder.append("Num hidden " + this.hsHiddenIndex.size());
        stringBuilder.append("\n");
        stringBuilder.append("Index hidden ");
        for (byte by : this.hsHiddenIndex) {
            stringBuilder.append(by + " ");
        }
        stringBuilder.append("\n");
        stringBuilder.append("Map hidden " + Arrays.toString(this.arrMapHiddenPPPoints));
        return stringBuilder.toString();
    }
}

