/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore;

import com.actelion.research.chem.descriptor.DescriptorEncoder;
import com.actelion.research.chem.descriptor.DescriptorHandlerFlexophore;
import com.actelion.research.chem.descriptor.flexophore.DistHistEncoder;
import com.actelion.research.chem.descriptor.flexophore.MolDistHist;
import com.actelion.research.chem.descriptor.flexophore.PPNode;
import com.actelion.research.util.datamodel.IntVec;

public class MolDistHistEncoder {
    private static MolDistHistEncoder INSTANCE;
    private DistHistEncoder distHistEncoder = new DistHistEncoder();

    public String encode(MolDistHist molDistHist) {
        if (!molDistHist.isFinalized()) {
            molDistHist.realize();
        }
        String string = MolDistHistEncoder.encodeByteVec(molDistHist.getArrNode());
        String string2 = " " + this.distHistEncoder.encodeHistograms(molDistHist);
        String string3 = molDistHist.getNodeAtoms() == null ? "" : " " + new String(new DescriptorEncoder().encodeIntArray2D(molDistHist.getNodeAtoms()));
        return string + string2 + string3;
    }

    public MolDistHist decode(byte[] byArray) {
        return this.decode(new String(byArray));
    }

    public MolDistHist decode(String string) {
        if (string.equals("Calculation Failed")) {
            return DescriptorHandlerFlexophore.FAILED_OBJECT;
        }
        String[] stringArray = string.split(" ");
        byte[] byArray = MolDistHistEncoder.decodeNodes(stringArray[0]);
        int n = 0;
        int n2 = 0;
        while (byArray[n2] > 0) {
            n2 += byArray[n2] * PPNode.getNumBytesEntry() + 1;
            ++n;
            if (n2 < byArray.length) continue;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        MolDistHist molDistHist = new MolDistHist(n);
        molDistHist.setArrNode(byArray2);
        if (stringArray.length >= 2 && stringArray[1].length() != 0) {
            this.distHistEncoder.decodeHistograms(stringArray[1], molDistHist);
        }
        if (stringArray.length >= 3) {
            molDistHist.setNodeAtoms(new DescriptorEncoder().decodeIntArray2D(stringArray[2].getBytes()));
        }
        return molDistHist;
    }

    public static byte[] decodeNodes(String string) {
        IntVec intVec = new IntVec(new DescriptorEncoder().decode(string));
        byte[] byArray = new byte[intVec.sizeBytes()];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(intVec.getByte(i) & 0xFF);
            n += Math.abs(byArray[i]);
        }
        if (n == 0) {
            throw new RuntimeException("Node vector contains only 0's!");
        }
        return byArray;
    }

    public static MolDistHistEncoder getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MolDistHistEncoder();
        }
        return INSTANCE;
    }

    private static String encodeByteVec(byte[] byArray) {
        double d = 4.0;
        int n = (int)((double)byArray.length / d + (d - 1.0) / d);
        IntVec intVec = new IntVec(n);
        for (int i = 0; i < byArray.length; ++i) {
            intVec.setByte(i, byArray[i] & 0xFF);
        }
        String string = new String(new DescriptorEncoder().encode(intVec.get()));
        return string;
    }
}

