/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore;

import com.actelion.research.calc.ArrayUtilsCalc;
import com.actelion.research.calc.statistics.median.ModelMedianInteger;
import com.actelion.research.chem.descriptor.flexophore.MolDistHist;
import com.actelion.research.util.datamodel.IntArray;

public class DistHistHelper {
    public static int getSpread(byte[] byArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] <= 0) continue;
            n2 = n;
            break;
        }
        n = 0;
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (byArray[i] <= 0) continue;
            n = i;
            break;
        }
        return n - n2 + 1;
    }

    public static int getMaxIndexNotZero(byte[] byArray) {
        int n = 0;
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (byArray[i] <= 0) continue;
            n = i;
            break;
        }
        return n;
    }

    public static int getMedianBin(byte[] byArray) {
        int n = -1;
        int n2 = 0;
        byte[] byArray2 = byArray;
        int n3 = byArray2.length;
        for (int i = 0; i < n3; ++i) {
            byte by = byArray2[i];
            n2 += by;
        }
        n2 /= 2;
        int n4 = 0;
        for (n3 = 0; n3 < byArray.length; ++n3) {
            if ((n4 += byArray[n3]) < n2) continue;
            n = n3;
            break;
        }
        return n;
    }

    public static RangeStatistics getRangeStatistics(MolDistHist molDistHist) {
        RangeStatistics rangeStatistics = new RangeStatistics();
        int n = molDistHist.getNumPPNodes();
        int n2 = (n * n - n) / 2;
        IntArray intArray = new IntArray(n2);
        IntArray intArray2 = new IntArray(n2);
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                byte[] byArray = molDistHist.getDistHist(i, j);
                int n8 = -1;
                for (n7 = byArray.length - 1; n7 >= 0; --n7) {
                    if (byArray[n7] <= 0) continue;
                    n8 = n7;
                    break;
                }
                intArray.add(n8);
                n7 = -1;
                for (n6 = 0; n6 < byArray.length; ++n6) {
                    if (byArray[n6] <= 0) continue;
                    n7 = n6;
                    break;
                }
                n6 = 0;
                for (n5 = n7; n5 < n8 + 1; ++n5) {
                    n6 += byArray[n5];
                }
                n5 = n6 / 2;
                n6 = 0;
                int n9 = -1;
                for (n4 = n7; n4 < n8 + 1; ++n4) {
                    if ((n6 += byArray[n4]) < n5) continue;
                    n9 = n4;
                    break;
                }
                n6 = 0;
                n4 = -1;
                for (n3 = n8; n3 >= n7; --n3) {
                    if ((n6 += byArray[n3]) < n5) continue;
                    n4 = n3;
                    break;
                }
                n3 = (int)((double)(n9 + n4) / 2.0 + 0.5);
                intArray2.add(n3);
            }
        }
        ModelMedianInteger modelMedianInteger = ArrayUtilsCalc.getMedian(intArray2.get());
        rangeStatistics.maxRange = intArray.max();
        rangeStatistics.medianRange = modelMedianInteger.median;
        return rangeStatistics;
    }

    public static class RangeStatistics {
        public int maxRange;
        public int medianRange;
    }
}

