/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.AbstractDescriptorHandlerFP;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.chem.descriptor.FingerPrintGenerator;
import java.util.BitSet;

public class DescriptorHandlerPFP512
extends AbstractDescriptorHandlerFP<StereoMolecule>
implements DescriptorConstants {
    private static final double CORRECTION_FACTOR = 0.85;
    private static DescriptorHandlerPFP512 sDefaultInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptorHandlerPFP512 getDefaultInstance() {
        Class<DescriptorHandlerPFP512> clazz = DescriptorHandlerPFP512.class;
        synchronized (DescriptorHandlerPFP512.class) {
            if (sDefaultInstance == null) {
                sDefaultInstance = new DescriptorHandlerPFP512();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultInstance;
        }
    }

    @Override
    public DescriptorInfo getInfo() {
        return DESCRIPTOR_PFP512;
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_PFP512.version;
    }

    @Override
    public int[] createDescriptor(StereoMolecule stereoMolecule) {
        if (stereoMolecule == null) {
            return null;
        }
        BitSet bitSet = new FingerPrintGenerator().getFingerprint(stereoMolecule);
        if (bitSet == null) {
            return FAILED_OBJECT;
        }
        int[] nArray = new int[16];
        int n = 1;
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 16; ++j) {
                if (!bitSet.get(16 * i + j)) continue;
                int n2 = j;
                nArray[n2] = nArray[n2] + n;
            }
            n <<= 1;
        }
        return nArray;
    }

    @Override
    public DescriptorHandler<int[], StereoMolecule> getThreadSafeCopy() {
        return this;
    }

    @Override
    public float getSimilarity(int[] nArray, int[] nArray2) {
        return this.normalizeValue(super.getSimilarity(nArray, nArray2));
    }

    private float normalizeValue(double d) {
        return d <= 0.0 ? 0.0f : (d >= 1.0 ? 1.0f : (float)(1.0 - Math.pow(1.0 - Math.pow(d, 0.85), 1.1764705882352942)));
    }
}

