/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.coords;

import com.actelion.research.chem.coords.InventorFragment;

public class FragmentAssociation {
    private InventorFragment[] mFragment = new InventorFragment[2];
    private double[] mX;
    private double[] mY;
    private int[] mCount;

    public FragmentAssociation(InventorFragment inventorFragment, InventorFragment inventorFragment2, int n, int n2) {
        this.mFragment[0] = inventorFragment;
        this.mFragment[1] = inventorFragment2;
        this.mX = new double[2];
        this.mY = new double[2];
        this.mX[0] = this.mFragment[0].getAtomX(n);
        this.mY[0] = this.mFragment[0].getAtomY(n);
        this.mX[1] = this.mFragment[1].getAtomX(n2);
        this.mY[1] = this.mFragment[1].getAtomY(n2);
        this.mCount = new int[2];
        this.mCount[0] = 1;
        this.mCount[1] = 1;
    }

    public FragmentAssociation(InventorFragment inventorFragment, InventorFragment inventorFragment2) {
        this.mFragment[0] = inventorFragment;
        this.mFragment[1] = inventorFragment2;
        this.mX = new double[2];
        this.mY = new double[2];
        this.mCount = new int[2];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < this.mFragment[i].size(); ++j) {
                int n = i;
                this.mX[n] = this.mX[n] + this.mFragment[i].getAtomX(j);
                int n2 = i;
                this.mY[n2] = this.mY[n2] + this.mFragment[i].getAtomY(j);
            }
            this.mCount[i] = this.mFragment[i].size();
        }
    }

    public void add(int n, int n2) {
        this.mX[0] = this.mX[0] + this.mFragment[0].getAtomX(n);
        this.mY[0] = this.mY[0] + this.mFragment[0].getAtomY(n);
        this.mX[1] = this.mX[1] + this.mFragment[1].getAtomX(n2);
        this.mY[1] = this.mY[1] + this.mFragment[1].getAtomY(n2);
        this.mCount[0] = this.mCount[0] + 1;
        this.mCount[1] = this.mCount[1] + 1;
    }

    public InventorFragment getFragment(int n) {
        return this.mFragment[n];
    }

    public int getPriority() {
        return this.mFragment[0].size() * this.mFragment[1].size();
    }

    public void arrange(double d, boolean bl) {
        int n;
        int n2;
        int n3;
        double[] dArray = new double[2];
        for (int i = 0; i < 2; ++i) {
            int n4 = i;
            this.mX[n4] = this.mX[n4] / (double)this.mCount[i];
            int n5 = i;
            this.mY[n5] = this.mY[n5] / (double)this.mCount[i];
            dArray[i] = this.mFragment[i].calculatePreferredAttachmentAngle(this.mX[i], this.mY[i], this.mFragment[1 - i].size(), d);
        }
        this.mFragment[0].rotate(this.mX[0], this.mY[0], 1.5707963267948966 - dArray[0]);
        this.mFragment[1].rotate(this.mX[1], this.mY[1], 4.71238898038469 - dArray[1]);
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double d4 = this.mY[0] - this.mY[1];
        for (int i = 0; i < this.mFragment[1].mAtomY.length; ++i) {
            int n6 = i;
            this.mFragment[1].mAtomY[n6] = this.mFragment[1].mAtomY[n6] + d4;
            if (d2 > this.mFragment[1].mAtomY[i]) {
                d2 = this.mFragment[1].mAtomY[i];
            }
            if (!(d3 < this.mFragment[1].mAtomY[i])) continue;
            d3 = this.mFragment[1].mAtomY[i];
        }
        double d5 = d3 - d2 + 2.0 * d;
        int n7 = (int)Math.ceil(d5);
        d2 += (d5 - (double)n7) / 2.0 - d;
        double[] dArray2 = new double[n7];
        for (n3 = 0; n3 < n7; ++n3) {
            dArray2[n3] = this.mX[1] + d;
        }
        for (n3 = 0; n3 < this.mFragment[1].mAtomY.length; ++n3) {
            double d6 = this.mFragment[1].mAtomY[n3] - d2;
            n2 = (int)(d6 - d);
            int n8 = Math.min((int)(d6 + d), n7 - 1);
            for (int i = n2; i <= n8; ++i) {
                if (!(dArray2[i] > this.mFragment[1].mAtomX[n3])) continue;
                dArray2[i] = this.mFragment[1].mAtomX[n3];
            }
        }
        n3 = 0;
        while (n3 < n7) {
            int n9 = n3++;
            dArray2[n9] = dArray2[n9] - d;
        }
        double d7 = this.mX[0] - this.mX[1];
        for (n = 0; n < this.mFragment[0].mAtomX.length; ++n) {
            n2 = (int)(this.mFragment[0].mAtomY[n] - d2);
            if (n2 < 0 || n2 >= dArray2.length || !(d7 < this.mFragment[0].mAtomX[n] - dArray2[n2])) continue;
            d7 = this.mFragment[0].mAtomX[n] - dArray2[n2];
        }
        n = 0;
        while (n < this.mFragment[1].mAtomX.length) {
            int n10 = n++;
            this.mFragment[1].mAtomX[n10] = this.mFragment[1].mAtomX[n10] + d7;
        }
        if (bl) {
            this.mFragment[0].rotate(this.mX[0], this.mY[0], dArray[0] - 1.5707963267948966);
            this.mFragment[1].rotate(this.mX[0], this.mY[0], dArray[0] - 1.5707963267948966);
        }
    }
}

