/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.conf;

import com.actelion.research.chem.StereoMolecule;

public class TorsionRelevanceHelper {
    public static final float[] getRelevance(StereoMolecule stereoMolecule, int[] nArray) {
        stereoMolecule.ensureHelperArrays(7);
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            if (stereoMolecule.isRingBond(nArray[i])) {
                fArray[i] = 0.33f;
                continue;
            }
            int n = stereoMolecule.getBondAtom(0, nArray[i]);
            int n2 = stereoMolecule.getBondAtom(1, nArray[i]);
            if (stereoMolecule.getConnAtoms(n) == 1 || stereoMolecule.getConnAtoms(n2) == 1) {
                fArray[i] = 1.0f / (float)stereoMolecule.getAtoms();
                continue;
            }
            int n3 = stereoMolecule.getSubstituentSize(n, n2);
            fArray[i] = 2.0f * (float)Math.min(n3, stereoMolecule.getAtoms() - n3) / (float)stereoMolecule.getAtoms();
        }
        return fArray;
    }

    public static final float[] getRelevance(StereoMolecule stereoMolecule, boolean[] blArray) {
        stereoMolecule.ensureHelperArrays(7);
        float[] fArray = new float[stereoMolecule.getBonds()];
        for (int i = 0; i < stereoMolecule.getBonds(); ++i) {
            if (blArray != null && !blArray[i]) continue;
            if (stereoMolecule.isRingBond(i)) {
                fArray[i] = 0.33f;
                continue;
            }
            int n = stereoMolecule.getBondAtom(0, i);
            int n2 = stereoMolecule.getBondAtom(1, i);
            if (stereoMolecule.getConnAtoms(n) == 1 || stereoMolecule.getConnAtoms(n2) == 1) {
                fArray[i] = 1.0f / (float)stereoMolecule.getAtoms();
                continue;
            }
            int n3 = stereoMolecule.getSubstituentSize(n, n2);
            fArray[i] = 2.0f * (float)Math.min(n3, stereoMolecule.getAtoms() - n3) / (float)stereoMolecule.getAtoms();
        }
        return fArray;
    }
}

