/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.conf;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.TorsionDB;
import com.actelion.research.chem.conf.TorsionPrediction;
import com.actelion.research.chem.conf.TorsionRelevanceHelper;

public class MolecularFlexibilityCalculator {
    public MolecularFlexibilityCalculator() {
        TorsionDB.initialize(1);
    }

    public float calculateMolecularFlexibility(StereoMolecule stereoMolecule) {
        stereoMolecule.ensureHelperArrays(7);
        if (stereoMolecule.getAtoms() == 0) {
            return 0.0f;
        }
        boolean[] blArray = new boolean[stereoMolecule.getBonds()];
        int n = TorsionDB.findRotatableBonds(stereoMolecule, false, blArray);
        if (n == 0) {
            return 0.0f;
        }
        float[] fArray = new float[stereoMolecule.getBonds()];
        for (int i = 0; i < stereoMolecule.getBonds(); ++i) {
            if (!blArray[i]) continue;
            int[] nArray = new int[4];
            String string = TorsionDB.getTorsionID(stereoMolecule, i, nArray, null);
            short[] sArray = TorsionDB.getTorsions(string);
            short[] sArray2 = null;
            short[][] sArray3 = null;
            if (sArray != null) {
                sArray2 = TorsionDB.getTorsionFrequencies(string);
                sArray3 = TorsionDB.getTorsionRanges(string);
            } else {
                TorsionPrediction torsionPrediction = new TorsionPrediction(stereoMolecule, nArray);
                sArray = torsionPrediction.getTorsions();
                sArray2 = torsionPrediction.getTorsionFrequencies();
                sArray3 = torsionPrediction.getTorsionRanges();
            }
            if (stereoMolecule.isAromaticBond(i)) continue;
            fArray[i] = this.calculateBondFlexibility(sArray, sArray2, sArray3);
            if (!stereoMolecule.isRingBond(i)) continue;
            int n2 = i;
            fArray[n2] = fArray[n2] * (0.5f * (1.0f - 3.0f / (float)stereoMolecule.getBondRingSize(i)));
        }
        float[] fArray2 = TorsionRelevanceHelper.getRelevance(stereoMolecule, (boolean[])null);
        return this.calculateMoleculeFlexibility(fArray, fArray2);
    }

    private float calculateBondFlexibility(short[] sArray, short[] sArray2, short[][] sArray3) {
        float f;
        int n = sArray.length;
        float f2 = 0.0f;
        int n2 = -1;
        float f3 = -1.0f;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            if (f2 < (float)sArray2[i]) {
                f2 = sArray2[i];
                n2 = i;
            }
            if (!(f3 < (f = (float)this.rightEmptySpace(i, n, sArray3)))) continue;
            f3 = f;
            n3 = i;
        }
        float f4 = f3;
        f = 1.0f;
        int n4 = n3;
        while (this.right(n4, n) != n2) {
            n4 = this.right(n4, n);
            f = (float)((double)f * (1.0 - Math.pow((float)sArray2[n4] / f2, 0.3)));
            f4 += f * (float)(this.rightEmptySpace(n4, n, sArray3) + sArray3[n4][1] - sArray3[n4][0]);
        }
        f = 1.0f;
        n4 = n3;
        while (n4 != n2) {
            int n5 = n4;
            n4 = this.left(n4, n);
            f = (float)((double)f * (1.0 - Math.sqrt((float)sArray2[n5] / f2)));
            f4 += f * (float)(this.rightEmptySpace(n4, n, sArray3) + sArray3[n5][1] - sArray3[n5][0]);
        }
        return 0.5f + 0.5f * (float)Math.cos((double)f4 * Math.PI / 360.0);
    }

    private int left(int n, int n2) {
        return n == 0 ? n2 - 1 : n - 1;
    }

    private int right(int n, int n2) {
        return n == n2 - 1 ? 0 : n + 1;
    }

    private int rightEmptySpace(int n, int n2, short[][] sArray) {
        return n == n2 - 1 ? 360 + sArray[0][0] - sArray[n][1] : sArray[n + 1][0] - sArray[n][1];
    }

    private float calculateMoleculeFlexibility(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray2[i] * fArray[i];
            f2 += fArray2[i];
        }
        float f3 = f2 == 0.0f ? 0.0f : f / f2;
        return (float)(1.0 - Math.pow(1.0 - Math.pow(f3, 0.7f), 1.4285714528998554));
    }
}

