/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.conf;

import com.actelion.research.calc.ThreadMaster;
import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.ConformerSet;
import com.actelion.research.chem.forcefield.AbstractForceField;
import com.actelion.research.chem.forcefield.mmff.ForceFieldMMFF94;
import java.util.HashMap;
import org.openmolecules.chem.conf.gen.ConformerGenerator;
import org.openmolecules.chem.conf.gen.RigidFragmentCache;
import org.openmolecules.chem.conf.so.ConformationSelfOrganizer;

public class ConformerSetGenerator {
    public static final int CONFORMERS = 200;
    private int mMaxNrConfs;
    private int mStrategy;
    private boolean mUseFF;
    private long mSeed;
    private static long DEFAULT_SEED = 12345L;
    private ThreadMaster threadMaster;

    public ConformerSetGenerator(int n, int n2, boolean bl, long l) {
        this.mMaxNrConfs = n;
        this.mStrategy = n2;
        this.mUseFF = bl;
        this.mSeed = l;
        RigidFragmentCache rigidFragmentCache = RigidFragmentCache.getDefaultInstance();
        rigidFragmentCache.loadDefaultCache();
    }

    public ConformerSetGenerator(int n) {
        this(n, 3, false, DEFAULT_SEED);
    }

    public ConformerSetGenerator() {
        this(200, 3, false, DEFAULT_SEED);
    }

    public ConformerSetGenerator(boolean bl) {
        this(200, 3, bl, DEFAULT_SEED);
    }

    public ConformerSetGenerator(boolean bl, long l) {
        this(200, 3, bl, l);
    }

    public void setThreadMaster(ThreadMaster threadMaster) {
        this.threadMaster = threadMaster;
    }

    public ConformerSet generateConformerSet(StereoMolecule stereoMolecule) {
        ConformerSet conformerSet = new ConformerSet();
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule);
        stereoMolecule2.stripSmallFragments();
        ConformerGenerator.addHydrogenAtoms(stereoMolecule2);
        Canonizer canonizer = new Canonizer(stereoMolecule2);
        stereoMolecule2 = canonizer.getCanMolecule(true);
        stereoMolecule2.ensureHelperArrays(31);
        int n = (int)Math.max((double)(2 * this.mMaxNrConfs), 1000.0 * Math.sqrt(this.mMaxNrConfs));
        ConformerGenerator conformerGenerator = new ConformerGenerator(this.mSeed, false);
        conformerGenerator.setThreadMaster(this.threadMaster);
        HashMap<String, Object> hashMap = null;
        if (this.mUseFF) {
            ForceFieldMMFF94.initialize("MMFF94s+");
            hashMap = new HashMap<String, Object>();
            hashMap.put("dielectric constant", 4.0);
        }
        if (conformerGenerator.initializeConformers(stereoMolecule2, this.mStrategy, n, false)) {
            for (int i = 0; i < this.mMaxNrConfs; ++i) {
                Object object;
                Conformer conformer = conformerGenerator.getNextConformer();
                if (conformer == null && i == 0) {
                    object = new ConformationSelfOrganizer(stereoMolecule2, true);
                    conformer = ((ConformationSelfOrganizer)object).generateOneConformer(this.mSeed);
                }
                if (conformer == null) break;
                if (this.mUseFF) {
                    conformer.copyTo(stereoMolecule2);
                    object = new ForceFieldMMFF94(stereoMolecule2, "MMFF94s+", hashMap);
                    ((AbstractForceField)object).minimise();
                    conformer.copyFrom(stereoMolecule2);
                }
                conformerSet.add(conformer);
                if (this.threadMaster != null && this.threadMaster.threadMustDie()) break;
            }
        }
        return conformerSet;
    }
}

