/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.conf;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.TorsionDescriptor;
import com.actelion.research.chem.conf.TorsionDescriptorHelper;
import java.util.Arrays;

public class Conformer
implements Comparable<Conformer> {
    private Coordinates[] mCoordinates;
    private StereoMolecule mMol;
    private String mName;
    private short[] mBondTorsion;
    private double mEnergy;
    private TorsionDescriptor mTorsionDescriptor;

    public Conformer(StereoMolecule stereoMolecule) {
        this.mMol = stereoMolecule;
        this.mCoordinates = new Coordinates[stereoMolecule.getAllAtoms()];
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            this.mCoordinates[i] = new Coordinates(stereoMolecule.getCoordinates(i));
        }
        this.mEnergy = Double.NaN;
    }

    public Conformer(Conformer conformer) {
        this(conformer, conformer.mMol);
    }

    public Conformer(Conformer conformer, StereoMolecule stereoMolecule) {
        this.mMol = stereoMolecule;
        this.mCoordinates = new Coordinates[conformer.mCoordinates.length];
        for (int i = 0; i < this.mCoordinates.length; ++i) {
            this.mCoordinates[i] = new Coordinates(conformer.mCoordinates[i]);
        }
        if (conformer.mBondTorsion != null) {
            this.mBondTorsion = Arrays.copyOf(conformer.mBondTorsion, conformer.mBondTorsion.length);
        }
        this.mEnergy = Double.NaN;
    }

    public Conformer center() {
        int n;
        Coordinates coordinates = new Coordinates();
        for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
            coordinates.add(this.mCoordinates[n]);
        }
        coordinates.scale(1.0 / (double)this.mMol.getAllAtoms());
        for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
            this.mCoordinates[n].sub(coordinates);
        }
        return this;
    }

    public Conformer translate(double d, double d2, double d3) {
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            this.mCoordinates[i].add(d, d2, d3);
        }
        return this;
    }

    public int getSize() {
        return this.mCoordinates.length;
    }

    public double getX(int n) {
        return this.mCoordinates[n].x;
    }

    public double getY(int n) {
        return this.mCoordinates[n].y;
    }

    public double getZ(int n) {
        return this.mCoordinates[n].z;
    }

    public Coordinates[] getCoordinates() {
        return this.mCoordinates;
    }

    public Coordinates getCoordinates(int n) {
        return this.mCoordinates[n];
    }

    public void setCoordinates(int n, Coordinates coordinates) {
        this.mCoordinates[n].set(coordinates);
    }

    public void setCoordinatesReplace(int n, Coordinates coordinates) {
        this.mCoordinates[n] = coordinates;
    }

    public void setX(int n, double d) {
        this.mCoordinates[n].x = d;
    }

    public void setY(int n, double d) {
        this.mCoordinates[n].y = d;
    }

    public void setZ(int n, double d) {
        this.mCoordinates[n].z = d;
    }

    public int deleteAtoms(boolean[] blArray) {
        int n = 0;
        for (int i = 0; i < this.mCoordinates.length; ++i) {
            if (!blArray[i]) continue;
            ++n;
        }
        if (n != 0) {
            Coordinates[] coordinatesArray = new Coordinates[this.mCoordinates.length - n];
            short[] sArray = this.mBondTorsion == null ? null : new short[this.mCoordinates.length - n];
            int n2 = 0;
            for (int i = 0; i < this.mCoordinates.length; ++i) {
                if (blArray[i]) continue;
                coordinatesArray[n2] = this.mCoordinates[i];
                if (sArray != null) {
                    sArray[n2] = this.mBondTorsion[i];
                }
                ++n2;
            }
            this.mCoordinates = coordinatesArray;
            this.mBondTorsion = sArray;
        }
        return n;
    }

    public double calculateTorsion(int[] nArray) {
        Coordinates coordinates = this.getCoordinates(nArray[0]);
        Coordinates coordinates2 = this.getCoordinates(nArray[1]);
        Coordinates coordinates3 = this.getCoordinates(nArray[2]);
        Coordinates coordinates4 = this.getCoordinates(nArray[3]);
        Coordinates coordinates5 = coordinates2.subC(coordinates);
        Coordinates coordinates6 = coordinates3.subC(coordinates2);
        Coordinates coordinates7 = coordinates4.subC(coordinates3);
        Coordinates coordinates8 = coordinates5.cross(coordinates6);
        Coordinates coordinates9 = coordinates6.cross(coordinates7);
        return -Math.atan2(coordinates6.getLength() * coordinates5.dot(coordinates9), coordinates8.dot(coordinates9));
    }

    public int getBondTorsion(int n) {
        return this.mBondTorsion == null ? -1 : this.mBondTorsion[n];
    }

    public void setBondTorsion(int n, short s) {
        if (this.mBondTorsion == null) {
            this.mBondTorsion = new short[this.mMol.getAllBonds()];
        }
        this.mBondTorsion[n] = s;
    }

    public StereoMolecule getMolecule() {
        return this.mMol;
    }

    public void copyFrom(StereoMolecule stereoMolecule) {
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            this.mCoordinates[i].set(stereoMolecule.getCoordinates(i));
        }
    }

    public void copyTo(StereoMolecule stereoMolecule) {
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            stereoMolecule.getCoordinates(i).set(this.mCoordinates[i]);
        }
    }

    public void copyFrom(Conformer conformer) {
        for (int i = 0; i < conformer.getSize(); ++i) {
            this.mCoordinates[i].set(conformer.mCoordinates[i]);
        }
        if (conformer.mName != null) {
            this.mName = this.createNameCopy(conformer.mName);
        }
    }

    private String createNameCopy(String string) {
        int n = string.lastIndexOf(32);
        if (n != -1) {
            if (string.substring(n + 1).equals("copy")) {
                return string.concat(" 2");
            }
            try {
                int n2 = Integer.parseInt(string.substring(n + 1));
                return string.substring(0, n + 1).concat(Integer.toString(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return string.concat(" copy");
    }

    public StereoMolecule toMolecule() {
        return this.toMolecule(this.mMol);
    }

    public StereoMolecule toMolecule(StereoMolecule stereoMolecule) {
        if (stereoMolecule == null) {
            stereoMolecule = this.mMol.getCompactCopy();
        }
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            stereoMolecule.getCoordinates(i).set(this.mCoordinates[i]);
        }
        if (this.mName != null) {
            stereoMolecule.setName(this.mName);
        }
        return stereoMolecule;
    }

    public double getEnergy() {
        return this.mEnergy;
    }

    public void setEnergy(double d) {
        this.mEnergy = d;
    }

    public String getName() {
        return this.mName == null ? this.mMol.getName() : this.mName;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public boolean equals(Conformer conformer) {
        this.ensureDescriptors(conformer);
        return this.mTorsionDescriptor.equals(conformer.mTorsionDescriptor);
    }

    @Override
    public int compareTo(Conformer conformer) {
        this.ensureDescriptors(conformer);
        return this.mTorsionDescriptor.compareTo(conformer.mTorsionDescriptor);
    }

    private void ensureDescriptors(Conformer conformer) {
        if (this.mTorsionDescriptor == null || conformer.mTorsionDescriptor == null) {
            TorsionDescriptorHelper torsionDescriptorHelper = new TorsionDescriptorHelper(this.mMol);
            if (this.mTorsionDescriptor == null) {
                this.mTorsionDescriptor = torsionDescriptorHelper.getTorsionDescriptor(this);
            }
            if (conformer.mTorsionDescriptor == null) {
                conformer.mTorsionDescriptor = torsionDescriptorHelper.getTorsionDescriptor(conformer);
            }
        }
    }
}

