/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.chemicalspaces.synthon;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.chem.io.RXNFileCreator;
import com.actelion.research.chem.reaction.Reaction;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class SynthonCreator {
    /*
     * WARNING - void declaration
     */
    public static Reaction[] create(Reaction reaction) throws Exception {
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        if (reaction.getProducts() > 1) {
            throw new Exception("only reactions with one product are supported");
        }
        Reaction[] reactionArray = new Reaction[reaction.getReactants()];
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < reaction.getReactants(); ++i) {
            if (reaction.getReactants() == 0) {
                throw new Exception("cannot create Synthons for reactions with one reactant");
            }
            object = reaction.getReactant(i);
            for (int j = 0; j < ((ExtendedMolecule)object).getAtoms(); ++j) {
                n5 = ((Molecule)object).getAtomMapNo(j);
                if (n5 == 0) continue;
                hashMap.put(n5, i);
            }
        }
        StereoMolecule stereoMolecule = reaction.getProduct(0);
        object = stereoMolecule.getRingSet();
        ArrayList arrayList = new ArrayList();
        for (n5 = 0; n5 < ((RingCollection)object).getSize(); ++n5) {
            int[] nArray;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int n6 : nArray = ((RingCollection)object).getRingAtoms(n5)) {
                n4 = stereoMolecule.getAtomMapNo(n6);
                if (n4 == 0) continue;
                int n7 = (Integer)hashMap.get(n4);
                hashSet.add(n7);
            }
            if (hashSet.size() != 1) continue;
            int[] nArray2 = ((RingCollection)object).getRingBonds(n5);
            Arrays.stream(nArray2).forEach(n -> arrayList.add(n));
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < stereoMolecule.getBonds(); ++i) {
            if (arrayList.contains(i)) continue;
            int n8 = stereoMolecule.getBondAtom(0, i);
            int n9 = stereoMolecule.getBondAtom(1, i);
            n3 = stereoMolecule.getAtomMapNo(n8);
            int n10 = stereoMolecule.getAtomMapNo(n9);
            if (n3 == 0) {
                if (n10 == 0) continue;
                arrayList2.add(i);
                continue;
            }
            if (n10 == 0) {
                arrayList2.add(i);
                continue;
            }
            if (hashMap.get(n3) == hashMap.get(n10)) continue;
            arrayList2.add(i);
        }
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule);
        stereoMolecule2.ensureHelperArrays(31);
        int n11 = 0;
        StereoMolecule[] stereoMoleculeArray = arrayList2.iterator();
        while (stereoMoleculeArray.hasNext()) {
            int n6;
            n3 = (Integer)stereoMoleculeArray.next();
            StereoMolecule stereoMolecule3 = new StereoMolecule(stereoMolecule2);
            stereoMolecule3.ensureHelperArrays(1);
            stereoMolecule3.setBondType(n3, 512);
            stereoMolecule3.deleteMarkedAtomsAndBonds();
            StereoMolecule[] stereoMoleculeArray2 = stereoMolecule3.getFragments();
            n4 = 1;
            for (StereoMolecule object2 : stereoMoleculeArray2) {
                object2.ensureHelperArrays(1);
                n6 = 0;
                for (int i = 0; i < object2.getAtoms(); ++i) {
                    n6 += object2.getAtomMapNo(i);
                }
                if (n6 != 0) continue;
                n4 = 0;
                break;
            }
            if (n4 == 0) continue;
            int n13 = stereoMolecule2.getBondType(n3);
            stereoMolecule2.setBondType(n3, 512);
            int n14 = stereoMolecule2.addAtom(92 + n11);
            n2 = stereoMolecule2.addAtom(92 + n11);
            int n15 = stereoMolecule2.addBond(stereoMolecule2.getBondAtom(0, n3), n14);
            stereoMolecule2.setBondType(n15, n13);
            n6 = stereoMolecule2.addBond(n2, stereoMolecule2.getBondAtom(1, n3));
            stereoMolecule2.setBondType(n6, n13);
            ++n11;
        }
        stereoMolecule2.deleteMarkedAtomsAndBonds();
        stereoMolecule2.ensureHelperArrays(31);
        for (StereoMolecule stereoMolecule4 : stereoMoleculeArray = stereoMolecule2.getFragments()) {
            void var17_43;
            CoordinateInventor coordinateInventor = new CoordinateInventor();
            coordinateInventor.setRandomSeed(78187493520L);
            coordinateInventor.invent(stereoMolecule4);
            Reaction reaction2 = new Reaction();
            n2 = -1;
            boolean bl = false;
            while (var17_43 < stereoMolecule4.getAtoms()) {
                if (stereoMolecule4.getAtomMapNo((int)var17_43) != 0) {
                    n2 = (Integer)hashMap.get(stereoMolecule4.getAtomMapNo((int)var17_43));
                }
                ++var17_43;
            }
            if (n2 == -1) {
                throw new Exception("could not process reaction");
            }
            stereoMolecule4.ensureHelperArrays(31);
            reaction2.addReactant(reaction.getReactant(n2));
            reaction2.addProduct(stereoMolecule4);
            reactionArray[n2] = reaction2;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(reaction.getName() + "_" + n2 + ".rxn"));
            new RXNFileCreator(reaction2).writeRXNfile(bufferedWriter);
            ((Writer)bufferedWriter).close();
        }
        return reactionArray;
    }
}

