/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.chemicalspaces;

import com.actelion.research.chem.CanonizerUtil;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.SSSearcherWithIndex;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.chemicalspaces.synthon.SynthonCreator;
import com.actelion.research.chem.chemicalspaces.synthon.SynthonReactor;
import com.actelion.research.chem.descriptor.DescriptorHandlerLongFFP512;
import com.actelion.research.chem.io.DWARFileCreator;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.Reactor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class ChemicalSpaceCreator {
    private File outdirectory;
    private Set<String> bbs;
    private Map<String, Map<String, List<String>>> bbData;
    private List<Reaction> reactions;
    private List<Reaction> functionalizations;
    private ConcurrentMap<String, long[]> fps;

    public ChemicalSpaceCreator(Set<String> set, List<Reaction> list, File file) {
        this.bbs = set;
        this.reactions = list;
        this.outdirectory = file;
        this.functionalizations = new ArrayList<Reaction>();
        for (Reaction reaction : list) {
            if (reaction.getReactants() != 1) continue;
            this.functionalizations.add(reaction);
        }
        list.removeAll(this.functionalizations);
    }

    public void setOutdirectory(File file) {
        this.outdirectory = file;
    }

    public void setBBs(Set<String> set) {
        this.bbs = set;
    }

    public void setBBData(Map<String, Map<String, List<String>>> map) {
        this.bbData = map;
    }

    public void setReactions(List<Reaction> list) {
        this.reactions = list;
    }

    public void create() {
        HashMap<String, List<Reaction>> hashMap = new HashMap<String, List<Reaction>>();
        ChemicalSpaceCreator.generateSynthonTransformations(this.reactions, hashMap);
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, List<Map<String, String>>> concurrentHashMap2 = new ConcurrentHashMap<String, List<Map<String, String>>>();
        ChemicalSpaceCreator.processBuildingBlocks(this.bbs, concurrentHashMap, this.functionalizations);
        this.fps = new ConcurrentHashMap<String, long[]>();
        ChemicalSpaceCreator.calcFragFPs(concurrentHashMap.keySet(), this.fps);
        ChemicalSpaceCreator.generateSynthons(this.reactions, concurrentHashMap, concurrentHashMap2, this.fps, hashMap);
        this.generateCombinatoriaLibraries(concurrentHashMap2, this.bbs, hashMap);
    }

    private static void calcFragFPs(Collection<String> collection, ConcurrentMap<String, long[]> concurrentMap) {
        collection.parallelStream().forEach(string -> {
            IDCodeParser iDCodeParser = new IDCodeParser();
            DescriptorHandlerLongFFP512 descriptorHandlerLongFFP512 = new DescriptorHandlerLongFFP512();
            StereoMolecule stereoMolecule = new StereoMolecule();
            try {
                iDCodeParser.parse(stereoMolecule, (String)string);
                long[] lArray = descriptorHandlerLongFFP512.createDescriptor(stereoMolecule);
                concurrentMap.put((String)string, lArray);
            }
            catch (Exception exception) {
                return;
            }
        });
    }

    private static void processBuildingBlocks(Collection<String> collection, ConcurrentMap<String, String> concurrentMap, List<Reaction> list) {
        collection.parallelStream().forEach(string -> {
            StereoMolecule stereoMolecule = new IDCodeParser().getCompactMolecule((String)string);
            if (stereoMolecule != null) {
                stereoMolecule.ensureHelperArrays(31);
                stereoMolecule.stripSmallFragments();
                stereoMolecule.normalizeAmbiguousBonds();
                if (concurrentMap.get(stereoMolecule.getIDCode()) != null) {
                    return;
                }
                concurrentMap.put(stereoMolecule.getIDCode(), (String)string);
                for (Reaction reaction : list) {
                    StereoMolecule stereoMolecule2;
                    SSSearcher sSSearcher = new SSSearcher();
                    sSSearcher.setFragment(reaction.getReactant(0));
                    sSSearcher.setMolecule(stereoMolecule);
                    if (!sSSearcher.isFragmentInMolecule() || (stereoMolecule2 = ChemicalSpaceCreator.getProduct(reaction, Arrays.asList(stereoMolecule))) == null) continue;
                    concurrentMap.put(stereoMolecule2.getIDCode(), (String)string);
                }
            }
        });
    }

    private static void generateSynthons(List<Reaction> list, ConcurrentMap<String, String> concurrentMap, ConcurrentMap<String, List<Map<String, String>>> concurrentMap2, ConcurrentMap<String, long[]> concurrentMap3, Map<String, List<Reaction>> map) {
        for (Reaction reaction : list) {
            ChemicalSpaceCreator.processReaction(reaction, concurrentMap, concurrentMap2, concurrentMap3, map);
        }
    }

    private static void generateSynthonTransformations(List<Reaction> list, Map<String, List<Reaction>> map) {
        for (Reaction reaction : list) {
            List<Object> list2 = new ArrayList();
            try {
                Reaction[] reactionArray = SynthonCreator.create(reaction);
                list2 = Arrays.asList(reactionArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            map.put(reaction.getName(), list2);
        }
    }

    private static void processReaction(Reaction reaction, ConcurrentMap<String, String> concurrentMap, ConcurrentMap<String, List<Map<String, String>>> concurrentMap2, ConcurrentMap<String, long[]> concurrentMap3, Map<String, List<Reaction>> map) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        ChemicalSpaceCreator.getReactants(reaction, concurrentMap, arrayList, concurrentMap3);
        concurrentMap2.putIfAbsent(reaction.getName(), new ArrayList());
        for (int i = 0; i < arrayList.size(); ++i) {
            List list = (List)arrayList.get(i);
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            ((List)concurrentMap2.get(reaction.getName())).add(concurrentHashMap);
            Reaction reaction2 = map.get(reaction.getName()).get(i);
            list.parallelStream().forEach(string -> {
                IDCodeParser iDCodeParser = new IDCodeParser();
                StereoMolecule stereoMolecule = new StereoMolecule();
                iDCodeParser.parse(stereoMolecule, (String)string);
                stereoMolecule.ensureHelperArrays(31);
                String string2 = ChemicalSpaceCreator.transformToSynthon(reaction2, stereoMolecule);
                String string3 = (String)concurrentMap.get(string);
                if (string2 != null) {
                    concurrentHashMap.put(string2, string3);
                }
            });
        }
    }

    private static void getReactants(Reaction reaction, ConcurrentMap<String, String> concurrentMap, List<List<String>> list, Map<String, long[]> map) {
        Object object;
        int n;
        SSSearcherWithIndex[] sSSearcherWithIndexArray = new SSSearcherWithIndex[reaction.getReactants()];
        for (n = 0; n < reaction.getReactants(); ++n) {
            object = new DescriptorHandlerLongFFP512();
            StereoMolecule stereoMolecule = reaction.getReactant(n);
            long[] lArray = ((DescriptorHandlerLongFFP512)object).createDescriptor(stereoMolecule);
            SSSearcherWithIndex sSSearcherWithIndex = new SSSearcherWithIndex();
            sSSearcherWithIndex.setFragment(stereoMolecule, lArray);
            sSSearcherWithIndexArray[n] = sSSearcherWithIndex;
        }
        n = 0;
        while (n < reaction.getReactants()) {
            object = Collections.synchronizedList(new ArrayList());
            int n2 = n++;
            concurrentMap.keySet().stream().forEach(arg_0 -> ChemicalSpaceCreator.lambda$getReactants$3(map, reaction, sSSearcherWithIndexArray, n2, (List)object, arg_0));
            list.add((List<String>)object);
        }
    }

    private static String transformToSynthon(Reaction reaction, StereoMolecule stereoMolecule) {
        String string = null;
        Reactor reactor = new Reactor(reaction, 15, Integer.MAX_VALUE);
        stereoMolecule.ensureHelperArrays(31);
        reactor.setReactant(0, stereoMolecule);
        String[][] stringArray = reactor.getProductIDCodes();
        int n = ChemicalSpaceCreator.getNormalizedProductsCount(reactor.getProducts());
        if (n == 0 || n > 1) {
            return string;
        }
        string = stringArray[0][0];
        return string;
    }

    private static StereoMolecule getProduct(Reaction reaction, List<StereoMolecule> list) {
        Reactor reactor = new Reactor(reaction, 15, Integer.MAX_VALUE);
        for (int i = 0; i < list.size(); ++i) {
            reactor.setReactant(i, list.get(i));
        }
        StereoMolecule[][] stereoMoleculeArray = reactor.getProducts();
        StereoMolecule stereoMolecule = stereoMoleculeArray.length == 0 || stereoMoleculeArray.length > 1 ? null : (stereoMoleculeArray[0].length == 0 || stereoMoleculeArray[0].length > 1 ? null : stereoMoleculeArray[0][0]);
        return stereoMolecule;
    }

    private static int getNormalizedProductsCount(StereoMolecule[][] stereoMoleculeArray) {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (int i = 0; i < stereoMoleculeArray.length; ++i) {
            for (int j = 0; j < stereoMoleculeArray[i].length; ++j) {
                hashSet.add(CanonizerUtil.getTautomerHash(stereoMoleculeArray[i][j], true));
            }
        }
        return hashSet.size();
    }

    private void generateCombinatoriaLibraries(ConcurrentMap<String, List<Map<String, String>>> concurrentMap, Set<String> set, Map<String, List<Reaction>> map) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashSet<Reaction> hashSet = new HashSet<Reaction>();
        for (Reaction object : this.reactions) {
            if (object.getReactants() != 1) continue;
            hashSet.add(object);
        }
        ArrayList arrayList = new ArrayList();
        this.reactions.stream().forEach(reaction -> {
            Object object;
            int n;
            if (reaction.getReactants() < 2) {
                return;
            }
            IDCodeParser iDCodeParser = new IDCodeParser();
            CombinatorialLibrary combinatorialLibrary = new CombinatorialLibrary();
            combinatorialLibrary.reaction = reaction;
            String string = reaction.getName();
            combinatorialLibrary.bbSynthons = (List)concurrentMap.get(string);
            ArrayList<Map<String, List<Map<String, String>>>> arrayList = new ArrayList<Map<String, List<Map<String, String>>>>();
            combinatorialLibrary.precursorLibs = arrayList;
            if (reaction.getReactants() > 2) {
                combinatorialLibrary.cleanup();
                arrayList.add(combinatorialLibrary.getSize());
                try {
                    this.writeCombinatorialLibrary(combinatorialLibrary);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            SSSearcherWithIndex[] sSSearcherWithIndexArray = new SSSearcherWithIndex[reaction.getReactants()];
            for (n = 0; n < sSSearcherWithIndexArray.length; ++n) {
                object = new SSSearcherWithIndex();
                ((SSSearcherWithIndex)object).setFragment(reaction.getReactant(n), (long[])null);
                sSSearcherWithIndexArray[n] = object;
            }
            for (n = 0; n < ((List)concurrentMap.get(string)).size(); ++n) {
                object = new HashMap();
                arrayList.add((Map<String, List<Map<String, String>>>)object);
                Reaction reaction2 = (Reaction)((List)map.get(string)).get(n);
                StereoMolecule stereoMolecule = reaction2.getProduct(0);
                int n2 = 0;
                for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                    if (stereoMolecule.getAtomicNo(i) < 92) continue;
                    ++n2;
                }
                for (Reaction reaction3 : this.reactions) {
                    if (reaction3.getReactants() != 2) continue;
                    String string2 = reaction3.getName();
                    for (int i = 0; i < ((List)concurrentMap.get(string2)).size(); ++i) {
                        Object object2;
                        Serializable serializable;
                        Map map5;
                        int n3;
                        ArrayList arrayList2 = new ArrayList();
                        String string3 = null;
                        string3 = string2 + "_" + i;
                        object.put(string3, arrayList2);
                        HashMap<Integer, StereoMolecule> hashMap = new HashMap<Integer, StereoMolecule>();
                        for (n3 = 0; n3 < reaction3.getReactants(); ++n3) {
                            if (n3 == i) continue;
                            hashMap.put(n3, reaction3.getReactant(n3));
                        }
                        for (n3 = 0; n3 < ((List)concurrentMap.get(string2)).size(); ++n3) {
                            map5 = new HashMap();
                            arrayList2.add(map5);
                        }
                        Map map6 = (Map)arrayList2.get(i);
                        map5 = (Map)((List)concurrentMap.get(string2)).get(i);
                        for (Object object3 : map5.keySet()) {
                            serializable = new StereoMolecule();
                            String string4 = (String)map5.get(object3);
                            iDCodeParser.parse((StereoMolecule)serializable, (String)object3);
                            Object object4 = ChemicalSpaceCreator.dummyReaction(string4, reaction3, hashMap, i);
                            if (object4 == null) continue;
                            if (ChemicalSpaceCreator.matchesReactionRole(reaction, sSSearcherWithIndexArray, n, (StereoMolecule)object4, null)) {
                                ChemicalSpaceCreator.mutateConnectorAtoms((StereoMolecule)serializable, n2);
                                object2 = ChemicalSpaceCreator.transformToSynthon(reaction2, (StereoMolecule)serializable);
                                if (object2 == null) continue;
                                map6.put(object2, string4);
                                continue;
                            }
                            for (Reaction reaction4 : hashSet) {
                                StereoMolecule stereoMolecule2;
                                StereoMolecule stereoMolecule22;
                                StereoMolecule stereoMolecule3;
                                if (hashSet.contains(reaction3)) continue;
                                SSSearcher sSSearcher = new SSSearcher();
                                sSSearcher.setFragment(reaction4.getReactant(0));
                                sSSearcher.setMolecule((StereoMolecule)object4);
                                if (!sSSearcher.isFragmentInMolecule() || (stereoMolecule3 = ChemicalSpaceCreator.getProduct(reaction4, Arrays.asList(object4))) == null || !ChemicalSpaceCreator.matchesReactionRole(reaction, sSSearcherWithIndexArray, n, stereoMolecule22 = stereoMolecule3, null) || (stereoMolecule2 = ChemicalSpaceCreator.getProduct(reaction4, Arrays.asList(serializable))) == null) continue;
                                ChemicalSpaceCreator.mutateConnectorAtoms(stereoMolecule2, n2);
                                String string5 = ChemicalSpaceCreator.transformToSynthon(reaction2, stereoMolecule2);
                                if (!object.containsKey(string3)) {
                                    ArrayList arrayList3 = new ArrayList();
                                    object.put(string3, arrayList3);
                                    for (int j = 0; j < ((List)concurrentMap.get(string2)).size(); ++j) {
                                        HashMap hashMap2 = new HashMap();
                                        arrayList3.add(hashMap2);
                                    }
                                }
                                ((Map)((List)object.get(string3)).get(i)).put(string5, string4);
                            }
                        }
                        for (int j = 0; j < ((List)concurrentMap.get(string2)).size(); ++j) {
                            Object object3;
                            if (j == i) continue;
                            object3 = (Map)((List)concurrentMap.get(string2)).get(j);
                            serializable = new HashMap();
                            for (Object object4 : object3.keySet()) {
                                object2 = new StereoMolecule();
                                boolean bl = true;
                                iDCodeParser.parse((StereoMolecule)object2, (String)object4);
                                for (SSSearcherWithIndex sSSearcherWithIndex : sSSearcherWithIndexArray) {
                                    sSSearcherWithIndex.setMolecule((StereoMolecule)object2, (long[])null);
                                    if (!sSSearcherWithIndex.isFragmentInMolecule()) continue;
                                    bl = false;
                                }
                                if (!bl) continue;
                                ChemicalSpaceCreator.mutateConnectorAtoms((StereoMolecule)object2, n2);
                                serializable.put(((StereoMolecule)object2).getIDCode(), object3.get(object4));
                            }
                            ((Map)arrayList2.get(j)).putAll(serializable);
                        }
                    }
                }
            }
            combinatorialLibrary.cleanup();
            arrayList.add(combinatorialLibrary.getSize());
            System.out.println(reaction.getName());
            combinatorialLibrary.generateRandomProducts(1000, hashMap, hashMap2, hashMap3);
            try {
                this.writeCombinatorialLibrary(combinatorialLibrary);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        });
        try {
            int n;
            String exception = "space.dwar";
            DWARFileCreator dWARFileCreator = new DWARFileCreator(new BufferedWriter(new FileWriter(exception)));
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (int i = 0; i < 4; ++i) {
                arrayList2.add(dWARFileCreator.addStructureColumn("Synthon" + (i + 1), "IDcode"));
            }
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            for (int i = 0; i < 4; ++i) {
                arrayList3.add(dWARFileCreator.addStructureColumn("BB" + (i + 1), "IDcode"));
            }
            ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
            for (n = 0; n < 3; ++n) {
                arrayList4.add(dWARFileCreator.addAlphanumericalColumn("Reaction" + (n + 1)));
            }
            n = dWARFileCreator.addStructureColumn("Product", "IDcode");
            dWARFileCreator.writeHeader(-1);
            hashMap.entrySet().stream().forEach(entry -> {
                dWARFileCreator.setRowStructure((String)entry.getKey(), n);
                List list4 = (List)entry.getValue();
                for (int i = 0; i < list4.size(); ++i) {
                    dWARFileCreator.setRowStructure((String)list4.get(i), (Integer)arrayList2.get(i));
                }
                List list5 = (List)hashMap2.get(entry.getKey());
                for (int i = 0; i < list5.size(); ++i) {
                    dWARFileCreator.setRowStructure((String)list5.get(i), (Integer)arrayList3.get(i));
                }
                List list6 = (List)hashMap3.get(entry.getKey());
                for (int i = 0; i < list6.size(); ++i) {
                    dWARFileCreator.setRowValue((String)list6.get(i), (Integer)arrayList4.get(i));
                }
                try {
                    dWARFileCreator.writeCurrentRow();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            });
            dWARFileCreator.writeEnd();
        }
        catch (Exception l3) {
            System.out.println("########");
            l3.printStackTrace();
        }
        long l3 = arrayList.stream().reduce(0L, (l, l2) -> l + l2);
        System.out.println("totSize");
        System.out.println(l3);
    }

    private static StereoMolecule dummyReaction(String string, Reaction reaction, Map<Integer, StereoMolecule> map, int n) {
        StereoMolecule stereoMolecule = null;
        SSSearcher sSSearcher = new SSSearcher();
        sSSearcher.setFragment(reaction.getReactant(n));
        StereoMolecule stereoMolecule2 = new IDCodeParser().getCompactMolecule(string);
        if (stereoMolecule2 != null) {
            sSSearcher.setMolecule(stereoMolecule2);
            if (sSSearcher.isFragmentInMolecule()) {
                Reactor reactor = new Reactor(reaction, 15, Integer.MAX_VALUE);
                reactor.setReactant(n, stereoMolecule2);
                StereoMolecule[][] stereoMoleculeArray = map.keySet().iterator();
                while (stereoMoleculeArray.hasNext()) {
                    int n2 = stereoMoleculeArray.next();
                    reactor.setReactant(n2, map.get(n2));
                }
                stereoMoleculeArray = reactor.getProducts();
                stereoMolecule = stereoMoleculeArray.length == 0 || stereoMoleculeArray.length > 1 ? null : (stereoMoleculeArray[0].length == 0 || stereoMoleculeArray[0].length > 1 ? null : stereoMoleculeArray[0][0]);
            }
        }
        return stereoMolecule;
    }

    private static void mutateConnectorAtoms(StereoMolecule stereoMolecule, int n) {
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            int n2 = stereoMolecule.getAtomicNo(i);
            if (n2 < 92) continue;
            stereoMolecule.setAtomicNo(i, n2 += n);
        }
        stereoMolecule.ensureHelperArrays(7);
    }

    /*
     * WARNING - void declaration
     */
    private void writeCombinatorialLibrary(CombinatorialLibrary combinatorialLibrary) throws IOException {
        CharSequence charSequence2;
        Iterator iterator;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        Object object5;
        String string2;
        int n2;
        File file = new File(this.outdirectory + "/CombinatorialLibraries/");
        file.mkdir();
        File file2 = new File(file.getAbsolutePath() + "/" + combinatorialLibrary.reaction.getName());
        file2.mkdir();
        File file3 = new File(file2.getAbsolutePath() + "/A");
        file3.mkdir();
        File file4 = new File(file2.getAbsolutePath() + "/B");
        file4.mkdir();
        File file5 = null;
        File file6 = null;
        if (combinatorialLibrary.bbSynthons.size() > 2) {
            file5 = new File(file2.getAbsolutePath() + "/C");
            file5.mkdir();
        }
        if (combinatorialLibrary.bbSynthons.size() > 3) {
            file6 = new File(file2.getAbsolutePath() + "/D");
            file6.mkdir();
        }
        if (combinatorialLibrary.precursorLibs.size() == 2) {
            for (n2 = 0; n2 < combinatorialLibrary.precursorLibs.size(); ++n2) {
                Object object6 = null;
                object6 = n2 == 0 ? new File(file3.getAbsolutePath() + "/virtual_bbs") : new File(file4.getAbsolutePath() + "/virtual_bbs");
                ((File)object6).mkdir();
                for (String object7 : combinatorialLibrary.precursorLibs.get(n2).keySet()) {
                    string2 = ((File)object6).getAbsoluteFile() + "/" + object7;
                    object5 = combinatorialLibrary.precursorLibs.get(n2).get(object7);
                    n = 1;
                    Iterator iterator2 = object5.iterator();
                    while (iterator2.hasNext()) {
                        object4 = (Map)iterator2.next();
                        if (object4.size() == 0) continue;
                        object3 = string2 + "_" + n + ".dwar";
                        object2 = new DWARFileCreator(new BufferedWriter(new FileWriter((String)object3)));
                        int n3 = ((DWARFileCreator)object2).addStructureColumn("Synthon", "IDcode");
                        int n4 = ((DWARFileCreator)object2).addStructureColumn("Building Block", "IDcode");
                        object = new ArrayList();
                        this.bbData.values().stream().forEach(arg_0 -> ChemicalSpaceCreator.lambda$writeCombinatorialLibrary$7((List)object, arg_0));
                        ArrayList<Integer> arrayList = new ArrayList<Integer>();
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            charSequence2 = (String)iterator.next();
                            int n5 = ((DWARFileCreator)object2).addAlphanumericalColumn((String)charSequence2);
                            arrayList.add(n5);
                        }
                        ((DWARFileCreator)object2).writeHeader(-1);
                        for (CharSequence charSequence2 : object4.keySet()) {
                            String string3 = (String)object4.get(charSequence2);
                            Map<String, List<String>> map2 = this.bbData.get(string3);
                            for (int i = 0; i < object.size(); ++i) {
                                String string4 = (String)object.get(i);
                                StringBuilder stringBuilder = new StringBuilder("");
                                List<String> list = map2.get(string4);
                                if (list != null) {
                                    list.forEach(string -> stringBuilder.append(string + ";"));
                                }
                                ((DWARFileCreator)object2).setRowValue(stringBuilder.toString(), (Integer)arrayList.get(i));
                            }
                            ((DWARFileCreator)object2).setRowStructure((String)charSequence2, n3);
                            ((DWARFileCreator)object2).setRowStructure(string3, n4);
                            ((DWARFileCreator)object2).writeCurrentRow();
                        }
                        ((DWARFileCreator)object2).writeEnd();
                        ++n;
                    }
                }
            }
        }
        n2 = 0;
        for (Map<String, String> map3 : combinatorialLibrary.bbSynthons) {
            void var11_18;
            if (map3.size() == 0) continue;
            Object var11_13 = null;
            switch (n2) {
                case 0: {
                    File file7 = file3;
                    break;
                }
                case 1: {
                    File file8 = file4;
                    break;
                }
                case 2: {
                    File file9 = file5;
                    break;
                }
                case 3: {
                    File file10 = file6;
                    break;
                }
            }
            string2 = var11_18 + "/" + combinatorialLibrary.reaction.getName() + ".dwar";
            object5 = new DWARFileCreator(new BufferedWriter(new FileWriter(string2)));
            n = ((DWARFileCreator)object5).addStructureColumn("Synthon", "IDcode");
            int n6 = ((DWARFileCreator)object5).addStructureColumn("Building Block", "IDcode");
            object4 = new ArrayList();
            this.bbData.values().stream().forEach(map -> {
                for (String string : map.keySet()) {
                    if (object4.contains(string)) continue;
                    object4.add(string);
                }
            });
            object3 = new ArrayList<Integer>();
            object2 = object4.iterator();
            while (object2.hasNext()) {
                String string5 = (String)object2.next();
                int n7 = ((DWARFileCreator)object5).addAlphanumericalColumn(string5);
                object3.add(n7);
            }
            ((DWARFileCreator)object5).writeHeader(-1);
            for (String string5 : map3.keySet()) {
                String string6 = (String)map3.get(string5);
                object = this.bbData.get(string6);
                for (int i = 0; i < object4.size(); ++i) {
                    iterator = (String)object4.get(i);
                    charSequence2 = new StringBuilder("");
                    List list = (List)object.get(iterator);
                    if (list != null) {
                        list.forEach(arg_0 -> ChemicalSpaceCreator.lambda$writeCombinatorialLibrary$10((StringBuilder)charSequence2, arg_0));
                    }
                    ((DWARFileCreator)object5).setRowValue(charSequence2.toString(), (Integer)object3.get(i));
                }
                ((DWARFileCreator)object5).setRowStructure(string5, n);
                ((DWARFileCreator)object5).setRowStructure((String)map3.get(string5), n6);
                ((DWARFileCreator)object5).writeCurrentRow();
            }
            ((DWARFileCreator)object5).writeEnd();
            ++n2;
        }
    }

    public static boolean matchesReactionRole(Reaction reaction, SSSearcherWithIndex[] sSSearcherWithIndexArray, int n, StereoMolecule stereoMolecule, long[] lArray) {
        boolean bl = true;
        SSSearcherWithIndex sSSearcherWithIndex = sSSearcherWithIndexArray[n];
        sSSearcherWithIndex.setMolecule(stereoMolecule, lArray);
        if (sSSearcherWithIndex.isFragmentInMolecule()) {
            for (int i = 0; i < reaction.getReactants(); ++i) {
                if (n == i || reaction.getReactant(n).getIDCode().equals(reaction.getReactant(i).getIDCode())) continue;
                SSSearcherWithIndex sSSearcherWithIndex2 = sSSearcherWithIndexArray[i];
                sSSearcherWithIndex2.setMolecule(stereoMolecule, lArray);
                if (!sSSearcherWithIndex2.isFragmentInMolecule()) continue;
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private static /* synthetic */ void lambda$writeCombinatorialLibrary$10(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string + ";");
    }

    private static /* synthetic */ void lambda$writeCombinatorialLibrary$7(List list, Map map) {
        for (String string : map.keySet()) {
            if (list.contains(string)) continue;
            list.add(string);
        }
    }

    private static /* synthetic */ void lambda$getReactants$3(Map map, Reaction reaction, SSSearcherWithIndex[] sSSearcherWithIndexArray, int n, List list, String string) {
        StereoMolecule stereoMolecule = new IDCodeParser().getCompactMolecule(string);
        if (stereoMolecule != null) {
            long[] lArray = (long[])map.get(string);
            if (lArray == null) {
                return;
            }
            boolean bl = ChemicalSpaceCreator.matchesReactionRole(reaction, sSSearcherWithIndexArray, n, stereoMolecule, lArray);
            if (bl) {
                list.add(string);
            }
        }
    }

    private static class CombinatorialLibrary {
        public Reaction reaction;
        public List<Map<String, String>> bbSynthons;
        public List<Map<String, List<Map<String, String>>>> precursorLibs;
        List<String> toRemove = new ArrayList<String>();

        private CombinatorialLibrary() {
        }

        private void cleanup() {
            for (Map<String, List<Map<String, String>>> map : this.precursorLibs) {
                for (String string : map.keySet()) {
                    for (Map<String, String> map2 : map.get(string)) {
                        if (map2 == null) {
                            this.toRemove.add(string);
                            continue;
                        }
                        if (map2.size() != 0) continue;
                        this.toRemove.add(string);
                    }
                }
                for (String string : this.toRemove) {
                    map.remove(string);
                }
                this.toRemove = new ArrayList<String>();
            }
        }

        public long getSize() {
            long l = 1L;
            for (Map<String, String> map : this.bbSynthons) {
                l *= (long)map.size();
            }
            if (this.precursorLibs.size() == 2) {
                int n;
                List<Map<String, String>> list;
                long l2 = this.bbSynthons.get(0).size();
                Map<String, List<Map<String, String>>> map = this.precursorLibs.get(0);
                long l3 = this.bbSynthons.get(1).size();
                Map<String, List<Map<String, String>>> map2 = this.precursorLibs.get(1);
                for (String string : map.keySet()) {
                    list = map.get(string);
                    n = 1;
                    for (Map<String, String> map3 : list) {
                        n = (int)((long)n * (long)map3.size());
                    }
                    l2 += (long)n;
                }
                for (String string : map2.keySet()) {
                    list = map2.get(string);
                    n = 1;
                    for (Map<String, String> map3 : list) {
                        n = (int)((long)n * (long)map3.size());
                    }
                    l3 += (long)n;
                }
                return l2 * l3;
            }
            return l;
        }

        public void generateRandomProducts(int n, Map<String, List<String>> map, Map<String, List<String>> map2, Map<String, List<String>> map3) {
            Random random = new Random();
            IDCodeParser iDCodeParser = new IDCodeParser();
            long l = (long)map.keySet().size() + Math.min(this.getSize(), (long)n);
            while ((long)map.keySet().size() < l) {
                ArrayList<StereoMolecule> arrayList = new ArrayList<StereoMolecule>();
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                ArrayList<StereoMolecule> arrayList4 = new ArrayList<StereoMolecule>();
                String string = "";
                arrayList3.add(this.reaction.getName());
                for (int i = 0; i < this.reaction.getReactants(); ++i) {
                    List<Map<String, String>> list;
                    Object object;
                    int n2 = random.nextInt(2);
                    Map<String, List<Map<String, String>>> map4 = this.precursorLibs.get(i);
                    if (map4.size() < 1 || n2 == 0) {
                        if (this.bbSynthons.get(i).size() < 1) {
                            return;
                        }
                        int n3 = random.nextInt(this.bbSynthons.get(i).size());
                        StereoMolecule stereoMolecule2 = new StereoMolecule();
                        object = this.bbSynthons.get(i);
                        list = new ArrayList(object.keySet());
                        iDCodeParser.parse(stereoMolecule2, (String)((Object)list.get(n3)));
                        arrayList.add(stereoMolecule2);
                        arrayList2.add(object.get(list.get(n3)));
                        arrayList4.add(stereoMolecule2);
                        continue;
                    }
                    ArrayList<StereoMolecule> arrayList5 = new ArrayList<StereoMolecule>();
                    int n4 = random.nextInt(map4.keySet().size());
                    object = new ArrayList<String>(map4.keySet());
                    list = map4.get(object.get(n4));
                    string = (String)object.get(n4);
                    arrayList3.add(string);
                    for (Map<String, String> map5 : list) {
                        ArrayList<String> arrayList6 = new ArrayList<String>(map5.keySet());
                        int n5 = random.nextInt(arrayList6.size());
                        StereoMolecule stereoMolecule3 = new StereoMolecule();
                        iDCodeParser.parse(stereoMolecule3, (String)arrayList6.get(n5));
                        arrayList.add(stereoMolecule3);
                        arrayList2.add(map5.get(arrayList6.get(n5)));
                        arrayList5.add(stereoMolecule3);
                    }
                    try {
                        arrayList4.add(SynthonReactor.react(arrayList5));
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                try {
                    StereoMolecule stereoMolecule4 = SynthonReactor.react(arrayList4);
                    List list = arrayList.stream().map(stereoMolecule -> stereoMolecule.getIDCode()).collect(Collectors.toList());
                    if (map.containsKey(stereoMolecule4.getIDCode())) continue;
                    map.put(stereoMolecule4.getIDCode(), list);
                    map2.put(stereoMolecule4.getIDCode(), arrayList2);
                    map3.put(stereoMolecule4.getIDCode(), arrayList3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

